/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.cohere.embeddings;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.inference.InputType;
import org.elasticsearch.inference.TaskSettings;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.inference.common.model.Truncation;
import org.elasticsearch.xpack.inference.services.ServiceUtils;
import org.elasticsearch.xpack.inference.services.cohere.CohereService;

public class CohereEmbeddingsTaskSettings
implements TaskSettings {
    public static final String NAME = "cohere_embeddings_task_settings";
    public static final CohereEmbeddingsTaskSettings EMPTY_SETTINGS = new CohereEmbeddingsTaskSettings(null, null);
    static final String INPUT_TYPE = "input_type";
    private final InputType inputType;
    private final Truncation truncation;

    public static CohereEmbeddingsTaskSettings fromMap(Map<String, Object> map) {
        if (map == null || map.isEmpty()) {
            return EMPTY_SETTINGS;
        }
        ValidationException validationException = new ValidationException();
        InputType inputType = ServiceUtils.extractOptionalEnum(map, INPUT_TYPE, "task_settings", InputType::fromString, CohereService.VALID_INPUT_TYPE_VALUES, validationException);
        Truncation truncation = ServiceUtils.extractOptionalEnum(map, "truncate", "task_settings", Truncation::fromString, Truncation.ALL, validationException);
        if (!validationException.validationErrors().isEmpty()) {
            throw validationException;
        }
        return new CohereEmbeddingsTaskSettings(inputType, truncation);
    }

    public static CohereEmbeddingsTaskSettings of(CohereEmbeddingsTaskSettings originalSettings, CohereEmbeddingsTaskSettings requestTaskSettings) {
        InputType inputTypeToUse = CohereEmbeddingsTaskSettings.getValidInputType(originalSettings, requestTaskSettings);
        Truncation truncationToUse = CohereEmbeddingsTaskSettings.getValidTruncation(originalSettings, requestTaskSettings);
        return new CohereEmbeddingsTaskSettings(inputTypeToUse, truncationToUse);
    }

    private static InputType getValidInputType(CohereEmbeddingsTaskSettings originalSettings, CohereEmbeddingsTaskSettings requestTaskSettings) {
        InputType inputTypeToUse = originalSettings.inputType;
        if (requestTaskSettings.inputType != null) {
            inputTypeToUse = requestTaskSettings.inputType;
        }
        return inputTypeToUse;
    }

    private static Truncation getValidTruncation(CohereEmbeddingsTaskSettings originalSettings, CohereEmbeddingsTaskSettings requestTaskSettings) {
        return requestTaskSettings.getTruncation() == null ? originalSettings.truncation : requestTaskSettings.getTruncation();
    }

    public CohereEmbeddingsTaskSettings(StreamInput in) throws IOException {
        this((InputType)in.readOptionalEnum(InputType.class), (Truncation)in.readOptionalEnum(Truncation.class));
    }

    public CohereEmbeddingsTaskSettings(@Nullable InputType inputType, @Nullable Truncation truncation) {
        CohereEmbeddingsTaskSettings.validateInputType(inputType);
        this.inputType = inputType;
        this.truncation = truncation;
    }

    private static void validateInputType(InputType inputType) {
        if (inputType == null) {
            return;
        }
        assert (CohereService.VALID_INPUT_TYPE_VALUES.contains(inputType)) : InputType.invalidInputTypeMessage((InputType)inputType);
    }

    public boolean isEmpty() {
        return this.inputType == null && this.truncation == null;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.inputType != null) {
            builder.field(INPUT_TYPE, (Enum)this.inputType);
        }
        if (this.truncation != null) {
            builder.field("truncate", (Enum)this.truncation);
        }
        builder.endObject();
        return builder;
    }

    public InputType getInputType() {
        return this.inputType;
    }

    public Truncation getTruncation() {
        return this.truncation;
    }

    public String getWriteableName() {
        return NAME;
    }

    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersions.V_8_13_0;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalEnum((Enum)this.inputType);
        out.writeOptionalEnum((Enum)this.truncation);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CohereEmbeddingsTaskSettings that = (CohereEmbeddingsTaskSettings)o;
        return Objects.equals(this.inputType, that.inputType) && Objects.equals((Object)this.truncation, (Object)that.truncation);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.inputType, this.truncation});
    }

    public TaskSettings updatedTaskSettings(Map<String, Object> newSettings) {
        CohereEmbeddingsTaskSettings updatedSettings = CohereEmbeddingsTaskSettings.fromMap(new HashMap<String, Object>(newSettings));
        return CohereEmbeddingsTaskSettings.of(this, updatedSettings);
    }
}

