/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.azureopenai.embeddings;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.mapper.vectors.DenseVectorFieldMapper;
import org.elasticsearch.inference.ServiceSettings;
import org.elasticsearch.inference.SimilarityMeasure;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.inference.InferenceUtils;
import org.elasticsearch.xpack.inference.services.ConfigurationParseContext;
import org.elasticsearch.xpack.inference.services.ServiceUtils;
import org.elasticsearch.xpack.inference.services.azureopenai.AzureOpenAiRateLimitServiceSettings;
import org.elasticsearch.xpack.inference.services.settings.FilteredXContentObject;
import org.elasticsearch.xpack.inference.services.settings.RateLimitSettings;

public class AzureOpenAiEmbeddingsServiceSettings
extends FilteredXContentObject
implements ServiceSettings,
AzureOpenAiRateLimitServiceSettings {
    public static final String NAME = "azure_openai_embeddings_service_settings";
    static final String DIMENSIONS_SET_BY_USER = "dimensions_set_by_user";
    private static final RateLimitSettings DEFAULT_RATE_LIMIT_SETTINGS = new RateLimitSettings(1440L);
    private final String resourceName;
    private final String deploymentId;
    private final String apiVersion;
    private final Integer dimensions;
    private final Boolean dimensionsSetByUser;
    private final Integer maxInputTokens;
    private final SimilarityMeasure similarity;
    private final RateLimitSettings rateLimitSettings;

    public static AzureOpenAiEmbeddingsServiceSettings fromMap(Map<String, Object> map, ConfigurationParseContext context) {
        ValidationException validationException = new ValidationException();
        CommonFields settings = AzureOpenAiEmbeddingsServiceSettings.fromMap(map, validationException, context);
        if (!validationException.validationErrors().isEmpty()) {
            throw validationException;
        }
        return new AzureOpenAiEmbeddingsServiceSettings(settings);
    }

    private static CommonFields fromMap(Map<String, Object> map, ValidationException validationException, ConfigurationParseContext context) {
        String resourceName = ServiceUtils.extractRequiredString(map, "resource_name", "service_settings", validationException);
        String deploymentId = ServiceUtils.extractRequiredString(map, "deployment_id", "service_settings", validationException);
        String apiVersion = ServiceUtils.extractRequiredString(map, "api_version", "service_settings", validationException);
        Integer dims = ServiceUtils.extractOptionalPositiveInteger(map, "dimensions", "service_settings", validationException);
        Integer maxTokens = ServiceUtils.extractOptionalPositiveInteger(map, "max_input_tokens", "service_settings", validationException);
        SimilarityMeasure similarity = ServiceUtils.extractSimilarity(map, "service_settings", validationException);
        RateLimitSettings rateLimitSettings = RateLimitSettings.of(map, DEFAULT_RATE_LIMIT_SETTINGS, validationException, "azureopenai", context);
        Boolean dimensionsSetByUser = ServiceUtils.extractOptionalBoolean(map, DIMENSIONS_SET_BY_USER, validationException);
        switch (context) {
            case REQUEST: {
                if (dimensionsSetByUser != null) {
                    validationException.addValidationError(ServiceUtils.invalidSettingError(DIMENSIONS_SET_BY_USER, "service_settings"));
                }
                dimensionsSetByUser = dims != null;
                break;
            }
            case PERSISTENT: {
                if (dimensionsSetByUser != null) break;
                validationException.addValidationError(InferenceUtils.missingSettingErrorMsg((String)DIMENSIONS_SET_BY_USER, (String)"service_settings"));
            }
        }
        return new CommonFields(resourceName, deploymentId, apiVersion, dims, Boolean.TRUE.equals(dimensionsSetByUser), maxTokens, similarity, rateLimitSettings);
    }

    public AzureOpenAiEmbeddingsServiceSettings(String resourceName, String deploymentId, String apiVersion, @Nullable Integer dimensions, Boolean dimensionsSetByUser, @Nullable Integer maxInputTokens, @Nullable SimilarityMeasure similarity, @Nullable RateLimitSettings rateLimitSettings) {
        this.resourceName = resourceName;
        this.deploymentId = deploymentId;
        this.apiVersion = apiVersion;
        this.dimensions = dimensions;
        this.dimensionsSetByUser = Objects.requireNonNull(dimensionsSetByUser);
        this.maxInputTokens = maxInputTokens;
        this.similarity = similarity;
        this.rateLimitSettings = Objects.requireNonNullElse(rateLimitSettings, DEFAULT_RATE_LIMIT_SETTINGS);
    }

    public AzureOpenAiEmbeddingsServiceSettings(StreamInput in) throws IOException {
        this.resourceName = in.readString();
        this.deploymentId = in.readString();
        this.apiVersion = in.readString();
        this.dimensions = in.readOptionalVInt();
        this.dimensionsSetByUser = in.readBoolean();
        this.maxInputTokens = in.readOptionalVInt();
        this.similarity = (SimilarityMeasure)in.readOptionalEnum(SimilarityMeasure.class);
        this.rateLimitSettings = new RateLimitSettings(in);
    }

    private AzureOpenAiEmbeddingsServiceSettings(CommonFields fields) {
        this(fields.resourceName, fields.deploymentId, fields.apiVersion, fields.dimensions, fields.dimensionsSetByUser, fields.maxInputTokens, fields.similarity, fields.rateLimitSettings);
    }

    @Override
    public RateLimitSettings rateLimitSettings() {
        return this.rateLimitSettings;
    }

    @Override
    public String resourceName() {
        return this.resourceName;
    }

    @Override
    public String deploymentId() {
        return this.deploymentId;
    }

    public String apiVersion() {
        return this.apiVersion;
    }

    public Integer dimensions() {
        return this.dimensions;
    }

    public Boolean dimensionsSetByUser() {
        return this.dimensionsSetByUser;
    }

    public Integer maxInputTokens() {
        return this.maxInputTokens;
    }

    public SimilarityMeasure similarity() {
        return this.similarity;
    }

    public DenseVectorFieldMapper.ElementType elementType() {
        return DenseVectorFieldMapper.ElementType.FLOAT;
    }

    public String modelId() {
        return null;
    }

    public String getWriteableName() {
        return NAME;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        this.toXContentFragmentOfExposedFields(builder, params);
        builder.field(DIMENSIONS_SET_BY_USER, this.dimensionsSetByUser);
        builder.endObject();
        return builder;
    }

    @Override
    protected XContentBuilder toXContentFragmentOfExposedFields(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field("resource_name", this.resourceName);
        builder.field("deployment_id", this.deploymentId);
        builder.field("api_version", this.apiVersion);
        if (this.dimensions != null) {
            builder.field("dimensions", this.dimensions);
        }
        if (this.maxInputTokens != null) {
            builder.field("max_input_tokens", this.maxInputTokens);
        }
        if (this.similarity != null) {
            builder.field("similarity", (Enum)this.similarity);
        }
        this.rateLimitSettings.toXContent(builder, params);
        return builder;
    }

    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersions.V_8_14_0;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.resourceName);
        out.writeString(this.deploymentId);
        out.writeString(this.apiVersion);
        out.writeOptionalVInt(this.dimensions);
        out.writeBoolean(this.dimensionsSetByUser.booleanValue());
        out.writeOptionalVInt(this.maxInputTokens);
        out.writeOptionalEnum((Enum)SimilarityMeasure.translateSimilarity((SimilarityMeasure)this.similarity, (TransportVersion)out.getTransportVersion()));
        this.rateLimitSettings.writeTo(out);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AzureOpenAiEmbeddingsServiceSettings that = (AzureOpenAiEmbeddingsServiceSettings)o;
        return Objects.equals(this.resourceName, that.resourceName) && Objects.equals(this.deploymentId, that.deploymentId) && Objects.equals(this.apiVersion, that.apiVersion) && Objects.equals(this.dimensions, that.dimensions) && Objects.equals(this.dimensionsSetByUser, that.dimensionsSetByUser) && Objects.equals(this.maxInputTokens, that.maxInputTokens) && Objects.equals(this.similarity, that.similarity) && Objects.equals(this.rateLimitSettings, that.rateLimitSettings);
    }

    public int hashCode() {
        return Objects.hash(this.resourceName, this.deploymentId, this.apiVersion, this.dimensions, this.dimensionsSetByUser, this.maxInputTokens, this.similarity, this.rateLimitSettings);
    }

    private record CommonFields(String resourceName, String deploymentId, String apiVersion, @Nullable Integer dimensions, Boolean dimensionsSetByUser, @Nullable Integer maxInputTokens, @Nullable SimilarityMeasure similarity, RateLimitSettings rateLimitSettings) {
    }
}

