/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.rest;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestUtils;
import org.elasticsearch.rest.Scope;
import org.elasticsearch.rest.ServerlessScope;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.inference.action.PutCCMConfigurationAction;
import org.elasticsearch.xpack.inference.services.elastic.ccm.CCMFeature;

@ServerlessScope(value=Scope.INTERNAL)
public class RestPutCCMConfigurationAction
extends BaseRestHandler {
    private final CCMFeature ccmFeature;

    public RestPutCCMConfigurationAction(CCMFeature ccmFeature) {
        this.ccmFeature = Objects.requireNonNull(ccmFeature);
    }

    public String getName() {
        return "put_inference_ccm_configuration_action";
    }

    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.PUT, "_inference/_ccm"));
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest restRequest, NodeClient client) throws IOException {
        PutCCMConfigurationAction.Request putReq;
        if (!this.ccmFeature.isCcmSupportedEnvironment()) {
            throw CCMFeature.CCM_FORBIDDEN_EXCEPTION;
        }
        if (!restRequest.hasContent()) {
            throw new IllegalArgumentException("The body must be specified when configuring CCM.");
        }
        try (XContentParser parser = restRequest.contentParser();){
            putReq = PutCCMConfigurationAction.Request.parseRequest((TimeValue)RestUtils.getMasterNodeTimeout((RestRequest)restRequest), (TimeValue)RestUtils.getAckTimeout((RestRequest)restRequest), (XContentParser)parser);
        }
        return channel -> client.execute((ActionType)PutCCMConfigurationAction.INSTANCE, (ActionRequest)putReq, (ActionListener)new RestToXContentListener(channel));
    }
}

