/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.rank.textsimilarity;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.common.document.DocumentField;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.inference.ChunkingSettings;
import org.elasticsearch.inference.ChunkingStrategy;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.rank.RankShardResult;
import org.elasticsearch.search.rank.feature.RankFeatureDoc;
import org.elasticsearch.search.rank.feature.RankFeatureShardResult;
import org.elasticsearch.search.rank.rerank.RerankingRankFeaturePhaseRankShardContext;
import org.elasticsearch.xpack.core.common.chunks.MemoryIndexChunkScorer;
import org.elasticsearch.xpack.core.inference.chunking.Chunker;
import org.elasticsearch.xpack.core.inference.chunking.ChunkerBuilder;
import org.elasticsearch.xpack.inference.rank.textsimilarity.ChunkScorerConfig;

public class TextSimilarityRerankingRankFeaturePhaseRankShardContext
extends RerankingRankFeaturePhaseRankShardContext {
    private final ChunkScorerConfig chunkScorerConfig;
    private final ChunkingSettings chunkingSettings;
    private final Chunker chunker;

    public TextSimilarityRerankingRankFeaturePhaseRankShardContext(String field, @Nullable ChunkScorerConfig chunkScorerConfig) {
        super(field);
        this.chunkScorerConfig = chunkScorerConfig;
        this.chunkingSettings = chunkScorerConfig != null ? chunkScorerConfig.chunkingSettings() : null;
        this.chunker = this.chunkingSettings != null ? ChunkerBuilder.fromChunkingStrategy((ChunkingStrategy)this.chunkingSettings.getChunkingStrategy()) : null;
    }

    public RankShardResult doBuildRankFeatureShardResult(SearchHits hits, int shardId) {
        RankFeatureDoc[] rankFeatureDocs = new RankFeatureDoc[hits.getHits().length];
        for (int i = 0; i < hits.getHits().length; ++i) {
            rankFeatureDocs[i] = new RankFeatureDoc(hits.getHits()[i].docId(), hits.getHits()[i].getScore(), shardId);
            SearchHit hit = hits.getHits()[i];
            DocumentField docField = hit.field(this.field);
            if (docField == null) continue;
            if (this.chunkScorerConfig != null) {
                List<String> bestChunks;
                int size = this.chunkScorerConfig.size() != null ? this.chunkScorerConfig.size() : 1;
                List chunkOffsets = this.chunker.chunk(docField.getValue().toString(), this.chunkingSettings);
                List<String> chunks = chunkOffsets.stream().map(offset -> docField.getValue().toString().substring(offset.start(), offset.end())).toList();
                try {
                    MemoryIndexChunkScorer scorer = new MemoryIndexChunkScorer();
                    List scoredChunks = scorer.scoreChunks(chunks, this.chunkScorerConfig.inferenceText(), size);
                    bestChunks = scoredChunks.stream().map(MemoryIndexChunkScorer.ScoredChunk::content).limit(size).toList();
                }
                catch (IOException e) {
                    throw new IllegalStateException("Could not generate chunks for input to reranker", e);
                }
                rankFeatureDocs[i].featureData(bestChunks);
                continue;
            }
            rankFeatureDocs[i].featureData(List.of(docField.getValue().toString()));
        }
        return new RankFeatureShardResult(rankFeatureDocs);
    }
}

