/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.rank.textsimilarity;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.inference.ChunkingSettings;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.inference.chunking.ChunkingSettingsBuilder;
import org.elasticsearch.xpack.core.inference.chunking.SentenceBoundaryChunkingSettings;

public class ChunkScorerConfig
implements Writeable,
ToXContentObject {
    public final Integer size;
    private final String inferenceText;
    private final ChunkingSettings chunkingSettings;
    public static final int DEFAULT_CHUNK_SIZE = 300;
    public static final int DEFAULT_SIZE = 1;

    public static ChunkingSettings createChunkingSettings(Integer chunkSize) {
        int chunkSizeOrDefault = chunkSize != null ? chunkSize : 300;
        SentenceBoundaryChunkingSettings chunkingSettings = new SentenceBoundaryChunkingSettings(Integer.valueOf(chunkSizeOrDefault), Integer.valueOf(0));
        chunkingSettings.validate();
        return chunkingSettings;
    }

    public static ChunkingSettings chunkingSettingsFromMap(Map<String, Object> map) {
        if (map == null || map.isEmpty()) {
            return ChunkScorerConfig.createChunkingSettings(300);
        }
        if (map.size() == 1 && map.containsKey("max_chunk_size")) {
            return ChunkScorerConfig.createChunkingSettings((Integer)map.get("max_chunk_size"));
        }
        return ChunkingSettingsBuilder.fromMap(map);
    }

    public ChunkScorerConfig(StreamInput in) throws IOException {
        this.size = in.readOptionalVInt();
        this.inferenceText = in.readString();
        Map chunkingSettingsMap = in.readGenericMap();
        this.chunkingSettings = ChunkingSettingsBuilder.fromMap((Map)chunkingSettingsMap);
    }

    public ChunkScorerConfig(Integer size, ChunkingSettings chunkingSettings) {
        this(size, null, chunkingSettings);
    }

    public ChunkScorerConfig(Integer size, String inferenceText, ChunkingSettings chunkingSettings) {
        this.size = size;
        this.inferenceText = inferenceText;
        this.chunkingSettings = chunkingSettings;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalVInt(this.size);
        out.writeString(this.inferenceText);
        out.writeGenericMap(this.chunkingSettings.asMap());
    }

    public Integer size() {
        return this.size;
    }

    public int sizeOrDefault() {
        return this.size != null ? this.size : 1;
    }

    public String inferenceText() {
        return this.inferenceText;
    }

    public ChunkingSettings chunkingSettings() {
        return this.chunkingSettings;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChunkScorerConfig that = (ChunkScorerConfig)o;
        return Objects.equals(this.size, that.size) && Objects.equals(this.inferenceText, that.inferenceText) && Objects.equals(this.chunkingSettings, that.chunkingSettings);
    }

    public int hashCode() {
        return Objects.hash(this.size, this.inferenceText, this.chunkingSettings);
    }

    public String toString() {
        return "ChunkScorerConfig{size=" + this.sizeOrDefault() + ", inferenceText=[" + this.inferenceText + "], chunkingSettings=" + String.valueOf(this.chunkingSettings) + "}";
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("size", this.size);
        builder.field("inference_text", this.inferenceText);
        builder.field("chunking_settings");
        this.chunkingSettings.toXContent(builder, params);
        builder.endObject();
        return builder;
    }
}

