/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.queries;

import java.io.IOException;
import java.util.ArrayList;
import org.elasticsearch.features.NodeFeature;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryRewriteContext;
import org.elasticsearch.plugins.internal.rewriter.QueryRewriteInterceptor;
import org.elasticsearch.search.vectors.KnnVectorQueryBuilder;
import org.elasticsearch.xpack.inference.queries.InterceptedInferenceKnnVectorQueryBuilder;

public class SemanticKnnVectorQueryRewriteInterceptor
implements QueryRewriteInterceptor {
    public static final NodeFeature SEMANTIC_KNN_VECTOR_QUERY_FILTERS_REWRITE_INTERCEPTION_SUPPORTED = new NodeFeature("search.semantic_knn_vector_query_filters_rewrite_interception_supported");

    public QueryBuilder interceptAndRewrite(QueryRewriteContext context, QueryBuilder queryBuilder) throws IOException {
        if (queryBuilder instanceof KnnVectorQueryBuilder) {
            KnnVectorQueryBuilder knnVectorQueryBuilder = (KnnVectorQueryBuilder)queryBuilder;
            return SemanticKnnVectorQueryRewriteInterceptor.interceptKnnQuery(context, knnVectorQueryBuilder);
        }
        throw new IllegalStateException("Unexpected query builder type: " + String.valueOf(queryBuilder.getClass()));
    }

    private static InterceptedInferenceKnnVectorQueryBuilder interceptKnnQuery(QueryRewriteContext context, KnnVectorQueryBuilder knnVectorQueryBuilder) throws IOException {
        boolean changed = false;
        ArrayList<QueryBuilder> rewrittenFilters = new ArrayList<QueryBuilder>(knnVectorQueryBuilder.filterQueries().size());
        for (QueryBuilder filter : knnVectorQueryBuilder.filterQueries()) {
            QueryBuilder rewritten = filter.rewrite(context);
            if (rewritten != filter) {
                changed = true;
            }
            rewrittenFilters.add(rewritten);
        }
        if (changed) {
            knnVectorQueryBuilder.setFilterQueries(rewrittenFilters);
        }
        return new InterceptedInferenceKnnVectorQueryBuilder(knnVectorQueryBuilder);
    }

    public String getQueryName() {
        return "knn";
    }
}

