/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.queries;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.query.MatchNoneQueryBuilder;
import org.elasticsearch.index.query.MatchQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryRewriteContext;
import org.elasticsearch.inference.InferenceResults;
import org.elasticsearch.plugins.internal.rewriter.QueryRewriteInterceptor;
import org.elasticsearch.xpack.inference.mapper.SemanticTextFieldMapper;
import org.elasticsearch.xpack.inference.queries.FullyQualifiedInferenceId;
import org.elasticsearch.xpack.inference.queries.InterceptedInferenceQueryBuilder;
import org.elasticsearch.xpack.inference.queries.LegacySemanticMatchQueryRewriteInterceptor;
import org.elasticsearch.xpack.inference.queries.SemanticQueryBuilder;

public class InterceptedInferenceMatchQueryBuilder
extends InterceptedInferenceQueryBuilder<MatchQueryBuilder> {
    public static final String NAME = "intercepted_inference_match";
    private static final QueryRewriteInterceptor BWC_INTERCEPTOR = new LegacySemanticMatchQueryRewriteInterceptor();
    private static final TransportVersion NEW_SEMANTIC_QUERY_INTERCEPTORS = TransportVersion.fromName((String)"new_semantic_query_interceptors");

    public InterceptedInferenceMatchQueryBuilder(MatchQueryBuilder originalQuery) {
        super(originalQuery);
    }

    public InterceptedInferenceMatchQueryBuilder(MatchQueryBuilder originalQuery, Map<FullyQualifiedInferenceId, InferenceResults> inferenceResultsMap) {
        super(originalQuery, inferenceResultsMap);
    }

    public InterceptedInferenceMatchQueryBuilder(StreamInput in) throws IOException {
        super(in);
    }

    private InterceptedInferenceMatchQueryBuilder(InterceptedInferenceQueryBuilder<MatchQueryBuilder> other, Map<FullyQualifiedInferenceId, InferenceResults> inferenceResultsMap, SetOnce<Map<FullyQualifiedInferenceId, InferenceResults>> inferenceResultsMapSupplier, boolean ccsRequest) {
        super(other, inferenceResultsMap, inferenceResultsMapSupplier, ccsRequest);
    }

    @Override
    protected Map<String, Float> getFields() {
        return Map.of(this.getField(), Float.valueOf(1.0f));
    }

    @Override
    protected String getQuery() {
        return (String)((MatchQueryBuilder)this.originalQuery).value();
    }

    @Override
    protected QueryBuilder doRewriteBwC(QueryRewriteContext queryRewriteContext) throws IOException {
        InterceptedInferenceMatchQueryBuilder rewritten = this;
        if (!queryRewriteContext.getMinTransportVersion().supports(NEW_SEMANTIC_QUERY_INTERCEPTORS)) {
            rewritten = BWC_INTERCEPTOR.interceptAndRewrite(queryRewriteContext, (QueryBuilder)this.originalQuery);
        }
        return rewritten;
    }

    protected InterceptedInferenceQueryBuilder<MatchQueryBuilder> copy(Map<FullyQualifiedInferenceId, InferenceResults> inferenceResultsMap, SetOnce<Map<FullyQualifiedInferenceId, InferenceResults>> inferenceResultsMapSupplier, boolean ccsRequest) {
        return new InterceptedInferenceMatchQueryBuilder(this, inferenceResultsMap, inferenceResultsMapSupplier, ccsRequest);
    }

    @Override
    protected QueryBuilder queryFields(Map<String, Float> inferenceFields, Map<String, Float> nonInferenceFields, QueryRewriteContext indexMetadataContext) {
        MappedFieldType fieldType = indexMetadataContext.getFieldType(this.getField());
        Object rewritten = fieldType == null ? new MatchNoneQueryBuilder() : (fieldType instanceof SemanticTextFieldMapper.SemanticTextFieldType ? ((SemanticQueryBuilder)new SemanticQueryBuilder(this.getField(), this.getQuery(), null, this.inferenceResultsMap).boost(((MatchQueryBuilder)this.originalQuery).boost())).queryName(((MatchQueryBuilder)this.originalQuery).queryName()) : this.originalQuery);
        return rewritten;
    }

    @Override
    protected boolean resolveWildcards() {
        return false;
    }

    @Override
    protected boolean useDefaultFields() {
        return false;
    }

    public String getWriteableName() {
        return NAME;
    }

    private String getField() {
        return ((MatchQueryBuilder)this.originalQuery).fieldName();
    }
}

