/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.external.http.sender;

import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.inference.InferenceStringGroup;
import org.elasticsearch.inference.InputType;
import org.elasticsearch.xpack.inference.external.http.sender.InferenceInputs;

public class EmbeddingsInput
extends InferenceInputs {
    private final Supplier<List<InferenceStringGroup>> inputListSupplier;
    private final InputType inputType;
    private final AtomicBoolean supplierInvoked = new AtomicBoolean();

    public EmbeddingsInput(List<String> input, @Nullable InputType inputType) {
        this(() -> input.stream().map(InferenceStringGroup::new).collect(Collectors.toList()), inputType, false);
    }

    public EmbeddingsInput(List<String> input, @Nullable InputType inputType, boolean stream) {
        this(() -> input.stream().map(InferenceStringGroup::new).collect(Collectors.toList()), inputType, stream);
    }

    public EmbeddingsInput(Supplier<List<InferenceStringGroup>> inputSupplier, @Nullable InputType inputType) {
        this(inputSupplier, inputType, false);
    }

    private EmbeddingsInput(Supplier<List<InferenceStringGroup>> inputSupplier, @Nullable InputType inputType, boolean stream) {
        super(stream);
        this.inputListSupplier = Objects.requireNonNull(inputSupplier);
        this.inputType = inputType;
    }

    public List<InferenceStringGroup> getInputs() {
        assert (this.supplierInvoked.compareAndSet(false, true)) : "EmbeddingsInput supplier invoked twice";
        return this.inputListSupplier.get();
    }

    public List<String> getTextInputs() {
        assert (this.supplierInvoked.compareAndSet(false, true)) : "EmbeddingsInput supplier invoked twice";
        return InferenceStringGroup.toStringList(this.inputListSupplier.get());
    }

    public InputType getInputType() {
        return this.inputType;
    }

    @Override
    public boolean isSingleInput() {
        return false;
    }
}

