/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.common;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.TransportAction;
import org.elasticsearch.action.support.nodes.BaseNodeResponse;
import org.elasticsearch.action.support.nodes.BaseNodesRequest;
import org.elasticsearch.action.support.nodes.BaseNodesResponse;
import org.elasticsearch.action.support.nodes.TransportNodesAction;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.transport.AbstractTransportRequest;
import org.elasticsearch.transport.TransportService;

public abstract class BroadcastMessageAction<Message extends Writeable>
extends TransportNodesAction<Request<Message>, Response, NodeRequest<Message>, NodeResponse, Void> {
    protected BroadcastMessageAction(String actionName, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, Writeable.Reader<Message> messageReader) {
        super(actionName, clusterService, transportService, actionFilters, in -> new NodeRequest<Writeable>((Writeable)messageReader.read(in)), (Executor)clusterService.threadPool().executor("management"));
    }

    protected Response newResponse(Request<Message> request, List<NodeResponse> nodeResponses, List<FailedNodeException> failures) {
        return new Response(this.clusterService.getClusterName(), nodeResponses, failures);
    }

    protected NodeRequest<Message> newNodeRequest(Request<Message> request) {
        return new NodeRequest(request.message);
    }

    protected NodeResponse newNodeResponse(StreamInput in, DiscoveryNode node) throws IOException {
        return new NodeResponse(in, node);
    }

    protected NodeResponse nodeOperation(NodeRequest<Message> request, Task task) {
        this.receiveMessage(request.message);
        return new NodeResponse(this.transportService.getLocalNode());
    }

    protected abstract void receiveMessage(Message var1);

    public static <T extends Writeable> Request<T> request(T message, TimeValue timeout) {
        return new Request<T>(message, timeout);
    }

    public static class Response
    extends BaseNodesResponse<NodeResponse> {
        protected Response(ClusterName clusterName, List<NodeResponse> nodes, List<FailedNodeException> failures) {
            super(clusterName, nodes, failures);
        }

        protected List<NodeResponse> readNodesFrom(StreamInput in) throws IOException {
            return in.readCollectionAsList(NodeResponse::new);
        }

        protected void writeNodesTo(StreamOutput out, List<NodeResponse> nodes) {
            TransportAction.localOnly();
        }
    }

    public static class NodeRequest<Message extends Writeable>
    extends AbstractTransportRequest {
        private final Message message;

        private NodeRequest(Message message) {
            this.message = message;
        }

        public Task createTask(long id, String type, String action, TaskId parentTaskId, Map<String, String> headers) {
            return new CancellableTask(id, type, action, "broadcasted message to an individual node", parentTaskId, headers);
        }
    }

    public static class Request<Message extends Writeable>
    extends BaseNodesRequest {
        private final Message message;

        protected Request(Message message, TimeValue timeout) {
            super(Strings.EMPTY_ARRAY);
            this.message = message;
            this.setTimeout(timeout);
        }
    }

    public static class NodeResponse
    extends BaseNodeResponse {
        protected NodeResponse(StreamInput in) throws IOException {
            super(in);
        }

        protected NodeResponse(StreamInput in, DiscoveryNode node) throws IOException {
            super(in, node);
        }

        protected NodeResponse(DiscoveryNode node) {
            super(node);
        }
    }
}

