/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ql.index;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ResolvedIndexExpressions;
import org.elasticsearch.action.admin.indices.alias.get.GetAliasesRequest;
import org.elasticsearch.action.admin.indices.get.GetIndexRequest;
import org.elasticsearch.action.admin.indices.resolve.ResolveIndexAction;
import org.elasticsearch.action.fieldcaps.FieldCapabilities;
import org.elasticsearch.action.fieldcaps.FieldCapabilitiesRequest;
import org.elasticsearch.action.fieldcaps.FieldCapabilitiesResponse;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.master.MasterNodeRequest;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.metadata.AliasMetadata;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.mapper.TimeSeriesParams;
import org.elasticsearch.search.crossproject.CrossProjectIndexResolutionValidator;
import org.elasticsearch.transport.NoSuchRemoteClusterException;
import org.elasticsearch.transport.RemoteClusterAware;
import org.elasticsearch.xpack.ql.QlIllegalArgumentException;
import org.elasticsearch.xpack.ql.index.EsIndex;
import org.elasticsearch.xpack.ql.index.IndexResolution;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.ql.type.DataTypeRegistry;
import org.elasticsearch.xpack.ql.type.DataTypes;
import org.elasticsearch.xpack.ql.type.DateEsField;
import org.elasticsearch.xpack.ql.type.EsField;
import org.elasticsearch.xpack.ql.type.InvalidMappedField;
import org.elasticsearch.xpack.ql.type.KeywordEsField;
import org.elasticsearch.xpack.ql.type.TextEsField;
import org.elasticsearch.xpack.ql.type.UnsupportedEsField;
import org.elasticsearch.xpack.ql.util.CollectionUtils;
import org.elasticsearch.xpack.ql.util.Holder;
import org.elasticsearch.xpack.ql.util.StringUtils;

public class IndexResolver {
    public static final String SQL_TABLE = "TABLE";
    public static final String SQL_VIEW = "VIEW";
    private static final IndicesOptions INDICES_ONLY_OPTIONS = IndicesOptions.builder().concreteTargetOptions(IndicesOptions.ConcreteTargetOptions.ALLOW_UNAVAILABLE_TARGETS).wildcardOptions(IndicesOptions.WildcardOptions.builder().matchOpen(true).matchClosed(false).includeHidden(false).allowEmptyExpressions(true).resolveAliases(false)).gatekeeperOptions(IndicesOptions.GatekeeperOptions.builder().ignoreThrottled(true).allowClosedIndices(true).allowAliasToMultipleIndices(true)).build();
    private static final IndicesOptions FROZEN_INDICES_OPTIONS = IndicesOptions.builder().concreteTargetOptions(IndicesOptions.ConcreteTargetOptions.ALLOW_UNAVAILABLE_TARGETS).wildcardOptions(IndicesOptions.WildcardOptions.builder().matchOpen(true).matchClosed(false).includeHidden(false).allowEmptyExpressions(true).resolveAliases(false)).gatekeeperOptions(IndicesOptions.GatekeeperOptions.builder().ignoreThrottled(false).allowClosedIndices(true).allowAliasToMultipleIndices(true)).build();
    public static final IndicesOptions FIELD_CAPS_INDICES_OPTIONS = IndicesOptions.builder().concreteTargetOptions(IndicesOptions.ConcreteTargetOptions.ALLOW_UNAVAILABLE_TARGETS).wildcardOptions(IndicesOptions.WildcardOptions.builder().matchOpen(true).matchClosed(false).includeHidden(false).allowEmptyExpressions(true).resolveAliases(true)).gatekeeperOptions(IndicesOptions.GatekeeperOptions.builder().ignoreThrottled(true).allowClosedIndices(true).allowAliasToMultipleIndices(true)).build();
    public static final IndicesOptions FIELD_CAPS_FROZEN_INDICES_OPTIONS = IndicesOptions.builder().concreteTargetOptions(IndicesOptions.ConcreteTargetOptions.ALLOW_UNAVAILABLE_TARGETS).wildcardOptions(IndicesOptions.WildcardOptions.builder().matchOpen(true).matchClosed(false).includeHidden(false).allowEmptyExpressions(true).resolveAliases(true)).gatekeeperOptions(IndicesOptions.GatekeeperOptions.builder().ignoreThrottled(false).allowClosedIndices(true).allowAliasToMultipleIndices(true)).build();
    public static final Set<String> ALL_FIELDS = Set.of("*");
    public static final Set<String> INDEX_METADATA_FIELD = Set.of("_index");
    public static final String UNMAPPED = "unmapped";
    private final Client client;
    private final String clusterName;
    private final DataTypeRegistry typeRegistry;
    private final Supplier<Set<String>> remoteClusters;
    public static final ExistingFieldInvalidCallback PRESERVE_PROPERTIES = (oldField, newField) -> {
        Map<String, EsField> oldProps = oldField.getProperties();
        if (oldProps.size() > 0) {
            newField.getProperties().putAll(oldProps);
        }
    };

    public IndexResolver(Client client, String clusterName, DataTypeRegistry typeRegistry, Supplier<Set<String>> remoteClusters) {
        this.client = client;
        this.clusterName = clusterName;
        this.typeRegistry = typeRegistry;
        this.remoteClusters = remoteClusters;
    }

    public String clusterName() {
        return this.clusterName;
    }

    public Set<String> remoteClusters() {
        return this.remoteClusters.get();
    }

    public void resolveNames(String clusterWildcard, String indexWildcard, String javaRegex, EnumSet<IndexType> types, ActionListener<Set<IndexInfo>> listener) {
        boolean retrieveAliases = CollectionUtils.isEmpty(types) || types.contains((Object)IndexType.ALIAS);
        boolean retrieveIndices = CollectionUtils.isEmpty(types) || types.contains((Object)IndexType.STANDARD_INDEX);
        boolean retrieveFrozenIndices = CollectionUtils.isEmpty(types) || types.contains((Object)IndexType.FROZEN_INDEX);
        String[] indexWildcards = Strings.commaDelimitedListToStringArray((String)indexWildcard);
        HashSet<IndexInfo> indexInfos = new HashSet<IndexInfo>();
        if (retrieveAliases && this.clusterIsLocal(clusterWildcard)) {
            ResolveIndexAction.Request resolveRequest = new ResolveIndexAction.Request(indexWildcards, IndicesOptions.lenientExpandOpen());
            this.client.admin().indices().resolveIndex(resolveRequest, ActionListener.wrap(response -> {
                for (ResolveIndexAction.ResolvedAlias alias : response.getAliases()) {
                    indexInfos.add(new IndexInfo(this.clusterName, alias.getName(), IndexType.ALIAS));
                }
                for (ResolveIndexAction.ResolvedDataStream dataStream : response.getDataStreams()) {
                    indexInfos.add(new IndexInfo(this.clusterName, dataStream.getName(), IndexType.ALIAS));
                }
                this.resolveIndices(clusterWildcard, indexWildcards, javaRegex, retrieveIndices, retrieveFrozenIndices, indexInfos, listener);
            }, ex -> {
                if (ex instanceof IndexNotFoundException || ex instanceof ElasticsearchSecurityException) {
                    this.resolveIndices(clusterWildcard, indexWildcards, javaRegex, retrieveIndices, retrieveFrozenIndices, indexInfos, listener);
                } else {
                    listener.onFailure(ex);
                }
            }));
        } else {
            this.resolveIndices(clusterWildcard, indexWildcards, javaRegex, retrieveIndices, retrieveFrozenIndices, indexInfos, listener);
        }
    }

    private void resolveIndices(String clusterWildcard, String[] indexWildcards, String javaRegex, boolean retrieveIndices, boolean retrieveFrozenIndices, Set<IndexInfo> indexInfos, ActionListener<Set<IndexInfo>> listener) {
        if (retrieveIndices || retrieveFrozenIndices) {
            if (this.clusterIsLocal(clusterWildcard)) {
                GetIndexRequest indexRequest = new GetIndexRequest(MasterNodeRequest.INFINITE_MASTER_NODE_TIMEOUT).indices(indexWildcards).features(new GetIndexRequest.Feature[]{GetIndexRequest.Feature.SETTINGS}).includeDefaults(false).indicesOptions(INDICES_ONLY_OPTIONS);
                if (retrieveFrozenIndices) {
                    indexRequest.indicesOptions(FROZEN_INDICES_OPTIONS);
                }
                this.client.admin().indices().getIndex(indexRequest, listener.delegateFailureAndWrap((delegate, indices) -> {
                    if (indices != null) {
                        for (String indexName : indices.getIndices()) {
                            boolean isFrozen = retrieveFrozenIndices && ((Settings)indices.getSettings().get(indexName)).getAsBoolean("index.frozen", Boolean.valueOf(false)) != false;
                            indexInfos.add(new IndexInfo(this.clusterName, indexName, isFrozen ? IndexType.FROZEN_INDEX : IndexType.STANDARD_INDEX));
                        }
                    }
                    this.resolveRemoteIndices(clusterWildcard, indexWildcards, javaRegex, retrieveFrozenIndices, indexInfos, (ActionListener<Set<IndexInfo>>)delegate);
                }));
            } else {
                this.resolveRemoteIndices(clusterWildcard, indexWildcards, javaRegex, retrieveFrozenIndices, indexInfos, listener);
            }
        } else {
            IndexResolver.filterResults(javaRegex, indexInfos, listener);
        }
    }

    private void resolveRemoteIndices(String clusterWildcard, String[] indexWildcards, String javaRegex, boolean retrieveFrozenIndices, Set<IndexInfo> indexInfos, ActionListener<Set<IndexInfo>> listener) {
        if (Strings.hasText((String)clusterWildcard)) {
            IndicesOptions indicesOptions = retrieveFrozenIndices ? FIELD_CAPS_FROZEN_INDICES_OPTIONS : FIELD_CAPS_INDICES_OPTIONS;
            FieldCapabilitiesRequest fieldRequest = IndexResolver.createFieldCapsRequest(StringUtils.qualifyAndJoinIndices(clusterWildcard, indexWildcards), ALL_FIELDS, indicesOptions, Collections.emptyMap());
            this.client.fieldCaps(fieldRequest, ActionListener.wrap(response -> {
                String[] indices = response.getIndices();
                if (indices != null) {
                    for (String indexName : indices) {
                        Tuple<String, String> splitRef = StringUtils.splitQualifiedIndex(indexName);
                        String cluster = splitRef.v1() == null ? this.clusterName : (String)splitRef.v1();
                        indexInfos.add(new IndexInfo(cluster, (String)splitRef.v2(), IndexType.STANDARD_INDEX));
                    }
                }
                IndexResolver.filterResults(javaRegex, indexInfos, listener);
            }, ex -> {
                if (ex instanceof NoSuchRemoteClusterException || ex instanceof ElasticsearchSecurityException) {
                    IndexResolver.filterResults(javaRegex, indexInfos, listener);
                } else {
                    listener.onFailure(ex);
                }
            }));
        } else {
            IndexResolver.filterResults(javaRegex, indexInfos, listener);
        }
    }

    private static void filterResults(String javaRegex, Set<IndexInfo> indexInfos, ActionListener<Set<IndexInfo>> listener) {
        Pattern pattern = javaRegex != null ? Pattern.compile(javaRegex) : null;
        TreeSet<IndexInfo> result = new TreeSet<IndexInfo>(Comparator.comparing(IndexInfo::cluster).thenComparing(IndexInfo::name));
        for (IndexInfo indexInfo : indexInfos) {
            if (pattern != null && !pattern.matcher(indexInfo.name()).matches()) continue;
            result.add(indexInfo);
        }
        listener.onResponse(result);
    }

    private boolean clusterIsLocal(String clusterWildcard) {
        return clusterWildcard == null || Regex.simpleMatch((String)clusterWildcard, (String)this.clusterName);
    }

    public void resolveAsMergedMapping(String indexWildcard, Set<String> fieldNames, IndicesOptions indicesOptions, Map<String, Object> runtimeMappings, boolean crossProjectEnabled, String projectRouting, ResolvedIndexExpressions resolvedIndexExpressions, ActionListener<IndexResolution> listener) {
        IndicesOptions iOpts = crossProjectEnabled ? CrossProjectIndexResolutionValidator.indicesOptionsForCrossProjectFanout((IndicesOptions)indicesOptions) : indicesOptions;
        FieldCapabilitiesRequest fieldRequest = IndexResolver.createFieldCapsRequest(indexWildcard, fieldNames, iOpts, runtimeMappings);
        if (crossProjectEnabled) {
            fieldRequest.includeResolvedTo(true);
        }
        this.client.fieldCaps(fieldRequest, listener.delegateFailureAndWrap((l, response) -> {
            Map resolvedRemotely;
            ElasticsearchException ex;
            if (crossProjectEnabled && (ex = CrossProjectIndexResolutionValidator.validate((IndicesOptions)iOpts, (String)projectRouting, (ResolvedIndexExpressions)resolvedIndexExpressions, (Map)(resolvedRemotely = response.getResolvedRemotely()))) != null) {
                l.onFailure((Exception)ex);
                return;
            }
            l.onResponse((Object)IndexResolver.mergedMappings(this.typeRegistry, indexWildcard, response));
        }));
    }

    public void resolveAsMergedMapping(String indexWildcard, Set<String> fieldNames, boolean includeFrozen, Map<String, Object> runtimeMappings, boolean setCpsOptions, String projectRouting, ActionListener<IndexResolution> listener) {
        this.resolveAsMergedMapping(indexWildcard, fieldNames, includeFrozen, runtimeMappings, setCpsOptions, projectRouting, listener, (String fieldName, Map<String, FieldCapabilities> types) -> null);
    }

    public void resolveAsMergedMapping(String indexWildcard, Set<String> fieldNames, boolean includeFrozen, Map<String, Object> runtimeMappings, boolean setCpsOptions, String projectRouting, ActionListener<IndexResolution> listener, BiFunction<String, Map<String, FieldCapabilities>, InvalidMappedField> specificValidityVerifier) {
        FieldCapabilitiesRequest fieldRequest = IndexResolver.createFieldCapsRequest(indexWildcard, fieldNames, includeFrozen, runtimeMappings);
        if (setCpsOptions) {
            if (projectRouting != null) {
                fieldRequest.projectRouting(projectRouting);
            }
            fieldRequest.indicesOptions(IndicesOptions.builder((IndicesOptions)fieldRequest.indicesOptions()).crossProjectModeOptions(new IndicesOptions.CrossProjectModeOptions(true)).build());
        }
        this.client.fieldCaps(fieldRequest, listener.delegateFailureAndWrap((l, response) -> l.onResponse((Object)IndexResolver.mergedMappings(this.typeRegistry, indexWildcard, response, specificValidityVerifier, null, null))));
    }

    public void resolveAsMergedMapping(String indexWildcard, Set<String> fieldNames, boolean includeFrozen, Map<String, Object> runtimeMappings, ActionListener<IndexResolution> listener, BiFunction<String, Map<String, FieldCapabilities>, InvalidMappedField> specificValidityVerifier, BiConsumer<EsField, InvalidMappedField> fieldUpdater, Set<String> allowedMetadataFields) {
        FieldCapabilitiesRequest fieldRequest = IndexResolver.createFieldCapsRequest(indexWildcard, fieldNames, includeFrozen, runtimeMappings);
        this.client.fieldCaps(fieldRequest, listener.delegateFailureAndWrap((l, response) -> l.onResponse((Object)IndexResolver.mergedMappings(this.typeRegistry, indexWildcard, response, specificValidityVerifier, fieldUpdater, allowedMetadataFields))));
    }

    public static IndexResolution mergedMappings(DataTypeRegistry typeRegistry, String indexPattern, FieldCapabilitiesResponse fieldCapsResponse, BiFunction<String, Map<String, FieldCapabilities>, InvalidMappedField> specificValidityVerifier) {
        return IndexResolver.mergedMappings(typeRegistry, indexPattern, fieldCapsResponse, specificValidityVerifier, null, null);
    }

    public static IndexResolution mergedMappings(DataTypeRegistry typeRegistry, String indexPattern, FieldCapabilitiesResponse fieldCapsResponse, BiFunction<String, Map<String, FieldCapabilities>, InvalidMappedField> specificValidityVerifier, BiConsumer<EsField, InvalidMappedField> fieldUpdater, Set<String> allowedMetadataFields) {
        if (fieldCapsResponse.getIndices().length == 0) {
            return IndexResolution.notFound(indexPattern);
        }
        BiFunction<String, Map<String, FieldCapabilities>, InvalidMappedField> validityVerifier = (fieldName, types) -> {
            InvalidMappedField f = (InvalidMappedField)specificValidityVerifier.apply((String)fieldName, (Map<String, FieldCapabilities>)types);
            if (f != null) {
                return f;
            }
            StringBuilder errorMessage = new StringBuilder();
            boolean hasUnmapped = types.containsKey(UNMAPPED);
            if (types.size() > (hasUnmapped ? 2 : 1)) {
                for (Map.Entry type : types.entrySet()) {
                    if (UNMAPPED.equals(type.getKey())) continue;
                    if (errorMessage.length() > 0) {
                        errorMessage.append(", ");
                    }
                    errorMessage.append("[");
                    errorMessage.append((String)type.getKey());
                    errorMessage.append("] in ");
                    errorMessage.append(Arrays.toString(((FieldCapabilities)type.getValue()).indices()));
                }
                errorMessage.insert(0, "mapped as [" + (types.size() - (hasUnmapped ? 1 : 0)) + "] incompatible types: ");
                return new InvalidMappedField((String)fieldName, errorMessage.toString());
            }
            FieldCapabilities fieldCap = (FieldCapabilities)types.values().iterator().next();
            if (fieldCap.isAggregatable() && fieldCap.nonAggregatableIndices() != null) {
                errorMessage.append("mapped as aggregatable except in ");
                errorMessage.append(Arrays.toString(fieldCap.nonAggregatableIndices()));
            }
            if (fieldCap.isSearchable() && fieldCap.nonSearchableIndices() != null) {
                if (errorMessage.length() > 0) {
                    errorMessage.append(",");
                }
                errorMessage.append("mapped as searchable except in ");
                errorMessage.append(Arrays.toString(fieldCap.nonSearchableIndices()));
            }
            if (errorMessage.length() > 0) {
                return new InvalidMappedField((String)fieldName, errorMessage.toString());
            }
            return null;
        };
        List<EsIndex> indices = IndexResolver.buildIndices(typeRegistry, null, fieldCapsResponse, null, i -> indexPattern, validityVerifier, fieldUpdater, allowedMetadataFields);
        if (indices.size() > 1) {
            throw new QlIllegalArgumentException("Incorrect merging of mappings (likely due to a bug) - expect at most one but found [{}]", indices.size());
        }
        String[] indexNames = fieldCapsResponse.getIndices();
        if (indices.isEmpty()) {
            return IndexResolution.valid(new EsIndex(indexNames[0], Collections.emptyMap(), Set.of()));
        }
        EsIndex idx = indices.get(0);
        return IndexResolution.valid(new EsIndex(idx.name(), idx.mapping(), Set.of(indexNames)));
    }

    public static IndexResolution mergedMappings(DataTypeRegistry typeRegistry, String indexPattern, FieldCapabilitiesResponse fieldCapsResponse) {
        return IndexResolver.mergedMappings(typeRegistry, indexPattern, fieldCapsResponse, (fieldName, types) -> null, null, null);
    }

    private static EsField createField(DataTypeRegistry typeRegistry, String fieldName, Map<String, Map<String, FieldCapabilities>> globalCaps, Map<String, EsField> hierarchicalMapping, Map<String, EsField> flattedMapping, Function<String, EsField> field) {
        Map<String, EsField> parentProps = hierarchicalMapping;
        int dot = fieldName.lastIndexOf(46);
        String fullFieldName = fieldName;
        EsField parent = null;
        if (dot >= 0) {
            String parentName = fieldName.substring(0, dot);
            fieldName = fieldName.substring(dot + 1);
            parent = flattedMapping.get(parentName);
            if (parent == null) {
                Function<String, EsField> fieldFunction;
                Map<String, FieldCapabilities> map = globalCaps.get(parentName);
                if (map == null) {
                    fieldFunction = s -> IndexResolver.createField(typeRegistry, s, DataTypes.OBJECT.esType(), null, new TreeMap<String, EsField>(), false, true);
                } else {
                    Iterator<FieldCapabilities> iterator = map.values().iterator();
                    FieldCapabilities parentCap = iterator.next();
                    if (iterator.hasNext() && UNMAPPED.equals(parentCap.getType())) {
                        parentCap = iterator.next();
                    }
                    FieldCapabilities parentC = parentCap;
                    fieldFunction = s -> IndexResolver.createField(typeRegistry, s, parentC.getType(), parentC.getMetricType(), new TreeMap<String, EsField>(), parentC.isAggregatable(), false);
                }
                parent = IndexResolver.createField(typeRegistry, parentName, globalCaps, hierarchicalMapping, flattedMapping, fieldFunction);
            }
            parentProps = parent.getProperties();
        }
        EsField esField = field.apply(fieldName);
        if (parent instanceof UnsupportedEsField) {
            UnsupportedEsField unsupportedParent = (UnsupportedEsField)parent;
            String inherited = unsupportedParent.getInherited();
            String type = unsupportedParent.getOriginalType();
            esField = inherited == null ? new UnsupportedEsField(esField.getName(), type, unsupportedParent.getName(), esField.getProperties()) : new UnsupportedEsField(esField.getName(), type, inherited, esField.getProperties());
        }
        parentProps.put(fieldName, esField);
        flattedMapping.put(fullFieldName, esField);
        return esField;
    }

    private static EsField createField(DataTypeRegistry typeRegistry, String fieldName, String typeName, TimeSeriesParams.MetricType metricType, Map<String, EsField> props, boolean isAggregateable, boolean isAlias) {
        DataType esType = typeRegistry.fromEs(typeName, metricType);
        if (esType == DataTypes.TEXT) {
            return new TextEsField(fieldName, props, false, isAlias);
        }
        if (esType == DataTypes.KEYWORD) {
            int length = Short.MAX_VALUE;
            boolean normalized = false;
            return new KeywordEsField(fieldName, props, isAggregateable, length, normalized, isAlias);
        }
        if (esType == DataTypes.DATETIME) {
            return DateEsField.dateEsField(fieldName, props, isAggregateable);
        }
        if (esType == DataTypes.UNSUPPORTED) {
            String originalType = metricType == TimeSeriesParams.MetricType.COUNTER ? "counter" : typeName;
            return new UnsupportedEsField(fieldName, originalType, null, props);
        }
        return new EsField(fieldName, esType, props, isAggregateable, isAlias);
    }

    private static FieldCapabilitiesRequest createFieldCapsRequest(String index, Set<String> fieldNames, IndicesOptions indicesOptions, Map<String, Object> runtimeMappings) {
        return new FieldCapabilitiesRequest().indices(Strings.commaDelimitedListToStringArray((String)index)).fields((String[])fieldNames.toArray(String[]::new)).includeUnmapped(true).runtimeFields(runtimeMappings).indicesOptions(indicesOptions);
    }

    private static FieldCapabilitiesRequest createFieldCapsRequest(String index, Set<String> fieldNames, boolean includeFrozen, Map<String, Object> runtimeMappings) {
        IndicesOptions indicesOptions = includeFrozen ? FIELD_CAPS_FROZEN_INDICES_OPTIONS : FIELD_CAPS_INDICES_OPTIONS;
        return IndexResolver.createFieldCapsRequest(index, fieldNames, indicesOptions, runtimeMappings);
    }

    public void resolveAsSeparateMappings(String indexWildcard, String javaRegex, boolean includeFrozen, Map<String, Object> runtimeMappings, boolean crossProjectEnabled, String projectRouting, ActionListener<List<EsIndex>> listener) {
        FieldCapabilitiesRequest fieldRequest = IndexResolver.createFieldCapsRequest(indexWildcard, ALL_FIELDS, includeFrozen, runtimeMappings);
        if (crossProjectEnabled) {
            fieldRequest.indicesOptions(IndicesOptions.builder((IndicesOptions)fieldRequest.indicesOptions()).crossProjectModeOptions(new IndicesOptions.CrossProjectModeOptions(true)).build());
            if (projectRouting != null) {
                fieldRequest.projectRouting(projectRouting);
            }
        }
        this.client.fieldCaps(fieldRequest, listener.delegateFailureAndWrap((delegate, response) -> this.client.admin().indices().getAliases(IndexResolver.createGetAliasesRequest(response, includeFrozen), ActionListener.wrap(aliases -> delegate.onResponse(IndexResolver.separateMappings(this.typeRegistry, javaRegex, response, aliases.getAliases())), ex -> {
            if (ex instanceof IndexNotFoundException || ex instanceof ElasticsearchSecurityException) {
                delegate.onResponse(IndexResolver.separateMappings(this.typeRegistry, javaRegex, response, null));
            } else {
                delegate.onFailure(ex);
            }
        }))));
    }

    private static GetAliasesRequest createGetAliasesRequest(FieldCapabilitiesResponse response, boolean includeFrozen) {
        return new GetAliasesRequest(MasterNodeRequest.INFINITE_MASTER_NODE_TIMEOUT, new String[0]).aliases(new String[]{"*"}).indices(response.getIndices()).indicesOptions(includeFrozen ? FIELD_CAPS_FROZEN_INDICES_OPTIONS : FIELD_CAPS_INDICES_OPTIONS);
    }

    public static List<EsIndex> separateMappings(DataTypeRegistry typeRegistry, String javaRegex, FieldCapabilitiesResponse fieldCaps, Map<String, List<AliasMetadata>> aliases) {
        return IndexResolver.buildIndices(typeRegistry, javaRegex, fieldCaps, aliases, Function.identity(), (s, cap) -> null, null, null);
    }

    private static List<EsIndex> buildIndices(DataTypeRegistry typeRegistry, String javaRegex, FieldCapabilitiesResponse fieldCapsResponse, Map<String, List<AliasMetadata>> aliases, Function<String, String> indexNameProcessor, BiFunction<String, Map<String, FieldCapabilities>, InvalidMappedField> validityVerifier, BiConsumer<EsField, InvalidMappedField> fieldUpdater, Set<String> allowedMetadataFields) {
        String fieldName;
        if (!(fieldCapsResponse.getIndices() != null && fieldCapsResponse.getIndices().length != 0 || aliases != null && !aliases.isEmpty())) {
            return Collections.emptyList();
        }
        HashSet<String> resolvedAliases = new HashSet<String>();
        if (aliases != null) {
            for (List<AliasMetadata> aliasList : aliases.values()) {
                for (AliasMetadata alias : aliasList) {
                    resolvedAliases.add(alias.getAlias());
                }
            }
        }
        LinkedHashMap indices = Maps.newLinkedHashMapWithExpectedSize((int)(fieldCapsResponse.getIndices().length + resolvedAliases.size()));
        Pattern pattern = javaRegex != null ? Pattern.compile(javaRegex) : null;
        TreeMap sortedFields = new TreeMap(Collections.reverseOrder());
        Map fieldCaps = fieldCapsResponse.get();
        for (Map.Entry entry : fieldCaps.entrySet()) {
            fieldName = (String)entry.getKey();
            if ((allowedMetadataFields == null || !allowedMetadataFields.contains(fieldName)) && fieldCapsResponse.isMetadataField(fieldName)) continue;
            sortedFields.put(fieldName, (Map)entry.getValue());
        }
        for (Map.Entry entry : sortedFields.entrySet()) {
            fieldName = (String)entry.getKey();
            Map types = (Map)entry.getValue();
            InvalidMappedField invalidField = validityVerifier.apply(fieldName, types);
            Map<String, InvalidMappedField> invalidFieldsForAliases = IndexResolver.getInvalidFieldsForAliases(fieldName, types, aliases);
            boolean isMetadataField = allowedMetadataFields != null && allowedMetadataFields.contains(fieldName);
            for (Map.Entry typeEntry : types.entrySet()) {
                if (UNMAPPED.equals(typeEntry.getKey())) continue;
                FieldCapabilities typeCap = (FieldCapabilities)typeEntry.getValue();
                String[] capIndices = typeCap.indices();
                String[] concreteIndices = capIndices != null ? capIndices : fieldCapsResponse.getIndices();
                LinkedHashSet<String> uniqueAliases = new LinkedHashSet<String>();
                for (String index : concreteIndices) {
                    EsField newField;
                    List<AliasMetadata> concreteIndexAliases;
                    List<AliasMetadata> list = concreteIndexAliases = aliases != null ? aliases.get(index) : null;
                    if (concreteIndexAliases != null) {
                        for (AliasMetadata e : concreteIndexAliases) {
                            uniqueAliases.add(e.alias());
                        }
                    }
                    if (pattern != null && !pattern.matcher((CharSequence)StringUtils.splitQualifiedIndex(index).v2()).matches()) continue;
                    String indexName = indexNameProcessor.apply(index);
                    Fields indexFields = indices.computeIfAbsent(indexName, k -> new Fields());
                    EsField field = indexFields.flattedMapping.get(fieldName);
                    if (isMetadataField || field != null && (invalidField == null || field instanceof InvalidMappedField)) continue;
                    IndexResolver.createField(typeRegistry, fieldName, indexFields, fieldCaps, invalidField, typeCap);
                    if (fieldUpdater == null || field == null || (newField = indexFields.flattedMapping.get(fieldName)) == field || !(newField instanceof InvalidMappedField)) continue;
                    InvalidMappedField newInvalidField = (InvalidMappedField)newField;
                    fieldUpdater.accept(field, newInvalidField);
                }
                for (String index : uniqueAliases) {
                    Fields indexFields = indices.computeIfAbsent(index, k -> new Fields());
                    EsField field = indexFields.flattedMapping.get(fieldName);
                    if (isMetadataField || field != null || invalidFieldsForAliases.get(index) != null) continue;
                    IndexResolver.createField(typeRegistry, fieldName, indexFields, fieldCaps, invalidField, typeCap);
                }
            }
        }
        ArrayList<EsIndex> foundIndices = new ArrayList<EsIndex>(indices.size());
        for (Map.Entry entry : indices.entrySet()) {
            foundIndices.add(new EsIndex((String)entry.getKey(), ((Fields)entry.getValue()).hierarchicalMapping, Set.of((String)entry.getKey())));
        }
        foundIndices.sort(Comparator.comparing(EsIndex::name));
        return foundIndices;
    }

    private static void createField(DataTypeRegistry typeRegistry, String fieldName, Fields indexFields, Map<String, Map<String, FieldCapabilities>> fieldCaps, InvalidMappedField invalidField, FieldCapabilities typeCap) {
        String parentName;
        int dot = fieldName.lastIndexOf(46);
        Holder<Boolean> isAliasFieldType = new Holder<Boolean>(false);
        if (dot >= 0 && indexFields.flattedMapping.get(parentName = fieldName.substring(0, dot)) == null && fieldCaps.get(parentName) == null) {
            isAliasFieldType.set(true);
        }
        IndexResolver.createField(typeRegistry, fieldName, fieldCaps, indexFields.hierarchicalMapping, indexFields.flattedMapping, (String s) -> invalidField != null ? invalidField : IndexResolver.createField(typeRegistry, s, typeCap.getType(), typeCap.getMetricType(), new TreeMap<String, EsField>(), typeCap.isAggregatable(), (Boolean)isAliasFieldType.get()));
    }

    private static Map<String, InvalidMappedField> getInvalidFieldsForAliases(String fieldName, Map<String, FieldCapabilities> types, Map<String, List<AliasMetadata>> aliases) {
        if (aliases == null || aliases.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, InvalidMappedField> invalidFields = new HashMap<String, InvalidMappedField>();
        HashMap typesErrors = new HashMap();
        HashMap aliasToIndices = new HashMap();
        for (Map.Entry<String, List<AliasMetadata>> entry : aliases.entrySet()) {
            for (AliasMetadata aliasMetadata : entry.getValue()) {
                String[] aliasName = aliasMetadata.alias();
                aliasToIndices.putIfAbsent(aliasName, new HashSet());
                ((Set)aliasToIndices.get(aliasName)).add(entry.getKey());
            }
        }
        for (Map.Entry<String, List<AliasMetadata>> entry : types.entrySet()) {
            String[] indices;
            String esFieldType = entry.getKey();
            if (Objects.equals(esFieldType, UNMAPPED) || (indices = ((FieldCapabilities)entry.getValue()).indices()) == null) continue;
            for (String index : indices) {
                List<AliasMetadata> indexAliases = aliases.get(index);
                if (indexAliases == null) continue;
                for (AliasMetadata aliasMetadata : indexAliases) {
                    String aliasName = aliasMetadata.alias();
                    if (typesErrors.containsKey(aliasName)) {
                        ((Set)typesErrors.get(aliasName)).add(esFieldType);
                        continue;
                    }
                    HashSet<String> fieldTypes = new HashSet<String>();
                    fieldTypes.add(esFieldType);
                    typesErrors.put(aliasName, fieldTypes);
                }
            }
        }
        block5: for (String string : aliasToIndices.keySet()) {
            Set esFieldTypes = (Set)typesErrors.get(string);
            if (esFieldTypes != null && esFieldTypes.size() > 1) {
                invalidFields.put(string, new InvalidMappedField(fieldName));
                continue;
            }
            for (Map.Entry<String, FieldCapabilities> type : types.entrySet()) {
                Set aliasIndices;
                if (Objects.equals(type.getKey(), UNMAPPED)) continue;
                FieldCapabilities f = type.getValue();
                if (f.nonAggregatableIndices() != null) {
                    aliasIndices = (Set)aliasToIndices.get(string);
                    int nonAggregatableCount = 0;
                    for (String nonAggIndex : f.nonAggregatableIndices()) {
                        if (!aliasIndices.contains(nonAggIndex)) continue;
                        ++nonAggregatableCount;
                    }
                    if (nonAggregatableCount > 0 && nonAggregatableCount != aliasIndices.size()) {
                        invalidFields.put(string, new InvalidMappedField(fieldName));
                        continue block5;
                    }
                }
                if (f.nonSearchableIndices() == null) continue;
                aliasIndices = (Set)aliasToIndices.get(string);
                int nonSearchableCount = 0;
                for (String nonSearchIndex : f.nonSearchableIndices()) {
                    if (!aliasIndices.contains(nonSearchIndex)) continue;
                    ++nonSearchableCount;
                }
                if (nonSearchableCount <= 0 || nonSearchableCount == aliasIndices.size()) continue;
                invalidFields.put(string, new InvalidMappedField(fieldName));
                continue block5;
            }
        }
        if (invalidFields.size() > 0) {
            return invalidFields;
        }
        return Collections.emptyMap();
    }

    public static enum IndexType {
        STANDARD_INDEX("TABLE", "INDEX"),
        ALIAS("VIEW", "ALIAS"),
        FROZEN_INDEX("TABLE", "FROZEN INDEX"),
        UNKNOWN("UNKNOWN", "UNKNOWN");

        public static final EnumSet<IndexType> VALID_INCLUDE_FROZEN;
        public static final EnumSet<IndexType> VALID_REGULAR;
        private final String toSql;
        private final String toNative;

        private IndexType(String sql, String toNative) {
            this.toSql = sql;
            this.toNative = toNative;
        }

        public String toSql() {
            return this.toSql;
        }

        public String toNative() {
            return this.toNative;
        }

        static {
            VALID_INCLUDE_FROZEN = EnumSet.of(STANDARD_INDEX, ALIAS, FROZEN_INDEX);
            VALID_REGULAR = EnumSet.of(STANDARD_INDEX, ALIAS);
        }
    }

    public record IndexInfo(String cluster, String name, IndexType type) {
        @Override
        public String toString() {
            return RemoteClusterAware.buildRemoteIndexName((String)this.cluster, (String)this.name);
        }
    }

    private static class Fields {
        final Map<String, EsField> hierarchicalMapping = new TreeMap<String, EsField>();
        final Map<String, EsField> flattedMapping = new LinkedHashMap<String, EsField>();

        private Fields() {
        }
    }

    public static interface ExistingFieldInvalidCallback
    extends BiConsumer<EsField, InvalidMappedField> {
    }
}

