/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.datastreams.action;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.concurrent.Executor;
import org.apache.lucene.document.LongPoint;
import org.apache.lucene.index.DocValuesSkipper;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.search.IndexSearcher;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.datastreams.DataStreamsActionUtil;
import org.elasticsearch.action.datastreams.DataStreamsStatsAction;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.DefaultShardOperationFailedException;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.broadcast.BroadcastRequest;
import org.elasticsearch.action.support.broadcast.node.TransportBroadcastByNodeAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.DataStream;
import org.elasticsearch.cluster.metadata.IndexAbstraction;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.ProjectMetadata;
import org.elasticsearch.cluster.project.ProjectResolver;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.ShardsIterator;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.store.StoreStats;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;

public class TransportDataStreamsStatsAction
extends TransportBroadcastByNodeAction<DataStreamsStatsAction.Request, DataStreamsStatsAction.Response, DataStreamsStatsAction.DataStreamShardStats, Void> {
    private final IndicesService indicesService;
    private final ProjectResolver projectResolver;

    @Inject
    public TransportDataStreamsStatsAction(ClusterService clusterService, TransportService transportService, IndicesService indicesService, ActionFilters actionFilters, ProjectResolver projectResolver, IndexNameExpressionResolver indexNameExpressionResolver) {
        super("indices:monitor/data_stream/stats", clusterService, transportService, actionFilters, indexNameExpressionResolver, DataStreamsStatsAction.Request::new, (Executor)transportService.getThreadPool().executor("management"));
        this.indicesService = indicesService;
        this.projectResolver = projectResolver;
    }

    protected void doExecute(Task task, DataStreamsStatsAction.Request request, ActionListener<DataStreamsStatsAction.Response> listener) {
        request.indicesOptions(DataStreamsActionUtil.updateIndicesOptions((IndicesOptions)request.indicesOptions()));
        super.doExecute(task, (BroadcastRequest)request, listener);
    }

    protected DataStreamsStatsAction.Request readRequestFrom(StreamInput in) throws IOException {
        return new DataStreamsStatsAction.Request(in);
    }

    protected ClusterBlockException checkGlobalBlock(ClusterState state, DataStreamsStatsAction.Request request) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_READ);
    }

    protected ClusterBlockException checkRequestBlock(ClusterState state, DataStreamsStatsAction.Request request, String[] concreteIndices) {
        return state.blocks().indicesBlockedException(this.projectResolver.getProjectId(), ClusterBlockLevel.METADATA_READ, concreteIndices);
    }

    protected ShardsIterator shards(ClusterState clusterState, DataStreamsStatsAction.Request request, String[] concreteIndices) {
        return clusterState.routingTable(this.projectResolver.getProjectId()).allSearchableShards(concreteIndices);
    }

    protected void shardOperation(DataStreamsStatsAction.Request request, ShardRouting shardRouting, Task task, Void nodeContext, ActionListener<DataStreamsStatsAction.DataStreamShardStats> listener) {
        ActionListener.completeWith(listener, () -> {
            assert (shardRouting.isSearchable()) : "shard routing is not searchable: " + String.valueOf(shardRouting);
            IndexService indexService = this.indicesService.indexServiceSafe(shardRouting.shardId().getIndex());
            IndexShard indexShard = indexService.getShard(shardRouting.shardId().id());
            StoreStats storeStats = indexShard.storeStats();
            IndexAbstraction indexAbstraction = (IndexAbstraction)this.projectResolver.getProjectMetadata(this.clusterService.state()).getIndicesLookup().get(shardRouting.getIndexName());
            assert (indexAbstraction != null);
            DataStream dataStream = indexAbstraction.getParentDataStream();
            assert (dataStream != null);
            return new DataStreamsStatsAction.DataStreamShardStats(indexShard.routingEntry(), storeStats, TransportDataStreamsStatsAction.getMaxTimestamp(indexShard));
        });
    }

    private static long getMaxTimestamp(IndexShard indexShard) throws IOException {
        try (Engine.Searcher searcher = indexShard.acquireSearcher("field_range");){
            IndexReader indexReader = searcher.getIndexReader();
            byte[] maxPackedValue = PointValues.getMaxPackedValue((IndexReader)indexReader, (String)"@timestamp");
            if (maxPackedValue != null) {
                long l = LongPoint.decodeDimension((byte[])maxPackedValue, (int)0);
                return l;
            }
            long l = DocValuesSkipper.globalMaxValue((IndexSearcher)searcher, (String)"@timestamp");
            return l;
        }
    }

    protected String[] resolveConcreteIndexNames(ClusterState clusterState, DataStreamsStatsAction.Request request) {
        return (String[])DataStreamsActionUtil.resolveConcreteIndexNames((IndexNameExpressionResolver)this.indexNameExpressionResolver, (ProjectMetadata)this.projectResolver.getProjectMetadata(clusterState), (String[])request.indices(), (IndicesOptions)request.indicesOptions()).toArray(String[]::new);
    }

    protected DataStreamsStatsAction.DataStreamShardStats readShardResult(StreamInput in) throws IOException {
        return new DataStreamsStatsAction.DataStreamShardStats(in);
    }

    protected TransportBroadcastByNodeAction.ResponseFactory<DataStreamsStatsAction.Response, DataStreamsStatsAction.DataStreamShardStats> getResponseFactory(DataStreamsStatsAction.Request request, ClusterState clusterState) {
        HashMap<String, AggregatedStats> aggregatedDataStreamsStats = new HashMap<String, AggregatedStats>();
        HashSet<String> allBackingIndices = new HashSet<String>();
        ProjectMetadata project = this.projectResolver.getProjectMetadata(clusterState);
        SortedMap indicesLookup = project.getIndicesLookup();
        List abstractionNames = this.indexNameExpressionResolver.dataStreamNames(project, request.indicesOptions(), request.indices());
        for (String abstraction : abstractionNames) {
            IndexAbstraction indexAbstraction = (IndexAbstraction)indicesLookup.get(abstraction);
            assert (indexAbstraction != null);
            if (indexAbstraction.getType() != IndexAbstraction.Type.DATA_STREAM) continue;
            DataStream dataStream = (DataStream)indexAbstraction;
            AggregatedStats stats = aggregatedDataStreamsStats.computeIfAbsent(dataStream.getName(), s -> new AggregatedStats());
            dataStream.getIndices().stream().map(Index::getName).forEach(index -> {
                stats.backingIndices.add((String)index);
                allBackingIndices.add((String)index);
            });
            dataStream.getFailureIndices().stream().map(Index::getName).forEach(index -> {
                stats.backingIndices.add((String)index);
                allBackingIndices.add((String)index);
            });
        }
        return new ResponseFactory(this, indicesLookup, allBackingIndices, aggregatedDataStreamsStats);
    }

    private static class AggregatedStats {
        Set<String> backingIndices = new HashSet<String>();
        long storageBytes = 0L;
        long maxTimestamp = 0L;

        private AggregatedStats() {
        }
    }

    private class ResponseFactory
    implements TransportBroadcastByNodeAction.ResponseFactory<DataStreamsStatsAction.Response, DataStreamsStatsAction.DataStreamShardStats> {
        private final SortedMap<String, IndexAbstraction> indicesLookup;
        private final Set<String> allBackingIndices;
        private final Map<String, AggregatedStats> aggregatedDataStreamsStats;

        ResponseFactory(TransportDataStreamsStatsAction transportDataStreamsStatsAction, SortedMap<String, IndexAbstraction> indicesLookup, Set<String> allBackingIndices, Map<String, AggregatedStats> aggregatedDataStreamsStats) {
            this.indicesLookup = indicesLookup;
            this.allBackingIndices = allBackingIndices;
            this.aggregatedDataStreamsStats = aggregatedDataStreamsStats;
        }

        public DataStreamsStatsAction.Response newResponse(int totalShards, int successfulShards, int failedShards, List<DataStreamsStatsAction.DataStreamShardStats> dataStreamShardStats, List<DefaultShardOperationFailedException> shardFailures) {
            long totalStoreSizeBytes = 0L;
            for (DataStreamsStatsAction.DataStreamShardStats shardStat : dataStreamShardStats) {
                String indexName = shardStat.getShardRouting().getIndexName();
                IndexAbstraction indexAbstraction = (IndexAbstraction)this.indicesLookup.get(indexName);
                DataStream dataStream = indexAbstraction.getParentDataStream();
                assert (dataStream != null);
                totalStoreSizeBytes += shardStat.getStoreStats().totalDataSetSizeInBytes();
                AggregatedStats stats = this.aggregatedDataStreamsStats.computeIfAbsent(dataStream.getName(), s -> new AggregatedStats());
                stats.storageBytes += shardStat.getStoreStats().totalDataSetSizeInBytes();
                stats.maxTimestamp = Math.max(stats.maxTimestamp, shardStat.getMaxTimestamp());
            }
            DataStreamsStatsAction.DataStreamStats[] dataStreamStats = (DataStreamsStatsAction.DataStreamStats[])this.aggregatedDataStreamsStats.entrySet().stream().map(entry -> new DataStreamsStatsAction.DataStreamStats((String)entry.getKey(), ((AggregatedStats)entry.getValue()).backingIndices.size(), ByteSizeValue.ofBytes((long)((AggregatedStats)entry.getValue()).storageBytes), ((AggregatedStats)entry.getValue()).maxTimestamp)).toArray(DataStreamsStatsAction.DataStreamStats[]::new);
            return new DataStreamsStatsAction.Response(totalShards, successfulShards, failedShards, shardFailures, this.aggregatedDataStreamsStats.size(), this.allBackingIndices.size(), ByteSizeValue.ofBytes((long)totalStoreSizeBytes), dataStreamStats);
        }
    }
}

