/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.blobcache.shared;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import java.nio.file.FileStore;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.IntConsumer;
import java.util.function.LongSupplier;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.store.AlreadyClosedException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRunnable;
import org.elasticsearch.action.support.PlainActionFuture;
import org.elasticsearch.action.support.RefCountingListener;
import org.elasticsearch.action.support.RefCountingRunnable;
import org.elasticsearch.blobcache.BlobCacheMetrics;
import org.elasticsearch.blobcache.BlobCacheUtils;
import org.elasticsearch.blobcache.common.ByteRange;
import org.elasticsearch.blobcache.common.SparseFileTracker;
import org.elasticsearch.blobcache.shared.KeyMapping;
import org.elasticsearch.blobcache.shared.SharedBlobCacheService;
import org.elasticsearch.blobcache.shared.SharedBytes;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodeRole;
import org.elasticsearch.cluster.routing.allocation.DataTier;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsException;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.RelativeByteSizeValue;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.common.util.concurrent.ThrottledTaskRunner;
import org.elasticsearch.core.AbstractRefCounted;
import org.elasticsearch.core.Assertions;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.env.Environment;
import org.elasticsearch.env.NodeEnvironment;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.store.LuceneFilesExtensions;
import org.elasticsearch.monitor.fs.FsProbe;
import org.elasticsearch.node.NodeRoleSettings;
import org.elasticsearch.telemetry.metric.LongCounter;
import org.elasticsearch.threadpool.ThreadPool;

public class SharedBlobCacheService<KeyType extends KeyBase>
implements Releasable {
    private static final String SHARED_CACHE_SETTINGS_PREFIX = "xpack.searchable.snapshot.shared_cache.";
    public static final Setting<ByteSizeValue> SHARED_CACHE_RANGE_SIZE_SETTING = new Setting("xpack.searchable.snapshot.shared_cache.range_size", ByteSizeValue.ofMb((long)16L).getStringRep(), s -> ByteSizeValue.parseBytesSizeValue((String)s, (String)"xpack.searchable.snapshot.shared_cache.range_size"), SharedBlobCacheService.getPositivePageSizeAlignedByteSizeValueValidator("xpack.searchable.snapshot.shared_cache.range_size"), new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<ByteSizeValue> SHARED_CACHE_RECOVERY_RANGE_SIZE_SETTING = new Setting("xpack.searchable.snapshot.shared_cache.recovery_range_size", ByteSizeValue.ofKb((long)128L).getStringRep(), s -> ByteSizeValue.parseBytesSizeValue((String)s, (String)"xpack.searchable.snapshot.shared_cache.recovery_range_size"), SharedBlobCacheService.getPositivePageSizeAlignedByteSizeValueValidator("xpack.searchable.snapshot.shared_cache.recovery_range_size"), new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<ByteSizeValue> SHARED_CACHE_REGION_SIZE_SETTING = new Setting("xpack.searchable.snapshot.shared_cache.region_size", SHARED_CACHE_RANGE_SIZE_SETTING, s -> ByteSizeValue.parseBytesSizeValue((String)s, (String)"xpack.searchable.snapshot.shared_cache.region_size"), SharedBlobCacheService.getPositivePageSizeAlignedByteSizeValueValidator("xpack.searchable.snapshot.shared_cache.region_size"), new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<Integer> SHARED_CACHE_CONCURRENT_EVICTIONS_SETTING = Setting.intSetting((String)"xpack.searchable.snapshot.shared_cache.concurrent_evictions", (int)5, (int)1, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<RelativeByteSizeValue> SHARED_CACHE_SIZE_SETTING = new Setting("xpack.searchable.snapshot.shared_cache.size", settings -> {
        if (DiscoveryNode.isDedicatedFrozenNode((Settings)settings) || SharedBlobCacheService.isSearchOrIndexingNode(settings)) {
            return "90%";
        }
        return ByteSizeValue.ZERO.getStringRep();
    }, s -> RelativeByteSizeValue.parseRelativeByteSizeValue((String)s, (String)"xpack.searchable.snapshot.shared_cache.size"), (Setting.Validator)new Setting.Validator<RelativeByteSizeValue>(){

        public void validate(RelativeByteSizeValue value) {
        }

        public void validate(RelativeByteSizeValue value, Map<Setting<?>, Object> settings) {
            if (value.isAbsolute() && value.getAbsolute().getBytes() == -1L) {
                throw new SettingsException("setting [{}] must be non-negative", new Object[]{"xpack.searchable.snapshot.shared_cache.size"});
            }
            if (value.isNonZeroSize()) {
                List roles = (List)settings.get(NodeRoleSettings.NODE_ROLES_SETTING);
                Set rolesSet = Set.copyOf(roles);
                if (!(DataTier.isFrozenNode(rolesSet) || rolesSet.contains(DiscoveryNodeRole.SEARCH_ROLE) || rolesSet.contains(DiscoveryNodeRole.INDEX_ROLE))) {
                    throw new SettingsException("Setting [{}] to be positive [{}] is only permitted on nodes with the data_frozen, search, or indexing role. Roles are [{}]", new Object[]{"xpack.searchable.snapshot.shared_cache.size", value.getStringRep(), roles.stream().map(DiscoveryNodeRole::roleName).collect(Collectors.joining(","))});
                }
                List dataPaths = (List)settings.get(Environment.PATH_DATA_SETTING);
                if (dataPaths.size() > 1) {
                    throw new SettingsException("setting [{}={}] is not permitted on nodes with multiple data paths [{}]", new Object[]{SHARED_CACHE_SIZE_SETTING.getKey(), value.getStringRep(), String.join((CharSequence)",", dataPaths)});
                }
            }
        }

        public Iterator<Setting<?>> settings() {
            List<Setting> settings = List.of(NodeRoleSettings.NODE_ROLES_SETTING, Environment.PATH_DATA_SETTING);
            return settings.iterator();
        }
    }, new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<ByteSizeValue> SHARED_CACHE_SIZE_MAX_HEADROOM_SETTING = new Setting("xpack.searchable.snapshot.shared_cache.size.max_headroom", settings -> {
        if (!SHARED_CACHE_SIZE_SETTING.exists(settings) && (DiscoveryNode.isDedicatedFrozenNode((Settings)settings) || SharedBlobCacheService.isSearchOrIndexingNode(settings))) {
            return "100GB";
        }
        return "-1";
    }, s -> ByteSizeValue.parseBytesSizeValue((String)s, (String)"xpack.searchable.snapshot.shared_cache.size.max_headroom"), (Setting.Validator)new Setting.Validator<ByteSizeValue>(){
        private final Collection<Setting<?>> dependencies = List.of(SHARED_CACHE_SIZE_SETTING);

        public Iterator<Setting<?>> settings() {
            return this.dependencies.iterator();
        }

        public void validate(ByteSizeValue value) {
        }

        public void validate(ByteSizeValue value, Map<Setting<?>, Object> settings, boolean isPresent) {
            RelativeByteSizeValue sizeValue;
            if (isPresent && value.getBytes() != -1L && (sizeValue = (RelativeByteSizeValue)settings.get(SHARED_CACHE_SIZE_SETTING)).isAbsolute()) {
                throw new SettingsException("setting [{}] cannot be specified for absolute [{}={}]", new Object[]{SHARED_CACHE_SIZE_MAX_HEADROOM_SETTING.getKey(), SHARED_CACHE_SIZE_SETTING.getKey(), sizeValue.getStringRep()});
            }
        }
    }, new Setting.Property[]{Setting.Property.NodeScope});
    public static final TimeValue MIN_SHARED_CACHE_DECAY_INTERVAL = TimeValue.timeValueSeconds((long)1L);
    public static final Setting<TimeValue> SHARED_CACHE_DECAY_INTERVAL_SETTING = Setting.timeSetting((String)"xpack.searchable.snapshot.shared_cache.decay.interval", (TimeValue)TimeValue.timeValueSeconds((long)60L), (TimeValue)MIN_SHARED_CACHE_DECAY_INTERVAL, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    public static final Setting<Integer> SHARED_CACHE_MAX_FREQ_SETTING = Setting.intSetting((String)"xpack.searchable.snapshot.shared_cache.max_freq", (int)100, (int)1, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<TimeValue> SHARED_CACHE_MIN_TIME_DELTA_SETTING = Setting.timeSetting((String)"xpack.searchable.snapshot.shared_cache.min_time_delta", (TimeValue)TimeValue.timeValueSeconds((long)60L), (TimeValue)TimeValue.timeValueSeconds((long)0L), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<Boolean> SHARED_CACHE_MMAP = Setting.boolSetting((String)"xpack.searchable.snapshot.shared_cache.mmap", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<Boolean> SHARED_CACHE_COUNT_READS = Setting.boolSetting((String)"xpack.searchable.snapshot.shared_cache.count_reads", (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    private static final Logger logger = LogManager.getLogger(SharedBlobCacheService.class);
    private final ThreadPool threadPool;
    private final Executor ioExecutor;
    private final SharedBytes sharedBytes;
    private final long cacheSize;
    private final int regionSize;
    private final int rangeSize;
    private final int recoveryRangeSize;
    private final int numRegions;
    private final ConcurrentLinkedQueue<SharedBytes.IO> freeRegions = new ConcurrentLinkedQueue();
    private final Cache<KeyType, CacheFileRegion<KeyType>> cache;
    private final ConcurrentHashMap<SharedBytes.IO, CacheFileRegion<KeyType>> regionOwners;
    private final LongAdder writeCount = new LongAdder();
    private final LongAdder writeBytes = new LongAdder();
    private final LongAdder readBytes = new LongAdder();
    private final LongAdder evictCount = new LongAdder();
    private final BlobCacheMetrics blobCacheMetrics;
    private final Runnable evictIncrementer;
    private final LongSupplier relativeTimeInNanosSupplier;
    private final ThrottledTaskRunner asyncEvictionsRunner;

    private static Setting.Validator<ByteSizeValue> getPageSizeAlignedByteSizeValueValidator(String settingName) {
        return value -> {
            if (value.getBytes() == -1L) {
                throw new SettingsException("setting [{}] must be non-negative", new Object[]{settingName});
            }
            if (value.getBytes() % 4096L != 0L) {
                throw new SettingsException("setting [{}] must be multiple of {}", new Object[]{settingName, 4096});
            }
        };
    }

    private static Setting.Validator<ByteSizeValue> getPositivePageSizeAlignedByteSizeValueValidator(String settingName) {
        return value -> {
            if (value.getBytes() <= 0L) {
                throw new SettingsException("setting [{}] must be greater than zero", new Object[]{settingName});
            }
            SharedBlobCacheService.getPageSizeAlignedByteSizeValueValidator(settingName).validate(value);
        };
    }

    private static boolean isSearchOrIndexingNode(Settings settings) {
        return DiscoveryNode.hasRole((Settings)settings, (DiscoveryNodeRole)DiscoveryNodeRole.SEARCH_ROLE) || DiscoveryNode.hasRole((Settings)settings, (DiscoveryNodeRole)DiscoveryNodeRole.INDEX_ROLE);
    }

    void computeDecay() {
        Cache<KeyType, CacheFileRegion<KeyType>> cache = this.cache;
        if (cache instanceof LFUCache) {
            LFUCache lfuCache = (LFUCache)cache;
            lfuCache.computeDecay();
        }
    }

    void maybeScheduleDecayAndNewEpoch() {
        Cache<KeyType, CacheFileRegion<KeyType>> cache = this.cache;
        if (cache instanceof LFUCache) {
            LFUCache lfuCache = (LFUCache)cache;
            lfuCache.maybeScheduleDecayAndNewEpoch(lfuCache.epoch.get());
        }
    }

    long epoch() {
        return ((LFUCache)this.cache).epoch.get();
    }

    public SharedBlobCacheService(NodeEnvironment environment, Settings settings, ThreadPool threadPool, Executor ioExecutor, BlobCacheMetrics blobCacheMetrics) {
        this(environment, settings, threadPool, ioExecutor, blobCacheMetrics, System::nanoTime);
    }

    public SharedBlobCacheService(NodeEnvironment environment, Settings settings, ThreadPool threadPool, Executor ioExecutor, BlobCacheMetrics blobCacheMetrics, LongSupplier relativeTimeInNanosSupplier) {
        long totalFsSize;
        this.threadPool = threadPool;
        this.ioExecutor = ioExecutor;
        try {
            totalFsSize = FsProbe.getTotal((FileStore)Environment.getFileStore((Path)environment.nodeDataPaths()[0]));
        }
        catch (IOException e) {
            throw new IllegalStateException("unable to probe size of filesystem [" + String.valueOf(environment.nodeDataPaths()[0]) + "]");
        }
        this.cacheSize = SharedBlobCacheService.calculateCacheSize(settings, totalFsSize);
        int regionSize = Math.toIntExact(((ByteSizeValue)SHARED_CACHE_REGION_SIZE_SETTING.get(settings)).getBytes());
        this.numRegions = Math.toIntExact(this.cacheSize / (long)regionSize);
        this.regionOwners = Assertions.ENABLED ? new ConcurrentHashMap() : null;
        this.regionSize = regionSize;
        assert ((long)regionSize > 0L);
        this.cache = new LFUCache(settings);
        try {
            this.sharedBytes = new SharedBytes(this.numRegions, regionSize, environment, this.writeBytes::add, ((Boolean)SHARED_CACHE_COUNT_READS.get(settings)).booleanValue() ? this.readBytes::add : ignored -> {}, (Boolean)SHARED_CACHE_MMAP.get(settings));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        for (int i = 0; i < this.numRegions; ++i) {
            this.freeRegions.add(this.sharedBytes.getFileChannel(i));
        }
        this.rangeSize = BlobCacheUtils.toIntBytes(((ByteSizeValue)SHARED_CACHE_RANGE_SIZE_SETTING.get(settings)).getBytes());
        this.recoveryRangeSize = BlobCacheUtils.toIntBytes(((ByteSizeValue)SHARED_CACHE_RECOVERY_RANGE_SIZE_SETTING.get(settings)).getBytes());
        this.blobCacheMetrics = blobCacheMetrics;
        this.evictIncrementer = () -> ((LongCounter)blobCacheMetrics.getEvictedCountNonZeroFrequency()).increment();
        this.relativeTimeInNanosSupplier = relativeTimeInNanosSupplier;
        this.asyncEvictionsRunner = new ThrottledTaskRunner("shared_blob_cache_evictions", ((Integer)SHARED_CACHE_CONCURRENT_EVICTIONS_SETTING.get(settings)).intValue(), (Executor)threadPool.generic());
    }

    public static long calculateCacheSize(Settings settings, long totalFsSize) {
        return ((RelativeByteSizeValue)SHARED_CACHE_SIZE_SETTING.get(settings)).calculateValue(ByteSizeValue.ofBytes((long)totalFsSize), (ByteSizeValue)SHARED_CACHE_SIZE_MAX_HEADROOM_SETTING.get(settings)).getBytes();
    }

    public BlobCacheMetrics getBlobCacheMetrics() {
        return this.blobCacheMetrics;
    }

    public ThreadPool getThreadPool() {
        return this.threadPool;
    }

    public int getRangeSize() {
        return this.rangeSize;
    }

    public int getRecoveryRangeSize() {
        return this.recoveryRangeSize;
    }

    protected int getRegion(long position) {
        return (int)(position / (long)this.regionSize);
    }

    protected int getRegionRelativePosition(long position) {
        return (int)(position % (long)this.regionSize);
    }

    protected long getRegionStart(int region) {
        return (long)region * (long)this.regionSize;
    }

    protected long getRegionEnd(int region) {
        return (long)(region + 1) * (long)this.regionSize;
    }

    protected int getEndingRegion(long position) {
        return this.getRegion(position - (long)(position % (long)this.regionSize == 0L ? 1 : 0));
    }

    protected ByteRange mapSubRangeToRegion(ByteRange range, int region) {
        long rangeEnd;
        long regionStart = this.getRegionStart(region);
        long regionEnd = this.getRegionEnd(region);
        if (range.start() >= regionEnd || range.end() <= regionStart) {
            return ByteRange.EMPTY;
        }
        long rangeStart = Math.max(regionStart, range.start());
        if (rangeStart >= (rangeEnd = Math.min(regionEnd, range.end()))) {
            return ByteRange.EMPTY;
        }
        return ByteRange.of(this.getRegionRelativePosition(rangeStart), rangeEnd == regionEnd ? (long)this.regionSize : (long)this.getRegionRelativePosition(rangeEnd));
    }

    protected int computeCacheFileRegionSize(long fileLength, int region) {
        int effectiveRegionSize;
        assert (fileLength > 0L);
        int maxRegion = this.getEndingRegion(fileLength);
        assert (region >= 0 && region <= maxRegion) : region + " - " + maxRegion;
        if (region == maxRegion && (long)(region + 1) * (long)this.regionSize != fileLength) {
            assert ((long)this.getRegionRelativePosition(fileLength) != 0L);
            effectiveRegionSize = this.getRegionRelativePosition(fileLength);
        } else {
            effectiveRegionSize = this.regionSize;
        }
        assert (this.getRegionStart(region) + (long)effectiveRegionSize <= fileLength);
        return effectiveRegionSize;
    }

    public int getRegionSize() {
        return this.regionSize;
    }

    CacheFileRegion<KeyType> get(KeyType cacheKey, long fileLength, int region) {
        return (CacheFileRegion)((Object)this.cache.get(cacheKey, (long)fileLength, (int)region).chunk);
    }

    public void maybeFetchRegion(KeyType cacheKey, int region, long blobLength, RangeMissingHandler writer, Executor fetchExecutor, ActionListener<Boolean> listener) {
        this.fetchRegion(cacheKey, region, blobLength, writer, fetchExecutor, false, listener);
    }

    public void fetchRegion(KeyType cacheKey, int region, long blobLength, RangeMissingHandler writer, Executor fetchExecutor, boolean force, ActionListener<Boolean> listener) {
        if (!force && this.freeRegions.isEmpty() && !this.maybeEvictLeastUsed()) {
            logger.info("No free regions, skipping loading region [{}]", (Object)region);
            listener.onResponse((Object)false);
            return;
        }
        try {
            ByteRange regionRange = ByteRange.of(0L, this.computeCacheFileRegionSize(blobLength, region));
            if (regionRange.isEmpty()) {
                listener.onResponse((Object)false);
                return;
            }
            CacheFileRegion<KeyType> entry = this.get(cacheKey, blobLength, region);
            entry.populate(regionRange, writer, fetchExecutor, listener);
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    public void maybeFetchRange(KeyType cacheKey, int region, ByteRange range, long blobLength, RangeMissingHandler writer, Executor fetchExecutor, ActionListener<Boolean> listener) {
        this.fetchRange(cacheKey, region, range, blobLength, writer, fetchExecutor, false, listener);
    }

    public void fetchRange(KeyType cacheKey, int region, ByteRange range, long blobLength, RangeMissingHandler writer, Executor fetchExecutor, boolean force, ActionListener<Boolean> listener) {
        if (!force && this.freeRegions.isEmpty() && !this.maybeEvictLeastUsed()) {
            logger.info("No free regions, skipping loading region [{}]", (Object)region);
            listener.onResponse((Object)false);
            return;
        }
        try {
            ByteRange regionRange = this.mapSubRangeToRegion(range, region);
            if (regionRange.isEmpty()) {
                listener.onResponse((Object)false);
                return;
            }
            CacheFileRegion<KeyType> entry = this.get(cacheKey, blobLength, region);
            entry.populate(regionRange, this.writerWithOffset(writer, Math.toIntExact(range.start() - this.getRegionStart(region))), fetchExecutor, listener);
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    private RangeMissingHandler writerWithOffset(final RangeMissingHandler writer, final int writeOffset) {
        if (writeOffset == 0) {
            return writer;
        }
        return new RangeMissingHandler(){

            @Override
            public void fillCacheRange(SharedBytes.IO channel, int channelPos, SourceInputStreamFactory streamFactory, int relativePos, int length, IntConsumer progressUpdater, ActionListener<Void> completionListener) throws IOException {
                writer.fillCacheRange(channel, channelPos, streamFactory, relativePos - writeOffset, length, progressUpdater, completionListener);
            }

            @Override
            public SourceInputStreamFactory sharedInputStreamFactory(List<SparseFileTracker.Gap> gaps) {
                return writer.sharedInputStreamFactory(gaps);
            }
        };
    }

    boolean maybeEvictLeastUsed() {
        Cache<KeyType, CacheFileRegion<KeyType>> cache = this.cache;
        if (cache instanceof LFUCache) {
            LFUCache lfuCache = (LFUCache)cache;
            return lfuCache.maybeEvictLeastUsed();
        }
        return false;
    }

    private static void throwAlreadyClosed(String message) {
        throw new AlreadyClosedException(message);
    }

    int freeRegionCount() {
        return this.freeRegions.size();
    }

    public Stats getStats() {
        return new Stats(this.numRegions, this.cacheSize, this.regionSize, this.evictCount.sum(), this.writeCount.sum(), this.writeBytes.sum(), this.blobCacheMetrics.readCount(), this.readBytes.sum(), this.blobCacheMetrics.missCount());
    }

    public void removeFromCache(KeyType cacheKey) {
        this.forceEvict(cacheKey.shardId(), (Predicate<KeyBase>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, equals(java.lang.Object ), (Lorg/elasticsearch/blobcache/shared/SharedBlobCacheService$KeyBase;)Z)(cacheKey));
    }

    public int forceEvict(Predicate<KeyType> cacheKeyPredicate) {
        return this.cache.forceEvict(cacheKeyPredicate);
    }

    public int forceEvict(ShardId shard, Predicate<KeyType> cacheKeyPredicate) {
        return this.cache.forceEvict(shard, cacheKeyPredicate);
    }

    public void forceEvictAsync(Predicate<KeyType> cacheKeyPredicate) {
        this.cache.forceEvictAsync(cacheKeyPredicate);
    }

    int getFreq(CacheFileRegion<KeyType> cacheFileRegion) {
        Cache<KeyType, CacheFileRegion<KeyType>> cache = this.cache;
        if (cache instanceof LFUCache) {
            LFUCache lfuCache = (LFUCache)cache;
            return lfuCache.getFreq(cacheFileRegion);
        }
        return -1;
    }

    public void close() {
        this.sharedBytes.decRef();
    }

    protected boolean assertOffsetsWithinFileLength(long offset, long length, long fileLength) {
        assert (offset >= 0L);
        assert (length > 0L);
        assert (fileLength > 0L);
        assert (offset + length <= fileLength) : "accessing [" + length + "] bytes at offset [" + offset + "] in cache file [" + String.valueOf(this) + "] would be beyond file length [" + fileLength + "]";
        return true;
    }

    public CacheFile getCacheFile(KeyType cacheKey, long length) {
        return new CacheFile(this, cacheKey, length);
    }

    private static String getFileExtension(String resourceDescription) {
        if (resourceDescription.endsWith(LuceneFilesExtensions.CFS.getExtension())) {
            return LuceneFilesExtensions.CFS.getExtension();
        }
        String extension = IndexFileNames.getExtension((String)resourceDescription);
        if (LuceneFilesExtensions.isLuceneExtension((String)extension)) {
            return extension;
        }
        return "other";
    }

    private static interface Cache<K, T>
    extends Releasable {
        public CacheEntry<T> get(K var1, long var2, int var4);

        public int forceEvict(Predicate<K> var1);

        public void forceEvictAsync(Predicate<K> var1);

        public int forceEvict(ShardId var1, Predicate<K> var2);
    }

    private class LFUCache
    implements Cache<KeyType, CacheFileRegion<KeyType>> {
        private final KeyMapping<ShardId, RegionKey<KeyType>, org.elasticsearch.blobcache.shared.SharedBlobCacheService$LFUCache.LFUCacheEntry> keyMapping = new KeyMapping();
        private final org.elasticsearch.blobcache.shared.SharedBlobCacheService$LFUCache.LFUCacheEntry[] freqs;
        private final int maxFreq;
        private final org.elasticsearch.blobcache.shared.SharedBlobCacheService$LFUCache.DecayAndNewEpochTask decayAndNewEpochTask;
        private final AtomicLong epoch = new AtomicLong();

        LFUCache(Settings settings) {
            this.maxFreq = (Integer)SHARED_CACHE_MAX_FREQ_SETTING.get(settings);
            this.freqs = (LFUCacheEntry[])Array.newInstance(LFUCacheEntry.class, this.maxFreq);
            this.decayAndNewEpochTask = new DecayAndNewEpochTask(SharedBlobCacheService.this.threadPool.generic());
        }

        public void close() {
            this.decayAndNewEpochTask.close();
        }

        int getFreq(CacheFileRegion<KeyType> cacheFileRegion) {
            return ((LFUCacheEntry)this.keyMapping.get((ShardId)((KeyBase)cacheFileRegion.regionKey.file()).shardId(), cacheFileRegion.regionKey)).freq;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public org.elasticsearch.blobcache.shared.SharedBlobCacheService$LFUCache.LFUCacheEntry get(KeyType cacheKey, long fileLength, int region) {
            RegionKey regionKey = new RegionKey(cacheKey, region);
            long now = this.epoch.get();
            LFUCacheEntry entry = (LFUCacheEntry)this.keyMapping.get(cacheKey.shardId(), regionKey);
            if (entry == null) {
                int effectiveRegionSize = SharedBlobCacheService.this.computeCacheFileRegionSize(fileLength, region);
                entry = this.keyMapping.computeIfAbsent(cacheKey.shardId(), regionKey, key -> new LFUCacheEntry(new CacheFileRegion(SharedBlobCacheService.this, key, effectiveRegionSize), now));
            }
            if (((CacheFileRegion)((Object)entry.chunk)).volatileIO() == null) {
                CacheFileRegion cacheFileRegion = (CacheFileRegion)((Object)entry.chunk);
                synchronized (cacheFileRegion) {
                    if (((CacheFileRegion)((Object)entry.chunk)).volatileIO() == null && !((CacheFileRegion)((Object)entry.chunk)).isEvicted()) {
                        return this.initChunk(entry);
                    }
                }
            }
            assert (this.assertChunkActiveOrEvicted(entry));
            if (now > entry.lastAccessedEpoch) {
                this.maybePromote(now, entry);
            }
            return entry;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int forceEvict(Predicate<KeyType> cacheKeyPredicate) {
            ArrayList matchingEntries = new ArrayList();
            this.keyMapping.forEach((key, value) -> {
                if (cacheKeyPredicate.test((KeyBase)key.file)) {
                    matchingEntries.add(value);
                }
            });
            int evictedCount = 0;
            int nonZeroFrequencyEvictedCount = 0;
            if (!matchingEntries.isEmpty()) {
                SharedBlobCacheService sharedBlobCacheService = SharedBlobCacheService.this;
                synchronized (sharedBlobCacheService) {
                    for (LFUCacheEntry entry : matchingEntries) {
                        int frequency = entry.freq;
                        boolean evicted = ((CacheFileRegion)((Object)entry.chunk)).forceEvict();
                        if (!evicted || ((CacheFileRegion)((Object)entry.chunk)).volatileIO() == null) continue;
                        this.unlink(entry);
                        this.keyMapping.remove(((KeyBase)((CacheFileRegion)((Object)entry.chunk)).regionKey.file).shardId(), ((CacheFileRegion)((Object)entry.chunk)).regionKey, (org.elasticsearch.blobcache.shared.SharedBlobCacheService$LFUCache.LFUCacheEntry)entry);
                        ++evictedCount;
                        if (frequency <= 0) continue;
                        ++nonZeroFrequencyEvictedCount;
                    }
                }
            }
            SharedBlobCacheService.this.blobCacheMetrics.getEvictedCountNonZeroFrequency().incrementBy((long)nonZeroFrequencyEvictedCount);
            return evictedCount;
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private boolean removeKeyMappingForEntry(LFUCacheEntry entry) {
            return this.keyMapping.remove(((KeyBase)((CacheFileRegion)((Object)entry.chunk)).regionKey.file()).shardId(), ((CacheFileRegion)((Object)entry.chunk)).regionKey, (org.elasticsearch.blobcache.shared.SharedBlobCacheService$LFUCache.LFUCacheEntry)entry);
        }

        @Override
        public void forceEvictAsync(final Predicate<KeyType> cacheKeyPredicate) {
            SharedBlobCacheService.this.asyncEvictionsRunner.enqueueTask((ActionListener)new ActionListener<Releasable>(){

                public void onResponse(Releasable releasable) {
                    try (Releasable releasable2 = releasable;){
                        LFUCache.this.forceEvict(cacheKeyPredicate);
                    }
                }

                public void onFailure(Exception e) {
                    String message = "unexpected failure evicting from shared blob cache";
                    logger.error("unexpected failure evicting from shared blob cache", (Throwable)e);
                    assert (false) : new AssertionError("unexpected failure evicting from shared blob cache", e);
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int forceEvict(ShardId shard, Predicate<KeyType> cacheKeyPredicate) {
            ArrayList matchingEntries = new ArrayList();
            this.keyMapping.forEach(shard, (key, entry) -> {
                if (cacheKeyPredicate.test((KeyBase)key.file)) {
                    matchingEntries.add(entry);
                }
            });
            int evictedCount = 0;
            int nonZeroFrequencyEvictedCount = 0;
            if (!matchingEntries.isEmpty()) {
                SharedBlobCacheService sharedBlobCacheService = SharedBlobCacheService.this;
                synchronized (sharedBlobCacheService) {
                    for (LFUCacheEntry entry2 : matchingEntries) {
                        int frequency = entry2.freq;
                        boolean evicted = ((CacheFileRegion)((Object)entry2.chunk)).forceEvict();
                        if (!evicted || ((CacheFileRegion)((Object)entry2.chunk)).volatileIO() == null) continue;
                        this.unlink(entry2);
                        assert (shard.equals((Object)((KeyBase)((CacheFileRegion)((Object)entry2.chunk)).regionKey.file).shardId()));
                        this.keyMapping.remove(shard, ((CacheFileRegion)((Object)entry2.chunk)).regionKey, (org.elasticsearch.blobcache.shared.SharedBlobCacheService$LFUCache.LFUCacheEntry)entry2);
                        ++evictedCount;
                        if (frequency <= 0) continue;
                        ++nonZeroFrequencyEvictedCount;
                    }
                }
            }
            SharedBlobCacheService.this.blobCacheMetrics.getEvictedCountNonZeroFrequency().incrementBy((long)nonZeroFrequencyEvictedCount);
            return evictedCount;
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private LFUCacheEntry initChunk(LFUCacheEntry entry) {
            assert (Thread.holdsLock(entry.chunk));
            RegionKey regionKey = ((CacheFileRegion)((Object)entry.chunk)).regionKey;
            if (this.keyMapping.get(((KeyBase)regionKey.file()).shardId(), regionKey) != entry) {
                SharedBlobCacheService.throwAlreadyClosed("no free region found (contender)");
            }
            assert (entry.freq == 1);
            assert (entry.prev == null);
            assert (entry.next == null);
            SharedBytes.IO freeSlot = SharedBlobCacheService.this.freeRegions.poll();
            if (freeSlot != null) {
                this.assignToSlot(entry, freeSlot);
            } else {
                SharedBytes.IO io;
                SharedBlobCacheService sharedBlobCacheService = SharedBlobCacheService.this;
                synchronized (sharedBlobCacheService) {
                    io = this.maybeEvictAndTake(SharedBlobCacheService.this.evictIncrementer);
                }
                if (io == null) {
                    io = SharedBlobCacheService.this.freeRegions.poll();
                }
                if (io != null) {
                    this.assignToSlot(entry, io);
                } else {
                    boolean removed = this.removeKeyMappingForEntry(entry);
                    assert (removed);
                    SharedBlobCacheService.throwAlreadyClosed("no free region found");
                }
            }
            return entry;
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void assignToSlot(LFUCacheEntry entry, SharedBytes.IO freeSlot) {
            assert (SharedBlobCacheService.this.regionOwners.put(freeSlot, (CacheFileRegion)((Object)entry.chunk)) == null);
            SharedBlobCacheService sharedBlobCacheService = SharedBlobCacheService.this;
            synchronized (sharedBlobCacheService) {
                if (((CacheFileRegion)((Object)entry.chunk)).isEvicted()) {
                    assert (SharedBlobCacheService.this.regionOwners.remove(freeSlot) == entry.chunk);
                    SharedBlobCacheService.this.freeRegions.add(freeSlot);
                    this.removeKeyMappingForEntry(entry);
                    SharedBlobCacheService.throwAlreadyClosed("evicted during free region allocation");
                }
                this.pushEntryToBack(entry);
                ((CacheFileRegion)((Object)entry.chunk)).volatileIO(freeSlot);
            }
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void pushEntryToBack(LFUCacheEntry entry) {
            assert (Thread.holdsLock(SharedBlobCacheService.this));
            assert (this.invariant(entry, false));
            assert (entry.prev == null);
            assert (entry.next == null);
            org.elasticsearch.blobcache.shared.SharedBlobCacheService$LFUCache.LFUCacheEntry currFront = this.freqs[entry.freq];
            if (currFront == null) {
                this.freqs[entry.freq] = entry;
                entry.prev = entry;
                entry.next = null;
            } else {
                assert (currFront.freq == entry.freq);
                org.elasticsearch.blobcache.shared.SharedBlobCacheService$LFUCache.LFUCacheEntry last = currFront.prev;
                currFront.prev = entry;
                last.next = entry;
                entry.prev = last;
                entry.next = null;
            }
            assert (this.freqs[entry.freq].prev == entry);
            assert (this.freqs[entry.freq].prev.next == null);
            assert (entry.prev != null);
            assert (entry.prev.next == null || entry.prev.next == entry);
            assert (entry.next == null);
            assert (this.invariant(entry, true));
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private synchronized boolean invariant(LFUCacheEntry e, boolean present) {
            boolean found = false;
            for (int i = 0; i < this.maxFreq; ++i) {
                assert (this.freqs[i] == null || this.freqs[i].prev != null);
                assert (this.freqs[i] == null || this.freqs[i].prev != this.freqs[i] || this.freqs[i].next == null);
                assert (this.freqs[i] == null || this.freqs[i].prev.next == null);
                org.elasticsearch.blobcache.shared.SharedBlobCacheService$LFUCache.LFUCacheEntry entry = this.freqs[i];
                while (entry != null) {
                    assert (entry.next == null || entry.next.prev == entry);
                    assert (entry.prev != null);
                    assert (entry.prev.next == null || entry.prev.next == entry);
                    assert (entry.freq == i);
                    if (entry == e) {
                        found = true;
                    }
                    entry = entry.next;
                }
                entry = this.freqs[i];
                while (entry != null && entry.prev != this.freqs[i]) {
                    assert (entry.next == null || entry.next.prev == entry);
                    assert (entry.prev != null);
                    assert (entry.prev.next == null || entry.prev.next == entry);
                    assert (entry.freq == i);
                    if (entry == e) {
                        found = true;
                    }
                    entry = entry.prev;
                }
            }
            assert (found == present);
            return true;
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean assertChunkActiveOrEvicted(LFUCacheEntry entry) {
            SharedBlobCacheService sharedBlobCacheService = SharedBlobCacheService.this;
            synchronized (sharedBlobCacheService) {
                assert (entry.prev != null || ((CacheFileRegion)((Object)entry.chunk)).isEvicted());
            }
            SharedBytes.IO io = ((CacheFileRegion)((Object)entry.chunk)).nonVolatileIO();
            assert (io != null || ((CacheFileRegion)((Object)entry.chunk)).isEvicted());
            assert (io == null || SharedBlobCacheService.this.regionOwners.get(io) == entry.chunk || ((CacheFileRegion)((Object)entry.chunk)).isEvicted());
            return true;
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void maybePromote(long epoch, LFUCacheEntry entry) {
            SharedBlobCacheService sharedBlobCacheService = SharedBlobCacheService.this;
            synchronized (sharedBlobCacheService) {
                if (epoch > entry.lastAccessedEpoch && entry.freq < this.maxFreq - 1 && !((CacheFileRegion)((Object)entry.chunk)).isEvicted()) {
                    this.unlink(entry);
                    entry.freq = Math.min(entry.freq + 2, this.maxFreq - 1);
                    entry.lastAccessedEpoch = epoch;
                    this.pushEntryToBack(entry);
                }
            }
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void unlink(LFUCacheEntry entry) {
            assert (Thread.holdsLock(SharedBlobCacheService.this));
            assert (this.invariant(entry, true));
            assert (entry.prev != null);
            org.elasticsearch.blobcache.shared.SharedBlobCacheService$LFUCache.LFUCacheEntry currFront = this.freqs[entry.freq];
            assert (currFront != null);
            if (currFront == entry) {
                this.freqs[entry.freq] = entry.next;
                if (entry.next != null) {
                    assert (entry.prev != entry);
                    entry.next.prev = entry.prev;
                }
            } else {
                if (entry.next != null) {
                    entry.next.prev = entry.prev;
                }
                entry.prev.next = entry.next;
                if (currFront.prev == entry) {
                    currFront.prev = entry.prev;
                }
            }
            entry.next = null;
            entry.prev = null;
            assert (this.invariant(entry, false));
        }

        private void appendLevel1ToLevel0() {
            assert (Thread.holdsLock(SharedBlobCacheService.this));
            org.elasticsearch.blobcache.shared.SharedBlobCacheService$LFUCache.LFUCacheEntry front0 = this.freqs[0];
            org.elasticsearch.blobcache.shared.SharedBlobCacheService$LFUCache.LFUCacheEntry front1 = this.freqs[1];
            if (front0 == null) {
                this.freqs[0] = front1;
                this.freqs[1] = null;
                this.decrementFreqList((LFUCacheEntry)front1);
                assert (front1 == null || this.invariant((LFUCacheEntry)front1, true));
            } else if (front1 != null) {
                org.elasticsearch.blobcache.shared.SharedBlobCacheService$LFUCache.LFUCacheEntry back0 = front0.prev;
                org.elasticsearch.blobcache.shared.SharedBlobCacheService$LFUCache.LFUCacheEntry back1 = front1.prev;
                assert (this.invariant((LFUCacheEntry)front0, true));
                assert (this.invariant((LFUCacheEntry)front1, true));
                assert (this.invariant((LFUCacheEntry)back0, true));
                assert (this.invariant((LFUCacheEntry)back1, true));
                this.decrementFreqList((LFUCacheEntry)front1);
                front0.prev = back1;
                back0.next = front1;
                front1.prev = back0;
                assert (back1.next == null);
                this.freqs[1] = null;
                assert (this.invariant((LFUCacheEntry)front0, true));
                assert (this.invariant((LFUCacheEntry)front1, true));
                assert (this.invariant((LFUCacheEntry)back0, true));
                assert (this.invariant((LFUCacheEntry)back1, true));
            }
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void decrementFreqList(LFUCacheEntry entry) {
            while (entry != null) {
                --entry.freq;
                entry = entry.next;
            }
        }

        private SharedBytes.IO maybeEvictAndTake(Runnable evictedNotification) {
            assert (Thread.holdsLock(SharedBlobCacheService.this));
            long currentEpoch = this.epoch.get();
            SharedBytes.IO freq0 = this.maybeEvictAndTakeForFrequency(evictedNotification, 0);
            if (this.freqs[0] == null) {
                this.maybeScheduleDecayAndNewEpoch(currentEpoch);
            }
            if (freq0 != null) {
                return freq0;
            }
            for (int currentFreq = 1; currentFreq < this.maxFreq; ++currentFreq) {
                SharedBytes.IO freeRegion = SharedBlobCacheService.this.freeRegions.poll();
                if (freeRegion != null) {
                    return freeRegion;
                }
                SharedBytes.IO taken = this.maybeEvictAndTakeForFrequency(evictedNotification, currentFreq);
                if (taken == null) continue;
                return taken;
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private SharedBytes.IO maybeEvictAndTakeForFrequency(Runnable evictedNotification, int currentFreq) {
            org.elasticsearch.blobcache.shared.SharedBlobCacheService$LFUCache.LFUCacheEntry entry = this.freqs[currentFreq];
            while (entry != null) {
                block12: {
                    boolean evicted = ((CacheFileRegion)((Object)entry.chunk)).tryEvictNoDecRef();
                    if (evicted) {
                        try {
                            SharedBytes.IO ioRef = ((CacheFileRegion)((Object)entry.chunk)).volatileIO();
                            if (ioRef == null) break block12;
                            try {
                                if (((CacheFileRegion)((Object)entry.chunk)).refCount() == 1) {
                                    ((CacheFileRegion)((Object)entry.chunk)).volatileIO(null);
                                    assert (SharedBlobCacheService.this.regionOwners.remove(ioRef) == entry.chunk);
                                    SharedBytes.IO iO = ioRef;
                                    return iO;
                                }
                            }
                            finally {
                                this.unlink((LFUCacheEntry)entry);
                                this.removeKeyMappingForEntry((LFUCacheEntry)entry);
                            }
                        }
                        finally {
                            ((CacheFileRegion)((Object)entry.chunk)).decRef();
                            if (currentFreq > 0) {
                                evictedNotification.run();
                            }
                        }
                    }
                }
                entry = entry.next;
            }
            return null;
        }

        private void maybeScheduleDecayAndNewEpoch(long currentEpoch) {
            this.decayAndNewEpochTask.spawnIfNotRunning(currentEpoch);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean maybeEvictLeastUsed() {
            SharedBlobCacheService sharedBlobCacheService = SharedBlobCacheService.this;
            synchronized (sharedBlobCacheService) {
                org.elasticsearch.blobcache.shared.SharedBlobCacheService$LFUCache.LFUCacheEntry entry = this.freqs[0];
                while (entry != null) {
                    boolean evicted = ((CacheFileRegion)((Object)entry.chunk)).tryEvict();
                    if (evicted && ((CacheFileRegion)((Object)entry.chunk)).volatileIO() != null) {
                        this.unlink((LFUCacheEntry)entry);
                        this.removeKeyMappingForEntry((LFUCacheEntry)entry);
                        return true;
                    }
                    entry = entry.next;
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void computeDecay() {
            long afterLock;
            long now = SharedBlobCacheService.this.threadPool.rawRelativeTimeInMillis();
            SharedBlobCacheService sharedBlobCacheService = SharedBlobCacheService.this;
            synchronized (sharedBlobCacheService) {
                afterLock = SharedBlobCacheService.this.threadPool.rawRelativeTimeInMillis();
                this.appendLevel1ToLevel0();
                for (int i = 2; i < this.maxFreq; ++i) {
                    assert (this.freqs[i - 1] == null);
                    this.freqs[i - 1] = this.freqs[i];
                    this.freqs[i] = null;
                    this.decrementFreqList((LFUCacheEntry)this.freqs[i - 1]);
                    assert (this.freqs[i - 1] == null || this.invariant((LFUCacheEntry)this.freqs[i - 1], true));
                }
            }
            long end = SharedBlobCacheService.this.threadPool.rawRelativeTimeInMillis();
            logger.debug("Decay took {} ms (acquire lock: {} ms)", (Object)(end - now), (Object)(afterLock - now));
        }

        class LFUCacheEntry
        extends CacheEntry<CacheFileRegion<KeyType>> {
            org.elasticsearch.blobcache.shared.SharedBlobCacheService$LFUCache.LFUCacheEntry prev;
            org.elasticsearch.blobcache.shared.SharedBlobCacheService$LFUCache.LFUCacheEntry next;
            int freq;
            volatile long lastAccessedEpoch;

            LFUCacheEntry(CacheFileRegion<KeyType> chunk, long lastAccessed) {
                super(chunk);
                this.lastAccessedEpoch = lastAccessed;
                this.freq = 1;
            }

            @Override
            void touch() {
                long now = LFUCache.this.epoch.get();
                if (now > this.lastAccessedEpoch) {
                    LFUCache.this.maybePromote(now, this);
                }
            }
        }

        class DecayAndNewEpochTask
        extends AbstractRunnable {
            private final Executor executor;
            private final AtomicLong pendingEpoch = new AtomicLong();
            private volatile boolean isClosed;

            DecayAndNewEpochTask(Executor executor) {
                this.executor = executor;
            }

            protected void doRun() throws Exception {
                if (!this.isClosed) {
                    LFUCache.this.computeDecay();
                }
            }

            public void onFailure(Exception e) {
                logger.error("failed to run cache decay task", (Throwable)e);
            }

            public void onAfter() {
                assert (this.pendingEpoch.get() == LFUCache.this.epoch.get() + 1L);
                LFUCache.this.epoch.incrementAndGet();
                SharedBlobCacheService.this.blobCacheMetrics.recordEpochChange();
            }

            public void onRejection(Exception e) {
                assert (false) : e;
                logger.error("unexpected rejection", (Throwable)e);
                LFUCache.this.epoch.incrementAndGet();
            }

            public String toString() {
                return "shared_cache_decay_task";
            }

            public void spawnIfNotRunning(long currentEpoch) {
                if (!this.isClosed && this.pendingEpoch.compareAndSet(currentEpoch, currentEpoch + 1L)) {
                    this.executor.execute((Runnable)((Object)this));
                }
            }

            public void close() {
                this.isClosed = true;
            }
        }
    }

    private static abstract class CacheEntry<T> {
        final T chunk;

        private CacheEntry(T chunk) {
            this.chunk = chunk;
        }

        abstract void touch();
    }

    static class CacheFileRegion<KeyType extends KeyBase>
    extends EvictableRefCounted {
        private static final VarHandle VH_IO = CacheFileRegion.findIOVarHandle();
        final SharedBlobCacheService<KeyType> blobCacheService;
        final RegionKey<KeyType> regionKey;
        final SparseFileTracker tracker;
        private SharedBytes.IO io = null;

        private static VarHandle findIOVarHandle() {
            try {
                return MethodHandles.lookup().in(CacheFileRegion.class).findVarHandle(CacheFileRegion.class, "io", SharedBytes.IO.class);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                throw new RuntimeException(e);
            }
        }

        CacheFileRegion(SharedBlobCacheService<KeyType> blobCacheService, RegionKey<KeyType> regionKey, int regionSize) {
            this.blobCacheService = blobCacheService;
            this.regionKey = regionKey;
            assert (regionSize > 0);
            this.tracker = new SparseFileTracker("file", regionSize);
        }

        private long physicalStartOffset() {
            SharedBytes.IO ioRef = this.nonVolatileIO();
            return ioRef == null ? -1L : (long)this.regionKey.region * (long)this.blobCacheService.regionSize;
        }

        public boolean tryIncRefEnsureOpen() {
            if (this.tryIncRef()) {
                this.ensureOpenOrDecRef();
                return true;
            }
            return false;
        }

        public void incRefEnsureOpen() {
            this.incRef();
            this.ensureOpenOrDecRef();
        }

        private void ensureOpenOrDecRef() {
            if (this.isEvicted()) {
                this.decRef();
                CacheFileRegion.throwAlreadyEvicted();
            }
        }

        boolean tryEvict() {
            assert (Thread.holdsLock(this.blobCacheService)) : "must hold lock when evicting";
            if (this.refCount() <= 1 && this.evict()) {
                logger.trace("evicted {} with channel offset {}", this.regionKey, (Object)this.physicalStartOffset());
                this.blobCacheService.evictCount.increment();
                this.blobCacheService.blobCacheMetrics.getTotalEvictedCount().increment();
                this.decRef();
                return true;
            }
            return false;
        }

        boolean tryEvictNoDecRef() {
            assert (Thread.holdsLock(this.blobCacheService)) : "must hold lock when evicting";
            if (this.refCount() <= 1 && this.evict()) {
                logger.trace("evicted and take {} with channel offset {}", this.regionKey, (Object)this.physicalStartOffset());
                this.blobCacheService.evictCount.increment();
                this.blobCacheService.blobCacheMetrics.getTotalEvictedCount().increment();
                return true;
            }
            return false;
        }

        public boolean forceEvict() {
            assert (Thread.holdsLock(this.blobCacheService)) : "must hold lock when evicting";
            if (this.evict()) {
                logger.trace("force evicted {} with channel offset {}", this.regionKey, (Object)this.physicalStartOffset());
                this.blobCacheService.evictCount.increment();
                this.blobCacheService.blobCacheMetrics.getTotalEvictedCount().increment();
                this.decRef();
                return true;
            }
            return false;
        }

        protected void closeInternal() {
            SharedBytes.IO io = this.volatileIO();
            if (io != null) {
                assert (this.blobCacheService.regionOwners.remove(io) == this);
                this.blobCacheService.freeRegions.add(io);
            }
            logger.trace("closed {} with channel offset {}", this.regionKey, (Object)this.physicalStartOffset());
        }

        private static void throwAlreadyEvicted() {
            SharedBlobCacheService.throwAlreadyClosed("File chunk is evicted");
        }

        private SharedBytes.IO volatileIO() {
            return VH_IO.getVolatile(this);
        }

        private void volatileIO(SharedBytes.IO io) {
            VH_IO.setVolatile(this, io);
        }

        private SharedBytes.IO nonVolatileIO() {
            return this.io;
        }

        SharedBytes.IO testOnlyNonVolatileIO() {
            return this.io;
        }

        boolean tryRead(ByteBuffer buf, long offset) throws IOException {
            SharedBytes.IO ioRef = this.nonVolatileIO();
            if (ioRef != null) {
                int readBytes = ioRef.read(buf, this.blobCacheService.getRegionRelativePosition(offset));
                if (this.isEvicted()) {
                    buf.position(buf.position() - readBytes);
                    return false;
                }
                return true;
            }
            return false;
        }

        void populate(ByteRange rangeToWrite, RangeMissingHandler writer, Executor executor, ActionListener<Boolean> listener) {
            block21: {
                try {
                    this.incRefEnsureOpen();
                    try (RefCountingRunnable refs = new RefCountingRunnable(() -> ((CacheFileRegion)this).decRef());){
                        List<SparseFileTracker.Gap> gaps = this.tracker.waitForRange(rangeToWrite, rangeToWrite, (ActionListener<Void>)(Assertions.ENABLED ? ActionListener.releaseAfter((ActionListener)ActionListener.running(() -> {
                            assert (this.blobCacheService.regionOwners.get(this.nonVolatileIO()) == this);
                        }), (Releasable)refs.acquire()) : refs.acquireListener()));
                        if (gaps.isEmpty()) {
                            listener.onResponse((Object)false);
                            return;
                        }
                        SourceInputStreamFactory streamFactory = writer.sharedInputStreamFactory(gaps);
                        logger.trace(() -> Strings.format((String)"fill gaps %s %s shared input stream factory", (Object[])new Object[]{gaps, streamFactory == null ? "without" : "with"}));
                        if (streamFactory == null) {
                            try (RefCountingListener parallelGapsListener = new RefCountingListener(listener.map(unused -> true));){
                                for (SparseFileTracker.Gap gap2 : gaps) {
                                    executor.execute(this.fillGapRunnable(gap2, writer, null, (ActionListener<Void>)ActionListener.releaseAfter((ActionListener)parallelGapsListener.acquire(), (Releasable)refs.acquire())));
                                }
                                break block21;
                            }
                        }
                        try (RefCountingListener sequentialGapsListener = new RefCountingListener(ActionListener.runBefore((ActionListener)listener.map(unused -> true), () -> ((SourceInputStreamFactory)streamFactory).close()));){
                            List<Runnable> gapFillingTasks = gaps.stream().map(gap -> this.fillGapRunnable((SparseFileTracker.Gap)gap, writer, streamFactory, (ActionListener<Void>)ActionListener.releaseAfter((ActionListener)sequentialGapsListener.acquire(), (Releasable)refs.acquire()))).toList();
                            executor.execute(() -> gapFillingTasks.forEach(Runnable::run));
                        }
                    }
                }
                catch (Exception e) {
                    listener.onFailure(e);
                }
            }
        }

        void populateAndRead(ByteRange rangeToWrite, ByteRange rangeToRead, RangeAvailableHandler reader, RangeMissingHandler writer, Executor executor, ActionListener<Integer> listener) {
            block14: {
                try {
                    this.incRefEnsureOpen();
                    try (RefCountingRunnable refs = new RefCountingRunnable(() -> ((CacheFileRegion)this).decRef());){
                        List<SparseFileTracker.Gap> gaps = this.tracker.waitForRange(rangeToWrite, rangeToRead, (ActionListener<Void>)ActionListener.releaseAfter(listener, (Releasable)refs.acquire()).delegateFailureAndWrap((l, success) -> {
                            SharedBytes.IO ioRef = this.nonVolatileIO();
                            assert (this.blobCacheService.regionOwners.get(ioRef) == this);
                            int start = Math.toIntExact(rangeToRead.start());
                            int read = reader.onRangeAvailable(ioRef, start, start, Math.toIntExact(rangeToRead.length()));
                            assert ((long)read == rangeToRead.length()) : "partial read [" + read + "] does not match the range to read [" + rangeToRead.end() + "-" + rangeToRead.start() + "]";
                            this.blobCacheService.blobCacheMetrics.recordRead();
                            l.onResponse((Object)read);
                        }));
                        if (gaps.isEmpty()) break block14;
                        SourceInputStreamFactory streamFactory = writer.sharedInputStreamFactory(gaps);
                        logger.trace(() -> Strings.format((String)"fill gaps %s %s shared input stream factory", (Object[])new Object[]{gaps, streamFactory == null ? "without" : "with"}));
                        if (streamFactory == null) {
                            for (SparseFileTracker.Gap gap2 : gaps) {
                                executor.execute(this.fillGapRunnable(gap2, writer, null, (ActionListener<Void>)refs.acquireListener()));
                            }
                            break block14;
                        }
                        ActionListener gapFillingListener = refs.acquireListener();
                        try (RefCountingRunnable gfRefs = new RefCountingRunnable((Runnable)ActionRunnable.run((ActionListener)gapFillingListener, () -> ((SourceInputStreamFactory)streamFactory).close()));){
                            List<Runnable> gapFillingTasks = gaps.stream().map(gap -> this.fillGapRunnable((SparseFileTracker.Gap)gap, writer, streamFactory, (ActionListener<Void>)gfRefs.acquireListener())).toList();
                            executor.execute(() -> gapFillingTasks.forEach(Runnable::run));
                        }
                    }
                }
                catch (Exception e) {
                    listener.onFailure(e);
                }
            }
        }

        private Runnable fillGapRunnable(SparseFileTracker.Gap gap, RangeMissingHandler writer, @Nullable SourceInputStreamFactory streamFactory, ActionListener<Void> listener) {
            return () -> ActionListener.run((ActionListener)listener, l -> {
                SharedBytes.IO ioRef = this.nonVolatileIO();
                assert (this.blobCacheService.regionOwners.get(ioRef) == this);
                assert (this.hasReferences()) : this;
                int start = Math.toIntExact(gap.start());
                writer.fillCacheRange(ioRef, start, streamFactory, start, Math.toIntExact(gap.end() - (long)start), progress -> gap.onProgress(start + progress), (ActionListener<Void>)l.map(unused -> {
                    assert (this.blobCacheService.regionOwners.get(ioRef) == this);
                    assert (this.hasReferences()) : this;
                    this.blobCacheService.writeCount.increment();
                    gap.onCompletion();
                    return null;
                }).delegateResponse((delegate, e) -> CacheFileRegion.failGapAndListener(gap, delegate, e)));
            });
        }

        private static void failGapAndListener(SparseFileTracker.Gap gap, ActionListener<?> listener, Exception e) {
            try {
                gap.onFailure(e);
            }
            catch (Exception ex) {
                e.addSuppressed(ex);
            }
            listener.onFailure(e);
        }

        protected void alreadyClosed() {
            CacheFileRegion.throwAlreadyEvicted();
        }
    }

    public static interface KeyBase {
        public ShardId shardId();
    }

    @FunctionalInterface
    public static interface RangeMissingHandler {
        @Nullable
        default public SourceInputStreamFactory sharedInputStreamFactory(List<SparseFileTracker.Gap> gaps) {
            return null;
        }

        public void fillCacheRange(SharedBytes.IO var1, int var2, @Nullable SourceInputStreamFactory var3, int var4, int var5, IntConsumer var6, ActionListener<Void> var7) throws IOException;
    }

    public record Stats(int numberOfRegions, long size, long regionSize, long evictCount, long writeCount, long writeBytes, long readCount, long readBytes, long missCount) {
        public static final Stats EMPTY = new Stats(0, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L);
    }

    public class CacheFile {
        private final KeyType cacheKey;
        private final long length;
        private CacheEntry<CacheFileRegion<KeyType>> lastAccessedRegion;
        final /* synthetic */ SharedBlobCacheService this$0;

        /*
         * WARNING - Possible parameter corruption
         * WARNING - void declaration
         */
        private CacheFile(KeyType length, long l) {
            void cacheKey;
            this.this$0 = (SharedBlobCacheService)this$0;
            this.cacheKey = cacheKey;
            this.length = (long)length;
        }

        public CacheFile copy() {
            return new CacheFile(this.this$0, this.cacheKey, this.length);
        }

        public long getLength() {
            return this.length;
        }

        public KeyType getCacheKey() {
            return this.cacheKey;
        }

        public boolean tryRead(ByteBuffer buf, long offset) throws IOException {
            long end;
            int endRegion;
            assert (this.this$0.assertOffsetsWithinFileLength(offset, buf.remaining(), this.length));
            int startRegion = this.this$0.getRegion(offset);
            if (startRegion != (endRegion = this.this$0.getEndingRegion(end = offset + (long)buf.remaining()))) {
                return false;
            }
            CacheEntry fileRegion = this.lastAccessedRegion;
            boolean incrementReads = false;
            if (fileRegion != null && ((CacheFileRegion)((Object)fileRegion.chunk)).regionKey.region == startRegion) {
                fileRegion.touch();
            } else {
                fileRegion = this.this$0.cache.get(this.cacheKey, this.length, startRegion);
                incrementReads = true;
            }
            CacheFileRegion region = (CacheFileRegion)((Object)fileRegion.chunk);
            if (!region.tracker.checkAvailable(end - this.this$0.getRegionStart(startRegion))) {
                return false;
            }
            boolean res = region.tryRead(buf, offset);
            CacheEntry<CacheFileRegion<Object>> cacheEntry = this.lastAccessedRegion = res ? fileRegion : null;
            if (res && incrementReads) {
                this.this$0.blobCacheMetrics.recordRead();
            }
            return res;
        }

        public int populateAndRead(ByteRange rangeToWrite, ByteRange rangeToRead, RangeAvailableHandler reader, final RangeMissingHandler writer, final String resourceDescription) throws Exception {
            int endRegion;
            assert (rangeToWrite.start() >= 0L) : rangeToWrite;
            assert (this.this$0.assertOffsetsWithinFileLength(rangeToRead.start(), rangeToRead.length(), this.length));
            final long startTime = this.this$0.relativeTimeInNanosSupplier.getAsLong();
            DelegatingRangeMissingHandler writerInstrumentationDecorator = new DelegatingRangeMissingHandler(writer){

                @Override
                public void fillCacheRange(SharedBytes.IO channel, int channelPos, SourceInputStreamFactory streamFactory, int relativePos, int length, IntConsumer progressUpdater, ActionListener<Void> completionListener) throws IOException {
                    String blobFileExtension = SharedBlobCacheService.getFileExtension(resourceDescription);
                    String executorName = EsExecutors.executorName((Thread)Thread.currentThread());
                    writer.fillCacheRange(channel, channelPos, streamFactory, relativePos, length, progressUpdater, (ActionListener<Void>)completionListener.map(unused -> {
                        long elapsedTime = TimeUnit.NANOSECONDS.toMillis(CacheFile.this.this$0.relativeTimeInNanosSupplier.getAsLong() - startTime);
                        CacheFile.this.this$0.blobCacheMetrics.getCacheMissLoadTimes().record(elapsedTime);
                        CacheFile.this.this$0.blobCacheMetrics.getCacheMissCounter().incrementBy(1L, Map.of("file_extension", blobFileExtension, "executor", executorName != null ? executorName : "other"));
                        return null;
                    }));
                }
            };
            if (rangeToRead.isEmpty()) {
                return 0;
            }
            int startRegion = this.this$0.getRegion(rangeToWrite.start());
            if (startRegion == (endRegion = this.this$0.getEndingRegion(rangeToWrite.end()))) {
                return this.readSingleRegion(rangeToWrite, rangeToRead, reader, writerInstrumentationDecorator, startRegion);
            }
            return this.readMultiRegions(rangeToWrite, rangeToRead, reader, writerInstrumentationDecorator, startRegion, endRegion);
        }

        private int readSingleRegion(ByteRange rangeToWrite, ByteRange rangeToRead, RangeAvailableHandler reader, RangeMissingHandler writer, int region) throws InterruptedException, ExecutionException {
            PlainActionFuture readFuture = new PlainActionFuture();
            CacheFileRegion fileRegion = this.this$0.get(this.cacheKey, this.length, region);
            long regionStart = this.this$0.getRegionStart(region);
            fileRegion.populateAndRead(this.this$0.mapSubRangeToRegion(rangeToWrite, region), this.this$0.mapSubRangeToRegion(rangeToRead, region), this.readerWithOffset(reader, fileRegion, Math.toIntExact(rangeToRead.start() - regionStart)), this.metricRecordingWriter(this.writerWithOffset(writer, fileRegion, Math.toIntExact(rangeToWrite.start() - regionStart))), this.this$0.ioExecutor, (ActionListener<Integer>)readFuture);
            return (Integer)readFuture.get();
        }

        private int readMultiRegions(ByteRange rangeToWrite, ByteRange rangeToRead, RangeAvailableHandler reader, RangeMissingHandler writer, int startRegion, int endRegion) throws InterruptedException, ExecutionException {
            PlainActionFuture readsComplete = new PlainActionFuture();
            AtomicInteger bytesRead = new AtomicInteger();
            try (RefCountingListener listeners = new RefCountingListener(1, (ActionListener)readsComplete);){
                for (int region = startRegion; region <= endRegion; ++region) {
                    ByteRange subRangeToRead = this.this$0.mapSubRangeToRegion(rangeToRead, region);
                    if (subRangeToRead.isEmpty()) continue;
                    ActionListener listener = listeners.acquire(i -> bytesRead.updateAndGet(j -> Math.addExact(i, j)));
                    try {
                        CacheFileRegion fileRegion = this.this$0.get(this.cacheKey, this.length, region);
                        long regionStart = this.this$0.getRegionStart(region);
                        fileRegion.populateAndRead(this.this$0.mapSubRangeToRegion(rangeToWrite, region), subRangeToRead, this.readerWithOffset(reader, fileRegion, Math.toIntExact(rangeToRead.start() - regionStart)), this.metricRecordingWriter(this.writerWithOffset(writer, fileRegion, Math.toIntExact(rangeToWrite.start() - regionStart))), this.this$0.ioExecutor, (ActionListener<Integer>)listener);
                        continue;
                    }
                    catch (Exception e) {
                        assert (e instanceof AlreadyClosedException) : e;
                        listener.onFailure(e);
                    }
                }
            }
            readsComplete.get();
            return bytesRead.get();
        }

        private RangeMissingHandler writerWithOffset(RangeMissingHandler writer, final CacheFileRegion<KeyType> fileRegion, final int writeOffset) {
            RangeMissingHandler adjustedWriter = writeOffset == 0 ? writer : new DelegatingRangeMissingHandler(this, writer){

                @Override
                public void fillCacheRange(SharedBytes.IO channel, int channelPos, SourceInputStreamFactory streamFactory, int relativePos, int len, IntConsumer progressUpdater, ActionListener<Void> completionListener) throws IOException {
                    this.delegate.fillCacheRange(channel, channelPos, streamFactory, relativePos - writeOffset, len, progressUpdater, completionListener);
                }
            };
            if (Assertions.ENABLED) {
                return new DelegatingRangeMissingHandler(adjustedWriter){

                    @Override
                    public void fillCacheRange(SharedBytes.IO channel, int channelPos, SourceInputStreamFactory streamFactory, int relativePos, int len, IntConsumer progressUpdater, ActionListener<Void> completionListener) throws IOException {
                        assert (CacheFile.this.assertValidRegionAndLength(fileRegion, channelPos, len));
                        this.delegate.fillCacheRange(channel, channelPos, streamFactory, relativePos, len, progressUpdater, Assertions.ENABLED ? ActionListener.runBefore(completionListener, () -> {
                            assert (CacheFile.this.this$0.regionOwners.get(fileRegion.nonVolatileIO()) == fileRegion) : "File chunk [" + String.valueOf(fileRegion2.regionKey) + "] no longer owns IO [" + String.valueOf(fileRegion.nonVolatileIO()) + "]";
                        }) : completionListener);
                    }
                };
            }
            return adjustedWriter;
        }

        private RangeMissingHandler metricRecordingWriter(RangeMissingHandler writer) {
            return new DelegatingRangeMissingHandler(writer){

                @Override
                public SourceInputStreamFactory sharedInputStreamFactory(List<SparseFileTracker.Gap> gaps) {
                    CacheFile.this.this$0.blobCacheMetrics.recordMiss();
                    return super.sharedInputStreamFactory(gaps);
                }
            };
        }

        private RangeAvailableHandler readerWithOffset(RangeAvailableHandler reader, CacheFileRegion<KeyType> fileRegion, int readOffset) {
            RangeAvailableHandler adjustedReader = (channel, channelPos, relativePos, len) -> reader.onRangeAvailable(channel, channelPos, relativePos - readOffset, len);
            if (Assertions.ENABLED) {
                return (channel, channelPos, relativePos, len) -> {
                    assert (this.assertValidRegionAndLength(fileRegion, channelPos, len));
                    int bytesRead = adjustedReader.onRangeAvailable(channel, channelPos, relativePos, len);
                    assert (this.this$0.regionOwners.get(fileRegion.nonVolatileIO()) == fileRegion) : "File chunk [" + String.valueOf(fileRegion.regionKey) + "] no longer owns IO [" + String.valueOf(fileRegion.nonVolatileIO()) + "]";
                    return bytesRead;
                };
            }
            return adjustedReader;
        }

        private boolean assertValidRegionAndLength(CacheFileRegion<KeyType> fileRegion, int channelPos, int len) {
            assert (fileRegion.nonVolatileIO() != null);
            assert (fileRegion.hasReferences());
            assert (this.this$0.regionOwners.get(fileRegion.nonVolatileIO()) == fileRegion);
            assert (channelPos >= 0 && channelPos + len <= this.this$0.regionSize);
            return true;
        }

        public String toString() {
            return "SharedCacheFile{cacheKey=" + String.valueOf(this.cacheKey) + ", length=" + this.length + "}";
        }
    }

    private static abstract class DelegatingRangeMissingHandler
    implements RangeMissingHandler {
        protected final RangeMissingHandler delegate;

        protected DelegatingRangeMissingHandler(RangeMissingHandler delegate) {
            this.delegate = delegate;
        }

        @Override
        public SourceInputStreamFactory sharedInputStreamFactory(List<SparseFileTracker.Gap> gaps) {
            return this.delegate.sharedInputStreamFactory(gaps);
        }

        @Override
        public void fillCacheRange(SharedBytes.IO channel, int channelPos, SourceInputStreamFactory streamFactory, int relativePos, int length, IntConsumer progressUpdater, ActionListener<Void> completionListener) throws IOException {
            this.delegate.fillCacheRange(channel, channelPos, streamFactory, relativePos, length, progressUpdater, completionListener);
        }
    }

    public static interface SourceInputStreamFactory
    extends Releasable {
        public void create(int var1, ActionListener<InputStream> var2) throws IOException;
    }

    @FunctionalInterface
    public static interface RangeAvailableHandler {
        public int onRangeAvailable(SharedBytes.IO var1, int var2, int var3, int var4) throws IOException;
    }

    private static abstract class EvictableRefCounted
    extends AbstractRefCounted {
        protected static final VarHandle VH_EVICTED_FIELD;
        private volatile int evicted = 0;

        private EvictableRefCounted() {
        }

        protected final boolean evict() {
            return VH_EVICTED_FIELD.compareAndSet(this, 0, 1);
        }

        public final boolean isEvicted() {
            return this.evicted != 0;
        }

        static {
            try {
                VH_EVICTED_FIELD = MethodHandles.lookup().in(EvictableRefCounted.class).findVarHandle(EvictableRefCounted.class, "evicted", Integer.TYPE);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private record RegionKey<KeyType>(KeyType file, int region) {
        @Override
        public String toString() {
            return "Chunk{file=" + String.valueOf(this.file) + ", region=" + this.region + "}";
        }
    }
}

