/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.blobcache.shared;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Function;

class KeyMapping<Key1, Key2, Value> {
    private final ConcurrentHashMap<Key1, ConcurrentHashMap<Key2, Value>> mapping = new ConcurrentHashMap();

    KeyMapping() {
    }

    public Value get(Key1 key1, Key2 key2) {
        ConcurrentHashMap<Key2, Value> inner = this.mapping.get(key1);
        if (inner != null) {
            return inner.get(key2);
        }
        return null;
    }

    public Value computeIfAbsent(Key1 key1, Key2 key2, Function<Key2, Value> function) {
        AtomicReference result = new AtomicReference();
        this.mapping.compute(key1, (k, current) -> {
            ConcurrentHashMap map = current == null ? new ConcurrentHashMap() : current;
            result.setPlain(map.computeIfAbsent(key2, function));
            return map;
        });
        return (Value)result.getPlain();
    }

    public boolean remove(Key1 key1, Key2 key2, Value value) {
        ConcurrentHashMap<Key2, Value> inner = this.mapping.get(key1);
        if (inner != null) {
            boolean removed = inner.remove(key2, value);
            if (removed && inner.isEmpty()) {
                this.mapping.computeIfPresent(key1, (k, v) -> v.isEmpty() ? null : v);
            }
            return removed;
        }
        return false;
    }

    Iterable<Key1> key1s() {
        return this.mapping.keySet();
    }

    void forEach(Key1 key1, BiConsumer<Key2, Value> consumer) {
        ConcurrentHashMap<Key2, Value> map = this.mapping.get(key1);
        if (map != null) {
            map.forEach(consumer);
        }
    }

    void forEach(BiConsumer<Key2, Value> consumer) {
        for (ConcurrentHashMap<Key2, Value> map : this.mapping.values()) {
            map.forEach(consumer);
        }
    }
}

