/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.exponentialhistogram;

import java.util.Arrays;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.exponentialhistogram.ExponentialHistogramCircuitBreaker;
import org.elasticsearch.exponentialhistogram.ExponentialHistogramMerger;
import org.elasticsearch.exponentialhistogram.ExponentialScaleUtils;
import org.elasticsearch.exponentialhistogram.FixedCapacityExponentialHistogram;
import org.elasticsearch.exponentialhistogram.RamEstimationUtil;
import org.elasticsearch.exponentialhistogram.ReleasableExponentialHistogram;
import org.elasticsearch.exponentialhistogram.ZeroBucket;

public class ExponentialHistogramGenerator
implements Accountable,
Releasable {
    private static final long SHALLOW_SIZE = RamUsageEstimator.shallowSizeOfInstance(ExponentialHistogramGenerator.class);
    private final double[] rawValueBuffer;
    private int valueCount;
    private final ExponentialHistogramMerger resultMerger;
    private final FixedCapacityExponentialHistogram valueBuffer;
    private final ExponentialHistogramCircuitBreaker circuitBreaker;
    private boolean closed = false;

    public static ExponentialHistogramGenerator create(int maxBucketCount, ExponentialHistogramCircuitBreaker circuitBreaker) {
        long size = ExponentialHistogramGenerator.estimateBaseSize(maxBucketCount);
        circuitBreaker.adjustBreaker(size);
        try {
            return new ExponentialHistogramGenerator(maxBucketCount, circuitBreaker);
        }
        catch (RuntimeException e) {
            circuitBreaker.adjustBreaker(-size);
            throw e;
        }
    }

    private ExponentialHistogramGenerator(int maxBucketCount, ExponentialHistogramCircuitBreaker circuitBreaker) {
        this.circuitBreaker = circuitBreaker;
        this.rawValueBuffer = new double[maxBucketCount];
        this.valueCount = 0;
        FixedCapacityExponentialHistogram buffer = null;
        ExponentialHistogramMerger merger = null;
        try {
            buffer = FixedCapacityExponentialHistogram.create(maxBucketCount, circuitBreaker);
            merger = ExponentialHistogramMerger.create(maxBucketCount, circuitBreaker);
        }
        catch (RuntimeException e) {
            Releasables.close((Releasable[])new Releasable[]{buffer, merger});
            throw e;
        }
        this.valueBuffer = buffer;
        this.resultMerger = merger;
    }

    public void add(double value) {
        assert (!this.closed) : "ExponentialHistogramGenerator has already been closed";
        if (this.valueCount == this.rawValueBuffer.length) {
            this.mergeValuesToHistogram();
        }
        this.rawValueBuffer[this.valueCount] = value;
        ++this.valueCount;
    }

    public ReleasableExponentialHistogram getAndClear() {
        this.mergeValuesToHistogram();
        return this.resultMerger.getAndClear();
    }

    private void mergeValuesToHistogram() {
        int negativeValuesCount;
        if (this.valueCount == 0) {
            return;
        }
        Arrays.sort(this.rawValueBuffer, 0, this.valueCount);
        for (negativeValuesCount = 0; negativeValuesCount < this.valueCount && this.rawValueBuffer[negativeValuesCount] < 0.0; ++negativeValuesCount) {
        }
        this.valueBuffer.reset();
        Aggregates aggregates = this.rawValuesAggregates();
        this.valueBuffer.setSum(aggregates.sum());
        this.valueBuffer.setMin(aggregates.min());
        this.valueBuffer.setMax(aggregates.max());
        int scale = this.valueBuffer.scale();
        for (int i = negativeValuesCount - 1; i >= 0; --i) {
            long count = 1L;
            long index = ExponentialScaleUtils.computeIndex(this.rawValueBuffer[i], scale);
            while (i - 1 >= 0 && ExponentialScaleUtils.computeIndex(this.rawValueBuffer[i - 1], scale) == index) {
                --i;
                ++count;
            }
            this.valueBuffer.tryAddBucket(index, count, false);
        }
        int zeroCount = 0;
        while (negativeValuesCount + zeroCount < this.valueCount && this.rawValueBuffer[negativeValuesCount + zeroCount] == 0.0) {
            ++zeroCount;
        }
        this.valueBuffer.setZeroBucket(ZeroBucket.minimalWithCount(zeroCount));
        for (int i = negativeValuesCount + zeroCount; i < this.valueCount; ++i) {
            long count = 1L;
            long index = ExponentialScaleUtils.computeIndex(this.rawValueBuffer[i], scale);
            while (i + 1 < this.valueCount && ExponentialScaleUtils.computeIndex(this.rawValueBuffer[i + 1], scale) == index) {
                ++i;
                ++count;
            }
            this.valueBuffer.tryAddBucket(index, count, true);
        }
        this.resultMerger.add(this.valueBuffer);
        this.valueCount = 0;
    }

    private Aggregates rawValuesAggregates() {
        if (this.valueCount == 0) {
            return new Aggregates(0.0, Double.NaN, Double.NaN);
        }
        double sum = 0.0;
        double min = Double.MAX_VALUE;
        double max = -1.7976931348623157E308;
        for (int i = 0; i < this.valueCount; ++i) {
            sum += this.rawValueBuffer[i];
            min = Math.min(min, this.rawValueBuffer[i]);
            max = Math.max(max, this.rawValueBuffer[i]);
        }
        return new Aggregates(sum, min, max);
    }

    private static long estimateBaseSize(int numBuckets) {
        return SHALLOW_SIZE + RamEstimationUtil.estimateDoubleArray(numBuckets);
    }

    public long ramBytesUsed() {
        return ExponentialHistogramGenerator.estimateBaseSize(this.rawValueBuffer.length) + this.resultMerger.ramBytesUsed() + this.valueBuffer.ramBytesUsed();
    }

    public void close() {
        if (this.closed) {
            assert (false) : "ExponentialHistogramGenerator closed multiple times";
        } else {
            this.closed = true;
            this.resultMerger.close();
            this.valueBuffer.close();
            this.circuitBreaker.adjustBreaker(-ExponentialHistogramGenerator.estimateBaseSize(this.rawValueBuffer.length));
        }
    }

    private record Aggregates(double sum, double min, double max) {
    }
}

