/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.exponentialhistogram.aggregations.metrics;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.search.ScoreMode;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.DoubleArray;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.AggregationExecutionContext;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.elasticsearch.search.aggregations.LeafBucketCollectorBase;
import org.elasticsearch.search.aggregations.metrics.CompensatedSum;
import org.elasticsearch.search.aggregations.metrics.NumericMetricsAggregator;
import org.elasticsearch.search.aggregations.metrics.Sum;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.xpack.core.exponentialhistogram.fielddata.ExponentialHistogramValuesReader;
import org.elasticsearch.xpack.exponentialhistogram.aggregations.support.ExponentialHistogramValuesSource;

public final class ExponentialHistogramSumAggregator
extends NumericMetricsAggregator.SingleValue {
    private final ExponentialHistogramValuesSource.ExponentialHistogram valuesSource;
    private final DocValueFormat format;
    private DoubleArray sums;
    private DoubleArray compensations;

    public ExponentialHistogramSumAggregator(String name, ValuesSourceConfig valuesSourceConfig, AggregationContext context, Aggregator parent, Map<String, Object> metadata) throws IOException {
        super(name, context, parent, metadata);
        assert (valuesSourceConfig.hasValues());
        this.valuesSource = (ExponentialHistogramValuesSource.ExponentialHistogram)valuesSourceConfig.getValuesSource();
        this.sums = context.bigArrays().newDoubleArray(1L, true);
        this.compensations = context.bigArrays().newDoubleArray(1L, true);
        this.format = valuesSourceConfig.format();
    }

    public ScoreMode scoreMode() {
        return this.valuesSource.needsScores() ? ScoreMode.COMPLETE : ScoreMode.COMPLETE_NO_SCORES;
    }

    public LeafBucketCollector getLeafCollector(AggregationExecutionContext aggCtx, LeafBucketCollector sub) throws IOException {
        final BigArrays bigArrays = this.bigArrays();
        final ExponentialHistogramValuesReader values = this.valuesSource.getHistogramValues(aggCtx.getLeafReaderContext());
        final CompensatedSum kahanSummation = new CompensatedSum(0.0, 0.0);
        return new LeafBucketCollectorBase(sub, values){

            public void collect(int doc, long bucket) throws IOException {
                ExponentialHistogramSumAggregator.this.sums = bigArrays.grow(ExponentialHistogramSumAggregator.this.sums, bucket + 1L);
                ExponentialHistogramSumAggregator.this.compensations = bigArrays.grow(ExponentialHistogramSumAggregator.this.compensations, bucket + 1L);
                if (values.advanceExact(doc)) {
                    double sum = ExponentialHistogramSumAggregator.this.sums.get(bucket);
                    double compensation = ExponentialHistogramSumAggregator.this.compensations.get(bucket);
                    kahanSummation.reset(sum, compensation);
                    kahanSummation.add(values.sumValue());
                    ExponentialHistogramSumAggregator.this.compensations.set(bucket, kahanSummation.delta());
                    ExponentialHistogramSumAggregator.this.sums.set(bucket, kahanSummation.value());
                }
            }
        };
    }

    public double metric(long owningBucketOrd) {
        if (owningBucketOrd >= this.sums.size()) {
            return 0.0;
        }
        return this.sums.get(owningBucketOrd);
    }

    public InternalAggregation buildAggregation(long bucket) {
        if (bucket >= this.sums.size()) {
            return this.buildEmptyAggregation();
        }
        return new Sum(this.name, this.sums.get(bucket), this.format, this.metadata());
    }

    public InternalAggregation buildEmptyAggregation() {
        return Sum.empty((String)this.name, (DocValueFormat)this.format, (Map)this.metadata());
    }

    public void doClose() {
        Releasables.close((Releasable[])new Releasable[]{this.sums, this.compensations});
    }
}

