/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.session;

import java.time.ZoneId;
import java.util.Map;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.xpack.ql.session.Configuration;
import org.elasticsearch.xpack.sql.action.SqlQueryTask;
import org.elasticsearch.xpack.sql.proto.Mode;
import org.elasticsearch.xpack.sql.proto.SqlVersion;
import org.elasticsearch.xpack.sql.proto.SqlVersions;

public class SqlConfiguration
extends Configuration {
    @Nullable
    private final String catalog;
    private final int pageSize;
    private final TimeValue requestTimeout;
    private final TimeValue pageTimeout;
    private final Mode mode;
    private final String clientId;
    private final SqlVersion version;
    private final boolean multiValueFieldLeniency;
    private final boolean includeFrozenIndices;
    @Nullable
    private final TaskId taskId;
    @Nullable
    private final SqlQueryTask task;
    @Nullable
    private final QueryBuilder filter;
    @Nullable
    private final Map<String, Object> runtimeMappings;
    private final boolean allowPartialSearchResults;
    private final boolean crossProject;
    private final String projectRouting;

    public SqlConfiguration(ZoneId zi, @Nullable String catalog, int pageSize, TimeValue requestTimeout, TimeValue pageTimeout, QueryBuilder filter, Map<String, Object> runtimeMappings, Mode mode, String clientId, SqlVersion version, String username, String clusterName, boolean multiValueFieldLeniency, boolean includeFrozen, @Nullable TaskId taskId, @Nullable SqlQueryTask task, boolean allowPartialSearchResults, boolean crossProject, String projectRouting) {
        super(zi, username, clusterName);
        this.catalog = catalog;
        this.pageSize = pageSize;
        this.requestTimeout = requestTimeout;
        this.pageTimeout = pageTimeout;
        this.filter = filter;
        this.runtimeMappings = runtimeMappings;
        this.mode = mode == null ? Mode.PLAIN : mode;
        this.clientId = clientId;
        this.version = version != null ? version : SqlVersions.SERVER_COMPAT_VERSION;
        this.multiValueFieldLeniency = multiValueFieldLeniency;
        this.includeFrozenIndices = includeFrozen;
        this.taskId = taskId;
        this.task = task;
        this.allowPartialSearchResults = allowPartialSearchResults;
        this.crossProject = crossProject;
        this.projectRouting = projectRouting;
    }

    public String catalog() {
        return this.catalog;
    }

    public int pageSize() {
        return this.pageSize;
    }

    public TimeValue requestTimeout() {
        return this.requestTimeout;
    }

    public TimeValue pageTimeout() {
        return this.pageTimeout;
    }

    public QueryBuilder filter() {
        return this.filter;
    }

    public Map<String, Object> runtimeMappings() {
        return this.runtimeMappings;
    }

    public Mode mode() {
        return this.mode;
    }

    public String clientId() {
        return this.clientId;
    }

    public boolean multiValueFieldLeniency() {
        return this.multiValueFieldLeniency;
    }

    public boolean includeFrozen() {
        return this.includeFrozenIndices;
    }

    public SqlVersion version() {
        return this.version;
    }

    public TaskId taskId() {
        return this.taskId;
    }

    public SqlQueryTask task() {
        return this.task;
    }

    public boolean allowPartialSearchResults() {
        return this.allowPartialSearchResults;
    }

    public boolean crossProject() {
        return this.crossProject;
    }

    public String projectRouting() {
        return this.projectRouting;
    }
}

