/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.function.scalar.geo;

import java.io.IOException;
import java.util.function.Function;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.ql.expression.gen.processor.Processor;
import org.elasticsearch.xpack.sql.SqlIllegalArgumentException;
import org.elasticsearch.xpack.sql.expression.literal.geo.GeoShape;

public class GeoProcessor
implements Processor {
    public static final String NAME = "geo";
    private final GeoOperation processor;

    public GeoProcessor(GeoOperation processor) {
        this.processor = processor;
    }

    public GeoProcessor(StreamInput in) throws IOException {
        this.processor = (GeoOperation)in.readEnum(GeoOperation.class);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeEnum((Enum)this.processor);
    }

    public String getWriteableName() {
        return NAME;
    }

    public Object process(Object input) {
        return this.processor.apply(input);
    }

    GeoOperation processor() {
        return this.processor;
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        GeoProcessor other = (GeoProcessor)obj;
        return this.processor == other.processor;
    }

    public int hashCode() {
        return this.processor.hashCode();
    }

    public String toString() {
        return this.processor.toString();
    }

    public static enum GeoOperation {
        ASWKT(GeoShape::toString),
        GEOMETRY_TYPE(GeoShape::getGeometryType),
        X(GeoShape::getX),
        Y(GeoShape::getY),
        Z(GeoShape::getZ);

        private final Function<Object, Object> apply = l -> l == null ? null : apply.apply(l);

        private GeoOperation(GeoShapeFunction<Object> apply) {
        }

        public final Object apply(Object l) {
            return this.apply.apply(l);
        }
    }

    private static interface GeoShapeFunction<R> {
        default public R apply(Object o) {
            if (o instanceof GeoShape) {
                return this.doApply((GeoShape)o);
            }
            throw new SqlIllegalArgumentException("A geo_point or geo_shape is required; received [{}]", o);
        }

        public R doApply(GeoShape var1);
    }
}

