/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.inference.assignment;

import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.xpack.core.ml.inference.assignment.RoutingInfo;
import org.elasticsearch.xpack.core.ml.inference.assignment.RoutingState;
import org.elasticsearch.xpack.core.ml.inference.assignment.RoutingStateAndReason;

public class RoutingInfoUpdate
implements Writeable {
    private final Optional<Integer> numberOfAllocations;
    private final Optional<RoutingStateAndReason> stateAndReason;

    public static RoutingInfoUpdate updateNumberOfAllocations(int numberOfAllocations) {
        return new RoutingInfoUpdate(Optional.of(numberOfAllocations), Optional.empty());
    }

    public static RoutingInfoUpdate updateStateAndReason(RoutingStateAndReason routingStateAndReason) {
        return new RoutingInfoUpdate(Optional.empty(), Optional.of(routingStateAndReason));
    }

    private RoutingInfoUpdate(Optional<Integer> numberOfAllocations, Optional<RoutingStateAndReason> stateAndReason) {
        this.numberOfAllocations = Objects.requireNonNull(numberOfAllocations);
        this.stateAndReason = Objects.requireNonNull(stateAndReason);
    }

    public RoutingInfoUpdate(StreamInput in) throws IOException {
        this.numberOfAllocations = Optional.ofNullable(in.readOptionalVInt());
        this.stateAndReason = Optional.ofNullable((RoutingStateAndReason)in.readOptionalWriteable(RoutingStateAndReason::new));
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalVInt((Integer)this.numberOfAllocations.orElse(null));
        out.writeOptionalWriteable((Writeable)this.stateAndReason.orElse(null));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RoutingInfoUpdate that = (RoutingInfoUpdate)o;
        return Objects.equals(this.numberOfAllocations, that.numberOfAllocations) && Objects.equals(this.stateAndReason, that.stateAndReason);
    }

    public int hashCode() {
        return Objects.hash(this.numberOfAllocations, this.stateAndReason);
    }

    public String toString() {
        return "RoutingInfoUpdate{numberOfAllocations=" + String.valueOf(this.numberOfAllocations) + ", stateAndReason=" + String.valueOf(this.stateAndReason) + "}";
    }

    public Optional<Integer> getNumberOfAllocations() {
        return this.numberOfAllocations;
    }

    public Optional<RoutingStateAndReason> getStateAndReason() {
        return this.stateAndReason;
    }

    public RoutingInfo apply(RoutingInfo routingInfo) {
        int currentAllocations = this.numberOfAllocations.orElse(routingInfo.getCurrentAllocations());
        RoutingState state = routingInfo.getState();
        String reason = routingInfo.getReason();
        if (this.stateAndReason.isPresent()) {
            state = this.stateAndReason.get().getState();
            reason = this.stateAndReason.get().getReason();
        }
        return new RoutingInfo(currentAllocations, routingInfo.getTargetAllocations(), state, reason);
    }
}

