/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.archive;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.XPackFeatureUsage;

public class ArchiveFeatureSetUsage
extends XPackFeatureUsage {
    private final int numberOfArchiveIndices;

    public ArchiveFeatureSetUsage(StreamInput input) throws IOException {
        super(input);
        this.numberOfArchiveIndices = input.readVInt();
    }

    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersion.minimumCompatible();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeVInt(this.numberOfArchiveIndices);
    }

    public ArchiveFeatureSetUsage(boolean available, int numberOfArchiveIndices) {
        super("archive", available, true);
        this.numberOfArchiveIndices = numberOfArchiveIndices;
    }

    public int getNumberOfArchiveIndices() {
        return this.numberOfArchiveIndices;
    }

    @Override
    protected void innerXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        super.innerXContent(builder, params);
        builder.field("indices_count", this.numberOfArchiveIndices);
    }

    public int hashCode() {
        return Objects.hash(this.available, this.enabled, this.numberOfArchiveIndices);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ArchiveFeatureSetUsage other = (ArchiveFeatureSetUsage)obj;
        return this.available == other.available && this.enabled == other.enabled && this.numberOfArchiveIndices == other.numberOfArchiveIndices;
    }
}

