/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.eql.plugin;

import java.io.IOException;
import java.time.ZoneId;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.concurrent.Executor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionListenerResponseHandler;
import org.elasticsearch.action.search.ShardSearchFailure;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.time.DateUtils;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.search.fetch.subphase.FieldAndFormat;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskAwareRequest;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.RemoteClusterAware;
import org.elasticsearch.transport.RemoteTransportException;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestOptions;
import org.elasticsearch.transport.TransportResponseHandler;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.XPackSettings;
import org.elasticsearch.xpack.core.async.AsyncExecutionId;
import org.elasticsearch.xpack.core.security.SecurityContext;
import org.elasticsearch.xpack.eql.action.EqlSearchAction;
import org.elasticsearch.xpack.eql.action.EqlSearchRequest;
import org.elasticsearch.xpack.eql.action.EqlSearchResponse;
import org.elasticsearch.xpack.eql.action.EqlSearchTask;
import org.elasticsearch.xpack.eql.execution.PlanExecutor;
import org.elasticsearch.xpack.eql.parser.ParserParams;
import org.elasticsearch.xpack.eql.plugin.EqlPlugin;
import org.elasticsearch.xpack.eql.session.EqlConfiguration;
import org.elasticsearch.xpack.eql.session.Results;
import org.elasticsearch.xpack.eql.util.RemoteClusterRegistry;
import org.elasticsearch.xpack.ql.async.AsyncTaskManagementService;
import org.elasticsearch.xpack.ql.expression.Order;

public final class TransportEqlSearchAction
extends HandledTransportAction<EqlSearchRequest, EqlSearchResponse>
implements AsyncTaskManagementService.AsyncOperation<EqlSearchRequest, EqlSearchResponse, EqlSearchTask> {
    private static final Logger log = LogManager.getLogger(TransportEqlSearchAction.class);
    private final SecurityContext securityContext;
    private final ClusterService clusterService;
    private final PlanExecutor planExecutor;
    private final TransportService transportService;
    private final AsyncTaskManagementService<EqlSearchRequest, EqlSearchResponse, EqlSearchTask> asyncTaskManagementService;

    @Inject
    public TransportEqlSearchAction(Settings settings, ClusterService clusterService, TransportService transportService, ThreadPool threadPool, ActionFilters actionFilters, PlanExecutor planExecutor, NamedWriteableRegistry registry, Client client, BigArrays bigArrays) {
        super("indices:data/read/eql", transportService, actionFilters, EqlSearchRequest::new, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.securityContext = (Boolean)XPackSettings.SECURITY_ENABLED.get(settings) != false ? new SecurityContext(settings, threadPool.getThreadContext()) : null;
        this.clusterService = clusterService;
        this.planExecutor = planExecutor;
        this.transportService = transportService;
        this.asyncTaskManagementService = new AsyncTaskManagementService(".async-search", client, "async_search", registry, this.taskManager, EqlSearchAction.INSTANCE.name(), (AsyncTaskManagementService.AsyncOperation)this, EqlSearchTask.class, clusterService, threadPool, bigArrays);
    }

    public EqlSearchTask createTask(EqlSearchRequest request, long id, String type, String action, TaskId parentTaskId, Map<String, String> headers, Map<String, String> originHeaders, AsyncExecutionId asyncExecutionId) {
        return new EqlSearchTask(id, type, action, request.getDescription(), parentTaskId, headers, originHeaders, asyncExecutionId, request.keepAlive());
    }

    public void execute(EqlSearchRequest request, EqlSearchTask task, ActionListener<EqlSearchResponse> listener) {
        TransportEqlSearchAction.operation(this.planExecutor, task, request, TransportEqlSearchAction.username(this.securityContext), this.transportService, this.clusterService, listener);
    }

    public EqlSearchResponse initialResponse(EqlSearchTask task) {
        return new EqlSearchResponse(EqlSearchResponse.Hits.EMPTY, TimeValue.nsecToMSec((long)(System.nanoTime() - task.getStartTimeNanos())), false, task.getExecutionId().getEncoded(), true, true, ShardSearchFailure.EMPTY_ARRAY);
    }

    public EqlSearchResponse readResponse(StreamInput inputStream) throws IOException {
        return new EqlSearchResponse(inputStream);
    }

    protected void doExecute(Task task, EqlSearchRequest request, ActionListener<EqlSearchResponse> listener) {
        if (TransportEqlSearchAction.requestIsAsync(request)) {
            this.asyncTaskManagementService.asyncExecute((TaskAwareRequest)request, request.waitForCompletionTimeout(), request.keepAlive(), request.keepOnCompletion(), listener);
        } else {
            TransportEqlSearchAction.operation(this.planExecutor, (EqlSearchTask)task, request, TransportEqlSearchAction.username(this.securityContext), this.transportService, this.clusterService, listener);
        }
    }

    public static void operation(PlanExecutor planExecutor, EqlSearchTask task, EqlSearchRequest request, String username, TransportService transportService, ClusterService clusterService, ActionListener<EqlSearchResponse> listener) {
        String nodeId = clusterService.localNode().getId();
        String clusterName = TransportEqlSearchAction.clusterName(clusterService);
        ZoneId zoneId = DateUtils.of((String)"Z");
        QueryBuilder filter = request.filter();
        List<FieldAndFormat> fetchFields = request.fetchFields();
        TimeValue timeout = TimeValue.timeValueSeconds((long)30L);
        String clientId = null;
        RemoteClusterRegistry remoteClusterRegistry = new RemoteClusterRegistry(transportService.getRemoteClusterService(), request.indicesOptions());
        Set<String> clusterAliases = remoteClusterRegistry.clusterAliases(request.indices(), false);
        if (TransportEqlSearchAction.canMinimizeRountrips(request, clusterAliases, transportService.getRemoteClusterService().crossProjectEnabled())) {
            String clusterAlias = clusterAliases.iterator().next();
            String[] remoteIndices = new String[request.indices().length];
            for (int i = 0; i < request.indices().length; ++i) {
                remoteIndices[i] = request.indices()[i].substring(clusterAlias.length() + 1);
            }
            transportService.sendRequest(transportService.getRemoteClusterService().getConnection(clusterAlias), EqlSearchAction.INSTANCE.name(), (TransportRequest)request.indices(remoteIndices), TransportRequestOptions.EMPTY, (TransportResponseHandler)new ActionListenerResponseHandler(ActionListener.wrap(r -> listener.onResponse((Object)TransportEqlSearchAction.qualifyHits(r, clusterAlias)), e -> listener.onFailure(TransportEqlSearchAction.qualifyException(e, remoteIndices, clusterAlias))), EqlSearchResponse::new, TransportResponseHandler.TRANSPORT_WORKER));
        } else {
            ParserParams params = new ParserParams(zoneId).fieldEventCategory(request.eventCategoryField()).fieldTimestamp(request.timestampField()).fieldTiebreaker(request.tiebreakerField()).resultPosition("tail".equals(request.resultPosition()) ? Order.OrderDirection.DESC : Order.OrderDirection.ASC).size(request.size()).fetchSize(request.fetchSize());
            EqlConfiguration cfg = new EqlConfiguration(request.indices(), zoneId, username, clusterName, filter, request.runtimeMappings(), fetchFields, timeout, request.indicesOptions(), request.fetchSize(), request.maxSamplesPerKey(), request.allowPartialSearchResults() == null ? TransportEqlSearchAction.defaultAllowPartialSearchResults(clusterService) : request.allowPartialSearchResults(), request.allowPartialSequenceResults() == null ? TransportEqlSearchAction.defaultAllowPartialSequenceResults(clusterService) : request.allowPartialSequenceResults(), request.getProjectRouting(), clientId, new TaskId(nodeId, task.getId()), task, transportService.getRemoteClusterService().crossProjectEnabled(), request.getResolvedIndexExpressions());
            planExecutor.eql(cfg, request.query(), params, (ActionListener<Results>)ActionListener.wrap(r -> listener.onResponse((Object)TransportEqlSearchAction.createResponse(r, task.getExecutionId())), arg_0 -> listener.onFailure(arg_0)));
        }
    }

    private static boolean defaultAllowPartialSearchResults(ClusterService clusterService) {
        if (clusterService.getClusterSettings() == null) {
            return (Boolean)EqlPlugin.DEFAULT_ALLOW_PARTIAL_SEARCH_RESULTS.getDefault(Settings.EMPTY);
        }
        return (Boolean)clusterService.getClusterSettings().get(EqlPlugin.DEFAULT_ALLOW_PARTIAL_SEARCH_RESULTS);
    }

    private static boolean defaultAllowPartialSequenceResults(ClusterService clusterService) {
        if (clusterService.getClusterSettings() == null) {
            return (Boolean)EqlPlugin.DEFAULT_ALLOW_PARTIAL_SEQUENCE_RESULTS.getDefault(Settings.EMPTY);
        }
        return (Boolean)clusterService.getClusterSettings().get(EqlPlugin.DEFAULT_ALLOW_PARTIAL_SEQUENCE_RESULTS);
    }

    static EqlSearchResponse createResponse(Results results, AsyncExecutionId id) {
        EqlSearchResponse.Hits hits = new EqlSearchResponse.Hits(results.events(), results.sequences(), results.totalHits());
        if (id != null) {
            return new EqlSearchResponse(hits, results.tookTime().getMillis(), results.timedOut(), id.getEncoded(), false, false, results.shardFailures());
        }
        return new EqlSearchResponse(hits, results.tookTime().getMillis(), results.timedOut(), results.shardFailures());
    }

    private static boolean requestIsAsync(EqlSearchRequest request) {
        return request.waitForCompletionTimeout() != null && request.waitForCompletionTimeout().getMillis() >= 0L;
    }

    private static boolean canMinimizeRountrips(EqlSearchRequest request, Set<String> clusterAliases, boolean crossProjectEnabled) {
        if (crossProjectEnabled) {
            return false;
        }
        if (!request.ccsMinimizeRoundtrips()) {
            return false;
        }
        if (clusterAliases.size() != 1 || clusterAliases.contains("")) {
            return false;
        }
        return !TransportEqlSearchAction.requestIsAsync(request);
    }

    private static EqlSearchResponse qualifyHits(EqlSearchResponse r, String clusterAlias) {
        EqlSearchResponse.Hits hits = r.hits();
        if (hits.sequences() != null) {
            for (EqlSearchResponse.Sequence s : hits.sequences()) {
                TransportEqlSearchAction.qualifyEvents(s.events(), clusterAlias);
            }
        } else {
            TransportEqlSearchAction.qualifyEvents(hits.events(), clusterAlias);
        }
        return r;
    }

    private static void qualifyEvents(List<EqlSearchResponse.Event> events, String clusterAlias) {
        if (events != null) {
            for (EqlSearchResponse.Event e : events) {
                e.index(RemoteClusterAware.buildRemoteIndexName((String)clusterAlias, (String)e.index()));
            }
        }
    }

    private static Exception qualifyException(Exception e, String[] indices, String clusterAlias) {
        IndexNotFoundException infe;
        Throwable throwable;
        Exception finalException = e;
        if (e instanceof RemoteTransportException && (throwable = e.getCause()) instanceof IndexNotFoundException && (infe = (IndexNotFoundException)throwable).getIndex() != null) {
            String qualifiedIndex;
            String exceptionIndexName = infe.getIndex().getName();
            String[] notFoundIndices = TransportEqlSearchAction.notFoundIndices(exceptionIndexName, indices);
            if (notFoundIndices != null) {
                StringJoiner sj = new StringJoiner(",");
                for (String notFoundIndex : notFoundIndices) {
                    sj.add(RemoteClusterAware.buildRemoteIndexName((String)clusterAlias, (String)notFoundIndex));
                }
                qualifiedIndex = sj.toString();
            } else {
                qualifiedIndex = RemoteClusterAware.buildRemoteIndexName((String)clusterAlias, (String)exceptionIndexName);
            }
            finalException = new RemoteTransportException(e.getMessage(), (Throwable)new IndexNotFoundException(qualifiedIndex));
        }
        return finalException;
    }

    private static String[] notFoundIndices(String exceptionIndexName, String[] indices) {
        String[] EXCEPTION_PREFIXES;
        for (String prefix : EXCEPTION_PREFIXES = new String[]{"Unknown index [", "["}) {
            if (!exceptionIndexName.startsWith(prefix) || !exceptionIndexName.endsWith("]")) continue;
            String indexList = exceptionIndexName.substring(prefix.length(), exceptionIndexName.length() - 1);
            return indexList.equals("*,-*") ? indices : indexList.split(",[ ]?");
        }
        return null;
    }

    static String username(SecurityContext securityContext) {
        return securityContext != null && securityContext.getUser() != null ? securityContext.getUser().principal() : null;
    }

    static String clusterName(ClusterService clusterService) {
        return clusterService.getClusterName().value();
    }
}

