/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.eql.expression.function.scalar.string;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.eql.EqlIllegalArgumentException;
import org.elasticsearch.xpack.eql.expression.function.scalar.string.StringUtils;
import org.elasticsearch.xpack.ql.expression.gen.processor.Processor;

public class SubstringFunctionProcessor
implements Processor {
    public static final String NAME = "ssub";
    private final Processor input;
    private final Processor start;
    private final Processor end;

    public SubstringFunctionProcessor(Processor source, Processor start, Processor end) {
        this.input = source;
        this.start = start;
        this.end = end;
    }

    public SubstringFunctionProcessor(StreamInput in) throws IOException {
        this.input = (Processor)in.readNamedWriteable(Processor.class);
        this.start = (Processor)in.readNamedWriteable(Processor.class);
        this.end = (Processor)in.readNamedWriteable(Processor.class);
    }

    public final void writeTo(StreamOutput out) throws IOException {
        out.writeNamedWriteable((NamedWriteable)this.input);
        out.writeNamedWriteable((NamedWriteable)this.start);
        out.writeNamedWriteable((NamedWriteable)this.end);
    }

    public Object process(Object o) {
        return SubstringFunctionProcessor.doProcess(this.input.process(o), this.start.process(o), this.end.process(o));
    }

    public static Object doProcess(Object input, Object start, Object end) {
        if (input == null) {
            return null;
        }
        if (!(input instanceof String || input instanceof Character)) {
            throw new EqlIllegalArgumentException("A string/char is required; received [{}]", input);
        }
        if (start == null) {
            return input;
        }
        if (!(start instanceof Number)) {
            throw new EqlIllegalArgumentException("A number is required; received [{}]", start);
        }
        if (end != null && !(end instanceof Number)) {
            throw new EqlIllegalArgumentException("A number is required; received [{}]", end);
        }
        String str = input.toString();
        int startIndex = ((Number)start).intValue();
        int endIndex = end == null ? str.length() : ((Number)end).intValue();
        return StringUtils.substringSlice(str, startIndex, endIndex);
    }

    protected Processor input() {
        return this.input;
    }

    protected Processor start() {
        return this.start;
    }

    protected Processor end() {
        return this.end;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SubstringFunctionProcessor other = (SubstringFunctionProcessor)obj;
        return Objects.equals(this.input(), other.input()) && Objects.equals(this.start(), other.start()) && Objects.equals(this.end(), other.end());
    }

    public int hashCode() {
        return Objects.hash(this.input(), this.start(), this.end());
    }

    public String getWriteableName() {
        return NAME;
    }
}

