/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.eql.execution.search;

import java.time.Instant;
import org.elasticsearch.xpack.eql.execution.search.Timestamp;

public class NanosTimestamp
extends Timestamp {
    private final Instant timestamp;

    NanosTimestamp(long millis, long micros) {
        this.timestamp = Instant.ofEpochMilli(millis).plusNanos(micros);
    }

    @Override
    public Instant instant() {
        return this.timestamp;
    }

    @Override
    public String asString() {
        long nanos = this.timestamp.getNano();
        long millisOfSecond = nanos / 1000000L;
        return this.timestamp.getEpochSecond() * 1000L + millisOfSecond + "." + (nanos - millisOfSecond * 1000000L);
    }
}

