/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.transform.action;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.admin.indices.alias.get.GetAliasesAction;
import org.elasticsearch.action.admin.indices.alias.get.GetAliasesRequest;
import org.elasticsearch.action.admin.indices.alias.get.GetAliasesResponse;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.admin.indices.delete.TransportDeleteIndexAction;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.SubscribableListener;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.AcknowledgedTransportMasterNodeAction;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.project.ProjectResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.admin.indices.AliasesNotFoundException;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.transform.TransformMetadata;
import org.elasticsearch.xpack.core.transform.action.DeleteTransformAction;
import org.elasticsearch.xpack.core.transform.action.StopTransformAction;
import org.elasticsearch.xpack.core.transform.transforms.TransformConfig;
import org.elasticsearch.xpack.transform.TransformServices;
import org.elasticsearch.xpack.transform.notifications.TransformAuditor;
import org.elasticsearch.xpack.transform.persistence.SeqNoPrimaryTermAndIndex;
import org.elasticsearch.xpack.transform.persistence.TransformConfigManager;
import org.elasticsearch.xpack.transform.transforms.TransformTask;

public class TransportDeleteTransformAction
extends AcknowledgedTransportMasterNodeAction<DeleteTransformAction.Request> {
    private static final Logger logger = LogManager.getLogger(TransportDeleteTransformAction.class);
    private final TransformConfigManager transformConfigManager;
    private final TransformAuditor auditor;
    private final Client client;
    private final ProjectResolver projectResolver;

    @Inject
    public TransportDeleteTransformAction(TransportService transportService, ActionFilters actionFilters, ThreadPool threadPool, ClusterService clusterService, TransformServices transformServices, Client client, ProjectResolver projectResolver) {
        super("cluster:admin/transform/delete", transportService, clusterService, threadPool, actionFilters, DeleteTransformAction.Request::new, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.transformConfigManager = transformServices.configManager();
        this.auditor = transformServices.auditor();
        this.client = client;
        this.projectResolver = projectResolver;
    }

    protected void masterOperation(Task task, DeleteTransformAction.Request request, ClusterState state, ActionListener<AcknowledgedResponse> listener) {
        boolean transformIsRunning;
        if (TransformMetadata.upgradeMode((ClusterState)state)) {
            listener.onFailure((Exception)new ElasticsearchStatusException("Cannot delete any Transform while the Transform feature is upgrading.", RestStatus.CONFLICT, new Object[0]));
            return;
        }
        TaskId parentTaskId = new TaskId(this.clusterService.localNode().getId(), task.getId());
        boolean bl = transformIsRunning = TransformTask.getTransformTask(request.getId(), state) != null;
        if (transformIsRunning && !request.isForce()) {
            listener.onFailure((Exception)new ElasticsearchStatusException("Cannot delete transform [" + request.getId() + "] as the task is running. Stop the task first", RestStatus.CONFLICT, new Object[0]));
            return;
        }
        ActionListener deleteDestIndexListener = ActionListener.wrap(unusedAcknowledgedResponse -> this.transformConfigManager.deleteTransform(request.getId(), (ActionListener<Boolean>)ActionListener.wrap(r -> {
            logger.info("[{}] deleted transform", (Object)request.getId());
            this.auditor.info(request.getId(), "Deleted transform.");
            listener.onResponse((Object)AcknowledgedResponse.of((boolean)r));
        }, arg_0 -> ((ActionListener)listener).onFailure(arg_0))), arg_0 -> listener.onFailure(arg_0));
        ActionListener stopTransformActionListener = ActionListener.wrap(unusedStopResponse -> {
            if (request.isDeleteDestIndex()) {
                this.deleteDestinationIndex(parentTaskId, request.getId(), request.ackTimeout(), (ActionListener<AcknowledgedResponse>)deleteDestIndexListener);
            } else {
                deleteDestIndexListener.onResponse(null);
            }
        }, arg_0 -> listener.onFailure(arg_0));
        this.stopTransform(transformIsRunning, parentTaskId, request.getId(), request.ackTimeout(), (ActionListener<StopTransformAction.Response>)stopTransformActionListener);
    }

    private void stopTransform(boolean transformIsRunning, TaskId parentTaskId, String transformId, TimeValue timeout, ActionListener<StopTransformAction.Response> listener) {
        if (!transformIsRunning) {
            listener.onResponse(null);
            return;
        }
        StopTransformAction.Request stopTransformRequest = new StopTransformAction.Request(transformId, true, true, timeout, true, false);
        stopTransformRequest.setParentTask(parentTaskId);
        ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"transform", (ActionType)StopTransformAction.INSTANCE, (ActionRequest)stopTransformRequest, listener);
    }

    private void deleteDestinationIndex(TaskId parentTaskId, String transformId, TimeValue timeout, ActionListener<AcknowledgedResponse> listener) {
        this.getTransformConfig(transformId).andThen((l, r) -> this.deleteDestinationIndex((TransformConfig)r.v1(), parentTaskId, timeout, (ActionListener<AcknowledgedResponse>)l)).addListener(listener.delegateResponse((l, e) -> {
            if (e instanceof IndexNotFoundException) {
                l.onResponse((Object)AcknowledgedResponse.TRUE);
            } else {
                l.onFailure(e);
            }
        }));
    }

    private SubscribableListener<Tuple<TransformConfig, SeqNoPrimaryTermAndIndex>> getTransformConfig(String transformId) {
        return SubscribableListener.newForked(l -> this.transformConfigManager.getTransformConfigurationForUpdate(transformId, (ActionListener<Tuple<TransformConfig, SeqNoPrimaryTermAndIndex>>)l));
    }

    private void deleteDestinationIndex(TransformConfig config, TaskId parentTaskId, TimeValue timeout, ActionListener<AcknowledgedResponse> listener) {
        SubscribableListener.newForked(l -> this.resolveDestinationIndex(config, parentTaskId, timeout, (ActionListener<String>)l)).andThen((l, destIndex) -> {
            DeleteIndexRequest deleteDestIndexRequest = new DeleteIndexRequest(destIndex);
            deleteDestIndexRequest.ackTimeout(timeout);
            deleteDestIndexRequest.setParentTask(parentTaskId);
            ClientHelper.executeWithHeadersAsync((Map)config.getHeaders(), (String)"transform", (Client)this.client, (ActionType)TransportDeleteIndexAction.TYPE, (ActionRequest)deleteDestIndexRequest, (ActionListener)l);
        }).addListener(listener);
    }

    private void resolveDestinationIndex(TransformConfig config, TaskId parentTaskId, TimeValue timeout, ActionListener<String> listener) {
        String destIndex = config.getDestination().getIndex();
        ActionListener responseListener = ActionListener.wrap(r -> TransportDeleteTransformAction.findDestinationIndexInAliases(r, destIndex, listener), e -> {
            if (e instanceof AliasesNotFoundException) {
                listener.onResponse((Object)destIndex);
            } else {
                listener.onFailure(e);
            }
        });
        GetAliasesRequest request = new GetAliasesRequest(timeout, new String[]{destIndex});
        request.setParentTask(parentTaskId);
        ClientHelper.executeWithHeadersAsync((Map)config.getHeaders(), (String)"transform", (Client)this.client, (ActionType)GetAliasesAction.INSTANCE, (ActionRequest)request, (ActionListener)responseListener);
    }

    private static void findDestinationIndexInAliases(GetAliasesResponse aliases, String destIndex, ActionListener<String> listener) {
        Map indexToAliases = aliases.getAliases();
        if (indexToAliases.isEmpty()) {
            listener.onResponse((Object)destIndex);
        } else if (indexToAliases.size() == 1) {
            listener.onResponse((Object)((String)indexToAliases.keySet().iterator().next()));
        } else {
            indexToAliases.entrySet().stream().map(entry -> {
                if (((List)entry.getValue()).stream().anyMatch(md -> destIndex.equals(md.getAlias()) && Boolean.TRUE.equals(md.writeIndex()))) {
                    return (String)entry.getKey();
                }
                return null;
            }).filter(Objects::nonNull).findFirst().ifPresentOrElse(arg_0 -> listener.onResponse(arg_0), () -> listener.onFailure((Exception)new ElasticsearchStatusException("Cannot disambiguate destination index alias [" + destIndex + "]. Alias points to many indices with no clear write alias. Retry with delete_dest_index=false and manually clean up destination index.", RestStatus.CONFLICT, new Object[0])));
        }
    }

    protected ClusterBlockException checkBlock(DeleteTransformAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(this.projectResolver.getProjectId(), ClusterBlockLevel.METADATA_READ);
    }
}

