/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories.blobstore.testkit.integrity;

import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.Executor;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.LegacyActionRequest;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.repositories.blobstore.testkit.integrity.ActiveRepositoryVerifyIntegrityTasks;
import org.elasticsearch.repositories.blobstore.testkit.integrity.RepositoryVerifyIntegrityResponseChunk;
import org.elasticsearch.repositories.blobstore.testkit.integrity.RepositoryVerifyIntegrityResponseStream;
import org.elasticsearch.repositories.blobstore.testkit.integrity.TransportRepositoryVerifyIntegrityCoordinationAction;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;

class TransportRepositoryVerifyIntegrityResponseChunkAction
extends HandledTransportAction<Request, ActionResponse.Empty> {
    static final String ACTION_NAME = TransportRepositoryVerifyIntegrityCoordinationAction.INSTANCE.name() + "[response_chunk]";
    private final ActiveRepositoryVerifyIntegrityTasks activeRepositoryVerifyIntegrityTasks;

    TransportRepositoryVerifyIntegrityResponseChunkAction(TransportService transportService, ActionFilters actionFilters, Executor executor, ActiveRepositoryVerifyIntegrityTasks activeRepositoryVerifyIntegrityTasks) {
        super(ACTION_NAME, transportService, actionFilters, Request::new, executor);
        this.activeRepositoryVerifyIntegrityTasks = activeRepositoryVerifyIntegrityTasks;
    }

    protected void doExecute(Task task, Request request, ActionListener<ActionResponse.Empty> listener) {
        ActionListener.run(listener, l -> {
            RepositoryVerifyIntegrityResponseStream responseStream = this.activeRepositoryVerifyIntegrityTasks.acquireResponseStream(request.coordinatingTaskId);
            try {
                if (request.chunkContents().type() == RepositoryVerifyIntegrityResponseChunk.Type.START_RESPONSE) {
                    responseStream.startResponse(() -> l.onResponse((Object)ActionResponse.Empty.INSTANCE));
                } else {
                    responseStream.writeChunk(request.chunkContents(), () -> l.onResponse((Object)ActionResponse.Empty.INSTANCE));
                }
            }
            finally {
                responseStream.decRef();
            }
        });
    }

    static class Request
    extends LegacyActionRequest {
        private final long coordinatingTaskId;
        private final RepositoryVerifyIntegrityResponseChunk chunkContents;

        Request(long coordinatingTaskId, RepositoryVerifyIntegrityResponseChunk chunkContents) {
            this.coordinatingTaskId = coordinatingTaskId;
            this.chunkContents = Objects.requireNonNull(chunkContents);
        }

        Request(StreamInput in) throws IOException {
            super(in);
            this.coordinatingTaskId = in.readVLong();
            this.chunkContents = new RepositoryVerifyIntegrityResponseChunk(in);
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeVLong(this.coordinatingTaskId);
            this.chunkContents.writeTo(out);
        }

        public ActionRequestValidationException validate() {
            return null;
        }

        public RepositoryVerifyIntegrityResponseChunk chunkContents() {
            return this.chunkContents;
        }
    }
}

