/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.gpu;

import java.util.List;
import org.apache.lucene.codecs.KnnVectorsFormat;
import org.elasticsearch.bootstrap.BootstrapCheck;
import org.elasticsearch.bootstrap.BootstrapContext;
import org.elasticsearch.common.ReferenceDocs;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.FeatureFlag;
import org.elasticsearch.gpu.GPUSupport;
import org.elasticsearch.gpu.codec.ES92GpuHnswSQVectorsFormat;
import org.elasticsearch.gpu.codec.ES92GpuHnswVectorsFormat;
import org.elasticsearch.index.mapper.vectors.DenseVectorFieldMapper;
import org.elasticsearch.index.mapper.vectors.VectorsFormatProvider;
import org.elasticsearch.license.License;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.plugins.internal.InternalVectorFormatProviderPlugin;
import org.elasticsearch.xpack.core.XPackPlugin;

public class GPUPlugin
extends Plugin
implements InternalVectorFormatProviderPlugin {
    public static final FeatureFlag GPU_FORMAT = new FeatureFlag("gpu_vectors_indexing");
    private static final License.OperationMode MINIMUM_ALLOWED_LICENSE = License.OperationMode.ENTERPRISE;
    private final GpuMode gpuMode;
    public static final Setting<GpuMode> VECTORS_INDEXING_USE_GPU_NODE_SETTING = Setting.enumSetting(GpuMode.class, (String)"vectors.indexing.use_gpu", (Enum)GpuMode.AUTO, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});

    public GPUPlugin(Settings settings) {
        this.gpuMode = (GpuMode)((Object)VECTORS_INDEXING_USE_GPU_NODE_SETTING.get(settings));
    }

    public List<Setting<?>> getSettings() {
        if (GPU_FORMAT.isEnabled()) {
            return List.of(VECTORS_INDEXING_USE_GPU_NODE_SETTING);
        }
        return List.of();
    }

    protected boolean isGpuIndexingFeatureAllowed() {
        XPackLicenseState licenseState = XPackPlugin.getSharedLicenseState();
        return licenseState != null && licenseState.isAllowedByLicense(MINIMUM_ALLOWED_LICENSE);
    }

    public List<BootstrapCheck> getBootstrapChecks() {
        if (GPU_FORMAT.isEnabled()) {
            return List.of(new GpuModeBootstrapCheck());
        }
        return List.of();
    }

    public VectorsFormatProvider getVectorsFormatProvider() {
        return (indexSettings, indexOptions, similarity, elementType) -> {
            if (GPU_FORMAT.isEnabled() && this.isGpuIndexingFeatureAllowed() && (this.gpuMode == GpuMode.TRUE || this.gpuMode == GpuMode.AUTO && GPUSupport.isSupported()) && this.vectorIndexAndElementTypeSupported(indexOptions.getType(), elementType)) {
                return GPUPlugin.getVectorsFormat(indexOptions, similarity);
            }
            return null;
        };
    }

    private boolean vectorIndexAndElementTypeSupported(DenseVectorFieldMapper.VectorIndexType type, DenseVectorFieldMapper.ElementType elementType) {
        if (elementType != DenseVectorFieldMapper.ElementType.FLOAT) {
            return false;
        }
        return type == DenseVectorFieldMapper.VectorIndexType.HNSW || type == DenseVectorFieldMapper.VectorIndexType.INT8_HNSW;
    }

    private static KnnVectorsFormat getVectorsFormat(DenseVectorFieldMapper.DenseVectorIndexOptions indexOptions, DenseVectorFieldMapper.VectorSimilarity similarity) {
        if (indexOptions.getType() == DenseVectorFieldMapper.VectorIndexType.HNSW) {
            DenseVectorFieldMapper.HnswIndexOptions hnswIndexOptions = (DenseVectorFieldMapper.HnswIndexOptions)indexOptions;
            int efConstruction = hnswIndexOptions.efConstruction();
            int m = hnswIndexOptions.m();
            int gpuM = 2 + m * 2 / 3;
            int gpuEfConstruction = m + m * efConstruction / 256;
            return new ES92GpuHnswVectorsFormat(gpuM, gpuEfConstruction);
        }
        if (indexOptions.getType() == DenseVectorFieldMapper.VectorIndexType.INT8_HNSW) {
            if (similarity == DenseVectorFieldMapper.VectorSimilarity.MAX_INNER_PRODUCT) {
                throw new IllegalArgumentException("GPU vector indexing does not support [" + String.valueOf(similarity) + "] similarity for [int8_hnsw] index type. Instead, consider using [" + String.valueOf(DenseVectorFieldMapper.VectorSimilarity.COSINE) + "] or  [hnsw] index type.");
            }
            DenseVectorFieldMapper.Int8HnswIndexOptions int8HnswIndexOptions = (DenseVectorFieldMapper.Int8HnswIndexOptions)indexOptions;
            int efConstruction = int8HnswIndexOptions.efConstruction();
            int m = int8HnswIndexOptions.m();
            int gpuM = 2 + m * 2 / 3;
            int gpuEfConstruction = m + m * efConstruction / 256;
            return new ES92GpuHnswSQVectorsFormat(gpuM, gpuEfConstruction, int8HnswIndexOptions.confidenceInterval(), 7, false);
        }
        throw new IllegalArgumentException("GPU vector indexing is not supported on this vector type: [" + String.valueOf(indexOptions.getType()) + "]");
    }

    public static enum GpuMode {
        TRUE,
        FALSE,
        AUTO;

    }

    static class GpuModeBootstrapCheck
    implements BootstrapCheck {
        GpuModeBootstrapCheck() {
        }

        public BootstrapCheck.BootstrapCheckResult check(BootstrapContext context) {
            Settings settings = context.settings();
            GpuMode gpuMode = (GpuMode)((Object)VECTORS_INDEXING_USE_GPU_NODE_SETTING.get(settings));
            if (gpuMode == GpuMode.TRUE && !GPUSupport.isSupported()) {
                return BootstrapCheck.BootstrapCheckResult.failure((String)"vectors.indexing.use_gpu is set to [true], but GPU resources are not accessible on this node. Check logs for details.");
            }
            return BootstrapCheck.BootstrapCheckResult.success();
        }

        public ReferenceDocs referenceDocs() {
            return ReferenceDocs.BOOTSTRAP_CHECKS;
        }
    }
}

