/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.oteldata.otlp;

import io.opentelemetry.proto.collector.metrics.v1.ExportMetricsPartialSuccess;
import io.opentelemetry.proto.collector.metrics.v1.ExportMetricsServiceRequest;
import io.opentelemetry.proto.collector.metrics.v1.ExportMetricsServiceResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.CompositeIndicesRequest;
import org.elasticsearch.action.DocWriteRequest;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkRequestBuilder;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xpack.oteldata.otlp.datapoint.DataPointGroupingContext;
import org.elasticsearch.xpack.oteldata.otlp.docbuilder.MetricDocumentBuilder;
import org.elasticsearch.xpack.oteldata.otlp.proto.BufferedByteStringAccessor;

public class OTLPMetricsTransportAction
extends HandledTransportAction<MetricsRequest, MetricsResponse> {
    public static final String NAME = "indices:data/write/otlp/metrics";
    public static final ActionType<MetricsResponse> TYPE = new ActionType("indices:data/write/otlp/metrics");
    private static final Logger logger = LogManager.getLogger(OTLPMetricsTransportAction.class);
    public static final int IGNORED_DATA_POINTS_MESSAGE_LIMIT = 10;
    private final Client client;

    @Inject
    public OTLPMetricsTransportAction(TransportService transportService, ActionFilters actionFilters, ThreadPool threadPool, Client client) {
        super(NAME, transportService, actionFilters, MetricsRequest::new, (Executor)threadPool.executor("write"));
        this.client = client;
    }

    protected void doExecute(Task task, MetricsRequest request, final ActionListener<MetricsResponse> listener) {
        BufferedByteStringAccessor byteStringAccessor = new BufferedByteStringAccessor();
        final DataPointGroupingContext context = new DataPointGroupingContext(byteStringAccessor);
        try {
            ExportMetricsServiceRequest metricsServiceRequest = ExportMetricsServiceRequest.parseFrom((InputStream)request.exportMetricsServiceRequest.streamInput());
            context.groupDataPoints(metricsServiceRequest);
            if (context.totalDataPoints() == 0) {
                OTLPMetricsTransportAction.handleEmptyRequest(listener);
                return;
            }
            BulkRequestBuilder bulkRequestBuilder = this.client.prepareBulk();
            MetricDocumentBuilder metricDocumentBuilder = new MetricDocumentBuilder(byteStringAccessor);
            context.consume(dataPointGroup -> this.addIndexRequest(bulkRequestBuilder, metricDocumentBuilder, (DataPointGroupingContext.DataPointGroup)dataPointGroup));
            if (bulkRequestBuilder.numberOfActions() == 0) {
                OTLPMetricsTransportAction.handlePartialSuccess(listener, context);
                return;
            }
            bulkRequestBuilder.execute((ActionListener)new ActionListener<BulkResponse>(this){

                public void onResponse(BulkResponse bulkItemResponses) {
                    if (bulkItemResponses.hasFailures() || context.getIgnoredDataPoints() > 0) {
                        OTLPMetricsTransportAction.handlePartialSuccess(bulkItemResponses, context, (ActionListener<MetricsResponse>)listener);
                    } else {
                        OTLPMetricsTransportAction.handleSuccess((ActionListener<MetricsResponse>)listener);
                    }
                }

                public void onFailure(Exception e) {
                    OTLPMetricsTransportAction.handleFailure((ActionListener<MetricsResponse>)listener, e, context);
                }
            });
        }
        catch (Exception e) {
            logger.error("failed to execute otlp metrics request", (Throwable)e);
            OTLPMetricsTransportAction.handleFailure(listener, e, context);
        }
    }

    private void addIndexRequest(BulkRequestBuilder bulkRequestBuilder, MetricDocumentBuilder metricDocumentBuilder, DataPointGroupingContext.DataPointGroup dataPointGroup) throws IOException {
        try (XContentBuilder xContentBuilder = XContentFactory.cborBuilder((OutputStream)new BytesStreamOutput());){
            Map dynamicTemplates = Maps.newHashMapWithExpectedSize((int)dataPointGroup.dataPoints().size());
            Map dynamicTemplateParams = Maps.newHashMapWithExpectedSize((int)dataPointGroup.dataPoints().size());
            BytesRef tsid = metricDocumentBuilder.buildMetricDocument(xContentBuilder, dataPointGroup, dynamicTemplates, dynamicTemplateParams);
            bulkRequestBuilder.add(new IndexRequest(dataPointGroup.targetIndex().index()).opType(DocWriteRequest.OpType.CREATE).setRequireDataStream(true).source(xContentBuilder).tsid(tsid).setIncludeSourceOnError(false).setDynamicTemplates(dynamicTemplates).setDynamicTemplateParams(dynamicTemplateParams));
        }
    }

    private static void handleSuccess(ActionListener<MetricsResponse> listener) {
        listener.onResponse((Object)new MetricsResponse(RestStatus.OK, ExportMetricsServiceResponse.newBuilder().build()));
    }

    private static void handleEmptyRequest(ActionListener<MetricsResponse> listener) {
        OTLPMetricsTransportAction.handleSuccess(listener);
    }

    private static void handlePartialSuccess(ActionListener<MetricsResponse> listener, DataPointGroupingContext context) {
        ExportMetricsServiceResponse response = OTLPMetricsTransportAction.responseWithRejectedDataPoints(context.getIgnoredDataPoints(), context.getIgnoredDataPointsMessage(10));
        listener.onResponse((Object)new MetricsResponse(RestStatus.BAD_REQUEST, response));
    }

    private static void handlePartialSuccess(BulkResponse bulkItemResponses, DataPointGroupingContext context, ActionListener<MetricsResponse> listener) {
        HashMap<String, Map> failureGroups = new HashMap<String, Map>();
        RestStatus status = RestStatus.OK;
        int failures = 0;
        for (BulkItemResponse bulkItemResponse : bulkItemResponses.getItems()) {
            BulkItemResponse.Failure failure = bulkItemResponse.getFailure();
            if (failure == null) continue;
            ++failures;
            if (failure.getStatus() == RestStatus.TOO_MANY_REQUESTS) {
                status = RestStatus.TOO_MANY_REQUESTS;
            }
            FailureGroup failureGroup = failureGroups.computeIfAbsent(failure.getIndex(), k -> new HashMap()).computeIfAbsent(failure.getStatus(), k -> new FailureGroup(new AtomicInteger(0), failure.getMessage()));
            failureGroup.failureCount().incrementAndGet();
        }
        if (bulkItemResponses.getItems().length == failures) {
            failures = context.totalDataPoints();
        }
        StringBuilder failureMessageBuilder = new StringBuilder();
        for (Map.Entry indexEntry : failureGroups.entrySet()) {
            String indexName = (String)indexEntry.getKey();
            for (Map.Entry statusEntry : ((Map)indexEntry.getValue()).entrySet()) {
                RestStatus restStatus = (RestStatus)statusEntry.getKey();
                FailureGroup failureGroup = (FailureGroup)statusEntry.getValue();
                failureMessageBuilder.append("Index [").append(indexName).append("] returned status [").append(restStatus).append("] for ").append(failureGroup.failureCount()).append(" documents. Sample error message: ");
                failureMessageBuilder.append(failureGroup.failureMessageSample());
                failureMessageBuilder.append("\n");
            }
        }
        failureMessageBuilder.append(context.getIgnoredDataPointsMessage(10));
        ExportMetricsServiceResponse response = OTLPMetricsTransportAction.responseWithRejectedDataPoints(failures + context.getIgnoredDataPoints(), failureMessageBuilder.toString());
        listener.onResponse((Object)new MetricsResponse(status, response));
    }

    private static void handleFailure(ActionListener<MetricsResponse> listener, Exception e, DataPointGroupingContext context) {
        listener.onResponse((Object)new MetricsResponse(ExceptionsHelper.status((Throwable)e), OTLPMetricsTransportAction.responseWithRejectedDataPoints(context.totalDataPoints(), e.getMessage())));
    }

    private static ExportMetricsServiceResponse responseWithRejectedDataPoints(int rejectedDataPoints, String message) {
        ExportMetricsPartialSuccess partialSuccess = ExportMetricsPartialSuccess.newBuilder().setRejectedDataPoints(rejectedDataPoints).setErrorMessage(message).build();
        return ExportMetricsServiceResponse.newBuilder().setPartialSuccess(partialSuccess).build();
    }

    public static class MetricsRequest
    extends ActionRequest
    implements CompositeIndicesRequest {
        private final BytesReference exportMetricsServiceRequest;

        public MetricsRequest(StreamInput in) throws IOException {
            super(in);
            this.exportMetricsServiceRequest = in.readBytesReference();
        }

        public MetricsRequest(BytesReference exportMetricsServiceRequest) {
            this.exportMetricsServiceRequest = exportMetricsServiceRequest;
        }

        public ActionRequestValidationException validate() {
            return null;
        }
    }

    public static class MetricsResponse
    extends ActionResponse {
        private final BytesReference response;
        private final RestStatus status;

        public MetricsResponse(RestStatus status, ExportMetricsServiceResponse response) {
            this(status, (BytesReference)new BytesArray(response.toByteArray()));
        }

        public MetricsResponse(RestStatus status, BytesReference response) {
            this.response = response;
            this.status = status;
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeBytesReference(this.response);
            out.writeEnum((Enum)this.status);
        }

        public BytesReference getResponse() {
            return this.response;
        }

        public RestStatus getStatus() {
            return this.status;
        }
    }

    record FailureGroup(AtomicInteger failureCount, String failureMessageSample) {
    }
}

