/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.plan.physical;

import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.NodeUtils;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.util.Queries;
import org.elasticsearch.xpack.esql.plan.physical.EsQueryExec;
import org.elasticsearch.xpack.esql.plan.physical.EstimatesRowSize;
import org.elasticsearch.xpack.esql.plan.physical.LeafExec;
import org.elasticsearch.xpack.esql.plan.physical.PhysicalPlan;

public class EsStatsQueryExec
extends LeafExec
implements EstimatesRowSize {
    private final String indexPattern;
    private final QueryBuilder query;
    private final Expression limit;
    private final List<Attribute> attrs;
    private final Stat stat;

    public EsStatsQueryExec(Source source, String indexPattern, @Nullable QueryBuilder query, Expression limit, List<Attribute> attributes, Stat stat) {
        super(source);
        this.indexPattern = indexPattern;
        this.query = query;
        this.limit = limit;
        this.attrs = attributes;
        this.stat = stat;
    }

    public void writeTo(StreamOutput out) throws IOException {
        throw new UnsupportedOperationException("not serialized");
    }

    public String getWriteableName() {
        throw new UnsupportedOperationException("not serialized");
    }

    protected NodeInfo<EsStatsQueryExec> info() {
        return NodeInfo.create((Node)this, EsStatsQueryExec::new, (Object)this.indexPattern, (Object)this.query, (Object)this.limit, this.attrs, (Object)this.stat);
    }

    @Nullable
    public QueryBuilder query() {
        return this.query;
    }

    public Stat stat() {
        return this.stat;
    }

    @Override
    public List<Attribute> output() {
        return this.attrs;
    }

    public Expression limit() {
        return this.limit;
    }

    @Override
    public PhysicalPlan estimateRowSize(EstimatesRowSize.State state) {
        state.add(false, this.attrs);
        int size = state.consumeAllFields(false);
        return this;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.indexPattern, this.query, this.limit, this.attrs, this.stat);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        EsStatsQueryExec other = (EsStatsQueryExec)obj;
        return Objects.equals(this.indexPattern, other.indexPattern) && Objects.equals(this.attrs, other.attrs) && Objects.equals(this.query, other.query) && Objects.equals(this.limit, other.limit) && Objects.equals(this.stat, other.stat);
    }

    public String nodeString() {
        return this.nodeName() + "[" + this.indexPattern + "], stats" + String.valueOf(this.stat) + "], query[" + (this.query != null ? Strings.toString((ToXContent)this.query, (boolean)false, (boolean)true) : "") + "]" + NodeUtils.limitedToString(this.attrs) + ", limit[" + (this.limit != null ? this.limit.toString() : "") + "], ";
    }

    public static sealed interface Stat
    permits BasicStat, ByStat {
        public List<ElementType> tagTypes();
    }

    public record ByStat(List<EsQueryExec.QueryBuilderAndTags> queryBuilderAndTags) implements Stat
    {
        public ByStat {
            if (queryBuilderAndTags.isEmpty()) {
                throw new IllegalStateException("ByStat must have at least one queryBuilderAndTags");
            }
        }

        @Override
        public List<ElementType> tagTypes() {
            Object object = this.queryBuilderAndTags.getFirst().tags().getFirst();
            Objects.requireNonNull(object);
            Object object2 = object;
            int n = 0;
            return List.of(switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Integer.class, Long.class}, (Object)object2, n)) {
                case 0 -> {
                    Integer i = (Integer)object2;
                    yield ElementType.INT;
                }
                case 1 -> {
                    Long l = (Long)object2;
                    yield ElementType.LONG;
                }
                default -> throw new IllegalStateException("Unsupported tag type in ByStat: " + String.valueOf(this.queryBuilderAndTags.getFirst().tags().getFirst()));
            });
        }

        @Override
        public String toString() {
            StringBuffer sb = new StringBuffer("ByStat{");
            sb.append("queryBuilderAndTags=").append(this.queryBuilderAndTags);
            sb.append('}');
            return sb.toString();
        }
    }

    public record BasicStat(String name, StatsType type, QueryBuilder query) implements Stat
    {
        public QueryBuilder filter(QueryBuilder sourceQuery) {
            return this.query == null ? sourceQuery : Queries.combine((Queries.Clause)Queries.Clause.FILTER, Arrays.asList(sourceQuery, this.query)).boost(0.0f);
        }

        @Override
        public List<ElementType> tagTypes() {
            return List.of();
        }
    }

    public static enum StatsType {
        COUNT;

    }
}

