/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.plan.logical.promql.operator;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.ReferenceAttribute;
import org.elasticsearch.xpack.esql.core.expression.function.Function;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.plan.logical.BinaryPlan;
import org.elasticsearch.xpack.esql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.esql.plan.logical.promql.operator.VectorMatch;

public abstract class VectorBinaryOperator
extends BinaryPlan {
    private final VectorMatch match;
    private final boolean dropMetricName;
    private final BinaryOp binaryOp;
    private List<Attribute> output;

    protected VectorBinaryOperator(Source source, LogicalPlan left, LogicalPlan right, VectorMatch match, boolean dropMetricName, BinaryOp binaryOp) {
        super(source, left, right);
        this.match = match;
        this.dropMetricName = dropMetricName;
        this.binaryOp = binaryOp;
    }

    public VectorMatch match() {
        return this.match;
    }

    public boolean dropMetricName() {
        return this.dropMetricName;
    }

    public BinaryOp binaryOp() {
        return this.binaryOp;
    }

    @Override
    public List<Attribute> output() {
        if (this.output == null) {
            this.output = this.computeOutputAttributes();
        }
        return this.output;
    }

    private List<Attribute> computeOutputAttributes() {
        HashSet<String> outputLabels;
        List<Attribute> leftAttrs = this.left().output();
        List<Attribute> rightAttrs = this.right().output();
        Set<String> leftLabels = this.extractLabelNames(leftAttrs);
        Set<String> rightLabels = this.extractLabelNames(rightAttrs);
        if (this.match != null) {
            if (this.match.filter() == VectorMatch.Filter.ON) {
                outputLabels = new HashSet<String>(this.match.filterLabels());
            } else if (this.match.filter() == VectorMatch.Filter.IGNORING) {
                outputLabels = new HashSet<String>(leftLabels);
                outputLabels.addAll(rightLabels);
                outputLabels.removeAll(this.match.filterLabels());
            } else {
                outputLabels = new HashSet<String>(leftLabels);
                outputLabels.retainAll(rightLabels);
            }
        } else {
            outputLabels = new HashSet<String>(leftLabels);
            outputLabels.retainAll(rightLabels);
        }
        if (this.dropMetricName) {
            outputLabels.remove("__name__");
        }
        ArrayList<Attribute> result = new ArrayList<Attribute>();
        for (String label : outputLabels) {
            Attribute attr = this.findAttribute(label, leftAttrs, rightAttrs);
            if (attr == null) continue;
            result.add(attr);
        }
        result.add((Attribute)new ReferenceAttribute(this.source(), "value", DataType.DOUBLE));
        return result;
    }

    private Set<String> extractLabelNames(List<Attribute> attrs) {
        HashSet<String> labels = new HashSet<String>();
        for (Attribute attr : attrs) {
            String name = attr.name();
            if (name.equals("value")) continue;
            labels.add(name);
        }
        return labels;
    }

    private Attribute findAttribute(String name, List<Attribute> left, List<Attribute> right) {
        for (Attribute attr : left) {
            if (!attr.name().equals(name)) continue;
            return attr;
        }
        for (Attribute attr : right) {
            if (!attr.name().equals(name)) continue;
            return attr;
        }
        return null;
    }

    @Override
    public abstract VectorBinaryOperator replaceChildren(LogicalPlan var1, LogicalPlan var2);

    @Override
    public boolean expressionsResolved() {
        return true;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (super.equals(o)) {
            VectorBinaryOperator that = (VectorBinaryOperator)((Object)o);
            return this.dropMetricName == that.dropMetricName && Objects.equals(this.match, that.match) && Objects.equals(this.binaryOp, that.binaryOp);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.match, this.dropMetricName, this.binaryOp);
    }

    public String getWriteableName() {
        throw new UnsupportedOperationException("PromQL plans should not be serialized");
    }

    public void writeTo(StreamOutput out) throws IOException {
        throw new UnsupportedOperationException("PromQL plans should not be serialized");
    }

    public static interface BinaryOp {
        public String name();

        public ScalarFunctionFactory asFunction();
    }

    public static interface ScalarFunctionFactory {
        public Function create(Source var1, Expression var2, Expression var3);
    }
}

