/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.plan.logical.local;

import java.io.IOException;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.xpack.esql.plan.logical.local.ImmediateLocalSupplier;
import org.elasticsearch.xpack.esql.plan.logical.local.LocalSupplier;
import org.elasticsearch.xpack.esql.planner.PlannerUtils;

public class CopyingLocalSupplier
implements LocalSupplier {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(LocalSupplier.class, "CopyingSupplier", CopyingLocalSupplier::new);
    private final ImmediateLocalSupplier delegate;

    public CopyingLocalSupplier(Page page) {
        this.delegate = new ImmediateLocalSupplier(page);
    }

    public CopyingLocalSupplier(StreamInput in) throws IOException {
        this.delegate = new ImmediateLocalSupplier(in);
    }

    @Override
    public Page get() {
        Block[] blockCopies = new Block[this.delegate.page.getBlockCount()];
        for (int i = 0; i < blockCopies.length; ++i) {
            blockCopies[i] = this.delegate.page.getBlock(i).deepCopy(PlannerUtils.NON_BREAKING_BLOCK_FACTORY);
        }
        return new Page(this.delegate.page.getPositionCount(), blockCopies);
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.delegate.writeTo(out);
    }

    public String getWriteableName() {
        return CopyingLocalSupplier.ENTRY.name;
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        CopyingLocalSupplier other = (CopyingLocalSupplier)obj;
        return this.delegate.page.equals((Object)other.delegate.page);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }
}

