/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.string;

import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.BytesRefVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.compute.operator.Warnings;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.inference.ChunkingSettings;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.function.scalar.string.Chunk;

public final class ChunkBytesRefEvaluator
implements EvalOperator.ExpressionEvaluator {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(ChunkBytesRefEvaluator.class);
    private final Source source;
    private final EvalOperator.ExpressionEvaluator str;
    private final ChunkingSettings chunkingSettings;
    private final DriverContext driverContext;
    private Warnings warnings;

    public ChunkBytesRefEvaluator(Source source, EvalOperator.ExpressionEvaluator str, ChunkingSettings chunkingSettings, DriverContext driverContext) {
        this.source = source;
        this.str = str;
        this.chunkingSettings = chunkingSettings;
        this.driverContext = driverContext;
    }

    public Block eval(Page page) {
        try (BytesRefBlock strBlock = (BytesRefBlock)this.str.eval(page);){
            BytesRefVector strVector = strBlock.asVector();
            if (strVector == null) {
                BytesRefBlock bytesRefBlock = this.eval(page.getPositionCount(), strBlock);
                return bytesRefBlock;
            }
            BytesRefBlock bytesRefBlock = this.eval(page.getPositionCount(), strVector);
            return bytesRefBlock;
        }
    }

    public long baseRamBytesUsed() {
        long baseRamBytesUsed = BASE_RAM_BYTES_USED;
        return baseRamBytesUsed += this.str.baseRamBytesUsed();
    }

    public BytesRefBlock eval(int positionCount, BytesRefBlock strBlock) {
        try (BytesRefBlock.Builder result = this.driverContext.blockFactory().newBytesRefBlockBuilder(positionCount);){
            BytesRef strScratch = new BytesRef();
            block9: for (int p = 0; p < positionCount; ++p) {
                switch (strBlock.getValueCount(p)) {
                    case 0: {
                        result.appendNull();
                        continue block9;
                    }
                    case 1: {
                        break;
                    }
                    default: {
                        this.warnings().registerException((Exception)new IllegalArgumentException("single-value function encountered multi-value"));
                        result.appendNull();
                        continue block9;
                    }
                }
                BytesRef str = strBlock.getBytesRef(strBlock.getFirstValueIndex(p), strScratch);
                Chunk.process(result, str, this.chunkingSettings);
            }
            BytesRefBlock bytesRefBlock = result.build();
            return bytesRefBlock;
        }
    }

    public BytesRefBlock eval(int positionCount, BytesRefVector strVector) {
        try (BytesRefBlock.Builder result = this.driverContext.blockFactory().newBytesRefBlockBuilder(positionCount);){
            BytesRef strScratch = new BytesRef();
            for (int p = 0; p < positionCount; ++p) {
                BytesRef str = strVector.getBytesRef(p, strScratch);
                Chunk.process(result, str, this.chunkingSettings);
            }
            BytesRefBlock bytesRefBlock = result.build();
            return bytesRefBlock;
        }
    }

    public String toString() {
        return "ChunkBytesRefEvaluator[str=" + String.valueOf(this.str) + ", chunkingSettings=" + String.valueOf(this.chunkingSettings) + "]";
    }

    public void close() {
        Releasables.closeExpectNoException((Releasable)this.str);
    }

    private Warnings warnings() {
        if (this.warnings == null) {
            this.warnings = Warnings.createWarnings((DriverContext.WarningsMode)this.driverContext.warningsMode(), (int)this.source.source().getLineNumber(), (int)this.source.source().getColumnNumber(), (String)this.source.text());
        }
        return this.warnings;
    }

    static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final Source source;
        private final EvalOperator.ExpressionEvaluator.Factory str;
        private final ChunkingSettings chunkingSettings;

        public Factory(Source source, EvalOperator.ExpressionEvaluator.Factory str, ChunkingSettings chunkingSettings) {
            this.source = source;
            this.str = str;
            this.chunkingSettings = chunkingSettings;
        }

        public ChunkBytesRefEvaluator get(DriverContext context) {
            return new ChunkBytesRefEvaluator(this.source, this.str.get(context), this.chunkingSettings, context);
        }

        public String toString() {
            return "ChunkBytesRefEvaluator[str=" + String.valueOf(this.str) + ", chunkingSettings=" + String.valueOf(this.chunkingSettings) + "]";
        }
    }
}

