/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.spatial;

import java.io.IOException;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.geo.GeoBoundingBox;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.geometry.Geometry;
import org.elasticsearch.geometry.LinearRing;
import org.elasticsearch.geometry.Point;
import org.elasticsearch.geometry.Polygon;
import org.elasticsearch.geometry.Rectangle;
import org.elasticsearch.search.aggregations.bucket.geogrid.GeoTileBoundedPredicate;
import org.elasticsearch.search.aggregations.bucket.geogrid.GeoTileUtils;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.FoldContext;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.core.util.SpatialCoordinateTypes;
import org.elasticsearch.xpack.esql.evaluator.mapper.EvaluatorMapper;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionAppliesTo;
import org.elasticsearch.xpack.esql.expression.function.FunctionAppliesToLifecycle;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.SpatialGridFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.StGeotileFromFieldAndLiteralAndLiteralEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.StGeotileFromFieldAndLiteralEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.StGeotileFromFieldDocValuesAndLiteralAndLiteralEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.StGeotileFromFieldDocValuesAndLiteralEvaluator;

public class StGeotile
extends SpatialGridFunction
implements EvaluatorMapper {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "StGeotile", StGeotile::new);
    public static final SpatialGridFunction.UnboundedGrid unboundedGrid = (point, precision) -> GeoTileUtils.longEncode((double)point.getX(), (double)point.getY(), (int)GeoTileUtils.checkPrecisionRange((int)precision));

    @FunctionInfo(returnType={"geotile"}, preview=true, appliesTo={@FunctionAppliesTo(lifeCycle=FunctionAppliesToLifecycle.PREVIEW)}, description="Calculates the `geotile` of the supplied geo_point at the specified precision.\nThe result is long encoded. Use [TO_STRING](#esql-to_string) to convert the result to a string,\n[TO_LONG](#esql-to_long) to convert it to a `long`, or [TO_GEOSHAPE](#esql-to_geoshape) to calculate\nthe `geo_shape` bounding geometry.\n\nThese functions are related to the [`geo_grid` query](/reference/query-languages/query-dsl/query-dsl-geo-grid-query.md)\nand the [`geotile_grid` aggregation](/reference/aggregations/search-aggregations-bucket-geotilegrid-aggregation.md).", examples={@Example(file="spatial-grid", tag="st_geotile-grid")})
    public StGeotile(Source source, @Param(name="geometry", type={"geo_point"}, description="Expression of type `geo_point`. If `null`, the function returns `null`.") Expression field, @Param(name="precision", type={"integer"}, description="Expression of type `integer`. If `null`, the function returns `null`.\nValid values are between [0 and 29](https://wiki.openstreetmap.org/wiki/Zoom_levels).") Expression precision, @Param(name="bounds", type={"geo_shape"}, description="Optional bounds to filter the grid tiles, a `geo_shape` of type `BBOX`.\nUse [`ST_ENVELOPE`](#esql-st_envelope) if the `geo_shape` is of any other type.", optional=true) Expression bounds) {
        this(source, field, precision, bounds, false);
    }

    private StGeotile(Source source, Expression field, Expression precision, Expression bounds, boolean spatialDocValues) {
        super(source, field, precision, bounds, spatialDocValues);
    }

    private StGeotile(StreamInput in) throws IOException {
        super(in, false);
    }

    @Override
    public SpatialGridFunction withDocValues(boolean useDocValues) {
        boolean docValues = this.spatialDocsValues || useDocValues;
        return new StGeotile(this.source(), this.spatialField, this.parameter, this.bounds, docValues);
    }

    public String getWriteableName() {
        return StGeotile.ENTRY.name;
    }

    public DataType dataType() {
        return DataType.GEOTILE;
    }

    @Override
    protected SpatialGridFunction replaceChildren(Expression newSpatialField, Expression newParameter, Expression newBounds) {
        return new StGeotile(this.source(), newSpatialField, newParameter, newBounds);
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, StGeotile::new, (Object)this.spatialField, (Object)this.parameter, (Object)this.bounds);
    }

    @Override
    public EvalOperator.ExpressionEvaluator.Factory toEvaluator(EvaluatorMapper.ToEvaluator toEvaluator) {
        if (!this.parameter().foldable()) {
            throw new IllegalArgumentException("precision must be foldable");
        }
        if (this.bounds != null) {
            if (!this.bounds.foldable()) {
                throw new IllegalArgumentException("bounds must be foldable");
            }
            GeoBoundingBox bbox = StGeotile.asGeoBoundingBox(this.bounds.fold(toEvaluator.foldCtx()));
            int precision = (Integer)this.parameter.fold(toEvaluator.foldCtx());
            GeoTileBoundedGrid.Factory bounds = new GeoTileBoundedGrid.Factory(precision, bbox);
            return this.spatialDocsValues ? new StGeotileFromFieldDocValuesAndLiteralAndLiteralEvaluator.Factory(this.source(), toEvaluator.apply(this.spatialField()), bounds::get) : new StGeotileFromFieldAndLiteralAndLiteralEvaluator.Factory(this.source(), toEvaluator.apply(this.spatialField), bounds::get);
        }
        int precision = GeoTileUtils.checkPrecisionRange((int)((Integer)this.parameter.fold(toEvaluator.foldCtx())));
        return this.spatialDocsValues ? new StGeotileFromFieldDocValuesAndLiteralEvaluator.Factory(this.source(), toEvaluator.apply(this.spatialField()), precision) : new StGeotileFromFieldAndLiteralEvaluator.Factory(this.source(), toEvaluator.apply(this.spatialField), precision);
    }

    public Object fold(FoldContext ctx) {
        BytesRef point = (BytesRef)this.spatialField().fold(ctx);
        int precision = GeoTileUtils.checkPrecisionRange((int)((Integer)this.parameter().fold(ctx)));
        if (this.bounds() == null) {
            return unboundedGrid.calculateGridId(SpatialCoordinateTypes.GEO.wkbAsPoint(point), precision);
        }
        GeoBoundingBox bbox = StGeotile.asGeoBoundingBox(this.bounds().fold(ctx));
        GeoTileBoundedGrid bounds = new GeoTileBoundedGrid(precision, bbox);
        long gridId = bounds.calculateGridId(SpatialCoordinateTypes.GEO.wkbAsPoint(point));
        return gridId < 0L ? null : Long.valueOf(gridId);
    }

    static void fromFieldAndLiteral(LongBlock.Builder results, int p, BytesRefBlock wkbBlock, int precision) {
        StGeotile.fromWKB(results, p, wkbBlock, precision, unboundedGrid);
    }

    static void fromFieldDocValuesAndLiteral(LongBlock.Builder results, int p, LongBlock encoded, int precision) {
        StGeotile.fromEncodedLong(results, p, encoded, precision, unboundedGrid);
    }

    static void fromFieldAndLiteralAndLiteral(LongBlock.Builder results, int p, BytesRefBlock in, GeoTileBoundedGrid bounds) {
        StGeotile.fromWKB(results, p, in, bounds);
    }

    static void fromFieldDocValuesAndLiteralAndLiteral(LongBlock.Builder results, int p, LongBlock encoded, GeoTileBoundedGrid bounds) {
        StGeotile.fromEncodedLong(results, p, encoded, bounds);
    }

    public static BytesRef toBounds(long gridId) {
        return StGeotile.fromRectangle(GeoTileUtils.toBoundingBox((long)gridId));
    }

    static BytesRef fromRectangle(Rectangle bbox) {
        double[] x = new double[]{bbox.getMinX(), bbox.getMaxX(), bbox.getMaxX(), bbox.getMinX(), bbox.getMinX()};
        double[] y = new double[]{bbox.getMinY(), bbox.getMinY(), bbox.getMaxY(), bbox.getMaxY(), bbox.getMinY()};
        LinearRing ring = new LinearRing(x, y);
        Polygon polygon = new Polygon(ring);
        return SpatialCoordinateTypes.GEO.asWkb((Geometry)polygon);
    }

    protected static class GeoTileBoundedGrid
    implements SpatialGridFunction.BoundedGrid {
        private final int precision;
        private final GeoTileBoundedPredicate bounds;

        private GeoTileBoundedGrid(int precision, GeoBoundingBox bbox) {
            this.precision = GeoTileUtils.checkPrecisionRange((int)precision);
            this.bounds = new GeoTileBoundedPredicate(precision, bbox);
        }

        @Override
        public long calculateGridId(Point point) {
            int y;
            int tiles = 1 << this.precision;
            int x = GeoTileUtils.getXTile((double)point.getX(), (int)tiles);
            if (this.bounds.validTile(x, y = GeoTileUtils.getYTile((double)point.getY(), (int)tiles), this.precision)) {
                return GeoTileUtils.longEncodeTiles((int)this.precision, (int)x, (int)y);
            }
            return -1L;
        }

        @Override
        public int precision() {
            return this.precision;
        }

        protected static class Factory {
            private final int precision;
            private final GeoBoundingBox bbox;

            Factory(int precision, GeoBoundingBox bbox) {
                this.precision = GeoTileUtils.checkPrecisionRange((int)precision);
                this.bbox = bbox;
            }

            public GeoTileBoundedGrid get(DriverContext context) {
                return new GeoTileBoundedGrid(this.precision, this.bbox);
            }
        }
    }
}

