/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.multivalue;

import java.io.IOException;
import java.util.List;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.TypeResolutions;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.AbstractMultivalueFunction;

public class MvCount
extends AbstractMultivalueFunction {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "MvCount", MvCount::new);

    @FunctionInfo(returnType={"integer"}, description="Converts a multivalued expression into a single valued column containing a count of the number of values.", examples={@Example(file="string", tag="mv_count")})
    public MvCount(Source source, @Param(name="field", type={"boolean", "cartesian_point", "cartesian_shape", "date", "date_nanos", "double", "geo_point", "geo_shape", "geohash", "geotile", "geohex", "integer", "ip", "keyword", "long", "text", "unsigned_long", "version"}, description="Multivalue expression.") Expression v) {
        super(source, v);
    }

    private MvCount(StreamInput in) throws IOException {
        super(in);
    }

    public String getWriteableName() {
        return MvCount.ENTRY.name;
    }

    @Override
    protected Expression.TypeResolution resolveFieldType() {
        return TypeResolutions.isRepresentableExceptCountersDenseVectorAggregateMetricDoubleAndExponentialHistogram((Expression)this.field(), (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.DEFAULT);
    }

    @Override
    public DataType dataType() {
        return DataType.INTEGER;
    }

    @Override
    protected EvalOperator.ExpressionEvaluator.Factory evaluator(EvalOperator.ExpressionEvaluator.Factory fieldEval) {
        return new EvaluatorFactory(fieldEval);
    }

    public Expression replaceChildren(List<Expression> newChildren) {
        return new MvCount(this.source(), newChildren.get(0));
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, MvCount::new, (Object)this.field());
    }

    private record EvaluatorFactory(EvalOperator.ExpressionEvaluator.Factory field) implements EvalOperator.ExpressionEvaluator.Factory
    {
        public EvalOperator.ExpressionEvaluator get(DriverContext context) {
            return new Evaluator(context, this.field.get(context));
        }

        @Override
        public String toString() {
            return "MvCount[field=" + String.valueOf(this.field) + "]";
        }
    }

    private static class Evaluator
    extends AbstractMultivalueFunction.AbstractEvaluator {
        private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(Evaluator.class);

        protected Evaluator(DriverContext driverContext, EvalOperator.ExpressionEvaluator field) {
            super(driverContext, field);
        }

        @Override
        protected String name() {
            return "MvCount";
        }

        @Override
        protected Block evalNullable(Block block) {
            try (IntBlock.Builder builder = this.driverContext.blockFactory().newIntBlockBuilder(block.getPositionCount());){
                for (int p = 0; p < block.getPositionCount(); ++p) {
                    int valueCount = block.getValueCount(p);
                    if (valueCount == 0) {
                        builder.appendNull();
                        continue;
                    }
                    builder.appendInt(valueCount);
                }
                IntBlock intBlock = builder.build();
                return intBlock;
            }
        }

        @Override
        protected Block evalNotNullable(Block block) {
            try (IntVector.FixedBuilder builder = this.driverContext.blockFactory().newIntVectorFixedBuilder(block.getPositionCount());){
                for (int p = 0; p < block.getPositionCount(); ++p) {
                    builder.appendInt(block.getValueCount(p));
                }
                IntBlock intBlock = builder.build().asBlock();
                return intBlock;
            }
        }

        @Override
        protected Block evalSingleValuedNullable(Block ref) {
            return this.evalNullable(ref);
        }

        @Override
        protected Block evalSingleValuedNotNullable(Block ref) {
            return this.driverContext.blockFactory().newConstantIntBlockWith(1, ref.getPositionCount());
        }

        public long baseRamBytesUsed() {
            return BASE_RAM_BYTES_USED + this.field.baseRamBytesUsed();
        }
    }
}

