/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.conditional;

import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.compute.operator.Warnings;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.function.scalar.conditional.ClampMax;

public final class ClampMaxIntegerEvaluator
implements EvalOperator.ExpressionEvaluator {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(ClampMaxIntegerEvaluator.class);
    private final Source source;
    private final EvalOperator.ExpressionEvaluator field;
    private final EvalOperator.ExpressionEvaluator max;
    private final DriverContext driverContext;
    private Warnings warnings;

    public ClampMaxIntegerEvaluator(Source source, EvalOperator.ExpressionEvaluator field, EvalOperator.ExpressionEvaluator max, DriverContext driverContext) {
        this.source = source;
        this.field = field;
        this.max = max;
        this.driverContext = driverContext;
    }

    public Block eval(Page page) {
        try (IntBlock fieldBlock = (IntBlock)this.field.eval(page);){
            IntBlock intBlock;
            block20: {
                IntVector maxVector;
                IntVector fieldVector;
                IntBlock maxBlock;
                block18: {
                    IntBlock intBlock2;
                    block19: {
                        block16: {
                            IntBlock intBlock3;
                            block17: {
                                maxBlock = (IntBlock)this.max.eval(page);
                                try {
                                    fieldVector = fieldBlock.asVector();
                                    if (fieldVector != null) break block16;
                                    intBlock3 = this.eval(page.getPositionCount(), fieldBlock, maxBlock);
                                    if (maxBlock == null) break block17;
                                }
                                catch (Throwable throwable) {
                                    if (maxBlock != null) {
                                        try {
                                            maxBlock.close();
                                        }
                                        catch (Throwable throwable2) {
                                            throwable.addSuppressed(throwable2);
                                        }
                                    }
                                    throw throwable;
                                }
                                maxBlock.close();
                            }
                            return intBlock3;
                        }
                        maxVector = maxBlock.asVector();
                        if (maxVector != null) break block18;
                        intBlock2 = this.eval(page.getPositionCount(), fieldBlock, maxBlock);
                        if (maxBlock == null) break block19;
                        maxBlock.close();
                    }
                    return intBlock2;
                }
                intBlock = this.eval(page.getPositionCount(), fieldVector, maxVector).asBlock();
                if (maxBlock == null) break block20;
                maxBlock.close();
            }
            return intBlock;
        }
    }

    public long baseRamBytesUsed() {
        long baseRamBytesUsed = BASE_RAM_BYTES_USED;
        baseRamBytesUsed += this.field.baseRamBytesUsed();
        return baseRamBytesUsed += this.max.baseRamBytesUsed();
    }

    public IntBlock eval(int positionCount, IntBlock fieldBlock, IntBlock maxBlock) {
        try (IntBlock.Builder result = this.driverContext.blockFactory().newIntBlockBuilder(positionCount);){
            block13: for (int p = 0; p < positionCount; ++p) {
                switch (fieldBlock.getValueCount(p)) {
                    case 0: {
                        result.appendNull();
                        continue block13;
                    }
                    case 1: {
                        break;
                    }
                    default: {
                        this.warnings().registerException((Exception)new IllegalArgumentException("single-value function encountered multi-value"));
                        result.appendNull();
                        continue block13;
                    }
                }
                switch (maxBlock.getValueCount(p)) {
                    case 0: {
                        result.appendNull();
                        continue block13;
                    }
                    case 1: {
                        break;
                    }
                    default: {
                        this.warnings().registerException((Exception)new IllegalArgumentException("single-value function encountered multi-value"));
                        result.appendNull();
                        continue block13;
                    }
                }
                int field = fieldBlock.getInt(fieldBlock.getFirstValueIndex(p));
                int max = maxBlock.getInt(maxBlock.getFirstValueIndex(p));
                result.appendInt(ClampMax.process(field, max));
            }
            IntBlock intBlock = result.build();
            return intBlock;
        }
    }

    public IntVector eval(int positionCount, IntVector fieldVector, IntVector maxVector) {
        try (IntVector.FixedBuilder result = this.driverContext.blockFactory().newIntVectorFixedBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                int field = fieldVector.getInt(p);
                int max = maxVector.getInt(p);
                result.appendInt(p, ClampMax.process(field, max));
            }
            IntVector intVector = result.build();
            return intVector;
        }
    }

    public String toString() {
        return "ClampMaxIntegerEvaluator[field=" + String.valueOf(this.field) + ", max=" + String.valueOf(this.max) + "]";
    }

    public void close() {
        Releasables.closeExpectNoException((Releasable[])new Releasable[]{this.field, this.max});
    }

    private Warnings warnings() {
        if (this.warnings == null) {
            this.warnings = Warnings.createWarnings((DriverContext.WarningsMode)this.driverContext.warningsMode(), (int)this.source.source().getLineNumber(), (int)this.source.source().getColumnNumber(), (String)this.source.text());
        }
        return this.warnings;
    }

    static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final Source source;
        private final EvalOperator.ExpressionEvaluator.Factory field;
        private final EvalOperator.ExpressionEvaluator.Factory max;

        public Factory(Source source, EvalOperator.ExpressionEvaluator.Factory field, EvalOperator.ExpressionEvaluator.Factory max) {
            this.source = source;
            this.field = field;
            this.max = max;
        }

        public ClampMaxIntegerEvaluator get(DriverContext context) {
            return new ClampMaxIntegerEvaluator(this.source, this.field.get(context), this.max.get(context), context);
        }

        public String toString() {
            return "ClampMaxIntegerEvaluator[field=" + String.valueOf(this.field) + ", max=" + String.valueOf(this.max) + "]";
        }
    }
}

