/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar;

import java.io.IOException;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Stream;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.xpack.esql.EsqlIllegalArgumentException;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.TypeResolutions;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.evaluator.mapper.EvaluatorMapper;
import org.elasticsearch.xpack.esql.expression.SurrogateExpression;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionAppliesTo;
import org.elasticsearch.xpack.esql.expression.function.FunctionAppliesToLifecycle;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.scalar.EsqlScalarFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.conditional.ClampMax;
import org.elasticsearch.xpack.esql.expression.function.scalar.conditional.ClampMin;

public class Clamp
extends EsqlScalarFunction
implements SurrogateExpression {
    private final Expression field;
    private final Expression min;
    private final Expression max;
    private DataType resolvedType;

    @FunctionInfo(returnType={"double", "integer", "long", "double", "unsigned_long", "keyword", "ip", "boolean", "date", "version"}, description="Limits (or clamps) the values of all samples to have a lower limit of min and an upper limit of max.", examples={@Example(file="k8s-timeseries-clamp", tag="clamp")}, appliesTo={@FunctionAppliesTo(lifeCycle=FunctionAppliesToLifecycle.PREVIEW, version="9.3.0")})
    public Clamp(Source source, @Param(name="field", type={"double", "integer", "long", "double", "unsigned_long", "keyword", "ip", "boolean", "date", "version"}, description="Numeric expression. If `null`, the function returns `null`.") Expression field, @Param(name="min", type={"double", "integer", "long", "double", "unsigned_long", "keyword", "ip", "boolean", "date", "version"}, description="The min value to clamp data into.") Expression min, @Param(name="max", type={"double", "integer", "long", "double", "unsigned_long", "keyword", "ip", "boolean", "date", "version"}, description="The max value to clamp data into.") Expression max) {
        super(source, List.of(field, min, max));
        this.field = field;
        this.min = min;
        this.max = max;
    }

    public String getWriteableName() {
        throw new UnsupportedOperationException("Clamp does not support serialization.");
    }

    protected Expression.TypeResolution resolveType() {
        if (!this.childrenResolved()) {
            return new Expression.TypeResolution("Unresolved children");
        }
        Expression field = (Expression)this.children().get(0);
        Expression max = (Expression)this.children().get(1);
        Expression min = (Expression)this.children().get(2);
        DataType fieldDataType = field.dataType().noText();
        Expression.TypeResolution resolution = TypeResolutions.isType((Expression)field, t -> t.isNumeric() || t == DataType.BOOLEAN || t.isDate() || DataType.isString((DataType)t) || t == DataType.IP || t == DataType.VERSION, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.FIRST, (String[])new String[]{fieldDataType.typeName()});
        if (resolution.unresolved()) {
            return resolution;
        }
        if (fieldDataType == DataType.NULL) {
            return new Expression.TypeResolution("'field' must not be null in clamp()");
        }
        resolution = TypeResolutions.isType((Expression)max, t -> t.isNumeric() ? fieldDataType.isNumeric() : t.noText() == fieldDataType.noText(), (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.SECOND, (String[])new String[]{fieldDataType.typeName()});
        if (resolution.unresolved()) {
            return resolution;
        }
        resolution = TypeResolutions.isType((Expression)min, t -> t.isNumeric() ? fieldDataType.isNumeric() : t.noText() == fieldDataType.noText(), (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.THIRD, (String[])new String[]{fieldDataType.typeName()});
        if (resolution.unresolved()) {
            return resolution;
        }
        this.resolvedType = !fieldDataType.isNumeric() ? fieldDataType : Stream.of(fieldDataType, max.dataType(), min.dataType()).sorted(Comparator.comparingInt(DataType::estimatedSize).thenComparing(DataType::isRationalNumber)).toList().getLast();
        return Expression.TypeResolution.TYPE_RESOLVED;
    }

    public DataType dataType() {
        if (this.resolvedType == null && !this.resolveType().resolved()) {
            throw new EsqlIllegalArgumentException("Unable to resolve data type for clamp_max");
        }
        return this.resolvedType;
    }

    public Expression replaceChildren(List<Expression> newChildren) {
        return new Clamp(this.source(), newChildren.get(0), newChildren.get(1), newChildren.get(2));
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, Clamp::new, (Object)this.field, (Object)((Expression)this.children().get(1)), (Object)((Expression)this.children().get(2)));
    }

    public void writeTo(StreamOutput out) throws IOException {
        throw new UnsupportedOperationException("Clamp does not support serialization.");
    }

    @Override
    public EvalOperator.ExpressionEvaluator.Factory toEvaluator(EvaluatorMapper.ToEvaluator toEvaluator) {
        throw new UnsupportedOperationException("Clamp should have been replaced by ClampMin and ClampMax. Something went wrong in the compute engine.");
    }

    @Override
    public Expression surrogate() {
        return new ClampMax(this.source(), (Expression)new ClampMin(this.source(), this.field, this.min), this.max);
    }
}

