/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import java.util.concurrent.Executor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.TransportMasterNodeReadAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.project.ProjectResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.action.util.QueryPage;
import org.elasticsearch.xpack.core.ml.action.GetDatafeedsAction;
import org.elasticsearch.xpack.core.ml.datafeed.DatafeedConfig;
import org.elasticsearch.xpack.ml.datafeed.DatafeedManager;

public class TransportGetDatafeedsAction
extends TransportMasterNodeReadAction<GetDatafeedsAction.Request, GetDatafeedsAction.Response> {
    private static final Logger logger = LogManager.getLogger(TransportGetDatafeedsAction.class);
    private final DatafeedManager datafeedManager;
    private final ProjectResolver projectResolver;

    @Inject
    public TransportGetDatafeedsAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, DatafeedManager datafeedManager, ProjectResolver projectResolver) {
        super("cluster:monitor/xpack/ml/datafeeds/get", transportService, clusterService, threadPool, actionFilters, GetDatafeedsAction.Request::new, GetDatafeedsAction.Response::new, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.datafeedManager = datafeedManager;
        this.projectResolver = projectResolver;
    }

    protected void masterOperation(Task task, GetDatafeedsAction.Request request, ClusterState state, ActionListener<GetDatafeedsAction.Response> listener) {
        TaskId parentTaskId = new TaskId(this.clusterService.localNode().getId(), task.getId());
        logger.debug("Get datafeed '{}'", (Object)request.getDatafeedId());
        this.datafeedManager.getDatafeeds(request, parentTaskId, (ActionListener<QueryPage<DatafeedConfig>>)listener.delegateFailureAndWrap((l, datafeeds) -> l.onResponse((Object)new GetDatafeedsAction.Response(datafeeds))));
    }

    protected ClusterBlockException checkBlock(GetDatafeedsAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(this.projectResolver.getProjectId(), ClusterBlockLevel.METADATA_READ);
    }
}

