/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesRequestBuilder;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesResponse;
import org.elasticsearch.action.admin.indices.rollover.RolloverRequest;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.PlainActionFuture;
import org.elasticsearch.action.support.SubscribableListener;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.client.internal.OriginSettingClient;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.routing.IndexRoutingTable;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.logging.LogManager;
import org.elasticsearch.logging.Logger;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.xpack.core.ml.job.persistence.AnomalyDetectorsIndex;
import org.elasticsearch.xpack.core.ml.utils.MlIndexAndAlias;
import org.elasticsearch.xpack.ml.MlAutoUpdateService;

public class MlAnomaliesIndexUpdate
implements MlAutoUpdateService.UpdateAction {
    private static final Logger logger = LogManager.getLogger(MlAnomaliesIndexUpdate.class);
    private final IndexNameExpressionResolver expressionResolver;
    private final OriginSettingClient client;

    public MlAnomaliesIndexUpdate(IndexNameExpressionResolver expressionResolver, Client client) {
        this.expressionResolver = expressionResolver;
        this.client = new OriginSettingClient(client, "ml");
    }

    @Override
    public boolean isMinTransportVersionSupported(TransportVersion minTransportVersion) {
        return true;
    }

    @Override
    public boolean isAbleToRun(ClusterState latestState) {
        String[] indices;
        for (String index : indices = this.expressionResolver.concreteIndexNames(latestState, IndicesOptions.lenientExpandOpenHidden(), new String[]{AnomalyDetectorsIndex.jobResultsIndexPattern()})) {
            IndexRoutingTable routingTable = latestState.getRoutingTable().index(index);
            if (routingTable != null && routingTable.allPrimaryShardsActive()) continue;
            return false;
        }
        return true;
    }

    @Override
    public String getName() {
        return "ml_anomalies_index_update";
    }

    @Override
    public void runUpdate(ClusterState latestState) {
        ArrayList<ElasticsearchStatusException> failures = new ArrayList<ElasticsearchStatusException>();
        String[] indices = this.expressionResolver.concreteIndexNames(latestState, IndicesOptions.lenientExpandOpenHidden(), new String[]{AnomalyDetectorsIndex.jobResultsIndexPattern()});
        if (indices.length == 0) {
            return;
        }
        Map<String, List<String>> baseIndicesMap = Arrays.stream(indices).collect(Collectors.groupingBy(MlIndexAndAlias::baseIndexName));
        for (String index : indices) {
            boolean isCompatibleIndexVersion = MlIndexAndAlias.indexIsReadWriteCompatibleInV9((IndexVersion)latestState.metadata().getProject().index(index).getCreationVersion());
            boolean isCompatibleIndexFormat = MlIndexAndAlias.has6DigitSuffix((String)index);
            if (isCompatibleIndexVersion && isCompatibleIndexFormat) continue;
            String latestIndex = MlIndexAndAlias.latestIndexMatchingBaseName((String)index, (IndexNameExpressionResolver)this.expressionResolver, (ClusterState)latestState);
            if (!index.equals(latestIndex)) {
                logger.debug("index [{}] will not be rolled over as there is a later index [{}]", new Object[]{index, latestIndex});
                continue;
            }
            PlainActionFuture updated = new PlainActionFuture();
            this.rollAndUpdateAliases(latestState, index, baseIndicesMap.get(MlIndexAndAlias.baseIndexName((String)index)), (ActionListener<Boolean>)updated);
            try {
                updated.actionGet();
            }
            catch (Exception ex) {
                String message = "failed rolling over legacy ml anomalies index [" + index + "]";
                logger.warn(message, (Throwable)ex);
                if (ex instanceof ElasticsearchException) {
                    ElasticsearchException elasticsearchException = (ElasticsearchException)ex;
                    failures.add(new ElasticsearchStatusException(message, elasticsearchException.status(), (Throwable)elasticsearchException, new Object[0]));
                    break;
                }
                failures.add(new ElasticsearchStatusException(message, RestStatus.REQUEST_TIMEOUT, (Throwable)ex, new Object[0]));
                break;
            }
        }
        if (failures.isEmpty()) {
            logger.info("legacy ml anomalies indices rolled over and aliases updated");
            return;
        }
        ElasticsearchStatusException exception = new ElasticsearchStatusException("failed to roll over legacy ml anomalies", RestStatus.CONFLICT, new Object[0]);
        failures.forEach(arg_0 -> exception.addSuppressed(arg_0));
        throw exception;
    }

    private void rollAndUpdateAliases(ClusterState clusterState, String index, List<String> baseIndices, ActionListener<Boolean> listener) {
        Tuple newIndexNameAndRolloverAlias = MlIndexAndAlias.createRolloverAliasAndNewIndexName((String)index);
        String rolloverAlias = (String)newIndexNameAndRolloverAlias.v1();
        String newIndexName = (String)newIndexNameAndRolloverAlias.v2();
        IndicesAliasesRequestBuilder aliasRequestBuilder = MlIndexAndAlias.createIndicesAliasesRequestBuilder((Client)this.client);
        SubscribableListener.newForked(l -> this.createAliasForRollover(index, rolloverAlias, (ActionListener<IndicesAliasesResponse>)l.map(AcknowledgedResponse::isAcknowledged))).andThen((l, success) -> this.rollover(rolloverAlias, newIndexName, (ActionListener<String>)l)).andThen((l, newIndexNameResponse) -> {
            MlIndexAndAlias.addResultsIndexRolloverAliasActions((IndicesAliasesRequestBuilder)aliasRequestBuilder, (String)newIndexNameResponse, (ClusterState)clusterState, (List)baseIndices);
            aliasRequestBuilder.removeAlias(newIndexNameResponse, rolloverAlias);
            MlIndexAndAlias.updateAliases((IndicesAliasesRequestBuilder)aliasRequestBuilder, (ActionListener)l);
        }).addListener(listener);
    }

    private void rollover(String alias, @Nullable String newIndexName, ActionListener<String> listener) {
        MlIndexAndAlias.rollover((Client)this.client, (RolloverRequest)new RolloverRequest(alias, newIndexName), listener);
    }

    private void createAliasForRollover(String indexName, String aliasName, ActionListener<IndicesAliasesResponse> listener) {
        MlIndexAndAlias.createAliasForRollover((Client)this.client, (String)indexName, (String)aliasName, listener);
    }
}

