/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.vectortile.feature;

import com.wdtinc.mapbox_vector_tile.VectorTile;
import com.wdtinc.mapbox_vector_tile.adapt.jts.IUserDataConverter;
import com.wdtinc.mapbox_vector_tile.adapt.jts.JtsAdapter;
import com.wdtinc.mapbox_vector_tile.build.MvtLayerProps;
import com.wdtinc.mapbox_vector_tile.encoding.GeomCmd;
import com.wdtinc.mapbox_vector_tile.encoding.GeomCmdHdr;
import com.wdtinc.mapbox_vector_tile.encoding.MvtUtil;
import com.wdtinc.mapbox_vector_tile.encoding.ZigZag;
import com.wdtinc.mapbox_vector_tile.util.Vec2d;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.locationtech.jts.algorithm.Area;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateArrays;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;

final class PatchedJtsAdapter {
    PatchedJtsAdapter() {
    }

    public static List<VectorTile.Tile.Feature> toFeatures(Collection<Geometry> flatGeoms, MvtLayerProps layerProps, IUserDataConverter userDataConverter) {
        if (flatGeoms.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<VectorTile.Tile.Feature> features = new ArrayList<VectorTile.Tile.Feature>();
        Vec2d cursor = new Vec2d();
        for (Geometry nextGeom : flatGeoms) {
            cursor.set(0.0, 0.0);
            VectorTile.Tile.Feature nextFeature = PatchedJtsAdapter.toFeature(nextGeom, cursor, layerProps, userDataConverter);
            if (nextFeature == null) continue;
            features.add(nextFeature);
        }
        return features;
    }

    private static VectorTile.Tile.Feature toFeature(Geometry geom, Vec2d cursor, MvtLayerProps layerProps, IUserDataConverter userDataConverter) {
        VectorTile.Tile.GeomType mvtGeomType = JtsAdapter.toGeomType((Geometry)geom);
        if (mvtGeomType == VectorTile.Tile.GeomType.UNKNOWN) {
            return null;
        }
        VectorTile.Tile.Feature.Builder featureBuilder = VectorTile.Tile.Feature.newBuilder();
        boolean mvtClosePath = MvtUtil.shouldClosePath((VectorTile.Tile.GeomType)mvtGeomType);
        ArrayList<Integer> mvtGeom = new ArrayList<Integer>();
        featureBuilder.setType(mvtGeomType);
        if (geom instanceof Point || geom instanceof MultiPoint) {
            mvtGeom.addAll(PatchedJtsAdapter.ptsToGeomCmds(geom, cursor));
        } else if (geom instanceof LineString || geom instanceof MultiLineString) {
            for (int i = 0; i < geom.getNumGeometries(); ++i) {
                mvtGeom.addAll(PatchedJtsAdapter.linesToGeomCmds(geom.getGeometryN(i), mvtClosePath, cursor, 1));
            }
        } else if (geom instanceof MultiPolygon || geom instanceof Polygon) {
            for (int i = 0; i < geom.getNumGeometries(); ++i) {
                Polygon nextPoly = (Polygon)geom.getGeometryN(i);
                ArrayList<Integer> nextPolyGeom = new ArrayList<Integer>();
                boolean valid = true;
                LinearRing exteriorRing = nextPoly.getExteriorRing();
                double exteriorArea = Area.ofRingSigned((Coordinate[])exteriorRing.getCoordinates());
                if ((int)Math.round(exteriorArea) == 0) continue;
                if (exteriorArea > 0.0) {
                    CoordinateArrays.reverse((Coordinate[])exteriorRing.getCoordinates());
                }
                nextPolyGeom.addAll(PatchedJtsAdapter.linesToGeomCmds((Geometry)exteriorRing, mvtClosePath, cursor, 2));
                for (int ringIndex = 0; ringIndex < nextPoly.getNumInteriorRing(); ++ringIndex) {
                    LinearRing nextInteriorRing = nextPoly.getInteriorRingN(ringIndex);
                    double interiorArea = Area.ofRingSigned((Coordinate[])nextInteriorRing.getCoordinates());
                    if ((int)Math.round(interiorArea) == 0) continue;
                    if (interiorArea < 0.0) {
                        CoordinateArrays.reverse((Coordinate[])nextInteriorRing.getCoordinates());
                    }
                    if (Math.abs(exteriorArea) <= Math.abs(interiorArea)) {
                        valid = false;
                        break;
                    }
                    nextPolyGeom.addAll(PatchedJtsAdapter.linesToGeomCmds((Geometry)nextInteriorRing, mvtClosePath, cursor, 2));
                }
                if (!valid) continue;
                mvtGeom.addAll(nextPolyGeom);
            }
        }
        if (mvtGeom.size() < 1) {
            return null;
        }
        featureBuilder.addAllGeometry(mvtGeom);
        userDataConverter.addTags(geom.getUserData(), layerProps, featureBuilder);
        return featureBuilder.build();
    }

    private static List<Integer> ptsToGeomCmds(Geometry geom, Vec2d cursor) {
        Coordinate[] geomCoords = geom.getCoordinates();
        if (geomCoords.length <= 0) {
            return Collections.emptyList();
        }
        ArrayList<Integer> geomCmds = new ArrayList<Integer>(PatchedJtsAdapter.geomCmdBuffLenPts(geomCoords.length));
        Vec2d mvtPos = new Vec2d();
        int moveCmdLen = 0;
        geomCmds.add(0);
        for (int i = 0; i < geomCoords.length; ++i) {
            Coordinate nextCoord = geomCoords[i];
            mvtPos.set(nextCoord.x, nextCoord.y);
            if (i != 0 && PatchedJtsAdapter.equalAsInts(cursor, mvtPos)) continue;
            ++moveCmdLen;
            PatchedJtsAdapter.moveCursor(cursor, geomCmds, mvtPos);
        }
        if (moveCmdLen <= GeomCmdHdr.CMD_HDR_LEN_MAX) {
            geomCmds.set(0, GeomCmdHdr.cmdHdr((GeomCmd)GeomCmd.MoveTo, (int)moveCmdLen));
            return geomCmds;
        }
        return Collections.emptyList();
    }

    private static List<Integer> linesToGeomCmds(Geometry geom, boolean closeEnabled, Vec2d cursor, int minLineToLen) {
        int repeatEndCoordCount;
        Coordinate[] geomCoords = geom.getCoordinates();
        int minExpGeomCoords = geomCoords.length - (repeatEndCoordCount = PatchedJtsAdapter.countCoordRepeatReverse(geomCoords));
        if (minExpGeomCoords < 2) {
            return Collections.emptyList();
        }
        ArrayList<Integer> geomCmds = new ArrayList<Integer>(PatchedJtsAdapter.geomCmdBuffLenLines(minExpGeomCoords, closeEnabled));
        Vec2d mvtPos = new Vec2d();
        Coordinate nextCoord = geomCoords[0];
        mvtPos.set(nextCoord.x, nextCoord.y);
        geomCmds.add(GeomCmdHdr.cmdHdr((GeomCmd)GeomCmd.MoveTo, (int)1));
        PatchedJtsAdapter.moveCursor(cursor, geomCmds, mvtPos);
        int lineToCmdHdrIndex = geomCmds.size();
        geomCmds.add(0);
        int lineToLength = 0;
        for (int i = 1; i < minExpGeomCoords; ++i) {
            nextCoord = geomCoords[i];
            mvtPos.set(nextCoord.x, nextCoord.y);
            if (PatchedJtsAdapter.equalAsInts(cursor, mvtPos)) continue;
            ++lineToLength;
            PatchedJtsAdapter.moveCursor(cursor, geomCmds, mvtPos);
        }
        if (lineToLength >= minLineToLen && lineToLength <= GeomCmdHdr.CMD_HDR_LEN_MAX) {
            geomCmds.set(lineToCmdHdrIndex, GeomCmdHdr.cmdHdr((GeomCmd)GeomCmd.LineTo, (int)lineToLength));
            if (closeEnabled) {
                geomCmds.add(GeomCmdHdr.closePathCmdHdr());
            }
            return geomCmds;
        }
        return Collections.emptyList();
    }

    private static int countCoordRepeatReverse(Coordinate[] coords) {
        Coordinate nextCoord;
        int repeatCoords = 0;
        Coordinate firstCoord = coords[0];
        for (int i = coords.length - 1; i > 0 && PatchedJtsAdapter.equalAsInts2d(firstCoord, nextCoord = coords[i]); --i) {
            ++repeatCoords;
        }
        return repeatCoords;
    }

    private static void moveCursor(Vec2d cursor, List<Integer> geomCmds, Vec2d mvtPos) {
        geomCmds.add(ZigZag.encode((int)((int)mvtPos.x - (int)cursor.x)));
        geomCmds.add(ZigZag.encode((int)((int)mvtPos.y - (int)cursor.y)));
        cursor.set(mvtPos);
    }

    private static boolean equalAsInts2d(Coordinate a, Coordinate b) {
        return (int)a.getOrdinate(0) == (int)b.getOrdinate(0) && (int)a.getOrdinate(1) == (int)b.getOrdinate(1);
    }

    private static boolean equalAsInts(Vec2d a, Vec2d b) {
        return (int)a.x == (int)b.x && (int)a.y == (int)b.y;
    }

    private static int geomCmdBuffLenPts(int coordCount) {
        return 1 + coordCount * 2;
    }

    private static int geomCmdBuffLenLines(int coordCount, boolean closeEnabled) {
        return 2 + (closeEnabled ? 1 : 0) + coordCount * 2;
    }
}

