/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.common.bytes.ReleasableBytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.transport.BytesTransportMessage;
import org.elasticsearch.transport.TransportResponse;

public class BytesTransportResponse
extends TransportResponse
implements BytesTransportMessage {
    private final ReleasableBytesReference bytes;
    private final TransportVersion version;

    public BytesTransportResponse(ReleasableBytesReference bytes, TransportVersion version) {
        this.bytes = bytes;
        this.version = Objects.requireNonNull(version);
    }

    public boolean mustConvertResponseForVersion(TransportVersion targetVersion) {
        return !this.version.equals(targetVersion);
    }

    public StreamInput streamInput() throws IOException {
        StreamInput streamInput = this.bytes.streamInput();
        streamInput.setTransportVersion(this.version);
        return streamInput;
    }

    @Override
    public ReleasableBytesReference bytes() {
        return this.bytes;
    }

    @Override
    public void writeThin(StreamOutput out) throws IOException {
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.bytes.writeTo(out);
    }

    @Override
    public void incRef() {
        this.bytes.incRef();
    }

    @Override
    public boolean tryIncRef() {
        return this.bytes.tryIncRef();
    }

    @Override
    public boolean decRef() {
        return this.bytes.decRef();
    }

    @Override
    public boolean hasReferences() {
        return this.bytes.hasReferences();
    }
}

