/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.crossproject;

import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.action.ResolvedIndexExpression;
import org.elasticsearch.action.ResolvedIndexExpressions;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.common.Strings;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.transport.RemoteClusterAware;

public class CrossProjectIndexResolutionValidator {
    private static final Logger logger = LogManager.getLogger(CrossProjectIndexResolutionValidator.class);

    public static ElasticsearchException validate(IndicesOptions indicesOptions, @Nullable String projectRouting, ResolvedIndexExpressions localResolvedExpressions, Map<String, ResolvedIndexExpressions> remoteResolvedExpressions) {
        if (indicesOptions.allowNoIndices() && indicesOptions.ignoreUnavailable()) {
            logger.debug("Skipping index existence check in lenient mode");
            return null;
        }
        boolean hasProjectRouting = !Strings.isEmpty(projectRouting);
        logger.debug("Checking index existence for [{}] and [{}] with indices options [{}]{}", (Object)localResolvedExpressions, remoteResolvedExpressions, (Object)indicesOptions, hasProjectRouting ? " and project routing [" + projectRouting + "]" : "");
        for (ResolvedIndexExpression localResolvedIndices : localResolvedExpressions.expressions()) {
            String originalExpression = localResolvedIndices.original();
            logger.debug("Checking replaced expression for original expression [{}]", (Object)originalExpression);
            boolean isQualifiedExpression = hasProjectRouting || RemoteClusterAware.isRemoteIndexName(originalExpression);
            Set<String> remoteExpressions = localResolvedIndices.remoteExpressions();
            ResolvedIndexExpression.LocalExpressions localExpressions = localResolvedIndices.localExpressions();
            ResolvedIndexExpression.LocalIndexResolutionResult result = localExpressions.localIndexResolutionResult();
            if (isQualifiedExpression) {
                ElasticsearchException e = CrossProjectIndexResolutionValidator.checkResolutionFailure(localExpressions, result, originalExpression, indicesOptions);
                if (e != null) {
                    return e;
                }
                for (String remoteExpression : remoteExpressions) {
                    String[] splitResource = CrossProjectIndexResolutionValidator.splitQualifiedResource(remoteExpression);
                    ElasticsearchException exception = CrossProjectIndexResolutionValidator.checkSingleRemoteExpression(remoteResolvedExpressions, splitResource[0], splitResource[1], remoteExpression, indicesOptions);
                    if (exception == null) continue;
                    return exception;
                }
                continue;
            }
            ElasticsearchException localException = CrossProjectIndexResolutionValidator.checkResolutionFailure(localExpressions, result, originalExpression, indicesOptions);
            if (localException == null) continue;
            boolean isUnauthorized = localException instanceof ElasticsearchSecurityException;
            boolean foundFlat = false;
            for (String remoteExpression : remoteExpressions) {
                String[] splitResource = CrossProjectIndexResolutionValidator.splitQualifiedResource(remoteExpression);
                ElasticsearchException exception = CrossProjectIndexResolutionValidator.checkSingleRemoteExpression(remoteResolvedExpressions, splitResource[0], splitResource[1], remoteExpression, indicesOptions);
                if (exception == null) {
                    foundFlat = true;
                    break;
                }
                if (isUnauthorized || !(exception instanceof ElasticsearchSecurityException)) continue;
                isUnauthorized = true;
            }
            if (foundFlat) continue;
            if (isUnauthorized) {
                return localException;
            }
            return new IndexNotFoundException(originalExpression);
        }
        return null;
    }

    public static IndicesOptions indicesOptionsForCrossProjectFanout(IndicesOptions indicesOptions) {
        return IndicesOptions.builder(indicesOptions).concreteTargetOptions(new IndicesOptions.ConcreteTargetOptions(true)).wildcardOptions(IndicesOptions.WildcardOptions.builder(indicesOptions.wildcardOptions()).allowEmptyExpressions(true).build()).crossProjectModeOptions(IndicesOptions.CrossProjectModeOptions.DEFAULT).build();
    }

    private static ElasticsearchSecurityException securityException(String originalExpression) {
        return new ElasticsearchSecurityException("user cannot access [" + originalExpression + "]", RestStatus.FORBIDDEN, new Object[0]);
    }

    private static ElasticsearchException checkSingleRemoteExpression(Map<String, ResolvedIndexExpressions> remoteResolvedExpressions, String projectAlias, String resource, String remoteExpression, IndicesOptions indicesOptions) {
        ResolvedIndexExpressions resolvedExpressionsInProject = remoteResolvedExpressions.get(projectAlias);
        if (resolvedExpressionsInProject == null) {
            return new IndexNotFoundException(remoteExpression);
        }
        ResolvedIndexExpression.LocalExpressions matchingExpression = CrossProjectIndexResolutionValidator.findMatchingExpression(resolvedExpressionsInProject, resource);
        if (matchingExpression == null) {
            assert (false) : "Expected to find matching expression [" + resource + "] in project [" + projectAlias + "]";
            return new IndexNotFoundException(remoteExpression);
        }
        return CrossProjectIndexResolutionValidator.checkResolutionFailure(matchingExpression, matchingExpression.localIndexResolutionResult(), remoteExpression, indicesOptions);
    }

    public static String[] splitQualifiedResource(String resource) {
        String[] splitResource = RemoteClusterAware.splitIndexName(resource);
        assert (splitResource.length == 2) : "Expected two strings (project and indexExpression) for a qualified resource [" + resource + "], but found [" + splitResource.length + "]";
        return splitResource;
    }

    private static ResolvedIndexExpression.LocalExpressions findMatchingExpression(ResolvedIndexExpressions projectExpressions, String resource) {
        return projectExpressions.expressions().stream().filter(expr -> expr.original().equals(resource)).map(ResolvedIndexExpression::localExpressions).findFirst().orElse(null);
    }

    private static ElasticsearchException checkResolutionFailure(ResolvedIndexExpression.LocalExpressions localExpressions, ResolvedIndexExpression.LocalIndexResolutionResult result, String expression, IndicesOptions indicesOptions) {
        assert (!(indicesOptions.allowNoIndices() && indicesOptions.ignoreUnavailable())) : "Should not be checking index existence in lenient mode";
        if (!indicesOptions.ignoreUnavailable()) {
            if (result == ResolvedIndexExpression.LocalIndexResolutionResult.CONCRETE_RESOURCE_NOT_VISIBLE) {
                return new IndexNotFoundException(expression);
            }
            if (result == ResolvedIndexExpression.LocalIndexResolutionResult.CONCRETE_RESOURCE_UNAUTHORIZED) {
                assert (localExpressions.exception() != null) : "ResolvedIndexExpression should have exception set when concrete index is unauthorized";
                return localExpressions.exception();
            }
        }
        if (!indicesOptions.allowNoIndices() && result == ResolvedIndexExpression.LocalIndexResolutionResult.SUCCESS && localExpressions.indices().isEmpty()) {
            return new IndexNotFoundException(expression);
        }
        return null;
    }
}

