/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.filter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.AggregationReduceContext;
import org.elasticsearch.search.aggregations.AggregatorReducer;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.search.aggregations.InternalMultiBucketAggregation;
import org.elasticsearch.search.aggregations.bucket.FixedMultiBucketAggregatorsReducer;
import org.elasticsearch.search.aggregations.bucket.filter.Filters;
import org.elasticsearch.search.aggregations.support.SamplingContext;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public class InternalFilters
extends InternalMultiBucketAggregation<InternalFilters, InternalBucket>
implements Filters {
    private final List<InternalBucket> buckets;
    private final boolean keyed;
    private final boolean keyedBucket;
    private transient Map<String, InternalBucket> bucketMap;

    public InternalFilters(String name, List<InternalBucket> buckets, boolean keyed, boolean keyedBucket, Map<String, Object> metadata) {
        super(name, metadata);
        this.buckets = buckets;
        this.keyed = keyed;
        this.keyedBucket = keyedBucket;
    }

    public InternalFilters(StreamInput in) throws IOException {
        super(in);
        this.keyed = in.readBoolean();
        this.keyedBucket = in.readBoolean();
        int size = in.readVInt();
        ArrayList<InternalBucket> buckets = new ArrayList<InternalBucket>(size);
        for (int i = 0; i < size; ++i) {
            buckets.add(new InternalBucket(in));
        }
        this.buckets = buckets;
        this.bucketMap = null;
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeBoolean(this.keyed);
        out.writeBoolean(this.keyedBucket);
        out.writeCollection(this.buckets);
    }

    @Override
    public String getWriteableName() {
        return "filters";
    }

    @Override
    public InternalFilters create(List<InternalBucket> buckets) {
        return new InternalFilters(this.name, buckets, this.keyed, this.keyedBucket, this.metadata);
    }

    @Override
    public InternalBucket createBucket(InternalAggregations aggregations, InternalBucket prototype) {
        return new InternalBucket(prototype.key, prototype.docCount, aggregations);
    }

    @Override
    public List<InternalBucket> getBuckets() {
        return this.buckets;
    }

    @Override
    public InternalBucket getBucketByKey(String key) {
        if (this.bucketMap == null) {
            this.bucketMap = Maps.newMapWithExpectedSize(this.buckets.size());
            for (InternalBucket bucket : this.buckets) {
                this.bucketMap.put(bucket.getKey(), bucket);
            }
        }
        return this.bucketMap.get(key);
    }

    @Override
    protected AggregatorReducer getLeaderReducer(final AggregationReduceContext reduceContext, final int size) {
        return new AggregatorReducer(){
            final FixedMultiBucketAggregatorsReducer<InternalBucket> reducer;
            {
                this.reducer = new FixedMultiBucketAggregatorsReducer<InternalBucket>(this, reduceContext, size, InternalFilters.this.getBuckets()){

                    @Override
                    protected InternalBucket createBucket(InternalBucket proto, long docCount, InternalAggregations aggregations) {
                        return new InternalBucket(proto.key, docCount, aggregations);
                    }
                };
            }

            @Override
            public void accept(InternalAggregation aggregation) {
                InternalFilters filters = (InternalFilters)aggregation;
                this.reducer.accept(filters.getBuckets());
            }

            @Override
            public InternalAggregation get() {
                return new InternalFilters(InternalFilters.this.name, this.reducer.get(), InternalFilters.this.keyed, InternalFilters.this.keyedBucket, InternalFilters.this.getMetadata());
            }

            @Override
            public void close() {
                Releasables.close(this.reducer);
            }
        };
    }

    @Override
    public InternalAggregation finalizeSampling(SamplingContext samplingContext) {
        ArrayList<InternalBucket> buckets = new ArrayList<InternalBucket>(this.buckets.size());
        for (InternalBucket bucket : this.buckets) {
            buckets.add(bucket.finalizeSampling(samplingContext));
        }
        return new InternalFilters(this.name, buckets, this.keyed, this.keyedBucket, this.getMetadata());
    }

    @Override
    public XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.keyed && this.keyedBucket) {
            builder.startObject(Aggregation.CommonFields.BUCKETS.getPreferredName());
        } else {
            builder.startArray(Aggregation.CommonFields.BUCKETS.getPreferredName());
        }
        for (InternalBucket bucket : this.buckets) {
            bucket.bucketToXContent(builder, params, this.keyed, this.keyedBucket);
        }
        if (this.keyed && this.keyedBucket) {
            builder.endObject();
        } else {
            builder.endArray();
        }
        return builder;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.buckets, this.keyed, this.keyedBucket);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        InternalFilters that = (InternalFilters)obj;
        return Objects.equals(this.buckets, that.buckets) && Objects.equals(this.keyed, that.keyed) && Objects.equals(this.keyedBucket, that.keyedBucket);
    }

    public static class InternalBucket
    extends InternalMultiBucketAggregation.InternalBucketWritable
    implements Filters.Bucket {
        private final String key;
        private long docCount;
        InternalAggregations aggregations;

        public InternalBucket(String key, long docCount, InternalAggregations aggregations) {
            this.key = key;
            this.docCount = docCount;
            this.aggregations = aggregations;
        }

        public InternalBucket(StreamInput in) throws IOException {
            this.key = in.readOptionalString();
            this.docCount = in.readVLong();
            this.aggregations = InternalAggregations.readFrom(in);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeOptionalString(this.key);
            out.writeVLong(this.docCount);
            this.aggregations.writeTo(out);
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public String getKeyAsString() {
            return this.key;
        }

        @Override
        public long getDocCount() {
            return this.docCount;
        }

        @Override
        public InternalAggregations getAggregations() {
            return this.aggregations;
        }

        private void bucketToXContent(XContentBuilder builder, ToXContent.Params params, boolean keyed, boolean keyedBucket) throws IOException {
            if (keyed && keyedBucket) {
                builder.startObject(this.key);
            } else {
                builder.startObject();
            }
            if (keyed && !keyedBucket) {
                builder.field(Aggregation.CommonFields.KEY.getPreferredName(), this.key);
            }
            builder.field(Aggregation.CommonFields.DOC_COUNT.getPreferredName(), this.docCount);
            this.aggregations.toXContentInternal(builder, params);
            builder.endObject();
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            InternalBucket that = (InternalBucket)other;
            return Objects.equals(this.key, that.key) && Objects.equals(this.docCount, that.docCount) && Objects.equals(this.aggregations, that.aggregations);
        }

        public int hashCode() {
            return Objects.hash(this.getClass(), this.key, this.docCount, this.aggregations);
        }

        InternalBucket finalizeSampling(SamplingContext samplingContext) {
            return new InternalBucket(this.key, samplingContext.scaleUp(this.docCount), InternalAggregations.finalizeSampling(this.aggregations, samplingContext));
        }
    }
}

