/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.search;

import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import org.elasticsearch.action.search.MultiSearchRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.TransportMultiSearchAction;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.common.CheckedBiConsumer;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.TriFunction;
import org.elasticsearch.common.bytes.ReleasableBytesReference;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.features.NodeFeature;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.Scope;
import org.elasticsearch.rest.ServerlessScope;
import org.elasticsearch.rest.action.RestCancellableNodeClient;
import org.elasticsearch.rest.action.RestRefCountedChunkedToXContentListener;
import org.elasticsearch.rest.action.search.RestSearchAction;
import org.elasticsearch.rest.action.search.SearchParamsParser;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.crossproject.CrossProjectModeDecider;
import org.elasticsearch.usage.SearchUsageHolder;
import org.elasticsearch.xcontent.XContent;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentType;

@ServerlessScope(value=Scope.PUBLIC)
public class RestMultiSearchAction
extends BaseRestHandler {
    private static final Set<String> RESPONSE_PARAMS = Set.of("typed_keys", "rest_total_hits_as_int");
    private final boolean allowExplicitIndex;
    private final SearchUsageHolder searchUsageHolder;
    private final Predicate<NodeFeature> clusterSupportsFeature;
    private final CrossProjectModeDecider crossProjectModeDecider;

    public RestMultiSearchAction(Settings settings, SearchUsageHolder searchUsageHolder, Predicate<NodeFeature> clusterSupportsFeature) {
        this.allowExplicitIndex = (Boolean)MULTI_ALLOW_EXPLICIT_INDEX.get(settings);
        this.searchUsageHolder = searchUsageHolder;
        this.clusterSupportsFeature = clusterSupportsFeature;
        this.crossProjectModeDecider = new CrossProjectModeDecider(settings);
    }

    @Override
    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.GET, "/_msearch"), new RestHandler.Route(RestRequest.Method.POST, "/_msearch"), new RestHandler.Route(RestRequest.Method.GET, "/{index}/_msearch"), new RestHandler.Route(RestRequest.Method.POST, "/{index}/_msearch"));
    }

    @Override
    public String getName() {
        return "msearch_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        if (client.threadPool() != null && client.threadPool().getThreadContext() != null) {
            client.threadPool().getThreadContext().setErrorTraceTransportHeader(request);
        }
        boolean crossProjectEnabled = this.crossProjectModeDecider.crossProjectEnabled();
        MultiSearchRequest multiSearchRequest = RestMultiSearchAction.parseRequest(request, this.allowExplicitIndex, this.searchUsageHolder, this.clusterSupportsFeature, Optional.of(crossProjectEnabled));
        return channel -> {
            RestCancellableNodeClient cancellableClient = new RestCancellableNodeClient(client, request.getHttpChannel());
            cancellableClient.execute(TransportMultiSearchAction.TYPE, multiSearchRequest, new RestRefCountedChunkedToXContentListener((RestChannel)channel));
        };
    }

    public static MultiSearchRequest parseRequest(RestRequest restRequest, boolean allowExplicitIndex, SearchUsageHolder searchUsageHolder, Predicate<NodeFeature> clusterSupportsFeature, Optional<Boolean> crossProjectEnabled) throws IOException {
        return RestMultiSearchAction.parseRequest(restRequest, allowExplicitIndex, searchUsageHolder, clusterSupportsFeature, (k, v, r) -> false, crossProjectEnabled);
    }

    public static MultiSearchRequest parseRequest(RestRequest restRequest, boolean allowExplicitIndex, SearchUsageHolder searchUsageHolder, Predicate<NodeFeature> clusterSupportsFeature, TriFunction<String, Object, SearchRequest, Boolean> extraParamParser, Optional<Boolean> crossProjectEnabled) throws IOException {
        MultiSearchRequest multiRequest = new MultiSearchRequest();
        IndicesOptions indicesOptions = IndicesOptions.fromRequest(restRequest, multiRequest.indicesOptions());
        if (multiRequest.allowsCrossProject() && crossProjectEnabled.orElse(false).booleanValue()) {
            indicesOptions = IndicesOptions.builder(indicesOptions).crossProjectModeOptions(new IndicesOptions.CrossProjectModeOptions(true)).build();
            multiRequest.setProjectRouting(restRequest.param("project_routing"));
        }
        multiRequest.indicesOptions(indicesOptions);
        if (restRequest.hasParam("max_concurrent_searches")) {
            multiRequest.maxConcurrentSearchRequests(restRequest.paramAsInt("max_concurrent_searches", 0));
        }
        Integer preFilterShardSize = null;
        if (restRequest.hasParam("pre_filter_shard_size")) {
            preFilterShardSize = restRequest.paramAsInt("pre_filter_shard_size", 128);
        }
        Integer maxConcurrentShardRequests = restRequest.hasParam("max_concurrent_shard_requests") ? Integer.valueOf(restRequest.paramAsInt("max_concurrent_shard_requests", Integer.MIN_VALUE)) : null;
        RestMultiSearchAction.parseMultiLineRequest(restRequest, multiRequest.indicesOptions(), allowExplicitIndex, (searchRequest, parser) -> {
            searchRequest.source(new SearchSourceBuilder().parseXContent((XContentParser)parser, false, searchUsageHolder, clusterSupportsFeature));
            RestSearchAction.validateSearchRequest(restRequest, searchRequest);
            if (searchRequest.pointInTimeBuilder() != null) {
                RestSearchAction.preparePointInTime(searchRequest, restRequest);
            } else {
                searchRequest.setCcsMinimizeRoundtrips(SearchParamsParser.parseCcsMinimizeRoundtrips(crossProjectEnabled, restRequest, searchRequest.isCcsMinimizeRoundtrips()));
            }
            multiRequest.add((SearchRequest)searchRequest);
        }, extraParamParser, crossProjectEnabled, multiRequest.getProjectRouting());
        List<SearchRequest> requests = multiRequest.requests();
        for (SearchRequest request : requests) {
            if (preFilterShardSize != null && request.getPreFilterShardSize() == null) {
                request.setPreFilterShardSize(preFilterShardSize);
            }
            if (maxConcurrentShardRequests == null) continue;
            request.setMaxConcurrentShardRequests(maxConcurrentShardRequests);
        }
        return multiRequest;
    }

    public static void parseMultiLineRequest(RestRequest request, IndicesOptions indicesOptions, boolean allowExplicitIndex, CheckedBiConsumer<SearchRequest, XContentParser, IOException> consumer, Optional<Boolean> crossProjectEnabled) throws IOException {
        RestMultiSearchAction.parseMultiLineRequest(request, indicesOptions, allowExplicitIndex, consumer, (k, v, r) -> false, crossProjectEnabled, null);
    }

    public static void parseMultiLineRequest(RestRequest request, IndicesOptions indicesOptions, boolean allowExplicitIndex, CheckedBiConsumer<SearchRequest, XContentParser, IOException> consumer, TriFunction<String, Object, SearchRequest, Boolean> extraParamParser, Optional<Boolean> crossProjectEnabled, @Nullable String projectRouting) throws IOException {
        String[] indices = Strings.splitStringByCommaToArray(request.param("index"));
        String searchType = request.param("search_type");
        boolean ccsMinimizeRoundtrips = SearchParamsParser.parseCcsMinimizeRoundtrips(crossProjectEnabled, request);
        String routing = request.param("routing");
        Tuple<XContentType, ReleasableBytesReference> sourceTuple = request.contentOrSourceParam();
        XContent xContent = ((XContentType)sourceTuple.v1()).xContent();
        ReleasableBytesReference data = (ReleasableBytesReference)sourceTuple.v2();
        MultiSearchRequest.readMultiLineFormat(xContent, request.contentParserConfig(), data, consumer, indices, indicesOptions, routing, searchType, ccsMinimizeRoundtrips, allowExplicitIndex, extraParamParser, crossProjectEnabled, projectRouting);
    }

    @Override
    public boolean mediaTypesValid(RestRequest request) {
        return super.mediaTypesValid(request) && XContentType.supportsDelimitedBulkRequests((XContentType)request.getXContentType());
    }

    @Override
    protected Set<String> responseParams() {
        return RESPONSE_PARAMS;
    }
}

