/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.search;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.CheckedConsumer;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.Scope;
import org.elasticsearch.rest.ServerlessScope;
import org.elasticsearch.rest.action.RestActions;
import org.elasticsearch.rest.action.RestBuilderListener;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

@ServerlessScope(value=Scope.PUBLIC)
public class RestCountAction
extends BaseRestHandler {
    private Settings settings;

    public RestCountAction(Settings settings) {
        this.settings = settings;
    }

    @Override
    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.GET, "/_count"), new RestHandler.Route(RestRequest.Method.POST, "/_count"), new RestHandler.Route(RestRequest.Method.GET, "/{index}/_count"), new RestHandler.Route(RestRequest.Method.POST, "/{index}/_count"));
    }

    @Override
    public String getName() {
        return "count_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(final RestRequest request, NodeClient client) throws IOException {
        if (this.settings != null && this.settings.getAsBoolean("serverless.cross_project.enabled", false).booleanValue()) {
            request.param("project_routing");
        }
        SearchRequest countRequest = new SearchRequest(Strings.splitStringByCommaToArray(request.param("index")));
        countRequest.indicesOptions(IndicesOptions.fromRequest(request, countRequest.indicesOptions()));
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().size(0).trackTotalHits(true);
        countRequest.source(searchSourceBuilder);
        request.withContentOrSourceParamParserOrNull((CheckedConsumer<XContentParser, IOException>)((CheckedConsumer)parser -> {
            if (parser == null) {
                QueryBuilder queryBuilder = RestActions.urlParamsToQueryBuilder(request);
                if (queryBuilder != null) {
                    searchSourceBuilder.query(queryBuilder);
                }
            } else {
                searchSourceBuilder.query(RestActions.getQueryContent(parser));
            }
        }));
        countRequest.routing(request.param("routing"));
        float minScore = request.paramAsFloat("min_score", -1.0f);
        if (minScore != -1.0f) {
            searchSourceBuilder.minScore(minScore);
        }
        countRequest.preference(request.param("preference"));
        final int terminateAfter = request.paramAsInt("terminate_after", 0);
        searchSourceBuilder.terminateAfter(terminateAfter);
        return channel -> client.search(countRequest, (ActionListener<SearchResponse>)new RestBuilderListener<SearchResponse>(this, channel){

            @Override
            public RestResponse buildResponse(SearchResponse response, XContentBuilder builder) throws Exception {
                builder.startObject();
                if (terminateAfter != 0) {
                    builder.field("terminated_early", response.isTerminatedEarly());
                }
                builder.field("count", response.getHits().getTotalHits().value());
                RestActions.buildBroadcastShardsHeader(builder, request, response.getTotalShards(), response.getSuccessfulShards(), 0, response.getFailedShards(), response.getShardFailures());
                builder.endObject();
                return new RestResponse(response.status(), builder);
            }
        });
    }
}

