/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices.recovery;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.LegacyActionRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.shard.ShardId;

public class StatelessUnpromotableRelocationAction {
    public static final ActionType<ActionResponse.Empty> TYPE = new ActionType("internal:index/shard/recovery/stateless_unpromotable_relocation");

    public static class Request
    extends LegacyActionRequest {
        private final long recoveryId;
        private final ShardId shardId;
        private final String targetAllocationId;
        private final long clusterStateVersion;

        public Request(long recoveryId, ShardId shardId, String targetAllocationId, long clusterStateVersion) {
            this.recoveryId = recoveryId;
            this.shardId = shardId;
            this.targetAllocationId = targetAllocationId;
            this.clusterStateVersion = clusterStateVersion;
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.recoveryId = in.readVLong();
            this.shardId = new ShardId(in);
            this.targetAllocationId = in.readString();
            this.clusterStateVersion = in.readVLong();
        }

        @Override
        public ActionRequestValidationException validate() {
            return null;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeVLong(this.recoveryId);
            this.shardId.writeTo(out);
            out.writeString(this.targetAllocationId);
            out.writeVLong(this.clusterStateVersion);
        }

        public long getRecoveryId() {
            return this.recoveryId;
        }

        public ShardId getShardId() {
            return this.shardId;
        }

        public long getClusterStateVersion() {
            return this.clusterStateVersion;
        }

        public String getTargetAllocationId() {
            return this.targetAllocationId;
        }

        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Request request = (Request)o;
            return this.recoveryId == request.recoveryId && this.clusterStateVersion == request.clusterStateVersion && Objects.equals(this.shardId, request.shardId) && Objects.equals(this.targetAllocationId, request.targetAllocationId);
        }

        public int hashCode() {
            return Objects.hash(this.recoveryId, this.shardId, this.targetAllocationId, this.clusterStateVersion);
        }
    }
}

