/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.vectors;

import java.io.IOException;
import java.util.function.Supplier;
import org.apache.lucene.index.LeafReaderContext;
import org.elasticsearch.core.CheckedFunction;
import org.elasticsearch.index.mapper.SourceLoader;

public class SyntheticVectorsPatchFieldLoader<T extends SourceLoader.SyntheticFieldLoader>
implements SourceLoader.SyntheticVectorsLoader {
    private final Supplier<T> syntheticLoaderSupplier;
    private final CheckedFunction<T, Object, IOException> copyObject;

    public SyntheticVectorsPatchFieldLoader(Supplier<T> syntheticLoaderSupplier, CheckedFunction<T, Object, IOException> copyObject) {
        this.syntheticLoaderSupplier = syntheticLoaderSupplier;
        this.copyObject = copyObject;
    }

    @Override
    public SourceLoader.SyntheticVectorsLoader.Leaf leaf(LeafReaderContext context) throws IOException {
        SourceLoader.SyntheticFieldLoader syntheticLoader = (SourceLoader.SyntheticFieldLoader)this.syntheticLoaderSupplier.get();
        SourceLoader.SyntheticFieldLoader.DocValuesLoader dvLoader = syntheticLoader.docValuesLoader(context.reader(), null);
        return (doc, acc) -> {
            if (dvLoader == null) {
                return;
            }
            if (dvLoader.advanceToDoc(doc) && syntheticLoader.hasValue()) {
                acc.add(new SourceLoader.LeafSyntheticVectorPath(syntheticLoader.fieldName(), this.copyObject.apply((Object)syntheticLoader)));
            }
        };
    }
}

