/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.FieldMemoryStats;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.XContentBuilder;

public class FieldDataStats
implements Writeable,
ToXContentFragment {
    private static final String FIELDDATA = "fielddata";
    private static final String MEMORY_SIZE = "memory_size";
    private static final String MEMORY_SIZE_IN_BYTES = "memory_size_in_bytes";
    private static final String EVICTIONS = "evictions";
    private static final String FIELDS = "fields";
    private static final String GLOBAL_ORDINALS = "global_ordinals";
    private static final String SHARD_MAX_VALUE_COUNT = "shard_max_value_count";
    private static final String BUILD_TIME = "build_time";
    private long memorySize;
    private long evictions;
    @Nullable
    private FieldMemoryStats fields;
    private final GlobalOrdinalsStats globalOrdinalsStats;

    public FieldDataStats() {
        this.globalOrdinalsStats = new GlobalOrdinalsStats(0L, null);
    }

    public FieldDataStats(StreamInput in) throws IOException {
        this.memorySize = in.readVLong();
        this.evictions = in.readVLong();
        this.fields = in.readOptionalWriteable(FieldMemoryStats::new);
        long buildTimeMillis = in.readVLong();
        Map<String, GlobalOrdinalsStats.GlobalOrdinalFieldStats> fieldGlobalOrdinalsStats = null;
        if (in.readBoolean()) {
            fieldGlobalOrdinalsStats = in.readMap(in1 -> new GlobalOrdinalsStats.GlobalOrdinalFieldStats(in1.readVLong(), in1.readVLong()));
        }
        this.globalOrdinalsStats = new GlobalOrdinalsStats(buildTimeMillis, fieldGlobalOrdinalsStats);
    }

    public FieldDataStats(long memorySize, long evictions, @Nullable FieldMemoryStats fields, GlobalOrdinalsStats globalOrdinalsStats) {
        this.memorySize = memorySize;
        this.evictions = evictions;
        this.fields = fields;
        this.globalOrdinalsStats = Objects.requireNonNull(globalOrdinalsStats);
    }

    public void add(FieldDataStats stats) {
        if (stats == null) {
            return;
        }
        this.memorySize += stats.memorySize;
        this.evictions += stats.evictions;
        if (stats.fields != null) {
            if (this.fields == null) {
                this.fields = stats.fields.copy();
            } else {
                this.fields.add(stats.fields);
            }
        }
        this.globalOrdinalsStats.add(stats.globalOrdinalsStats);
    }

    public long getMemorySizeInBytes() {
        return this.memorySize;
    }

    public ByteSizeValue getMemorySize() {
        return ByteSizeValue.ofBytes(this.memorySize);
    }

    public long getEvictions() {
        return this.evictions;
    }

    @Nullable
    public FieldMemoryStats getFields() {
        return this.fields;
    }

    public GlobalOrdinalsStats getGlobalOrdinalsStats() {
        return this.globalOrdinalsStats;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVLong(this.memorySize);
        out.writeVLong(this.evictions);
        out.writeOptionalWriteable(this.fields);
        out.writeVLong(this.globalOrdinalsStats.buildTimeMillis);
        if (this.globalOrdinalsStats.fieldGlobalOrdinalsStats != null) {
            out.writeBoolean(true);
            out.writeMap(this.globalOrdinalsStats.fieldGlobalOrdinalsStats, (out1, value) -> {
                out1.writeVLong(value.totalBuildingTime);
                out1.writeVLong(value.valueCount);
            });
        } else {
            out.writeBoolean(false);
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(FIELDDATA);
        builder.humanReadableField(MEMORY_SIZE_IN_BYTES, MEMORY_SIZE, (Object)this.getMemorySize());
        builder.field(EVICTIONS, this.getEvictions());
        if (this.fields != null) {
            this.fields.toXContent(builder, FIELDS, MEMORY_SIZE_IN_BYTES, MEMORY_SIZE);
        }
        builder.startObject(GLOBAL_ORDINALS);
        builder.humanReadableField("build_time_in_millis", BUILD_TIME, (Object)new TimeValue(this.globalOrdinalsStats.buildTimeMillis));
        if (this.globalOrdinalsStats.fieldGlobalOrdinalsStats != null) {
            builder.startObject(FIELDS);
            for (Map.Entry<String, GlobalOrdinalsStats.GlobalOrdinalFieldStats> entry : this.globalOrdinalsStats.fieldGlobalOrdinalsStats.entrySet()) {
                builder.startObject(entry.getKey());
                builder.humanReadableField("build_time_in_millis", BUILD_TIME, (Object)new TimeValue(entry.getValue().totalBuildingTime));
                builder.field(SHARD_MAX_VALUE_COUNT, entry.getValue().valueCount);
                builder.endObject();
            }
            builder.endObject();
        }
        builder.endObject();
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FieldDataStats that = (FieldDataStats)o;
        return this.memorySize == that.memorySize && this.evictions == that.evictions && Objects.equals(this.fields, that.fields) && Objects.equals(this.globalOrdinalsStats, that.globalOrdinalsStats);
    }

    public int hashCode() {
        return Objects.hash(this.memorySize, this.evictions, this.fields, this.globalOrdinalsStats);
    }

    public static class GlobalOrdinalsStats {
        private long buildTimeMillis;
        @Nullable
        private Map<String, GlobalOrdinalFieldStats> fieldGlobalOrdinalsStats;

        public GlobalOrdinalsStats(long buildTimeMillis, Map<String, GlobalOrdinalFieldStats> fieldGlobalOrdinalsStats) {
            this.buildTimeMillis = buildTimeMillis;
            this.fieldGlobalOrdinalsStats = fieldGlobalOrdinalsStats;
        }

        public long getBuildTimeMillis() {
            return this.buildTimeMillis;
        }

        @Nullable
        public Map<String, GlobalOrdinalFieldStats> getFieldGlobalOrdinalsStats() {
            return this.fieldGlobalOrdinalsStats;
        }

        void add(GlobalOrdinalsStats other) {
            this.buildTimeMillis += other.buildTimeMillis;
            if (this.fieldGlobalOrdinalsStats != null && other.fieldGlobalOrdinalsStats != null) {
                for (Map.Entry<String, GlobalOrdinalFieldStats> entry : other.fieldGlobalOrdinalsStats.entrySet()) {
                    this.fieldGlobalOrdinalsStats.merge(entry.getKey(), entry.getValue(), (value1, value2) -> new GlobalOrdinalFieldStats(value1.totalBuildingTime + value2.totalBuildingTime, Math.max(value1.valueCount, value2.valueCount)));
                }
            } else if (other.fieldGlobalOrdinalsStats != null) {
                this.fieldGlobalOrdinalsStats = other.fieldGlobalOrdinalsStats;
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            GlobalOrdinalsStats that = (GlobalOrdinalsStats)o;
            return this.buildTimeMillis == that.buildTimeMillis && Objects.equals(this.fieldGlobalOrdinalsStats, that.fieldGlobalOrdinalsStats);
        }

        public int hashCode() {
            return Objects.hash(this.buildTimeMillis, this.fieldGlobalOrdinalsStats);
        }

        public record GlobalOrdinalFieldStats(long totalBuildingTime, long valueCount) {
        }
    }
}

