/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.codec.vectors.es93;

import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import org.apache.lucene.codecs.KnnVectorsFormat;
import org.apache.lucene.codecs.KnnVectorsReader;
import org.apache.lucene.codecs.KnnVectorsWriter;
import org.apache.lucene.codecs.hnsw.FlatVectorScorerUtil;
import org.apache.lucene.codecs.hnsw.FlatVectorsFormat;
import org.apache.lucene.codecs.hnsw.FlatVectorsReader;
import org.apache.lucene.codecs.hnsw.FlatVectorsScorer;
import org.apache.lucene.codecs.hnsw.ScalarQuantizedVectorScorer;
import org.apache.lucene.codecs.lucene99.Lucene99ScalarQuantizedVectorsReader;
import org.apache.lucene.codecs.lucene99.Lucene99ScalarQuantizedVectorsWriter;
import org.apache.lucene.index.ByteVectorValues;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FloatVectorValues;
import org.apache.lucene.index.KnnVectorValues;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.index.VectorSimilarityFunction;
import org.apache.lucene.search.AcceptDocs;
import org.apache.lucene.search.KnnCollector;
import org.apache.lucene.util.hnsw.RandomVectorScorer;
import org.apache.lucene.util.hnsw.RandomVectorScorerSupplier;
import org.apache.lucene.util.quantization.QuantizedByteVectorValues;
import org.elasticsearch.index.codec.vectors.VectorScoringUtils;
import org.elasticsearch.index.codec.vectors.es93.ES93GenericFlatVectorsFormat;
import org.elasticsearch.index.mapper.vectors.DenseVectorFieldMapper;
import org.elasticsearch.simdvec.VectorScorerFactory;
import org.elasticsearch.simdvec.VectorSimilarityType;

public class ES93ScalarQuantizedVectorsFormat
extends KnnVectorsFormat {
    static final String NAME = "ES93ScalarQuantizedVectorsFormat";
    private static final int ALLOWED_BITS = 144;
    static final FlatVectorsScorer flatVectorScorer = new ESQuantizedFlatVectorsScorer((FlatVectorsScorer)new ScalarQuantizedVectorScorer(FlatVectorScorerUtil.getLucene99FlatVectorsScorer()));
    private static final float MINIMUM_CONFIDENCE_INTERVAL = 0.9f;
    private static final float MAXIMUM_CONFIDENCE_INTERVAL = 1.0f;
    private final FlatVectorsFormat rawVectorFormat;
    public final Float confidenceInterval;
    private final byte bits;
    private final boolean compress;

    public ES93ScalarQuantizedVectorsFormat() {
        this(DenseVectorFieldMapper.ElementType.FLOAT, null, 7, false);
    }

    public ES93ScalarQuantizedVectorsFormat(DenseVectorFieldMapper.ElementType elementType) {
        this(elementType, null, 7, false);
    }

    public ES93ScalarQuantizedVectorsFormat(DenseVectorFieldMapper.ElementType elementType, Float confidenceInterval, int bits, boolean compress) {
        super(NAME);
        if (confidenceInterval != null && confidenceInterval.floatValue() != 0.0f && (confidenceInterval.floatValue() < 0.9f || confidenceInterval.floatValue() > 1.0f)) {
            throw new IllegalArgumentException("confidenceInterval must be between 0.9 and 1.0; confidenceInterval=" + confidenceInterval);
        }
        if (bits < 1 || bits > 8 || (0x90 & 1 << bits) == 0) {
            throw new IllegalArgumentException("bits must be one of: 4, 7; bits=" + bits);
        }
        assert (elementType != DenseVectorFieldMapper.ElementType.BIT) : "BIT should not be used with scalar quantization";
        this.rawVectorFormat = new ES93GenericFlatVectorsFormat(elementType, false);
        this.confidenceInterval = confidenceInterval;
        this.bits = (byte)bits;
        this.compress = compress;
    }

    public KnnVectorsWriter fieldsWriter(SegmentWriteState state) throws IOException {
        return new Lucene99ScalarQuantizedVectorsWriter(state, this.confidenceInterval, this.bits, this.compress, this.rawVectorFormat.fieldsWriter(state), flatVectorScorer);
    }

    public KnnVectorsReader fieldsReader(SegmentReadState state) throws IOException {
        return new ES93FlatVectorReader((FlatVectorsReader)new Lucene99ScalarQuantizedVectorsReader(state, this.rawVectorFormat.fieldsReader(state), flatVectorScorer));
    }

    public int getMaxDimensions(String fieldName) {
        return 4096;
    }

    public String toString() {
        return "ES93ScalarQuantizedVectorsFormat(name=ES93ScalarQuantizedVectorsFormat, confidenceInterval=" + this.confidenceInterval + ", bits=" + this.bits + ", compressed=" + this.compress + ", flatVectorScorer=" + String.valueOf(flatVectorScorer) + ", rawVectorFormat=" + String.valueOf(this.rawVectorFormat) + ")";
    }

    static class ES93FlatVectorReader
    extends KnnVectorsReader {
        private final FlatVectorsReader reader;

        ES93FlatVectorReader(FlatVectorsReader reader) {
            this.reader = reader;
        }

        public void checkIntegrity() throws IOException {
            this.reader.checkIntegrity();
        }

        public FloatVectorValues getFloatVectorValues(String field) throws IOException {
            return this.reader.getFloatVectorValues(field);
        }

        public ByteVectorValues getByteVectorValues(String field) throws IOException {
            return this.reader.getByteVectorValues(field);
        }

        public void search(String field, float[] target, KnnCollector knnCollector, AcceptDocs acceptDocs) throws IOException {
            VectorScoringUtils.scoreAndCollectAll(knnCollector, acceptDocs, this.reader.getRandomVectorScorer(field, target));
        }

        public void search(String field, byte[] target, KnnCollector knnCollector, AcceptDocs acceptDocs) throws IOException {
            VectorScoringUtils.scoreAndCollectAll(knnCollector, acceptDocs, this.reader.getRandomVectorScorer(field, target));
        }

        public Map<String, Long> getOffHeapByteSize(FieldInfo fieldInfo) {
            return this.reader.getOffHeapByteSize(fieldInfo);
        }

        public void close() throws IOException {
            this.reader.close();
        }
    }

    static final class ESQuantizedFlatVectorsScorer
    implements FlatVectorsScorer {
        final FlatVectorsScorer delegate;
        final VectorScorerFactory factory;

        ESQuantizedFlatVectorsScorer(FlatVectorsScorer delegate) {
            this.delegate = delegate;
            this.factory = VectorScorerFactory.instance().orElse(null);
        }

        public String toString() {
            return "ESQuantizedFlatVectorsScorer(delegate=" + String.valueOf(this.delegate) + ", factory=" + String.valueOf(this.factory) + ")";
        }

        public RandomVectorScorerSupplier getRandomVectorScorerSupplier(VectorSimilarityFunction sim, KnnVectorValues values) throws IOException {
            QuantizedByteVectorValues qValues;
            if (values instanceof QuantizedByteVectorValues && (qValues = (QuantizedByteVectorValues)values).getSlice() != null) {
                Optional scorer;
                if (qValues.getScalarQuantizer().getBits() != 7) {
                    return this.delegate.getRandomVectorScorerSupplier(sim, values);
                }
                if (this.factory != null && (scorer = this.factory.getInt7SQVectorScorerSupplier(VectorSimilarityType.of((VectorSimilarityFunction)sim), qValues.getSlice(), qValues, qValues.getScalarQuantizer().getConstantMultiplier())).isPresent()) {
                    return (RandomVectorScorerSupplier)scorer.get();
                }
            }
            return this.delegate.getRandomVectorScorerSupplier(sim, values);
        }

        public RandomVectorScorer getRandomVectorScorer(VectorSimilarityFunction sim, KnnVectorValues values, float[] query) throws IOException {
            QuantizedByteVectorValues qValues;
            if (values instanceof QuantizedByteVectorValues && (qValues = (QuantizedByteVectorValues)values).getSlice() != null) {
                Optional scorer;
                if (qValues.getScalarQuantizer().getBits() != 7) {
                    return this.delegate.getRandomVectorScorer(sim, values, query);
                }
                if (this.factory != null && (scorer = this.factory.getInt7SQVectorScorer(sim, qValues, query)).isPresent()) {
                    return (RandomVectorScorer)scorer.get();
                }
            }
            return this.delegate.getRandomVectorScorer(sim, values, query);
        }

        public RandomVectorScorer getRandomVectorScorer(VectorSimilarityFunction sim, KnnVectorValues values, byte[] query) throws IOException {
            return this.delegate.getRandomVectorScorer(sim, values, query);
        }
    }
}

