/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.codec.vectors.es93;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.hnsw.FlatFieldVectorsWriter;
import org.apache.lucene.codecs.hnsw.FlatVectorsWriter;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.MergeState;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.index.Sorter;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.hnsw.CloseableRandomVectorScorerSupplier;
import org.elasticsearch.core.IOUtils;
import org.elasticsearch.index.codec.vectors.es93.GenericFormatMetaInformation;

class ES93GenericFlatVectorsWriter
extends FlatVectorsWriter {
    private final String rawVectorFormatName;
    private final boolean useDirectIOReads;
    private final FlatVectorsWriter rawVectorWriter;
    private final IndexOutput metaOut;
    private final List<Integer> fieldNumbers = new ArrayList<Integer>();

    ES93GenericFlatVectorsWriter(GenericFormatMetaInformation metaInfo, String rawVectorsFormatName, boolean useDirectIOReads, SegmentWriteState state, FlatVectorsWriter rawWriter) throws IOException {
        super(rawWriter.getFlatVectorScorer());
        this.rawVectorFormatName = rawVectorsFormatName;
        this.useDirectIOReads = useDirectIOReads;
        this.rawVectorWriter = rawWriter;
        String metaFileName = IndexFileNames.segmentFileName((String)state.segmentInfo.name, (String)state.segmentSuffix, (String)metaInfo.extension());
        try {
            this.metaOut = state.directory.createOutput(metaFileName, state.context);
            CodecUtil.writeIndexHeader((DataOutput)this.metaOut, (String)metaInfo.codecName(), (int)metaInfo.versionCurrent(), (byte[])state.segmentInfo.getId(), (String)state.segmentSuffix);
        }
        catch (Throwable t) {
            IOUtils.closeWhileHandlingException((Closeable)((Object)this));
            throw t;
        }
    }

    public FlatFieldVectorsWriter<?> addField(FieldInfo fieldInfo) throws IOException {
        FlatFieldVectorsWriter writer = this.rawVectorWriter.addField(fieldInfo);
        this.fieldNumbers.add(fieldInfo.number);
        return writer;
    }

    public void mergeOneField(FieldInfo fieldInfo, MergeState mergeState) throws IOException {
        this.rawVectorWriter.mergeOneField(fieldInfo, mergeState);
        this.writeMeta(fieldInfo.number);
    }

    public CloseableRandomVectorScorerSupplier mergeOneFieldToIndex(FieldInfo fieldInfo, MergeState mergeState) throws IOException {
        CloseableRandomVectorScorerSupplier supplier = this.rawVectorWriter.mergeOneFieldToIndex(fieldInfo, mergeState);
        this.writeMeta(fieldInfo.number);
        return supplier;
    }

    public void flush(int maxDoc, Sorter.DocMap sortMap) throws IOException {
        this.rawVectorWriter.flush(maxDoc, sortMap);
        for (Integer field : this.fieldNumbers) {
            this.writeMeta(field);
        }
    }

    private void writeMeta(int field) throws IOException {
        this.metaOut.writeInt(field);
        this.metaOut.writeString(this.rawVectorFormatName);
        this.metaOut.writeByte(this.useDirectIOReads ? (byte)1 : 0);
    }

    public void finish() throws IOException {
        this.rawVectorWriter.finish();
        if (this.metaOut != null) {
            this.metaOut.writeInt(-1);
            CodecUtil.writeFooter((IndexOutput)this.metaOut);
        }
    }

    public void close() throws IOException {
        IOUtils.close((Closeable[])new Closeable[]{this.metaOut, this.rawVectorWriter});
    }

    public long ramBytesUsed() {
        return this.rawVectorWriter.ramBytesUsed();
    }
}

