/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.codec.tsdb.es819;

import java.io.Closeable;
import java.io.IOException;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.DocValuesProducer;
import org.apache.lucene.codecs.compressing.Decompressor;
import org.apache.lucene.codecs.lucene90.IndexedDISI;
import org.apache.lucene.index.BaseTermsEnum;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.DocValuesSkipIndexType;
import org.apache.lucene.index.DocValuesSkipper;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.ImpactsEnum;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.internal.hppc.IntObjectHashMap;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.store.ByteArrayDataInput;
import org.apache.lucene.store.ChecksumIndexInput;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.RandomAccessInput;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.GroupVIntUtil;
import org.apache.lucene.util.LongValues;
import org.apache.lucene.util.compress.LZ4;
import org.apache.lucene.util.packed.DirectMonotonicReader;
import org.apache.lucene.util.packed.PackedInts;
import org.elasticsearch.core.Assertions;
import org.elasticsearch.core.IOUtils;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.codec.tsdb.BinaryDVCompressionMode;
import org.elasticsearch.index.codec.tsdb.TSDBDocValuesEncoder;
import org.elasticsearch.index.codec.tsdb.es819.ES819TSDBDocValuesFormat;
import org.elasticsearch.index.mapper.BlockLoader;
import org.elasticsearch.index.mapper.blockloader.docvalues.BlockDocValuesReader;

final class ES819TSDBDocValuesProducer
extends DocValuesProducer {
    final IntObjectHashMap<NumericEntry> numerics;
    private final int primarySortFieldNumber;
    final IntObjectHashMap<BinaryEntry> binaries;
    final IntObjectHashMap<SortedEntry> sorted;
    final IntObjectHashMap<SortedSetEntry> sortedSets;
    final IntObjectHashMap<SortedNumericEntry> sortedNumerics;
    private final IntObjectHashMap<DocValuesSkipperEntry> skippers;
    private final IndexInput data;
    private final int maxDoc;
    final int version;
    private final boolean merging;
    private final int numericBlockShift;
    private final int numericBlockSize;
    private final int numericBlockMask;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ES819TSDBDocValuesProducer(SegmentReadState state, String dataCodec, String dataExtension, String metaCodec, String metaExtension) throws IOException {
        int blockShift;
        int version;
        block17: {
            this.numerics = new IntObjectHashMap();
            this.binaries = new IntObjectHashMap();
            this.sorted = new IntObjectHashMap();
            this.sortedSets = new IntObjectHashMap();
            this.sortedNumerics = new IntObjectHashMap();
            this.skippers = new IntObjectHashMap();
            this.maxDoc = state.segmentInfo.maxDoc();
            this.primarySortFieldNumber = ES819TSDBDocValuesProducer.primarySortFieldNumber(state.segmentInfo, state.fieldInfos);
            this.merging = false;
            version = -1;
            blockShift = 7;
            String metaName = IndexFileNames.segmentFileName((String)state.segmentInfo.name, (String)state.segmentSuffix, (String)metaExtension);
            try (ChecksumIndexInput in = state.directory.openChecksumInput(metaName);){
                Throwable priorE = null;
                try {
                    version = CodecUtil.checkIndexHeader((DataInput)in, (String)metaCodec, (int)0, (int)2, (byte[])state.segmentInfo.getId(), (String)state.segmentSuffix);
                    if (version >= 2) {
                        blockShift = in.readByte();
                    }
                    this.readFields((IndexInput)in, state.fieldInfos, version, blockShift);
                }
                catch (Throwable exception) {
                    try {
                        priorE = exception;
                        break block17;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        CodecUtil.checkFooter((ChecksumIndexInput)in, (Throwable)priorE);
                    }
                }
                CodecUtil.checkFooter((ChecksumIndexInput)in, (Throwable)priorE);
            }
        }
        this.numericBlockShift = blockShift;
        this.numericBlockSize = 1 << blockShift;
        this.numericBlockMask = this.numericBlockSize - 1;
        String dataName = IndexFileNames.segmentFileName((String)state.segmentInfo.name, (String)state.segmentSuffix, (String)dataExtension);
        this.data = state.directory.openInput(dataName, state.context);
        boolean success = false;
        try {
            int version2 = CodecUtil.checkIndexHeader((DataInput)this.data, (String)dataCodec, (int)0, (int)2, (byte[])state.segmentInfo.getId(), (String)state.segmentSuffix);
            if (version != version2) {
                throw new CorruptIndexException("Format versions mismatch: meta=" + version + ", data=" + version2, (DataInput)this.data);
            }
            CodecUtil.retrieveChecksum((IndexInput)this.data);
            success = true;
            this.version = version;
        }
        finally {
            if (!success) {
                IOUtils.closeWhileHandlingException((Closeable)this.data);
            }
        }
    }

    private ES819TSDBDocValuesProducer(IntObjectHashMap<NumericEntry> numerics, IntObjectHashMap<BinaryEntry> binaries, IntObjectHashMap<SortedEntry> sorted, IntObjectHashMap<SortedSetEntry> sortedSets, IntObjectHashMap<SortedNumericEntry> sortedNumerics, IntObjectHashMap<DocValuesSkipperEntry> skippers, IndexInput data, int maxDoc, int version, int primarySortFieldNumber, boolean merging, int numericBlockShift) {
        this.numerics = numerics;
        this.binaries = binaries;
        this.sorted = sorted;
        this.sortedSets = sortedSets;
        this.sortedNumerics = sortedNumerics;
        this.skippers = skippers;
        this.data = data.clone();
        this.maxDoc = maxDoc;
        this.version = version;
        this.primarySortFieldNumber = primarySortFieldNumber;
        this.merging = merging;
        this.numericBlockShift = numericBlockShift;
        this.numericBlockSize = 1 << numericBlockShift;
        this.numericBlockMask = this.numericBlockSize - 1;
    }

    public DocValuesProducer getMergeInstance() {
        return new ES819TSDBDocValuesProducer(this.numerics, this.binaries, this.sorted, this.sortedSets, this.sortedNumerics, this.skippers, this.data, this.maxDoc, this.version, this.primarySortFieldNumber, true, this.numericBlockShift);
    }

    public NumericDocValues getNumeric(FieldInfo field) throws IOException {
        NumericEntry entry = (NumericEntry)this.numerics.get(field.number);
        return this.getNumeric(entry, -1L);
    }

    public BinaryDocValues getBinary(FieldInfo field) throws IOException {
        BinaryEntry entry = (BinaryEntry)this.binaries.get(field.number);
        if (entry.docsWithFieldOffset == -2L) {
            return DocValues.emptyBinary();
        }
        return switch (entry.compression) {
            case BinaryDVCompressionMode.NO_COMPRESS -> this.getUncompressedBinary(entry);
            default -> this.getCompressedBinary(entry);
        };
    }

    public BinaryDocValues getUncompressedBinary(final BinaryEntry entry) throws IOException {
        final RandomAccessInput bytesSlice = this.data.randomAccessSlice(entry.dataOffset, entry.dataLength);
        if (entry.docsWithFieldOffset == -1L) {
            if (entry.minLength == entry.maxLength) {
                final int length = entry.maxLength;
                return new DenseBinaryDocValues(this, this.maxDoc){
                    final BytesRef bytes;
                    {
                        super(maxDoc);
                        this.bytes = new BytesRef(new byte[length], 0, length);
                    }

                    public BytesRef binaryValue() throws IOException {
                        bytesSlice.readBytes((long)this.doc * (long)length, this.bytes.bytes, 0, length);
                        return this.bytes;
                    }

                    @Override
                    public BlockLoader.Block tryRead(BlockLoader.BlockFactory factory, BlockLoader.Docs docs, int offset, boolean nullsFiltered, BlockDocValuesReader.ToDouble toDouble, boolean toInt) throws IOException {
                        int lastDocId;
                        int count = docs.count() - offset;
                        int firstDocId = docs.get(offset);
                        this.doc = lastDocId = docs.get(count - 1);
                        if (ES819TSDBDocValuesProducer.isDense(firstDocId, lastDocId, count)) {
                            try (BlockLoader.SingletonBytesRefBuilder builder = factory.singletonBytesRefs(count);){
                                int bulkLength = length * count;
                                byte[] bytes = new byte[bulkLength];
                                bytesSlice.readBytes((long)firstDocId * (long)length, bytes, 0, bulkLength);
                                builder.appendBytesRefs(bytes, length);
                                BlockLoader.Block block = builder.build();
                                return block;
                            }
                        }
                        try (BlockLoader.BytesRefBuilder builder = factory.bytesRefs(count);){
                            for (int i = offset; i < docs.count(); ++i) {
                                int docId = docs.get(i);
                                bytesSlice.readBytes((long)docId * (long)length, this.bytes.bytes, 0, length);
                                builder.appendBytesRef(this.bytes);
                            }
                            BlockLoader.Block block = builder.build();
                            return block;
                        }
                    }
                };
            }
            RandomAccessInput addressesData = this.data.randomAccessSlice(entry.addressesOffset, entry.addressesLength);
            DirectMonotonicReader addresses = DirectMonotonicReader.getInstance((DirectMonotonicReader.Meta)entry.addressesMeta, (RandomAccessInput)addressesData, (boolean)this.merging);
            return new DenseBinaryDocValues(this, this.maxDoc, (LongValues)addresses, bytesSlice){
                final BytesRef bytes;
                final /* synthetic */ LongValues val$addresses;
                final /* synthetic */ RandomAccessInput val$bytesSlice;
                {
                    this.val$addresses = longValues;
                    this.val$bytesSlice = randomAccessInput;
                    super(maxDoc);
                    this.bytes = new BytesRef(new byte[entry.maxLength], 0, entry.maxLength);
                }

                public BytesRef binaryValue() throws IOException {
                    long startOffset = this.val$addresses.get((long)this.doc);
                    this.bytes.length = (int)(this.val$addresses.get((long)this.doc + 1L) - startOffset);
                    this.val$bytesSlice.readBytes(startOffset, this.bytes.bytes, 0, this.bytes.length);
                    return this.bytes;
                }

                @Override
                public BlockLoader.Block tryRead(BlockLoader.BlockFactory factory, BlockLoader.Docs docs, int offset, boolean nullsFiltered, BlockDocValuesReader.ToDouble toDouble, boolean toInt) throws IOException {
                    int lastDocId;
                    int count = docs.count() - offset;
                    int firstDocId = docs.get(offset);
                    this.doc = lastDocId = docs.get(count - 1);
                    if (ES819TSDBDocValuesProducer.isDense(firstDocId, lastDocId, count)) {
                        try (BlockLoader.SingletonBytesRefBuilder builder = factory.singletonBytesRefs(count);){
                            long[] offsets = new long[count + 1];
                            long startOffset = this.val$addresses.get((long)firstDocId);
                            int i = offset;
                            int j = 1;
                            while (i < docs.count()) {
                                long nextOffset;
                                int docId = docs.get(i);
                                offsets[j] = nextOffset = this.val$addresses.get((long)(docId + 1)) - startOffset;
                                ++i;
                                ++j;
                            }
                            int length = Math.toIntExact(this.val$addresses.get((long)lastDocId + 1L) - startOffset);
                            byte[] bytes = new byte[length];
                            this.val$bytesSlice.readBytes(startOffset, bytes, 0, length);
                            builder.appendBytesRefs(bytes, offsets);
                            BlockLoader.Block block = builder.build();
                            return block;
                        }
                    }
                    try (BlockLoader.BytesRefBuilder builder = factory.bytesRefs(count);){
                        for (int i = offset; i < docs.count(); ++i) {
                            int docId = docs.get(i);
                            long startOffset = this.val$addresses.get((long)docId);
                            this.bytes.length = (int)(this.val$addresses.get((long)docId + 1L) - startOffset);
                            this.val$bytesSlice.readBytes(startOffset, this.bytes.bytes, 0, this.bytes.length);
                            builder.appendBytesRef(this.bytes);
                        }
                        BlockLoader.Block block = builder.build();
                        return block;
                    }
                }
            };
        }
        IndexedDISI disi = new IndexedDISI(this.data, entry.docsWithFieldOffset, entry.docsWithFieldLength, (int)entry.jumpTableEntryCount, entry.denseRankPower, (long)entry.numDocsWithField);
        if (entry.minLength == entry.maxLength) {
            final int length = entry.maxLength;
            return new SparseBinaryDocValues(this, disi){
                final BytesRef bytes;
                {
                    super(disi);
                    this.bytes = new BytesRef(new byte[length], 0, length);
                }

                public BytesRef binaryValue() throws IOException {
                    bytesSlice.readBytes((long)this.disi.index() * (long)length, this.bytes.bytes, 0, length);
                    return this.bytes;
                }
            };
        }
        RandomAccessInput addressesData = this.data.randomAccessSlice(entry.addressesOffset, entry.addressesLength);
        DirectMonotonicReader addresses = DirectMonotonicReader.getInstance((DirectMonotonicReader.Meta)entry.addressesMeta, (RandomAccessInput)addressesData, (boolean)this.merging);
        return new SparseBinaryDocValues(this, disi, (LongValues)addresses, bytesSlice){
            final BytesRef bytes;
            final /* synthetic */ LongValues val$addresses;
            final /* synthetic */ RandomAccessInput val$bytesSlice;
            {
                this.val$addresses = longValues;
                this.val$bytesSlice = randomAccessInput;
                super(disi);
                this.bytes = new BytesRef(new byte[entry.maxLength], 0, entry.maxLength);
            }

            public BytesRef binaryValue() throws IOException {
                int index = this.disi.index();
                long startOffset = this.val$addresses.get((long)index);
                this.bytes.length = (int)(this.val$addresses.get((long)index + 1L) - startOffset);
                this.val$bytesSlice.readBytes(startOffset, this.bytes.bytes, 0, this.bytes.length);
                return this.bytes;
            }
        };
    }

    private BinaryDocValues getCompressedBinary(final BinaryEntry entry) throws IOException {
        if (entry.docsWithFieldOffset == -1L) {
            RandomAccessInput addressesData = this.data.randomAccessSlice(entry.addressesOffset, entry.addressesLength);
            DirectMonotonicReader addresses = DirectMonotonicReader.getInstance((DirectMonotonicReader.Meta)entry.addressesMeta, (RandomAccessInput)addressesData);
            RandomAccessInput docOffsetsData = this.data.randomAccessSlice(entry.docOffsetsOffset, entry.docOffsetLength);
            DirectMonotonicReader docOffsets = DirectMonotonicReader.getInstance((DirectMonotonicReader.Meta)entry.docOffsetMeta, (RandomAccessInput)docOffsetsData);
            return new DenseBinaryDocValues(this.maxDoc, (LongValues)addresses, docOffsets){
                final BinaryDecoder decoder;
                final /* synthetic */ LongValues val$addresses;
                final /* synthetic */ DirectMonotonicReader val$docOffsets;
                {
                    this.val$addresses = longValues;
                    this.val$docOffsets = directMonotonicReader;
                    super(maxDoc);
                    this.decoder = new BinaryDecoder(entry.compression.compressionMode().newDecompressor(), this.val$addresses, this.val$docOffsets, ES819TSDBDocValuesProducer.this.data.clone(), entry.maxUncompressedChunkSize, entry.maxNumDocsInAnyBlock);
                }

                public BytesRef binaryValue() throws IOException {
                    return this.decoder.decode(this.doc, entry.numCompressedBlocks);
                }

                @Override
                public BlockLoader.Block tryRead(BlockLoader.BlockFactory factory, BlockLoader.Docs docs, int offset, boolean nullsFiltered, BlockDocValuesReader.ToDouble toDouble, boolean toInt) throws IOException {
                    int lastDocId;
                    int count = docs.count() - offset;
                    int firstDocId = docs.get(offset);
                    this.doc = lastDocId = docs.get(count - 1);
                    if (ES819TSDBDocValuesProducer.isDense(firstDocId, lastDocId, count)) {
                        try (BlockLoader.SingletonBytesRefBuilder builder = factory.singletonBytesRefs(count);){
                            this.decoder.decodeBulk(entry.numCompressedBlocks, firstDocId, count, builder);
                            BlockLoader.Block block = builder.build();
                            return block;
                        }
                    }
                    try (BlockLoader.BytesRefBuilder builder = factory.bytesRefs(count);){
                        for (int i = offset; i < docs.count(); ++i) {
                            builder.appendBytesRef(this.decoder.decode(docs.get(i), entry.numCompressedBlocks));
                        }
                        BlockLoader.Block block = builder.build();
                        return block;
                    }
                }
            };
        }
        IndexedDISI disi = new IndexedDISI(this.data, entry.docsWithFieldOffset, entry.docsWithFieldLength, (int)entry.jumpTableEntryCount, entry.denseRankPower, (long)entry.numDocsWithField);
        RandomAccessInput addressesData = this.data.randomAccessSlice(entry.addressesOffset, entry.addressesLength);
        DirectMonotonicReader addresses = DirectMonotonicReader.getInstance((DirectMonotonicReader.Meta)entry.addressesMeta, (RandomAccessInput)addressesData);
        RandomAccessInput docOffsetsData = this.data.randomAccessSlice(entry.docOffsetsOffset, entry.docOffsetLength);
        DirectMonotonicReader docOffsets = DirectMonotonicReader.getInstance((DirectMonotonicReader.Meta)entry.docOffsetMeta, (RandomAccessInput)docOffsetsData);
        return new SparseBinaryDocValues(disi, (LongValues)addresses, docOffsets){
            final BinaryDecoder decoder;
            final /* synthetic */ LongValues val$addresses;
            final /* synthetic */ DirectMonotonicReader val$docOffsets;
            {
                this.val$addresses = longValues;
                this.val$docOffsets = directMonotonicReader;
                super(disi);
                this.decoder = new BinaryDecoder(entry.compression.compressionMode().newDecompressor(), this.val$addresses, this.val$docOffsets, ES819TSDBDocValuesProducer.this.data.clone(), entry.maxUncompressedChunkSize, entry.maxNumDocsInAnyBlock);
            }

            public BytesRef binaryValue() throws IOException {
                return this.decoder.decode(this.disi.index(), entry.numCompressedBlocks);
            }
        };
    }

    public SortedDocValues getSorted(FieldInfo field) throws IOException {
        SortedEntry entry = (SortedEntry)this.sorted.get(field.number);
        return this.getSorted(entry, field.number == this.primarySortFieldNumber);
    }

    private SortedDocValues getSorted(SortedEntry entry, final boolean valuesSorted) throws IOException {
        if (entry.ordsEntry.docsWithFieldOffset == -2L) {
            return DocValues.emptySorted();
        }
        final NumericDocValues ords = this.getNumeric(entry.ordsEntry, entry.termsDictEntry.termsDictSize);
        return new BaseSortedDocValues(entry){

            public int ordValue() throws IOException {
                return (int)ords.longValue();
            }

            public boolean advanceExact(int target) throws IOException {
                return ords.advanceExact(target);
            }

            public int docID() {
                return ords.docID();
            }

            public int nextDoc() throws IOException {
                return ords.nextDoc();
            }

            public int advance(int target) throws IOException {
                return ords.advance(target);
            }

            public long cost() {
                return ords.cost();
            }

            public int docIDRunEnd() throws IOException {
                return ords.docIDRunEnd();
            }

            @Override
            public BlockLoader.Block tryRead(BlockLoader.BlockFactory factory, BlockLoader.Docs docs, int offset, boolean nullsFiltered, BlockDocValuesReader.ToDouble toDouble, boolean toInt) throws IOException {
                assert (toDouble == null);
                if (ords instanceof BaseDenseNumericValues) {
                    BaseDenseNumericValues denseOrds = (BaseDenseNumericValues)ords;
                    BlockLoader.Block block = this.tryReadAHead(factory, docs, offset);
                    if (block != null) {
                        return block;
                    }
                    try (BlockLoader.SingletonOrdinalsBuilder builder = factory.singletonOrdinalsBuilder(this, docs.count() - offset, true);){
                        SingletonLongToSingletonOrdinalDelegate delegate = new SingletonLongToSingletonOrdinalDelegate(builder, ES819TSDBDocValuesProducer.this.numericBlockSize);
                        BlockLoader.Block result = denseOrds.tryRead(delegate, docs, offset);
                        if (result != null) {
                            BlockLoader.Block block2 = result;
                            return block2;
                        }
                    }
                }
                return null;
            }

            @Override
            BlockLoader.Block tryReadAHead(BlockLoader.BlockFactory factory, BlockLoader.Docs docs, int offset) throws IOException {
                if (ords instanceof BaseDenseNumericValues) {
                    BaseDenseNumericValues denseOrds = (BaseDenseNumericValues)ords;
                    if (this.entry.termsDictEntry.termsDictSize == 1L) {
                        return factory.constantBytes(BytesRef.deepCopyOf((BytesRef)this.lookupOrd(0)), docs.count() - offset);
                    }
                    if (!valuesSorted) {
                        return null;
                    }
                    int firstDoc = docs.get(offset);
                    denseOrds.advanceExact(firstDoc);
                    int startValue = Math.toIntExact(denseOrds.longValue());
                    int docCount = docs.count();
                    int lastDoc = docs.get(docCount - 1);
                    int lastValue = Math.toIntExact(denseOrds.lookAheadValueAt(lastDoc));
                    if (lastValue == startValue) {
                        BytesRef b = this.lookupOrd(Math.toIntExact(startValue));
                        return factory.constantBytes(BytesRef.deepCopyOf((BytesRef)b), docCount - offset);
                    }
                    SortedOrdinalReader ordinalReader = denseOrds.sortedOrdinalReader();
                    if (ordinalReader != null) {
                        try (BlockLoader.SingletonOrdinalsBuilder builder = factory.singletonOrdinalsBuilder(this, docCount - offset, true);){
                            int docIndex = offset;
                            while (docIndex < docCount) {
                                int ord = Math.toIntExact(ordinalReader.readValueAndAdvance(docs.get(docIndex)));
                                if ((long)lastDoc < ordinalReader.rangeEndExclusive) {
                                    builder.appendOrds(ord, docCount - docIndex);
                                    break;
                                }
                                int startIndex = docIndex;
                                while (docIndex < docCount && (long)docs.get(docIndex) < ordinalReader.rangeEndExclusive) {
                                    ++docIndex;
                                }
                                builder.appendOrds(ord, docIndex - startIndex);
                            }
                            BlockLoader.Block block = builder.build();
                            return block;
                        }
                    }
                }
                return null;
            }
        };
    }

    public SortedNumericDocValues getSortedNumeric(FieldInfo field) throws IOException {
        SortedNumericEntry entry = (SortedNumericEntry)this.sortedNumerics.get(field.number);
        return this.getSortedNumeric(entry, -1L);
    }

    public SortedSetDocValues getSortedSet(FieldInfo field) throws IOException {
        SortedSetEntry entry = (SortedSetEntry)this.sortedSets.get(field.number);
        if (entry.singleValueEntry != null) {
            return DocValues.singleton((SortedDocValues)this.getSorted(entry.singleValueEntry, field.number == this.primarySortFieldNumber));
        }
        SortedNumericEntry ordsEntry = entry.ordsEntry;
        final SortedNumericDocValues ords = this.getSortedNumeric(ordsEntry, entry.termsDictEntry.termsDictSize);
        return new BaseSortedSetDocValues(this, entry, this.data, this.merging){
            int i;
            int count;
            boolean set;
            {
                super(entry, data, merging);
                this.i = 0;
                this.count = 0;
                this.set = false;
            }

            public long nextOrd() throws IOException {
                if (!this.set) {
                    this.set = true;
                    this.i = 0;
                    this.count = ords.docValueCount();
                }
                assert (this.i < this.count);
                ++this.i;
                return ords.nextValue();
            }

            public int docValueCount() {
                return ords.docValueCount();
            }

            public boolean advanceExact(int target) throws IOException {
                this.set = false;
                return ords.advanceExact(target);
            }

            public int docID() {
                return ords.docID();
            }

            public int nextDoc() throws IOException {
                this.set = false;
                return ords.nextDoc();
            }

            public int advance(int target) throws IOException {
                this.set = false;
                return ords.advance(target);
            }

            public long cost() {
                return ords.cost();
            }

            public int docIDRunEnd() throws IOException {
                return ords.docIDRunEnd();
            }
        };
    }

    public DocValuesSkipper getSkipper(FieldInfo field) throws IOException {
        final DocValuesSkipperEntry entry = (DocValuesSkipperEntry)this.skippers.get(field.number);
        return new DocValuesSkipper(){
            final int[] minDocID = new int[4];
            final int[] maxDocID = new int[4];
            IndexInput input;
            final long[] minValue;
            final long[] maxValue;
            final int[] docCount;
            int levels;
            {
                for (int i = 0; i < 4; ++i) {
                    this.maxDocID[i] = -1;
                    this.minDocID[i] = -1;
                }
                this.minValue = new long[4];
                this.maxValue = new long[4];
                this.docCount = new int[4];
                this.levels = 1;
            }

            public void advance(int target) throws IOException {
                if (target > entry.maxDocId) {
                    for (int i = 0; i < 4; ++i) {
                        this.maxDocID[i] = Integer.MAX_VALUE;
                        this.minDocID[i] = Integer.MAX_VALUE;
                    }
                } else {
                    boolean valid;
                    if (this.input == null) {
                        this.input = ES819TSDBDocValuesProducer.this.data.slice("doc value skipper", entry.offset, entry.length);
                    }
                    assert (target > this.maxDocID[0]) : "target must be bigger than current interval";
                    block1: do {
                        this.levels = this.input.readByte();
                        assert (this.levels <= 4 && this.levels > 0) : "level out of range [" + this.levels + "]";
                        valid = true;
                        for (int level = this.levels - 1; level >= 0; --level) {
                            this.maxDocID[level] = this.input.readInt();
                            if (this.maxDocID[level] < target) {
                                this.input.skipBytes(ES819TSDBDocValuesFormat.SKIP_INDEX_JUMP_LENGTH_PER_LEVEL[level]);
                                valid = false;
                                continue block1;
                            }
                            this.minDocID[level] = this.input.readInt();
                            this.maxValue[level] = this.input.readLong();
                            this.minValue[level] = this.input.readLong();
                            this.docCount[level] = this.input.readInt();
                        }
                    } while (!valid);
                    while (this.levels < 4 && this.maxDocID[this.levels] >= target) {
                        ++this.levels;
                    }
                }
            }

            public int numLevels() {
                return this.levels;
            }

            public int minDocID(int level) {
                return this.minDocID[level];
            }

            public int maxDocID(int level) {
                return this.maxDocID[level];
            }

            public long minValue(int level) {
                return this.minValue[level];
            }

            public long maxValue(int level) {
                return this.maxValue[level];
            }

            public int docCount(int level) {
                return this.docCount[level];
            }

            public long minValue() {
                return entry.minValue;
            }

            public long maxValue() {
                return entry.maxValue;
            }

            public int docCount() {
                return entry.docCount;
            }
        };
    }

    public void checkIntegrity() throws IOException {
        CodecUtil.checksumEntireFile((IndexInput)this.data);
    }

    public void close() throws IOException {
        this.data.close();
    }

    static int primarySortFieldNumber(SegmentInfo segmentInfo, FieldInfos fieldInfos) {
        FieldInfo fieldInfo;
        SortField sortField;
        Sort indexSort = segmentInfo.getIndexSort();
        if (indexSort != null && indexSort.getSort().length > 0 && !(sortField = indexSort.getSort()[0]).getReverse() && (fieldInfo = fieldInfos.fieldInfo(sortField.getField())) != null) {
            return fieldInfo.number;
        }
        return -1;
    }

    private void readFields(IndexInput meta, FieldInfos infos, int version, int numericBlockShift) throws IOException {
        int fieldNumber = meta.readInt();
        while (fieldNumber != -1) {
            FieldInfo info = infos.fieldInfo(fieldNumber);
            if (info == null) {
                throw new CorruptIndexException("Invalid field number: " + fieldNumber, (DataInput)meta);
            }
            byte type = meta.readByte();
            if (info.docValuesSkipIndexType() != DocValuesSkipIndexType.NONE) {
                this.skippers.put(info.number, (Object)ES819TSDBDocValuesProducer.readDocValueSkipperMeta(meta));
            }
            if (type == 0) {
                this.numerics.put(info.number, (Object)ES819TSDBDocValuesProducer.readNumeric(meta, numericBlockShift));
            } else if (type == 1) {
                this.binaries.put(info.number, (Object)this.readBinary(meta, version));
            } else if (type == 2) {
                this.sorted.put(info.number, (Object)ES819TSDBDocValuesProducer.readSorted(meta, numericBlockShift));
            } else if (type == 3) {
                this.sortedSets.put(info.number, (Object)ES819TSDBDocValuesProducer.readSortedSet(meta, numericBlockShift));
            } else if (type == 4) {
                this.sortedNumerics.put(info.number, (Object)ES819TSDBDocValuesProducer.readSortedNumeric(meta, numericBlockShift));
            } else {
                throw new CorruptIndexException("invalid type: " + type, (DataInput)meta);
            }
            fieldNumber = meta.readInt();
        }
    }

    private static NumericEntry readNumeric(IndexInput meta, int numericBlockShift) throws IOException {
        NumericEntry entry = new NumericEntry();
        ES819TSDBDocValuesProducer.readNumeric(meta, entry, numericBlockShift);
        return entry;
    }

    private static DocValuesSkipperEntry readDocValueSkipperMeta(IndexInput meta) throws IOException {
        long offset = meta.readLong();
        long length = meta.readLong();
        long maxValue = meta.readLong();
        long minValue = meta.readLong();
        int docCount = meta.readInt();
        int maxDocID = meta.readInt();
        return new DocValuesSkipperEntry(offset, length, minValue, maxValue, docCount, maxDocID);
    }

    private static void readNumeric(IndexInput meta, NumericEntry entry, int numericBlockShift) throws IOException {
        entry.numValues = meta.readLong();
        entry.numDocsWithField = meta.readInt();
        if (entry.numValues > 0L) {
            int indexBlockShift = meta.readInt();
            if (indexBlockShift != -1) {
                if (indexBlockShift == -2) {
                    int numOrds = meta.readVInt();
                    byte blockShift = meta.readByte();
                    entry.sortedOrdinals = DirectMonotonicReader.loadMeta((IndexInput)meta, (long)(numOrds + 1), (int)blockShift);
                } else {
                    entry.indexMeta = DirectMonotonicReader.loadMeta((IndexInput)meta, (long)(1L + (entry.numValues - 1L >>> numericBlockShift)), (int)indexBlockShift);
                }
            }
            entry.indexOffset = meta.readLong();
            entry.indexLength = meta.readLong();
            entry.valuesOffset = meta.readLong();
            entry.valuesLength = meta.readLong();
        }
        entry.docsWithFieldOffset = meta.readLong();
        entry.docsWithFieldLength = meta.readLong();
        entry.jumpTableEntryCount = meta.readShort();
        entry.denseRankPower = meta.readByte();
    }

    private BinaryEntry readBinary(IndexInput meta, int version) throws IOException {
        BinaryDVCompressionMode compression = version >= 1 ? BinaryDVCompressionMode.fromMode(meta.readByte()) : BinaryDVCompressionMode.NO_COMPRESS;
        BinaryEntry entry = new BinaryEntry(compression);
        entry.dataOffset = meta.readLong();
        entry.dataLength = meta.readLong();
        entry.docsWithFieldOffset = meta.readLong();
        entry.docsWithFieldLength = meta.readLong();
        entry.jumpTableEntryCount = meta.readShort();
        entry.denseRankPower = meta.readByte();
        entry.numDocsWithField = meta.readInt();
        entry.minLength = meta.readInt();
        entry.maxLength = meta.readInt();
        if (compression == BinaryDVCompressionMode.NO_COMPRESS) {
            if (entry.minLength < entry.maxLength) {
                entry.addressesOffset = meta.readLong();
                long numAddresses = (long)entry.numDocsWithField + 1L;
                int blockShift = meta.readVInt();
                entry.addressesMeta = DirectMonotonicReader.loadMeta((IndexInput)meta, (long)numAddresses, (int)blockShift);
                entry.addressesLength = meta.readLong();
            }
        } else if (entry.numDocsWithField > 0) {
            entry.addressesOffset = meta.readLong();
            int numCompressedChunks = meta.readVInt();
            entry.maxUncompressedChunkSize = meta.readVInt();
            entry.maxNumDocsInAnyBlock = meta.readVInt();
            int blockShift = meta.readVInt();
            entry.addressesMeta = DirectMonotonicReader.loadMeta((IndexInput)meta, (long)(numCompressedChunks + 1), (int)blockShift);
            entry.addressesLength = meta.readLong();
            entry.docOffsetsOffset = meta.readLong();
            entry.docOffsetMeta = DirectMonotonicReader.loadMeta((IndexInput)meta, (long)(numCompressedChunks + 1), (int)blockShift);
            entry.docOffsetLength = meta.readLong();
            entry.numCompressedBlocks = numCompressedChunks;
        }
        return entry;
    }

    private static SortedNumericEntry readSortedNumeric(IndexInput meta, int numericBlockShift) throws IOException {
        SortedNumericEntry entry = new SortedNumericEntry();
        ES819TSDBDocValuesProducer.readSortedNumeric(meta, entry, numericBlockShift);
        return entry;
    }

    private static SortedNumericEntry readSortedNumeric(IndexInput meta, SortedNumericEntry entry, int numericBlockShift) throws IOException {
        ES819TSDBDocValuesProducer.readNumeric(meta, entry, numericBlockShift);
        if ((long)entry.numDocsWithField != entry.numValues) {
            entry.addressesOffset = meta.readLong();
            int blockShift = meta.readVInt();
            entry.addressesMeta = DirectMonotonicReader.loadMeta((IndexInput)meta, (long)(entry.numDocsWithField + 1), (int)blockShift);
            entry.addressesLength = meta.readLong();
        }
        return entry;
    }

    private static SortedEntry readSorted(IndexInput meta, int numericBlockShift) throws IOException {
        SortedEntry entry = new SortedEntry();
        entry.ordsEntry = new NumericEntry();
        ES819TSDBDocValuesProducer.readNumeric(meta, entry.ordsEntry, numericBlockShift);
        entry.termsDictEntry = new TermsDictEntry();
        ES819TSDBDocValuesProducer.readTermDict(meta, entry.termsDictEntry);
        return entry;
    }

    private static SortedSetEntry readSortedSet(IndexInput meta, int numericBlockShift) throws IOException {
        SortedSetEntry entry = new SortedSetEntry();
        byte multiValued = meta.readByte();
        switch (multiValued) {
            case 0: {
                entry.singleValueEntry = ES819TSDBDocValuesProducer.readSorted(meta, numericBlockShift);
                return entry;
            }
            case 1: {
                break;
            }
            default: {
                throw new CorruptIndexException("Invalid multiValued flag: " + multiValued, (DataInput)meta);
            }
        }
        entry.ordsEntry = new SortedNumericEntry();
        ES819TSDBDocValuesProducer.readSortedNumeric(meta, entry.ordsEntry, numericBlockShift);
        entry.termsDictEntry = new TermsDictEntry();
        ES819TSDBDocValuesProducer.readTermDict(meta, entry.termsDictEntry);
        return entry;
    }

    private static void readTermDict(IndexInput meta, TermsDictEntry entry) throws IOException {
        entry.termsDictSize = meta.readVLong();
        int blockShift = meta.readInt();
        long addressesSize = entry.termsDictSize + 64L - 1L >>> 6;
        entry.termsAddressesMeta = DirectMonotonicReader.loadMeta((IndexInput)meta, (long)addressesSize, (int)blockShift);
        entry.maxTermLength = meta.readInt();
        entry.maxBlockLength = meta.readInt();
        entry.termsDataOffset = meta.readLong();
        entry.termsDataLength = meta.readLong();
        entry.termsAddressesOffset = meta.readLong();
        entry.termsAddressesLength = meta.readLong();
        entry.termsDictIndexShift = meta.readInt();
        long indexSize = entry.termsDictSize + (1L << entry.termsDictIndexShift) - 1L >>> entry.termsDictIndexShift;
        entry.termsIndexAddressesMeta = DirectMonotonicReader.loadMeta((IndexInput)meta, (long)(1L + indexSize), (int)blockShift);
        entry.termsIndexOffset = meta.readLong();
        entry.termsIndexLength = meta.readLong();
        entry.termsIndexAddressesOffset = meta.readLong();
        entry.termsIndexAddressesLength = meta.readLong();
    }

    private NumericDocValues getNumeric(final NumericEntry entry, long maxOrd) throws IOException {
        int bitsPerOrd;
        if (entry.docsWithFieldOffset == -2L) {
            return DocValues.emptyNumeric();
        }
        if (maxOrd == 1L) {
            if (entry.docsWithFieldOffset == -1L) {
                return new BaseDenseNumericValues(this.maxDoc){

                    public long longValue() {
                        return 0L;
                    }

                    public int docIDRunEnd() {
                        return ES819TSDBDocValuesProducer.this.maxDoc;
                    }

                    @Override
                    long lookAheadValueAt(int targetDoc) throws IOException {
                        return 0L;
                    }

                    @Override
                    SortedOrdinalReader sortedOrdinalReader() {
                        return null;
                    }
                };
            }
            IndexedDISI disi = new IndexedDISI(this.data, entry.docsWithFieldOffset, entry.docsWithFieldLength, (int)entry.jumpTableEntryCount, entry.denseRankPower, entry.numValues);
            return new BaseSparseNumericValues(this, disi){

                public long longValue() throws IOException {
                    return 0L;
                }

                public int docIDRunEnd() throws IOException {
                    return this.disi.docIDRunEnd();
                }
            };
        }
        if (entry.sortedOrdinals != null) {
            return this.getRangeEncodedNumericDocValues(entry, maxOrd);
        }
        RandomAccessInput indexSlice = this.data.randomAccessSlice(entry.indexOffset, entry.indexLength);
        final DirectMonotonicReader indexReader = DirectMonotonicReader.getInstance((DirectMonotonicReader.Meta)entry.indexMeta, (RandomAccessInput)indexSlice, (boolean)this.merging);
        final IndexInput valuesData = this.data.slice("values", entry.valuesOffset, entry.valuesLength);
        int n = bitsPerOrd = maxOrd >= 0L ? PackedInts.bitsRequired((long)(maxOrd - 1L)) : -1;
        if (entry.docsWithFieldOffset == -1L) {
            return new BaseDenseNumericValues(this.maxDoc){
                private final TSDBDocValuesEncoder decoder;
                private long currentBlockIndex;
                private final long[] currentBlock;
                private long lookaheadBlockIndex;
                private long[] lookaheadBlock;
                private IndexInput lookaheadData;
                {
                    super(maxDoc);
                    this.decoder = new TSDBDocValuesEncoder(ES819TSDBDocValuesProducer.this.numericBlockSize);
                    this.currentBlockIndex = -1L;
                    this.currentBlock = new long[ES819TSDBDocValuesProducer.this.numericBlockSize];
                    this.lookaheadBlockIndex = -1L;
                    this.lookaheadData = null;
                }

                public int docIDRunEnd() {
                    return ES819TSDBDocValuesProducer.this.maxDoc;
                }

                public long longValue() throws IOException {
                    int index = this.doc;
                    int blockIndex = index >>> ES819TSDBDocValuesProducer.this.numericBlockShift;
                    int blockInIndex = index & ES819TSDBDocValuesProducer.this.numericBlockMask;
                    if ((long)blockIndex == this.currentBlockIndex) {
                        return this.currentBlock[blockInIndex];
                    }
                    if ((long)blockIndex == this.lookaheadBlockIndex) {
                        return this.lookaheadBlock[blockInIndex];
                    }
                    assert ((long)blockIndex > this.currentBlockIndex) : blockIndex + " < " + this.currentBlockIndex;
                    if (this.currentBlockIndex + 1L != (long)blockIndex) {
                        valuesData.seek(indexReader.get((long)blockIndex));
                    }
                    this.currentBlockIndex = blockIndex;
                    if (bitsPerOrd == -1) {
                        this.decoder.decode((DataInput)valuesData, this.currentBlock);
                    } else {
                        this.decoder.decodeOrdinals((DataInput)valuesData, this.currentBlock, bitsPerOrd);
                    }
                    return this.currentBlock[blockInIndex];
                }

                @Override
                public BlockLoader.Block tryRead(BlockLoader.BlockFactory factory, BlockLoader.Docs docs, int offset, boolean nullsFiltered, BlockDocValuesReader.ToDouble toDouble, boolean toInt) throws IOException {
                    try (BlockLoader.SingletonLongBuilder singletonLongBuilder = ES819TSDBDocValuesProducer.singletonLongBuilder(factory, toDouble, docs.count() - offset, toInt);){
                        BlockLoader.Block block = this.tryRead(singletonLongBuilder, docs, offset);
                        return block;
                    }
                }

                @Override
                BlockLoader.Block tryRead(BlockLoader.SingletonLongBuilder builder, BlockLoader.Docs docs, int offset) throws IOException {
                    int length;
                    int docsCount = docs.count();
                    this.doc = docs.get(docsCount - 1);
                    for (int i = offset; i < docsCount; i += length) {
                        int remainingBlockLength;
                        int index = docs.get(i);
                        int blockIndex = index >>> ES819TSDBDocValuesProducer.this.numericBlockShift;
                        int blockInIndex = index & ES819TSDBDocValuesProducer.this.numericBlockMask;
                        if ((long)blockIndex != this.currentBlockIndex) {
                            assert ((long)blockIndex > this.currentBlockIndex) : blockIndex + " < " + this.currentBlockIndex;
                            if (this.currentBlockIndex + 1L != (long)blockIndex) {
                                valuesData.seek(indexReader.get((long)blockIndex));
                            }
                            this.currentBlockIndex = blockIndex;
                            if (bitsPerOrd == -1) {
                                this.decoder.decode((DataInput)valuesData, this.currentBlock);
                            } else {
                                this.decoder.decodeOrdinals((DataInput)valuesData, this.currentBlock, bitsPerOrd);
                            }
                        }
                        length = 1;
                        for (int newLength = remainingBlockLength = Math.min(ES819TSDBDocValuesProducer.this.numericBlockSize - blockInIndex, docsCount - i); newLength > 1; newLength >>= 1) {
                            int lastIndex = i + newLength - 1;
                            if (!ES819TSDBDocValuesProducer.isDense(index, docs.get(lastIndex), newLength)) continue;
                            length = newLength;
                            break;
                        }
                        builder.appendLongs(this.currentBlock, blockInIndex, length);
                    }
                    return builder.build();
                }

                @Override
                long lookAheadValueAt(int targetDoc) throws IOException {
                    int blockIndex = targetDoc >>> ES819TSDBDocValuesProducer.this.numericBlockShift;
                    int valueIndex = targetDoc & ES819TSDBDocValuesProducer.this.numericBlockMask;
                    if ((long)blockIndex == this.currentBlockIndex) {
                        return this.currentBlock[valueIndex];
                    }
                    if (this.lookaheadBlockIndex != (long)blockIndex) {
                        if (this.lookaheadBlock == null) {
                            this.lookaheadBlock = new long[ES819TSDBDocValuesProducer.this.numericBlockSize];
                            this.lookaheadData = ES819TSDBDocValuesProducer.this.data.slice("look_ahead_values", entry.valuesOffset, entry.valuesLength);
                        }
                        if (this.lookaheadBlockIndex + 1L != (long)blockIndex) {
                            this.lookaheadData.seek(indexReader.get((long)blockIndex));
                        }
                        if (bitsPerOrd == -1) {
                            this.decoder.decode((DataInput)this.lookaheadData, this.lookaheadBlock);
                        } else {
                            this.decoder.decodeOrdinals((DataInput)this.lookaheadData, this.lookaheadBlock, bitsPerOrd);
                        }
                        this.lookaheadBlockIndex = blockIndex;
                    }
                    return this.lookaheadBlock[valueIndex];
                }

                @Override
                SortedOrdinalReader sortedOrdinalReader() {
                    return null;
                }
            };
        }
        IndexedDISI disi = new IndexedDISI(this.data, entry.docsWithFieldOffset, entry.docsWithFieldLength, (int)entry.jumpTableEntryCount, entry.denseRankPower, entry.numValues);
        return new BaseSparseNumericValues(disi){
            private final TSDBDocValuesEncoder decoder;
            private IndexedDISI lookAheadDISI;
            private long currentBlockIndex;
            private final long[] currentBlock;
            {
                super(disi);
                this.decoder = new TSDBDocValuesEncoder(ES819TSDBDocValuesProducer.this.numericBlockSize);
                this.currentBlockIndex = -1L;
                this.currentBlock = new long[ES819TSDBDocValuesProducer.this.numericBlockSize];
            }

            public int docIDRunEnd() throws IOException {
                return this.disi.docIDRunEnd();
            }

            public long longValue() throws IOException {
                int index = this.disi.index();
                int blockIndex = index >>> ES819TSDBDocValuesProducer.this.numericBlockShift;
                int blockInIndex = index & ES819TSDBDocValuesProducer.this.numericBlockMask;
                if ((long)blockIndex != this.currentBlockIndex) {
                    assert ((long)blockIndex > this.currentBlockIndex) : blockIndex + "<=" + this.currentBlockIndex;
                    if (this.currentBlockIndex + 1L != (long)blockIndex) {
                        valuesData.seek(indexReader.get((long)blockIndex));
                    }
                    this.currentBlockIndex = blockIndex;
                    if (bitsPerOrd == -1) {
                        this.decoder.decode((DataInput)valuesData, this.currentBlock);
                    } else {
                        this.decoder.decodeOrdinals((DataInput)valuesData, this.currentBlock, bitsPerOrd);
                    }
                }
                return this.currentBlock[blockInIndex];
            }

            @Override
            public BlockLoader.Block tryRead(BlockLoader.BlockFactory factory, BlockLoader.Docs docs, int offset, boolean nullsFiltered, BlockDocValuesReader.ToDouble toDouble, boolean toInt) throws IOException {
                int lastDoc;
                if (!nullsFiltered) {
                    return null;
                }
                int firstDoc = docs.get(offset);
                if (!this.disi.advanceExact(firstDoc)) {
                    assert (false) : "nullsFiltered is true, but doc [" + firstDoc + "] has no value";
                    throw new IllegalStateException("nullsFiltered is true, but doc [" + firstDoc + "] has no value");
                }
                if (this.lookAheadDISI == null) {
                    this.lookAheadDISI = new IndexedDISI(ES819TSDBDocValuesProducer.this.data, entry.docsWithFieldOffset, entry.docsWithFieldLength, (int)entry.jumpTableEntryCount, entry.denseRankPower, entry.numValues);
                }
                if (!this.lookAheadDISI.advanceExact(lastDoc = docs.get(docs.count() - 1))) {
                    assert (false) : "nullsFiltered is true, but doc [" + lastDoc + "] has no value";
                    throw new IllegalStateException("nullsFiltered is true, but doc [" + lastDoc + "] has no value");
                }
                int firstIndex = this.disi.index();
                int lastIndex = this.lookAheadDISI.index();
                int valueCount = lastIndex - firstIndex + 1;
                if (valueCount != docs.count()) {
                    return null;
                }
                if (Assertions.ENABLED) {
                    for (int i = 0; i < docs.count(); ++i) {
                        int doc = docs.get(i + offset);
                        assert (this.disi.advanceExact(doc)) : "nullsFiltered is true, but doc [" + doc + "] has no value";
                        assert (this.disi.index() == firstIndex + i) : "unexpected disi index " + (firstIndex + i) + "!=" + this.disi.index();
                    }
                }
                try (BlockLoader.SingletonLongBuilder singletonLongBuilder = ES819TSDBDocValuesProducer.singletonLongBuilder(factory, toDouble, valueCount, toInt);){
                    int count;
                    for (int i = 0; i < valueCount; i += count) {
                        int index = firstIndex + i;
                        int blockIndex = index >>> ES819TSDBDocValuesProducer.this.numericBlockShift;
                        int blockStartIndex = index & ES819TSDBDocValuesProducer.this.numericBlockMask;
                        if ((long)blockIndex != this.currentBlockIndex) {
                            assert ((long)blockIndex > this.currentBlockIndex) : blockIndex + "<=" + this.currentBlockIndex;
                            if (this.currentBlockIndex + 1L != (long)blockIndex) {
                                valuesData.seek(indexReader.get((long)blockIndex));
                            }
                            this.currentBlockIndex = blockIndex;
                            this.decoder.decode((DataInput)valuesData, this.currentBlock);
                        }
                        count = Math.min(ES819TSDBDocValuesProducer.this.numericBlockSize - blockStartIndex, valueCount - i);
                        singletonLongBuilder.appendLongs(this.currentBlock, blockStartIndex, count);
                    }
                    BlockLoader.Block block = singletonLongBuilder.build();
                    return block;
                }
            }
        };
    }

    private static boolean isDense(int firstDocId, int lastDocId, int length) {
        return lastDocId - firstDocId == length - 1;
    }

    private NumericDocValues getRangeEncodedNumericDocValues(NumericEntry entry, long maxOrd) throws IOException {
        final SortedOrdinalReader ordinalsReader = new SortedOrdinalReader(maxOrd, DirectMonotonicReader.getInstance((DirectMonotonicReader.Meta)entry.sortedOrdinals, (RandomAccessInput)this.data.randomAccessSlice(entry.valuesOffset, entry.valuesLength), (boolean)true));
        if (entry.docsWithFieldOffset == -1L) {
            return new BaseDenseNumericValues(this.maxDoc){

                @Override
                long lookAheadValueAt(int targetDoc) {
                    return ordinalsReader.lookAheadValue(targetDoc);
                }

                public long longValue() {
                    return ordinalsReader.readValueAndAdvance(this.doc);
                }

                public int docIDRunEnd() throws IOException {
                    return ES819TSDBDocValuesProducer.this.maxDoc;
                }

                @Override
                SortedOrdinalReader sortedOrdinalReader() {
                    return ordinalsReader;
                }
            };
        }
        IndexedDISI disi = new IndexedDISI(this.data, entry.docsWithFieldOffset, entry.docsWithFieldLength, (int)entry.jumpTableEntryCount, entry.denseRankPower, entry.numValues);
        return new BaseSparseNumericValues(this, disi){

            public long longValue() {
                return ordinalsReader.readValueAndAdvance(this.disi.docID());
            }

            public int docIDRunEnd() throws IOException {
                return this.disi.docIDRunEnd();
            }
        };
    }

    private NumericValues getValues(NumericEntry entry, long maxOrd) throws IOException {
        assert (entry.numValues > 0L);
        RandomAccessInput indexSlice = this.data.randomAccessSlice(entry.indexOffset, entry.indexLength);
        DirectMonotonicReader indexReader = DirectMonotonicReader.getInstance((DirectMonotonicReader.Meta)entry.indexMeta, (RandomAccessInput)indexSlice, (boolean)this.merging);
        IndexInput valuesData = this.data.slice("values", entry.valuesOffset, entry.valuesLength);
        int bitsPerOrd = maxOrd >= 0L ? PackedInts.bitsRequired((long)(maxOrd - 1L)) : -1;
        long[] currentBlockIndex = new long[]{-1L};
        long[] currentBlock = new long[this.numericBlockSize];
        TSDBDocValuesEncoder decoder = new TSDBDocValuesEncoder(this.numericBlockSize);
        return index -> {
            long blockIndex = index >>> this.numericBlockShift;
            int blockInIndex = (int)(index & (long)this.numericBlockMask);
            if (blockIndex != currentBlockIndex[0]) {
                if (currentBlockIndex[0] + 1L != blockIndex) {
                    valuesData.seek(indexReader.get(blockIndex));
                }
                currentBlockIndex[0] = blockIndex;
                if (bitsPerOrd == -1) {
                    decoder.decode((DataInput)valuesData, currentBlock);
                } else {
                    decoder.decodeOrdinals((DataInput)valuesData, currentBlock, bitsPerOrd);
                }
            }
            return currentBlock[blockInIndex];
        };
    }

    private SortedNumericDocValues getSortedNumeric(SortedNumericEntry entry, long maxOrd) throws IOException {
        if (entry.numValues == (long)entry.numDocsWithField) {
            return DocValues.singleton((NumericDocValues)this.getNumeric(entry, maxOrd));
        }
        RandomAccessInput addressesInput = this.data.randomAccessSlice(entry.addressesOffset, entry.addressesLength);
        DirectMonotonicReader addresses = DirectMonotonicReader.getInstance((DirectMonotonicReader.Meta)entry.addressesMeta, (RandomAccessInput)addressesInput, (boolean)this.merging);
        assert (entry.sortedOrdinals == null) : "encoded ordinal range supports only one value per document";
        if (entry.sortedOrdinals != null) {
            NumericDocValues values = this.getRangeEncodedNumericDocValues(entry, maxOrd);
            return DocValues.singleton((NumericDocValues)values);
        }
        final NumericValues values = this.getValues(entry, maxOrd);
        if (entry.docsWithFieldOffset == -1L) {
            return new SortedNumericDocValues((LongValues)addresses, values){
                int doc = -1;
                long start;
                long end;
                int count;
                final /* synthetic */ LongValues val$addresses;
                final /* synthetic */ NumericValues val$values;
                {
                    this.val$addresses = longValues;
                    this.val$values = numericValues;
                }

                public int nextDoc() throws IOException {
                    return this.advance(this.doc + 1);
                }

                public int docID() {
                    return this.doc;
                }

                public long cost() {
                    return ES819TSDBDocValuesProducer.this.maxDoc;
                }

                public int advance(int target) throws IOException {
                    if (target >= ES819TSDBDocValuesProducer.this.maxDoc) {
                        this.doc = Integer.MAX_VALUE;
                        return Integer.MAX_VALUE;
                    }
                    this.start = this.val$addresses.get((long)target);
                    this.end = this.val$addresses.get((long)target + 1L);
                    this.count = (int)(this.end - this.start);
                    this.doc = target;
                    return this.doc;
                }

                public boolean advanceExact(int target) throws IOException {
                    this.start = this.val$addresses.get((long)target);
                    this.end = this.val$addresses.get((long)target + 1L);
                    this.count = (int)(this.end - this.start);
                    this.doc = target;
                    return true;
                }

                public long nextValue() throws IOException {
                    return this.val$values.advance(this.start++);
                }

                public int docValueCount() {
                    return this.count;
                }

                public int docIDRunEnd() {
                    return ES819TSDBDocValuesProducer.this.maxDoc;
                }
            };
        }
        final IndexedDISI disi = new IndexedDISI(this.data, entry.docsWithFieldOffset, entry.docsWithFieldLength, (int)entry.jumpTableEntryCount, entry.denseRankPower, (long)entry.numDocsWithField);
        return new SortedNumericDocValues(this, (LongValues)addresses){
            boolean set;
            long start;
            long end;
            int count;
            final /* synthetic */ LongValues val$addresses;
            {
                this.val$addresses = longValues;
            }

            public int nextDoc() throws IOException {
                this.set = false;
                return disi.nextDoc();
            }

            public int docID() {
                return disi.docID();
            }

            public long cost() {
                return disi.cost();
            }

            public int advance(int target) throws IOException {
                this.set = false;
                return disi.advance(target);
            }

            public boolean advanceExact(int target) throws IOException {
                this.set = false;
                return disi.advanceExact(target);
            }

            public long nextValue() throws IOException {
                this.set();
                return values.advance(this.start++);
            }

            public int docValueCount() {
                this.set();
                return this.count;
            }

            public int docIDRunEnd() throws IOException {
                return disi.docIDRunEnd();
            }

            private void set() {
                if (!this.set) {
                    int index = disi.index();
                    this.start = this.val$addresses.get((long)index);
                    this.end = this.val$addresses.get((long)index + 1L);
                    this.count = (int)(this.end - this.start);
                    this.set = true;
                }
            }
        };
    }

    static BlockLoader.SingletonLongBuilder singletonLongBuilder(BlockLoader.BlockFactory factory, BlockDocValuesReader.ToDouble toDouble, int valueCount, boolean toInt) {
        assert (!(toInt && toDouble != null));
        if (toDouble != null) {
            return new SingletonLongToDoubleDelegate(factory.singletonDoubles(valueCount), toDouble);
        }
        if (toInt) {
            return new SingletonLongtoIntDelegate(factory.singletonInts(valueCount));
        }
        return factory.singletonLongs(valueCount);
    }

    static class NumericEntry {
        long docsWithFieldOffset;
        long docsWithFieldLength;
        short jumpTableEntryCount;
        byte denseRankPower;
        long numValues;
        int numDocsWithField;
        long indexOffset;
        long indexLength;
        DirectMonotonicReader.Meta indexMeta;
        long valuesOffset;
        long valuesLength;
        DirectMonotonicReader.Meta sortedOrdinals;

        NumericEntry() {
        }
    }

    static class BinaryEntry {
        final BinaryDVCompressionMode compression;
        long dataOffset;
        long dataLength;
        long docsWithFieldOffset;
        long docsWithFieldLength;
        short jumpTableEntryCount;
        byte denseRankPower;
        int numDocsWithField;
        int minLength;
        int maxLength;
        long addressesOffset;
        long addressesLength;
        long docOffsetsOffset;
        long docOffsetLength;
        int maxUncompressedChunkSize;
        int maxNumDocsInAnyBlock;
        int numCompressedBlocks;
        DirectMonotonicReader.Meta addressesMeta;
        DirectMonotonicReader.Meta docOffsetMeta;

        BinaryEntry(BinaryDVCompressionMode compression) {
            this.compression = compression;
        }
    }

    static class SortedEntry {
        NumericEntry ordsEntry;
        TermsDictEntry termsDictEntry;

        SortedEntry() {
        }
    }

    private static class TermsDictEntry {
        long termsDictSize;
        DirectMonotonicReader.Meta termsAddressesMeta;
        int maxTermLength;
        long termsDataOffset;
        long termsDataLength;
        long termsAddressesOffset;
        long termsAddressesLength;
        int termsDictIndexShift;
        DirectMonotonicReader.Meta termsIndexAddressesMeta;
        long termsIndexOffset;
        long termsIndexLength;
        long termsIndexAddressesOffset;
        long termsIndexAddressesLength;
        int maxBlockLength;

        private TermsDictEntry() {
        }
    }

    static class SortedNumericEntry
    extends NumericEntry {
        DirectMonotonicReader.Meta addressesMeta;
        long addressesOffset;
        long addressesLength;

        SortedNumericEntry() {
        }
    }

    static class SortedSetEntry {
        SortedEntry singleValueEntry;
        SortedNumericEntry ordsEntry;
        TermsDictEntry termsDictEntry;

        SortedSetEntry() {
        }
    }

    private record DocValuesSkipperEntry(long offset, long length, long minValue, long maxValue, int docCount, int maxDocId) {
    }

    static final class SortedOrdinalReader {
        final long maxOrd;
        final DirectMonotonicReader startDocs;
        private long currentIndex = -1L;
        private long rangeEndExclusive = -1L;

        SortedOrdinalReader(long maxOrd, DirectMonotonicReader startDocs) {
            this.maxOrd = maxOrd;
            this.startDocs = startDocs;
        }

        long readValueAndAdvance(int doc) {
            if ((long)doc < this.rangeEndExclusive) {
                return this.currentIndex;
            }
            this.currentIndex = (long)doc == this.rangeEndExclusive ? ++this.currentIndex : this.searchRange(doc);
            this.rangeEndExclusive = this.startDocs.get(this.currentIndex + 1L);
            return this.currentIndex;
        }

        private long searchRange(int doc) {
            long index = this.startDocs.binarySearch(this.currentIndex + 1L, this.maxOrd, (long)doc);
            if (index < 0L) {
                index = -2L - index;
            }
            assert (index < this.maxOrd) : "invalid range " + index + " for doc " + doc + " in maxOrd " + this.maxOrd;
            return index;
        }

        long lookAheadValue(int targetDoc) {
            if ((long)targetDoc < this.rangeEndExclusive) {
                return this.currentIndex;
            }
            return this.searchRange(targetDoc);
        }
    }

    @FunctionalInterface
    private static interface NumericValues {
        public long advance(long var1) throws IOException;
    }

    static final class SingletonLongToDoubleDelegate
    implements BlockLoader.SingletonLongBuilder {
        private final BlockLoader.SingletonDoubleBuilder doubleBuilder;
        private final BlockDocValuesReader.ToDouble toDouble;

        SingletonLongToDoubleDelegate(BlockLoader.SingletonDoubleBuilder doubleBuilder, BlockDocValuesReader.ToDouble toDouble) {
            this.doubleBuilder = doubleBuilder;
            this.toDouble = toDouble;
        }

        @Override
        public BlockLoader.SingletonLongBuilder appendLong(long value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public BlockLoader.SingletonLongBuilder appendLongs(long[] values, int from, int length) {
            this.doubleBuilder.appendLongs(this.toDouble, values, from, length);
            return this;
        }

        @Override
        public BlockLoader.Block build() {
            return this.doubleBuilder.build();
        }

        @Override
        public BlockLoader.Builder appendNull() {
            throw new UnsupportedOperationException();
        }

        @Override
        public BlockLoader.Builder beginPositionEntry() {
            throw new UnsupportedOperationException();
        }

        @Override
        public BlockLoader.Builder endPositionEntry() {
            throw new UnsupportedOperationException();
        }

        public void close() {
            this.doubleBuilder.close();
        }
    }

    static final class SingletonLongtoIntDelegate
    implements BlockLoader.SingletonLongBuilder {
        private final BlockLoader.SingletonIntBuilder builder;

        SingletonLongtoIntDelegate(BlockLoader.SingletonIntBuilder builder) {
            this.builder = builder;
        }

        @Override
        public BlockLoader.SingletonLongBuilder appendLong(long value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public BlockLoader.SingletonLongBuilder appendLongs(long[] values, int from, int length) {
            this.builder.appendLongs(values, from, length);
            return this;
        }

        @Override
        public BlockLoader.Block build() {
            return this.builder.build();
        }

        @Override
        public BlockLoader.Builder appendNull() {
            throw new UnsupportedOperationException();
        }

        @Override
        public BlockLoader.Builder beginPositionEntry() {
            throw new UnsupportedOperationException();
        }

        @Override
        public BlockLoader.Builder endPositionEntry() {
            throw new UnsupportedOperationException();
        }

        public void close() {
            this.builder.close();
        }
    }

    static final class SingletonLongToSingletonOrdinalDelegate
    implements BlockLoader.SingletonLongBuilder {
        private final BlockLoader.SingletonOrdinalsBuilder builder;
        private final int[] buffer;

        SingletonLongToSingletonOrdinalDelegate(BlockLoader.SingletonOrdinalsBuilder builder, int bufferSize) {
            this.builder = builder;
            this.buffer = new int[bufferSize];
        }

        @Override
        public BlockLoader.SingletonLongBuilder appendLong(long value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public BlockLoader.SingletonLongBuilder appendLongs(long[] values, int from, int length) {
            assert (length <= this.buffer.length);
            int minOrd = Integer.MAX_VALUE;
            int maxOrd = Integer.MIN_VALUE;
            int counter = 0;
            int end = from + length;
            for (int j = from; j < end; ++j) {
                int ord = Math.toIntExact(values[j]);
                this.buffer[counter++] = ord;
                minOrd = Math.min(minOrd, ord);
                maxOrd = Math.max(maxOrd, ord);
            }
            assert (counter == length);
            this.builder.appendOrds(this.buffer, 0, length, minOrd, maxOrd);
            return this;
        }

        @Override
        public BlockLoader.Block build() {
            return this.builder.build();
        }

        @Override
        public BlockLoader.Builder appendNull() {
            throw new UnsupportedOperationException();
        }

        @Override
        public BlockLoader.Builder beginPositionEntry() {
            throw new UnsupportedOperationException();
        }

        @Override
        public BlockLoader.Builder endPositionEntry() {
            throw new UnsupportedOperationException();
        }

        public void close() {
        }
    }

    private static class TermsDict
    extends BaseTermsEnum {
        static final int LZ4_DECOMPRESSOR_PADDING = 7;
        final TermsDictEntry entry;
        final LongValues blockAddresses;
        final IndexInput bytes;
        final long blockMask;
        final LongValues indexAddresses;
        final RandomAccessInput indexBytes;
        final BytesRef term;
        long ord = -1L;
        BytesRef blockBuffer = null;
        ByteArrayDataInput blockInput = null;
        long currentCompressedBlockStart = -1L;
        long currentCompressedBlockEnd = -1L;

        TermsDict(TermsDictEntry entry, IndexInput data, boolean merging) throws IOException {
            this.entry = entry;
            RandomAccessInput addressesSlice = data.randomAccessSlice(entry.termsAddressesOffset, entry.termsAddressesLength);
            this.blockAddresses = DirectMonotonicReader.getInstance((DirectMonotonicReader.Meta)entry.termsAddressesMeta, (RandomAccessInput)addressesSlice, (boolean)merging);
            this.bytes = data.slice("terms", entry.termsDataOffset, entry.termsDataLength);
            this.blockMask = 63L;
            RandomAccessInput indexAddressesSlice = data.randomAccessSlice(entry.termsIndexAddressesOffset, entry.termsIndexAddressesLength);
            this.indexAddresses = DirectMonotonicReader.getInstance((DirectMonotonicReader.Meta)entry.termsIndexAddressesMeta, (RandomAccessInput)indexAddressesSlice, (boolean)merging);
            this.indexBytes = data.randomAccessSlice(entry.termsIndexOffset, entry.termsIndexLength);
            this.term = new BytesRef(entry.maxTermLength);
            int bufferSize = entry.maxBlockLength + entry.maxTermLength + 7;
            this.blockBuffer = new BytesRef(new byte[bufferSize], 0, bufferSize);
        }

        public BytesRef next() throws IOException {
            if (++this.ord >= this.entry.termsDictSize) {
                return null;
            }
            if ((this.ord & this.blockMask) == 0L) {
                this.decompressBlock();
            } else {
                ByteArrayDataInput input = this.blockInput;
                int token = Byte.toUnsignedInt(input.readByte());
                int prefixLength = token & 0xF;
                int suffixLength = 1 + (token >>> 4);
                if (prefixLength == 15) {
                    prefixLength += input.readVInt();
                }
                if (suffixLength == 16) {
                    suffixLength += input.readVInt();
                }
                this.term.length = prefixLength + suffixLength;
                input.readBytes(this.term.bytes, prefixLength, suffixLength);
            }
            return this.term;
        }

        public void seekExact(long ord) throws IOException {
            if (ord < 0L || ord >= this.entry.termsDictSize) {
                throw new IndexOutOfBoundsException();
            }
            long currentBlockIndex = this.ord >> 6;
            long blockIndex = ord >> 6;
            if (ord < this.ord || blockIndex != currentBlockIndex) {
                long blockAddress = this.blockAddresses.get(blockIndex);
                this.bytes.seek(blockAddress);
                this.ord = (blockIndex << 6) - 1L;
            }
            while (this.ord < ord) {
                this.next();
            }
        }

        private BytesRef getTermFromIndex(long index) throws IOException {
            assert (index >= 0L && index <= this.entry.termsDictSize - 1L >>> this.entry.termsDictIndexShift);
            long start = this.indexAddresses.get(index);
            this.term.length = (int)(this.indexAddresses.get(index + 1L) - start);
            this.indexBytes.readBytes(start, this.term.bytes, 0, this.term.length);
            return this.term;
        }

        private long seekTermsIndex(BytesRef text) throws IOException {
            long lo = 0L;
            long hi = this.entry.termsDictSize - 1L >> this.entry.termsDictIndexShift;
            while (lo <= hi) {
                long mid = lo + hi >>> 1;
                this.getTermFromIndex(mid);
                int cmp = this.term.compareTo(text);
                if (cmp <= 0) {
                    lo = mid + 1L;
                    continue;
                }
                hi = mid - 1L;
            }
            assert (hi < 0L || this.getTermFromIndex(hi).compareTo(text) <= 0);
            assert (hi == this.entry.termsDictSize - 1L >> this.entry.termsDictIndexShift || this.getTermFromIndex(hi + 1L).compareTo(text) > 0);
            return hi;
        }

        private BytesRef getFirstTermFromBlock(long block) throws IOException {
            assert (block >= 0L && block <= this.entry.termsDictSize - 1L >>> 6);
            long blockAddress = this.blockAddresses.get(block);
            this.bytes.seek(blockAddress);
            this.term.length = this.bytes.readVInt();
            this.bytes.readBytes(this.term.bytes, 0, this.term.length);
            return this.term;
        }

        private long seekBlock(BytesRef text) throws IOException {
            long index = this.seekTermsIndex(text);
            if (index == -1L) {
                return -1L;
            }
            long ordLo = index << this.entry.termsDictIndexShift;
            long ordHi = Math.min(this.entry.termsDictSize, ordLo + (1L << this.entry.termsDictIndexShift)) - 1L;
            long blockLo = ordLo >>> 6;
            long blockHi = ordHi >>> 6;
            while (blockLo <= blockHi) {
                long blockMid = blockLo + blockHi >>> 1;
                this.getFirstTermFromBlock(blockMid);
                int cmp = this.term.compareTo(text);
                if (cmp <= 0) {
                    blockLo = blockMid + 1L;
                    continue;
                }
                blockHi = blockMid - 1L;
            }
            assert (blockHi < 0L || this.getFirstTermFromBlock(blockHi).compareTo(text) <= 0);
            assert (blockHi == this.entry.termsDictSize - 1L >>> 6 || this.getFirstTermFromBlock(blockHi + 1L).compareTo(text) > 0);
            return blockHi;
        }

        public TermsEnum.SeekStatus seekCeil(BytesRef text) throws IOException {
            long block = this.seekBlock(text);
            if (block == -1L) {
                if (this.entry.termsDictSize == 0L) {
                    this.ord = 0L;
                    return TermsEnum.SeekStatus.END;
                }
                this.seekExact(0L);
                return TermsEnum.SeekStatus.NOT_FOUND;
            }
            long blockAddress = this.blockAddresses.get(block);
            this.ord = block << 6;
            this.bytes.seek(blockAddress);
            this.decompressBlock();
            do {
                int cmp;
                if ((cmp = this.term.compareTo(text)) == 0) {
                    return TermsEnum.SeekStatus.FOUND;
                }
                if (cmp <= 0) continue;
                return TermsEnum.SeekStatus.NOT_FOUND;
            } while (this.next() != null);
            return TermsEnum.SeekStatus.END;
        }

        private void decompressBlock() throws IOException {
            this.term.length = this.bytes.readVInt();
            this.bytes.readBytes(this.term.bytes, 0, this.term.length);
            long offset = this.bytes.getFilePointer();
            if (offset < this.entry.termsDataLength - 1L) {
                if (this.currentCompressedBlockStart != offset) {
                    this.blockBuffer.offset = this.term.length;
                    this.blockBuffer.length = this.bytes.readVInt();
                    System.arraycopy(this.term.bytes, 0, this.blockBuffer.bytes, 0, this.blockBuffer.offset);
                    LZ4.decompress((DataInput)this.bytes, (int)this.blockBuffer.length, (byte[])this.blockBuffer.bytes, (int)this.blockBuffer.offset);
                    this.currentCompressedBlockStart = offset;
                    this.currentCompressedBlockEnd = this.bytes.getFilePointer();
                } else {
                    this.bytes.seek(this.currentCompressedBlockEnd);
                }
                this.blockInput = new ByteArrayDataInput(this.blockBuffer.bytes, this.blockBuffer.offset, this.blockBuffer.length);
            }
        }

        public BytesRef term() throws IOException {
            return this.term;
        }

        public long ord() throws IOException {
            return this.ord;
        }

        public long totalTermFreq() throws IOException {
            return -1L;
        }

        public PostingsEnum postings(PostingsEnum reuse, int flags) throws IOException {
            throw new UnsupportedOperationException();
        }

        public ImpactsEnum impacts(int flags) throws IOException {
            throw new UnsupportedOperationException();
        }

        public int docFreq() throws IOException {
            throw new UnsupportedOperationException();
        }
    }

    static abstract class BaseSortedSetDocValues
    extends SortedSetDocValues {
        final SortedSetEntry entry;
        final IndexInput data;
        final boolean merging;
        final TermsEnum termsEnum;

        BaseSortedSetDocValues(SortedSetEntry entry, IndexInput data, boolean merging) throws IOException {
            this.entry = entry;
            this.data = data;
            this.merging = merging;
            this.termsEnum = this.termsEnum();
        }

        public long getValueCount() {
            return this.entry.termsDictEntry.termsDictSize;
        }

        public BytesRef lookupOrd(long ord) throws IOException {
            this.termsEnum.seekExact(ord);
            return this.termsEnum.term();
        }

        public long lookupTerm(BytesRef key) throws IOException {
            TermsEnum.SeekStatus status = this.termsEnum.seekCeil(key);
            return switch (status) {
                case TermsEnum.SeekStatus.FOUND -> this.termsEnum.ord();
                default -> -1L - this.termsEnum.ord();
            };
        }

        public TermsEnum termsEnum() throws IOException {
            return new TermsDict(this.entry.termsDictEntry, this.data, this.merging);
        }
    }

    static abstract class BaseSparseNumericValues
    extends NumericDocValues
    implements BlockLoader.OptionalColumnAtATimeReader {
        protected final IndexedDISI disi;

        BaseSparseNumericValues(IndexedDISI disi) {
            this.disi = disi;
        }

        public final int advance(int target) throws IOException {
            return this.disi.advance(target);
        }

        public final boolean advanceExact(int target) throws IOException {
            return this.disi.advanceExact(target);
        }

        public final int nextDoc() throws IOException {
            return this.disi.nextDoc();
        }

        public final int docID() {
            return this.disi.docID();
        }

        public final long cost() {
            return this.disi.cost();
        }

        @Override
        public BlockLoader.Block tryRead(BlockLoader.BlockFactory factory, BlockLoader.Docs docs, int offset, boolean nullsFiltered, BlockDocValuesReader.ToDouble toDouble, boolean toInt) throws IOException {
            return null;
        }
    }

    static abstract class BaseDenseNumericValues
    extends NumericDocValues
    implements BlockLoader.OptionalColumnAtATimeReader {
        private final int maxDoc;
        protected int doc = -1;

        BaseDenseNumericValues(int maxDoc) {
            this.maxDoc = maxDoc;
        }

        public final int docID() {
            return this.doc;
        }

        public final int nextDoc() throws IOException {
            return this.advance(this.doc + 1);
        }

        public final int advance(int target) throws IOException {
            if (target >= this.maxDoc) {
                this.doc = Integer.MAX_VALUE;
                return Integer.MAX_VALUE;
            }
            this.doc = target;
            return this.doc;
        }

        public final boolean advanceExact(int target) {
            this.doc = target;
            return true;
        }

        public final long cost() {
            return this.maxDoc;
        }

        @Override
        public BlockLoader.Block tryRead(BlockLoader.BlockFactory factory, BlockLoader.Docs docs, int offset, boolean nullsFiltered, BlockDocValuesReader.ToDouble toDouble, boolean toInt) throws IOException {
            return null;
        }

        abstract long lookAheadValueAt(int var1) throws IOException;

        BlockLoader.Block tryRead(BlockLoader.SingletonLongBuilder builder, BlockLoader.Docs docs, int offset) throws IOException {
            return null;
        }

        @Nullable
        abstract SortedOrdinalReader sortedOrdinalReader();
    }

    abstract class BaseSortedDocValues
    extends SortedDocValues
    implements BlockLoader.OptionalColumnAtATimeReader {
        final SortedEntry entry;
        final TermsEnum termsEnum;

        BaseSortedDocValues(SortedEntry entry) throws IOException {
            this.entry = entry;
            this.termsEnum = this.termsEnum();
        }

        public int getValueCount() {
            return Math.toIntExact(this.entry.termsDictEntry.termsDictSize);
        }

        public BytesRef lookupOrd(int ord) throws IOException {
            this.termsEnum.seekExact((long)ord);
            return this.termsEnum.term();
        }

        public int lookupTerm(BytesRef key) throws IOException {
            TermsEnum.SeekStatus status = this.termsEnum.seekCeil(key);
            return switch (status) {
                case TermsEnum.SeekStatus.FOUND -> Math.toIntExact(this.termsEnum.ord());
                default -> Math.toIntExact(-1L - this.termsEnum.ord());
            };
        }

        public TermsEnum termsEnum() throws IOException {
            return new TermsDict(this.entry.termsDictEntry, ES819TSDBDocValuesProducer.this.data, ES819TSDBDocValuesProducer.this.merging);
        }

        @Override
        public BlockLoader.Block tryRead(BlockLoader.BlockFactory factory, BlockLoader.Docs docs, int offset, boolean nullsFiltered, BlockDocValuesReader.ToDouble toDouble, boolean toInt) throws IOException {
            return null;
        }

        BlockLoader.Block tryReadAHead(BlockLoader.BlockFactory factory, BlockLoader.Docs docs, int offset) throws IOException {
            return null;
        }
    }

    static abstract class SparseBinaryDocValues
    extends BinaryDocValues
    implements BlockLoader.OptionalColumnAtATimeReader {
        final IndexedDISI disi;

        SparseBinaryDocValues(IndexedDISI disi) {
            this.disi = disi;
        }

        public int nextDoc() throws IOException {
            return this.disi.nextDoc();
        }

        public int docID() {
            return this.disi.docID();
        }

        public long cost() {
            return this.disi.cost();
        }

        public int advance(int target) throws IOException {
            return this.disi.advance(target);
        }

        public boolean advanceExact(int target) throws IOException {
            return this.disi.advanceExact(target);
        }

        public int docIDRunEnd() throws IOException {
            return this.disi.docIDRunEnd();
        }

        @Override
        @Nullable
        public BlockLoader.Block tryRead(BlockLoader.BlockFactory factory, BlockLoader.Docs docs, int offset, boolean nullsFiltered, BlockDocValuesReader.ToDouble toDouble, boolean toInt) throws IOException {
            return null;
        }
    }

    static abstract class DenseBinaryDocValues
    extends BinaryDocValues
    implements BlockLoader.OptionalColumnAtATimeReader {
        final int maxDoc;
        int doc = -1;

        DenseBinaryDocValues(int maxDoc) {
            this.maxDoc = maxDoc;
        }

        public int nextDoc() throws IOException {
            return this.advance(this.doc + 1);
        }

        public int docID() {
            return this.doc;
        }

        public long cost() {
            return this.maxDoc;
        }

        public int advance(int target) throws IOException {
            if (target >= this.maxDoc) {
                this.doc = Integer.MAX_VALUE;
                return Integer.MAX_VALUE;
            }
            this.doc = target;
            return this.doc;
        }

        public boolean advanceExact(int target) throws IOException {
            this.doc = target;
            return true;
        }

        public int docIDRunEnd() throws IOException {
            return this.maxDoc;
        }

        @Override
        @Nullable
        public BlockLoader.Block tryRead(BlockLoader.BlockFactory factory, BlockLoader.Docs docs, int offset, boolean nullsFiltered, BlockDocValuesReader.ToDouble toDouble, boolean toInt) throws IOException {
            return null;
        }
    }

    static final class BinaryDecoder {
        private final LongValues addresses;
        private final DirectMonotonicReader docOffsets;
        private final IndexInput compressedData;
        private long lastBlockId = -1L;
        private final int[] uncompressedDocStarts;
        private final byte[] uncompressedBlock;
        private final BytesRef uncompressedBytesRef;
        private long startDocNumForBlock = -1L;
        private long limitDocNumForBlock = -1L;
        private final Decompressor decompressor;

        BinaryDecoder(Decompressor decompressor, LongValues addresses, DirectMonotonicReader docOffsets, IndexInput compressedData, int biggestUncompressedBlockSize, int maxNumDocsInAnyBlock) {
            this.decompressor = decompressor;
            this.addresses = addresses;
            this.docOffsets = docOffsets;
            this.compressedData = compressedData;
            this.uncompressedBlock = new byte[biggestUncompressedBlockSize];
            this.uncompressedBytesRef = new BytesRef(this.uncompressedBlock);
            this.uncompressedDocStarts = new int[maxNumDocsInAnyBlock + 1];
        }

        private void decompressBlock(int blockId, int numDocsInBlock) throws IOException {
            long blockStartOffset = this.addresses.get((long)blockId);
            this.compressedData.seek(blockStartOffset);
            BinaryDVCompressionMode.BlockHeader header = BinaryDVCompressionMode.BlockHeader.fromByte(this.compressedData.readByte());
            int uncompressedBlockLength = this.compressedData.readVInt();
            if (uncompressedBlockLength == 0) {
                return;
            }
            this.decompressDocOffsets(numDocsInBlock, (DataInput)this.compressedData);
            assert (uncompressedBlockLength <= this.uncompressedBlock.length);
            this.uncompressedBytesRef.offset = 0;
            this.uncompressedBytesRef.length = this.uncompressedBlock.length;
            if (header.isCompressed()) {
                this.decompressor.decompress((DataInput)this.compressedData, uncompressedBlockLength, 0, uncompressedBlockLength, this.uncompressedBytesRef);
            } else {
                this.compressedData.readBytes(this.uncompressedBlock, 0, uncompressedBlockLength);
            }
        }

        void decompressDocOffsets(int numDocsInBlock, DataInput input) throws IOException {
            int numOffsets = numDocsInBlock + 1;
            GroupVIntUtil.readGroupVInts((DataInput)input, (int[])this.uncompressedDocStarts, (int)numOffsets);
            this.deltaDecode(this.uncompressedDocStarts, numOffsets);
        }

        void deltaDecode(int[] arr, int length) {
            int sum = 0;
            for (int i = 0; i < length; ++i) {
                arr[i] = sum += arr[i];
            }
        }

        long findAndUpdateBlock(int docNumber, int numBlocks) {
            if ((long)docNumber < this.limitDocNumForBlock && this.lastBlockId >= 0L) {
                return this.lastBlockId;
            }
            long index = this.docOffsets.binarySearch(this.lastBlockId + 1L, (long)numBlocks, (long)docNumber);
            if (index < 0L) {
                index = -2L - index;
            }
            assert (index < (long)numBlocks) : "invalid range " + index + " for doc " + docNumber + " in numBlocks " + numBlocks;
            this.startDocNumForBlock = this.docOffsets.get(index);
            this.limitDocNumForBlock = this.docOffsets.get(index + 1L);
            return index;
        }

        long findAndUpdateBlockByScanning(int docNumber) {
            if ((long)docNumber < this.limitDocNumForBlock && this.lastBlockId >= 0L) {
                return this.lastBlockId;
            }
            long blockId = this.lastBlockId + 1L;
            this.startDocNumForBlock = this.docOffsets.get(blockId);
            this.limitDocNumForBlock = this.docOffsets.get(blockId + 1L);
            return blockId;
        }

        BytesRef decode(int docNumber, int numBlocks) throws IOException {
            long blockId = this.findAndUpdateBlock(docNumber, numBlocks);
            int numDocsInBlock = (int)(this.limitDocNumForBlock - this.startDocNumForBlock);
            int idxInBlock = (int)((long)docNumber - this.startDocNumForBlock);
            assert (idxInBlock < numDocsInBlock);
            if (blockId != this.lastBlockId) {
                this.decompressBlock((int)blockId, numDocsInBlock);
                this.lastBlockId = blockId;
            }
            int start = this.uncompressedDocStarts[idxInBlock];
            int end = this.uncompressedDocStarts[idxInBlock + 1];
            this.uncompressedBytesRef.offset = start;
            this.uncompressedBytesRef.length = end - start;
            return this.uncompressedBytesRef;
        }

        int computeMultipleBlockBufferSize(int count, int firstDoc, long firstBlockId, long numBlocks) throws IOException {
            IndexInput readAhead = this.compressedData.clone();
            int lastDoc = firstDoc + count - 1;
            int requiredBufferSize = 0;
            for (long blockId = firstBlockId; blockId < numBlocks; ++blockId) {
                long blockStartOffset = this.addresses.get(blockId);
                readAhead.seek(blockStartOffset);
                readAhead.readByte();
                int uncompressedBlockLength = readAhead.readVInt();
                requiredBufferSize += uncompressedBlockLength;
                long blockLimit = this.docOffsets.get(blockId + 1L);
                if ((long)lastDoc < blockLimit) break;
            }
            return requiredBufferSize;
        }

        void decodeBulk(int numBlocks, int firstDoc, int count, BlockLoader.SingletonBytesRefBuilder builder) throws IOException {
            int remainingCount = count;
            int nextDoc = firstDoc;
            int blockDocOffset = 0;
            int blockByteOffset = 0;
            long firstBlockId = this.findAndUpdateBlock(nextDoc, numBlocks);
            long[] offsets = new long[count + 1];
            int bufferSize = this.computeMultipleBlockBufferSize(count, firstDoc, firstBlockId, numBlocks);
            byte[] bytes = new byte[bufferSize];
            while (remainingCount > 0) {
                long blockId = remainingCount == count ? firstBlockId : this.findAndUpdateBlockByScanning(nextDoc);
                int numDocsInBlock = (int)(this.limitDocNumForBlock - this.startDocNumForBlock);
                int idxFirstDocInBlock = (int)((long)nextDoc - this.startDocNumForBlock);
                int countInBlock = Math.min(numDocsInBlock - idxFirstDocInBlock, remainingCount);
                assert (idxFirstDocInBlock < numDocsInBlock);
                assert (countInBlock <= numDocsInBlock);
                if (blockId != this.lastBlockId) {
                    this.decompressBlock((int)blockId, numDocsInBlock);
                    this.lastBlockId = blockId;
                }
                int startOffset = this.uncompressedDocStarts[idxFirstDocInBlock];
                int endOffset = this.uncompressedDocStarts[idxFirstDocInBlock + countInBlock];
                int lenValuesInBlock = endOffset - startOffset;
                for (int i = 0; i < countInBlock; ++i) {
                    int byteOffsetInBlock = this.uncompressedDocStarts[idxFirstDocInBlock + i + 1] - startOffset;
                    offsets[blockDocOffset + i + 1] = byteOffsetInBlock + blockByteOffset;
                }
                System.arraycopy(this.uncompressedBlock, startOffset, bytes, blockByteOffset, lenValuesInBlock);
                nextDoc += countInBlock;
                remainingCount -= countInBlock;
                blockDocOffset += countInBlock;
                blockByteOffset += lenValuesInBlock;
            }
            int totalLen = Math.toIntExact(offsets[count]);
            if (totalLen == 0) {
                builder.appendBytesRefs(new byte[0], 0L);
            } else {
                builder.appendBytesRefs(bytes, offsets);
            }
        }
    }
}

