/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support.replication;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.RetryableAction;
import org.elasticsearch.action.support.replication.ReplicationRequest;
import org.elasticsearch.action.support.replication.ReplicationResponse;
import org.elasticsearch.action.support.replication.ReplicationTask;
import org.elasticsearch.action.support.replication.TransportReplicationAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.ProjectId;
import org.elasticsearch.cluster.metadata.ProjectMetadata;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.SplitShardCountSummary;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.CheckedBiConsumer;
import org.elasticsearch.common.TriConsumer;
import org.elasticsearch.common.util.concurrent.CountDown;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.index.shard.ShardId;

public class ReplicationSplitHelper<Request extends ReplicationRequest<Request>, ReplicaRequest extends ReplicationRequest<ReplicaRequest>, Response extends ReplicationResponse> {
    private final Logger logger;
    private final ClusterService clusterService;
    private final TimeValue initialRetryBackoffBound;
    private final TimeValue retryTimeout;
    private final TriConsumer<DiscoveryNode, TransportReplicationAction.ConcreteShardRequest<Request>, ActionListener<Response>> primaryRequestSender;

    public ReplicationSplitHelper(Logger logger, ClusterService clusterService, TimeValue initialRetryBackoffBound, TimeValue retryTimeout, TriConsumer<DiscoveryNode, TransportReplicationAction.ConcreteShardRequest<Request>, ActionListener<Response>> primaryRequestSender) {
        this.clusterService = clusterService;
        this.logger = logger;
        this.initialRetryBackoffBound = initialRetryBackoffBound;
        this.retryTimeout = retryTimeout;
        this.primaryRequestSender = primaryRequestSender;
    }

    public static <Request extends ReplicationRequest<Request>> boolean needsSplitCoordination(Request primaryRequest, IndexMetadata indexMetadata) {
        SplitShardCountSummary requestSplitSummary = primaryRequest.reshardSplitShardCountSummary();
        return !requestSplitSummary.isUnset() && !requestSplitSummary.equals(SplitShardCountSummary.forIndexing(indexMetadata, primaryRequest.shardId().getId()));
    }

    public SplitCoordinator newSplitRequest(TransportReplicationAction<Request, ReplicaRequest, Response> action, ReplicationTask task, ProjectMetadata project, TransportReplicationAction.PrimaryShardReference primaryShardReference, Request primaryRequest, CheckedBiConsumer<TransportReplicationAction.PrimaryShardReference, ActionListener<Response>, Exception> executePrimaryRequest, ActionListener<Response> onCompletionListener) {
        return new SplitCoordinator(this, action, task, project, primaryShardReference, primaryRequest, executePrimaryRequest, onCompletionListener);
    }

    public static class SplitCoordinator {
        private final TransportReplicationAction<Request, ReplicaRequest, Response> action;
        private final ReplicationTask task;
        private final ProjectMetadata project;
        private final TransportReplicationAction.PrimaryShardReference primaryShardReference;
        private final Request originalRequest;
        private final CheckedBiConsumer<TransportReplicationAction.PrimaryShardReference, ActionListener<Response>, Exception> doPrimaryRequest;
        private final ActionListener<Response> onCompletionListener;
        final /* synthetic */ ReplicationSplitHelper this$0;

        public SplitCoordinator(TransportReplicationAction<Request, ReplicaRequest, Response> action, ReplicationTask task, ProjectMetadata project, TransportReplicationAction.PrimaryShardReference primaryShardReference, Request originalRequest, CheckedBiConsumer<TransportReplicationAction.PrimaryShardReference, ActionListener<Response>, Exception> doPrimaryRequest, ActionListener<Response> onCompletionListener) {
            this.this$0 = this$0;
            this.action = action;
            this.task = task;
            this.project = project;
            this.primaryShardReference = primaryShardReference;
            this.originalRequest = originalRequest;
            this.doPrimaryRequest = doPrimaryRequest;
            this.onCompletionListener = onCompletionListener;
        }

        public void coordinate() throws Exception {
            Map splitRequests = this.action.splitRequestOnPrimary(this.originalRequest);
            int numSplitRequests = splitRequests.size();
            assert (numSplitRequests > 0) : "expected at-least 1 split request";
            assert (numSplitRequests <= 2) : "number of split requests too many";
            if (numSplitRequests == 1) {
                if (splitRequests.containsKey(((ReplicationRequest)this.originalRequest).shardId())) {
                    TransportReplicationAction.setPhase(this.task, "primary");
                    this.doPrimaryRequest.accept(this.primaryShardReference, this.onCompletionListener);
                } else {
                    this.primaryShardReference.close();
                    TransportReplicationAction.setPhase(this.task, "primary_reshard_target_delegation");
                    Map.Entry next = splitRequests.entrySet().iterator().next();
                    ReplicationRequest request = (ReplicationRequest)next.getValue();
                    ShardId targetShardId = next.getKey();
                    this.delegateToTarget(targetShardId, request, this.this$0.clusterService::state, this.project, new ActionListener<Response>(){

                        @Override
                        public void onResponse(Response response) {
                            TransportReplicationAction.setPhase(SplitCoordinator.this.task, "finished");
                            SplitCoordinator.this.onCompletionListener.onResponse(response);
                        }

                        @Override
                        public void onFailure(Exception e) {
                            TransportReplicationAction.setPhase(SplitCoordinator.this.task, "finished");
                            SplitCoordinator.this.onCompletionListener.onFailure(e);
                        }
                    });
                }
            } else {
                this.coordinateMultipleRequests(splitRequests);
            }
        }

        private void coordinateMultipleRequests(final Map<ShardId, Request> splitRequests) throws Exception {
            TransportReplicationAction.setPhase(this.task, "primary_with_reshard_target_delegation");
            final ConcurrentHashMap results = new ConcurrentHashMap(splitRequests.size());
            final CountDown countDown = new CountDown(splitRequests.size());
            for (final Map.Entry splitRequest : splitRequests.entrySet()) {
                ActionListener listener = new ActionListener<Response>(){

                    @Override
                    public void onResponse(Response response) {
                        results.put((ShardId)splitRequest.getKey(), new Tuple(response, null));
                        if (countDown.countDown()) {
                            this.finish();
                        }
                    }

                    @Override
                    public void onFailure(Exception e) {
                        results.put((ShardId)splitRequest.getKey(), new Tuple(null, (Object)e));
                        if (countDown.countDown()) {
                            this.finish();
                        }
                    }

                    private void finish() {
                        Tuple finalResponse = SplitCoordinator.this.action.combineSplitResponses(SplitCoordinator.this.originalRequest, splitRequests, results);
                        TransportReplicationAction.setPhase(SplitCoordinator.this.task, "finished");
                        if (finalResponse.v1() != null) {
                            SplitCoordinator.this.onCompletionListener.onResponse((ReplicationResponse)finalResponse.v1());
                        } else {
                            SplitCoordinator.this.onCompletionListener.onFailure((Exception)finalResponse.v2());
                        }
                    }
                };
                if (splitRequest.getKey().equals(((ReplicationRequest)this.originalRequest).shardId())) {
                    this.doPrimaryRequest.accept(this.primaryShardReference, listener);
                    continue;
                }
                this.delegateToTarget(splitRequest.getKey(), (ReplicationRequest)splitRequest.getValue(), this.this$0.clusterService::state, this.project, listener);
            }
        }

        private void delegateToTarget(final ShardId targetShardId, Request splitRequest, final Supplier<ClusterState> clusterStateSupplier, final ProjectMetadata project, ActionListener<Response> finalListener) {
            new RetryableAction<Response>(this.this$0.logger, this.this$0.clusterService.threadPool(), this.this$0.initialRetryBackoffBound, this.this$0.retryTimeout, finalListener, EsExecutors.DIRECT_EXECUTOR_SERVICE, (ReplicationRequest)splitRequest){
                final /* synthetic */ ReplicationRequest val$splitRequest;
                {
                    this.val$splitRequest = replicationRequest;
                    super(logger, threadPool, initialDelay, timeoutValue, listener, executor);
                }

                @Override
                public void tryAction(ActionListener<Response> listener) {
                    ClusterState clusterState = (ClusterState)clusterStateSupplier.get();
                    ProjectId projectId = project.id();
                    ShardRouting target = clusterState.routingTable(projectId).shardRoutingTable(targetShardId).primaryShard();
                    IndexMetadata indexMetadata = project.index(targetShardId.getIndex());
                    DiscoveryNode targetNode = clusterState.nodes().get(target.currentNodeId());
                    String allocationID = target.allocationId().getId();
                    long expectedPrimaryTerm = indexMetadata.primaryTerm(targetShardId.id());
                    TransportReplicationAction.ConcreteShardRequest<ReplicationRequest> concreteShardRequest = new TransportReplicationAction.ConcreteShardRequest<ReplicationRequest>(this.val$splitRequest, allocationID, expectedPrimaryTerm);
                    SplitCoordinator.this.this$0.primaryRequestSender.apply(targetNode, concreteShardRequest, listener);
                }

                @Override
                public boolean shouldRetry(Exception e) {
                    return TransportReplicationAction.retryPrimaryException(ExceptionsHelper.unwrapCause(e));
                }
            }.run();
        }
    }
}

