/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support.local;

import java.util.concurrent.Executor;
import java.util.function.BooleanSupplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchTimeoutException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionRunnable;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.TransportAction;
import org.elasticsearch.action.support.local.LocalClusterStateRequest;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateObserver;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.core.Predicates;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.node.NodeClosedException;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskCancelledException;
import org.elasticsearch.tasks.TaskManager;

public abstract class TransportLocalClusterStateAction<Request extends LocalClusterStateRequest, Response extends ActionResponse>
extends TransportAction<Request, Response> {
    private static final Logger logger = LogManager.getLogger(TransportLocalClusterStateAction.class);
    protected final ClusterService clusterService;
    protected final Executor executor;

    protected TransportLocalClusterStateAction(String actionName, ActionFilters actionFilters, TaskManager taskManager, ClusterService clusterService, Executor executor) {
        super(actionName, actionFilters, taskManager, EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.clusterService = clusterService;
        this.executor = executor;
    }

    protected abstract ClusterBlockException checkBlock(Request var1, ClusterState var2);

    protected abstract void localClusterStateOperation(Task var1, Request var2, ClusterState var3, ActionListener<Response> var4) throws Exception;

    @Override
    protected final void doExecute(Task task, Request request, ActionListener<Response> listener) {
        ClusterState state;
        ClusterBlockException clusterBlockException;
        if (task != null) {
            request.setParentTask(this.clusterService.localNode().getId(), task.getId());
        }
        if ((clusterBlockException = this.checkBlock(request, state = this.clusterService.state())) != null) {
            if (!clusterBlockException.retryable()) {
                listener.onFailure(clusterBlockException);
            } else {
                this.waitForClusterUnblock(task, request, listener, state, clusterBlockException);
            }
        } else {
            this.innerDoExecute(task, request, listener, state);
        }
    }

    private void innerDoExecute(Task task, Request request, ActionListener<Response> listener, ClusterState state) {
        CancellableTask cancellableTask;
        if (task instanceof CancellableTask && (cancellableTask = (CancellableTask)task).notifyIfCancelled(listener)) {
            return;
        }
        this.executor.execute(ActionRunnable.wrap(listener, l -> this.localClusterStateOperation(task, request, state, (ActionListener<Response>)l)));
    }

    private void waitForClusterUnblock(final Task task, Request request, ActionListener<Response> listener, ClusterState initialState, ClusterBlockException exception) {
        ClusterStateObserver observer = new ClusterStateObserver(initialState, this.clusterService, ((LocalClusterStateRequest)request).masterTimeout(), logger, this.clusterService.threadPool().getThreadContext());
        final BooleanSupplier waitComplete = Predicates.once();
        if (task instanceof CancellableTask) {
            CancellableTask cancellableTask = (CancellableTask)task;
            cancellableTask.addListener(() -> {
                if (!waitComplete.getAsBoolean()) {
                    return;
                }
                listener.onFailure(new TaskCancelledException("Task was cancelled"));
                logger.trace("task [{}] was cancelled, notifying listener", (Object)task.getId());
            });
        }
        observer.waitForNextChange(new ClusterStateObserver.Listener(){
            final /* synthetic */ LocalClusterStateRequest val$request;
            final /* synthetic */ ActionListener val$listener;
            final /* synthetic */ ClusterBlockException val$exception;
            {
                this.val$request = localClusterStateRequest;
                this.val$listener = actionListener;
                this.val$exception = clusterBlockException;
            }

            @Override
            public void onNewClusterState(ClusterState state) {
                if (!waitComplete.getAsBoolean()) {
                    return;
                }
                logger.trace("retrying with cluster state version [{}]", (Object)state.version());
                TransportLocalClusterStateAction.this.innerDoExecute(task, this.val$request, this.val$listener, state);
            }

            @Override
            public void onClusterServiceClose() {
                if (!waitComplete.getAsBoolean()) {
                    return;
                }
                this.val$listener.onFailure(new NodeClosedException(TransportLocalClusterStateAction.this.clusterService.localNode()));
            }

            @Override
            public void onTimeout(TimeValue timeout) {
                if (!waitComplete.getAsBoolean()) {
                    return;
                }
                logger.debug(() -> Strings.format("timed out while waiting for cluster to unblock in [%s] (timeout [%s])", TransportLocalClusterStateAction.this.actionName, timeout), (Throwable)this.val$exception);
                this.val$listener.onFailure(new ElasticsearchTimeoutException("timed out while waiting for cluster to unblock", (Throwable)this.val$exception, new Object[0]));
            }
        }, clusterState -> this.isTaskCancelled(task) || this.checkBlock(request, (ClusterState)clusterState) == null);
    }

    private boolean isTaskCancelled(Task task) {
        CancellableTask cancellableTask;
        return task instanceof CancellableTask && (cancellableTask = (CancellableTask)task).isCancelled();
    }
}

